/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.gui.EventFilter;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.ExceptionHandler;
import de.qfs.lib.util.Reflector;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class EventQueue
extends java.awt.EventQueue {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.EventQueue");
    public static final int WRAPPER_ID = 12769;
    public static final int RUNNABLE_ID = 12770;
    protected static EventQueue theQueue;
    protected java.awt.EventQueue originalQueue;
    protected Object originalPostQueue;
    protected ExceptionHandler handler;
    protected boolean installed;
    protected List<EventFilter> eventFilters = Collections.synchronizedList(new ArrayList());
    private boolean tabPressed;
    private int lastCodePressed;
    private static boolean hacksGuessed;
    private static boolean tabHackEnabled;
    private static boolean metaHackEnabled;
    private static boolean deleteHackEnabled;
    protected boolean hasFwDispatcher;

    public EventQueue() {
        if (EventQueue.logger.level >= 7) {
            logger.lvlBuild(7, "EventQueue()", 199).log();
        }
    }

    public static java.awt.EventQueue instance() {
        if (theQueue != null) {
            return theQueue;
        }
        return Toolkit.getDefaultToolkit().getSystemEventQueue();
    }

    public static boolean install() {
        if (EventQueue.logger.level >= 7) {
            logger.lvlBuild(7, "install()", 234).log();
        }
        if (!hacksGuessed) {
            deleteHackEnabled = (System.getProperty("java.vendor").indexOf("Blackdown") >= 0 || System.getProperty("java.vendor").indexOf("Sun") >= 0) && System.getProperty("java.version").startsWith("1.3.");
            tabHackEnabled = Toolkit.getDefaultToolkit().getClass().getName().indexOf("motif") >= 0;
            boolean bl = metaHackEnabled = (System.getProperty("java.vendor").indexOf("IBM") >= 0 || System.getProperty("java.vendor").indexOf("Hewlett Packard") >= 0) && Toolkit.getDefaultToolkit().getClass().getName().indexOf("motif") >= 0;
            if (EventQueue.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "install()", 255).add("deleteHackEnabled", deleteHackEnabled)).add("tabHackEnabled", tabHackEnabled)).add("metaHackEnabled", metaHackEnabled)).log();
            }
            hacksGuessed = true;
        }
        if (theQueue != null && EventQueue.theQueue.installed) {
            return true;
        }
        java.awt.EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (theQueue == null) {
            theQueue = new EventQueue();
        } else if (theQueue == eventQueue) {
            EventQueue.theQueue.installed = true;
            return true;
        }
        theQueue.install(eventQueue, null);
        return true;
    }

    public static void uninstall() {
        if (EventQueue.logger.level >= 7) {
            logger.lvlBuild(7, "uninstall()", 287).log();
        }
        if (theQueue != null) {
            theQueue.uninstall(null);
            theQueue = null;
        }
    }

    public static boolean isInstalled() {
        return theQueue != null && EventQueue.theQueue.installed;
    }

    public static final boolean isTabHackEnabled() {
        return tabHackEnabled;
    }

    public static final void setTabHackEnabled(boolean bl) {
        tabHackEnabled = bl;
    }

    public static final boolean isMetaHackEnabled() {
        return metaHackEnabled;
    }

    public static final void setMetaHackEnabled(boolean bl) {
        metaHackEnabled = bl;
    }

    public static final boolean isDeleteHackEnabled() {
        return deleteHackEnabled;
    }

    public static final void setDeleteHackEnabled(boolean bl) {
        deleteHackEnabled = bl;
    }

    public void install(java.awt.EventQueue eventQueue, Object object) {
        Object object2;
        block8: {
            if (EventQueue.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "install(EventQueue,Object)", 414).addDetail("original", eventQueue)).addDetail("appContext", object)).log();
            }
            this.installed = true;
            this.originalQueue = eventQueue;
            try {
                object2 = Reflector.get(eventQueue, "dispatchThread", true);
                if (EventQueue.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "install(EventQueue,Object)", 420).add("dispatchThread", object2)).log();
                }
                if (object2 == null) {
                    Reflector.call(eventQueue, "initDispatchThread", true);
                    object2 = Reflector.get(eventQueue, "dispatchThread", true);
                    if (EventQueue.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "install(EventQueue,Object)", 427).add("dispatchThread now", object2)).log();
                    }
                }
            }
            catch (Throwable throwable) {
                if (EventQueue.logger.level < 3) break block8;
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "install(EventQueue,Object)", 430).add("ex", throwable)).log();
            }
        }
        object2 = Reflector.safeGet(eventQueue, "fwDispatcher", true);
        if (object2 != null) {
            Reflector.safeSet(eventQueue, "fwDispatcher", null, true);
        }
        eventQueue.push(this);
        if (object2 != null) {
            Reflector.safeSet(eventQueue, "fwDispatcher", object2, true);
            Reflector.safeSet(this, "fwDispatcher", object2, true);
            this.hasFwDispatcher = true;
        }
    }

    public void uninstall(Object object) {
        if (EventQueue.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "uninstall(Object)", 453).addDetail("appContext", object)).log();
        }
        this.installed = false;
        this.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventFilter(EventFilter eventFilter) {
        if (EventQueue.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addEventFilter(EventFilter)", 462).addDetail("filter", eventFilter)).log();
        }
        List<EventFilter> list = this.eventFilters;
        synchronized (list) {
            this.eventFilters.remove(eventFilter);
            this.eventFilters.add(eventFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventFilter(EventFilter eventFilter) {
        List<EventFilter> list = this.eventFilters;
        synchronized (list) {
            this.eventFilters.remove(eventFilter);
        }
    }

    @Override
    public AWTEvent getNextEvent() throws InterruptedException {
        AWTEvent aWTEvent;
        boolean bl = this.hasFwDispatcher = Reflector.safeGet(this, "fwDispatcher", true) != null;
        if (this.hasFwDispatcher) {
            return super.getNextEvent();
        }
        while (true) {
            AWTEvent aWTEvent2;
            aWTEvent = super.getNextEvent();
            if (!this.installed) break;
            AWTEvent aWTEvent3 = aWTEvent2 = aWTEvent instanceof WrapperEvent ? ((WrapperEvent)aWTEvent).getWrappedEvent() : aWTEvent;
            if (this.checkHacksAndFilters(aWTEvent2)) break;
            if (EventQueue.logger.level < 9) continue;
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getNextEvent()", 511).add("Event filtered", aWTEvent)).log();
        }
        return aWTEvent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void dispatchEvent(AWTEvent aWTEvent) {
        if (EventQueue.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "dispatchEvent(AWTEvent)", 538).add("event", aWTEvent)).log();
        }
        if (this.hasFwDispatcher) {
            if (aWTEvent instanceof WrapperEvent) {
                super.dispatchEvent(aWTEvent);
                return;
            } else {
                super.dispatchEvent(new WrapperEvent(this, aWTEvent));
            }
            return;
        }
        if (this.installed && this.handler != null) {
            try {
                this.doDispatch(aWTEvent);
                return;
            }
            catch (Throwable throwable) {
                if (this.handler.handleException(throwable)) return;
                if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
                throw (RuntimeException)throwable;
            }
        } else {
            this.doDispatch(aWTEvent);
        }
    }

    protected boolean checkHacksAndFilters(AWTEvent aWTEvent) {
        if (EventQueue.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "checkHacksAndFilters(AWTEvent)", 580).add("event", aWTEvent)).log();
        }
        if (this.installed && !this.filterEvent(aWTEvent)) {
            return false;
        }
        if (this.installed && tabHackEnabled && this.tabHack(aWTEvent)) {
            return false;
        }
        if (this.installed && metaHackEnabled && aWTEvent.getID() >= 400 && aWTEvent.getID() <= 402 && (((KeyEvent)aWTEvent).getModifiers() & 0xC) == 12) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            keyEvent.setModifiers(keyEvent.getModifiers() & 0xFFFFFFFB);
        }
        if (this.installed && deleteHackEnabled) {
            if (aWTEvent.getID() == 401) {
                this.lastCodePressed = ((KeyEvent)aWTEvent).getKeyCode();
            } else {
                if (aWTEvent.getID() == 400 && this.lastCodePressed == 127 && ((KeyEvent)aWTEvent).getKeyChar() == '\u00ff') {
                    return false;
                }
                if (aWTEvent.getID() == 400 && this.lastCodePressed == 27 && ((KeyEvent)aWTEvent).getKeyChar() == 'i') {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected void doDispatch(AWTEvent var1_1) {
        if (EventQueue.logger.level >= 7) {
            ((LevelAwareLogBuilder)EventQueue.logger.lvlBuild(7, "doDispatch(AWTEvent)", 629).addDetail("event", var1_1)).log();
        }
        if (this.hasFwDispatcher) {
            try {
                Reflector.call((Object)this, "dispatchEventImpl", new Class[]{AWTEvent.class, Object.class}, new Object[]{var1_1, var1_1.getSource()}, true);
            }
            catch (InvocationTargetException var2_2) {
                var3_4 = var2_2.getTargetException();
                if (this.handler.handleException(var3_4)) {
                    return;
                }
                if (var3_4 instanceof RuntimeException) {
                    throw (RuntimeException)var3_4;
                }
                throw (Error)var3_4;
            }
            catch (Throwable var2_3) {
                if (EventQueue.logger.level < 3) ** GOTO lbl20
                ((LevelAwareLogBuilder)EventQueue.logger.lvlBuild(3, "doDispatch(AWTEvent)", 648).add("ex", var2_3)).log();
            }
        } else {
            super.dispatchEvent(var1_1);
        }
lbl20:
        // 4 sources

        if (EventQueue.logger.level >= 9) {
            ((LevelAwareLogBuilder)EventQueue.logger.lvlBuild(9, "doDispatch(AWTEvent)", 653).add("done")).log();
        }
    }

    @Override
    public void pop() {
        if (EventQueue.logger.level >= 7) {
            logger.lvlBuild(7, "pop()", 664).log();
        }
        super.pop();
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        if (EventQueue.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setExceptionHandler(ExceptionHandler)", 679).addDetail("handler", exceptionHandler)).log();
        }
        this.handler = exceptionHandler;
    }

    protected boolean tabHack(AWTEvent aWTEvent) {
        KeyEvent keyEvent;
        if (aWTEvent.getID() >= 400 && aWTEvent.getID() <= 402 && (keyEvent = (KeyEvent)aWTEvent).getKeyCode() == 9) {
            if (keyEvent.getID() == 401 && (keyEvent.getModifiers() & 1) == 1) {
                this.tabPressed = true;
            } else if (keyEvent.getID() == 402 && (keyEvent.getModifiers() & 1) == 1) {
                if (this.tabPressed) {
                    this.tabPressed = false;
                } else {
                    this.postEvent(new KeyEvent((Component)keyEvent.getSource(), 401, keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar()));
                    this.postEvent(new KeyEvent((Component)keyEvent.getSource(), 400, keyEvent.getWhen(), keyEvent.getModifiers(), 0, '\t'));
                    this.postEvent(aWTEvent);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean filterEvent(AWTEvent aWTEvent) {
        EventFilter[] eventFilterArray = this;
        synchronized (this) {
            EventFilter[] eventFilterArray2 = this.eventFilters.toArray(new EventFilter[0]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (EventFilter eventFilter : eventFilterArray2) {
                if (eventFilter.filter(aWTEvent)) continue;
                return false;
            }
            return true;
        }
    }

    static {
        hacksGuessed = false;
        tabHackEnabled = true;
        metaHackEnabled = true;
        deleteHackEnabled = true;
    }

    public static class RunnableEvent
    extends AWTEvent
    implements ActiveEvent {
        Runnable runnable;

        public RunnableEvent(Object object, Runnable runnable) {
            super(object, 12770);
            this.runnable = runnable;
        }

        @Override
        public void dispatch() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "RunnableEvent.dispatch()", 935).log();
            }
            this.runnable.run();
        }
    }

    public static class WrapperEvent
    extends AWTEvent
    implements ActiveEvent {
        java.awt.EventQueue queue;
        AWTEvent event;

        public WrapperEvent(java.awt.EventQueue eventQueue, AWTEvent aWTEvent) {
            super(aWTEvent.getSource(), 12769);
            this.queue = eventQueue;
            this.event = aWTEvent;
        }

        public final AWTEvent getWrappedEvent() {
            return this.event;
        }

        @Override
        public void dispatch() {
            block5: {
                if (this.queue instanceof EventQueue && ((EventQueue)this.queue).hasFwDispatcher) {
                    if (!((EventQueue)this.queue).checkHacksAndFilters(this.event)) {
                        if (logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "WrapperEvent.dispatch()", 871).add("Event filtered")).log();
                        }
                        return;
                    }
                    ((EventQueue)this.queue).doDispatch(this.event);
                    return;
                }
                try {
                    Reflector.call((Object)this.queue, "dispatchEvent", AWTEvent.class, (Object)this.event, true);
                }
                catch (Throwable throwable) {
                    if (logger.level < 1) break block5;
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "WrapperEvent.dispatch()", 881).add("ex", throwable)).log();
                }
            }
        }
    }
}

