/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.config.ConfigWrapper;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.gui.AWTTreeAdapter;
import de.qfs.lib.gui.Grid;
import de.qfs.lib.gui.Message;
import de.qfs.lib.gui.NotifyingJDialog;
import de.qfs.lib.gui.SVGIcon;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.gui.ThemeSupport;
import de.qfs.lib.gui.WrappingBox;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.notifications.DefaultNotificationCenter;
import de.qfs.lib.notifications.Observer;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.edit.KeyOptionEdit;
import de.qfs.lib.tree.ReturnFromTraversalException;
import de.qfs.lib.tree.TreeAdapter;
import de.qfs.lib.tree.TreeUtil;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Reflector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import lombok.Generated;
import lombok.NonNull;

public class ModalDialog
extends NotifyingJDialog
implements ActionListener,
WindowListener {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.ModalDialog");
    public static final int CLOSED_OPTION = -1;
    public static final int OK_OPTION = 0;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int MINIMAL_BUTTON_WIDTH = 50;
    protected static final String[] defaultButtons = new String[]{"ok", "cancel"};
    private static Image defaultIconImage = null;
    private static List<Image> defaultIconImages = null;
    private static int[] defaultIconSizes = new int[]{8, 16, 20, 24, 32, 48, 64};
    static boolean forceToFront = true;
    static Function<Dialog, Boolean> toFrontHandler;
    protected static KeyStroke defaultButtonKeyStroke;
    protected static boolean returnTriggersFocusedButton;
    protected String name;
    protected String resourceName;
    protected int retval;
    protected Component mainComponent;
    protected JPanel mainPanel;
    protected ButtonData[] buttons;
    protected JButton defaultButton;
    Component initialFocusTarget;
    protected GridBagLayout layout;
    protected JPanel panel;
    protected int minWidth;
    protected int minHeight;
    private boolean forceSize;
    private boolean maybeForceSize;
    private boolean maybeForcePosition;
    private float buttonAlignment;
    Observer updateBorderObserver;

    public ModalDialog(String string, Window window) {
        super(window);
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ModalDialog(String,Window)", 377).addDetail("name", string)).addDetail("window", window)).log();
        }
        this.name = string;
        this.resourceName = string;
        this.setModal(true);
    }

    public ModalDialog(String string, Window window, Component component) {
        super(window);
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ModalDialog(String,Window,Component)", 396).addDetail("name", string)).addDetail("window", window)).addDetail("com", component)).log();
        }
        this.name = string;
        this.resourceName = string;
        this.mainComponent = component;
        if (component instanceof JComponent && ((JComponent)component).getClientProperty("qflib.dialog.kind") != null) {
            this.getRootPane().putClientProperty("qflib.dialog.kind", ((JComponent)component).getClientProperty("qflib.dialog.kind"));
        }
        this.setModal(true);
    }

    public static final KeyStroke getDefaultButtonKeyStroke() {
        if (ModalDialog.logger.level >= 7) {
            logger.lvlBuild(7, "getDefaultButtonKeyStroke()", 422).log();
        }
        return defaultButtonKeyStroke;
    }

    public static final void setDefaultButtonKeyStroke(KeyStroke keyStroke) {
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setDefaultButtonKeyStroke(KeyStroke)", 435).addDetail("_defaultButtonKeyStroke", keyStroke)).log();
        }
        defaultButtonKeyStroke = keyStroke;
    }

    public static final boolean isReturnTriggersFocusedButton() {
        if (ModalDialog.logger.level >= 7) {
            logger.lvlBuild(7, "isReturnTriggersFocusedButton()", 448).log();
        }
        return returnTriggersFocusedButton;
    }

    public static final void setReturnTriggersFocusedButton(boolean bl) {
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setReturnTriggersFocusedButton(boolean)", 461).addDetail("_returnTriggersFocusedButton", bl)).log();
        }
        returnTriggersFocusedButton = bl;
    }

    public void init(MapResourceBundle mapResourceBundle) {
        String string;
        String string2;
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "init(MapResourceBundle)", 480).addDetail("rb", mapResourceBundle)).log();
        }
        if ((string2 = mapResourceBundle.getString(this.resName("title"), null)) != null) {
            this.setTitle(string2);
        }
        if ((string = mapResourceBundle.getString(this.resName("name"), null)) != null) {
            this.setName(string);
        } else {
            this.setName("ModalDialog-" + this.name);
        }
        if (!this.hasIconImage()) {
            this.setIconImage(ModalDialog.getDefaultIconImage());
        }
        this.panel = new Grid();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.initComponent();
        this.addMainComponentToMainPanel();
        ((Grid)this.panel).addLine(new Component[]{this.mainPanel}, 1.0);
        this.createButtonLine(mapResourceBundle);
        this.updateBorderObserver = notification -> {
            Border border = UIManager.getBorder("OptionPane.border");
            if (border == null) {
                border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
            }
            this.panel.setBorder(border);
        };
        DefaultNotificationCenter.instance().addAndCallWeakObserver(this.updateBorderObserver, "user.theme.updatedUI", null);
        this.panel.setMinimumSize(this.panel.getPreferredSize());
        if (defaultButtonKeyStroke != null) {
            this.panel.registerKeyboardAction(this, "defaultAction", defaultButtonKeyStroke, 1);
        }
        if (returnTriggersFocusedButton) {
            this.panel.registerKeyboardAction(this, "returnAction", KeyStroke.getKeyStroke(10, 0), 1);
        }
        this.setContentPane(this.panel);
        if (this.defaultButton != null) {
            this.getRootPane().setDefaultButton(this.defaultButton);
        }
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.minWidth = mapResourceBundle.getInt(this.resName("width"), -1);
        this.minHeight = mapResourceBundle.getInt(this.resName("height"), -1);
        if (mapResourceBundle.getBoolean(this.resName("scalesize"), false)) {
            double d = Math.max(1.0, ThemeSupport.getFontScale());
            this.minWidth = (int)((double)this.minWidth * d);
            this.minHeight = (int)((double)this.minHeight * d);
        }
        this.forceSize = mapResourceBundle.getBoolean(this.resName("forcesize"), false);
        this.maybeForceSize = mapResourceBundle.getString(this.resName("forcesize"), null) == null;
        this.maybeForcePosition = mapResourceBundle.getBoolean(this.resName("forceposition"), false);
        this.fixSize();
        SwingUtil.centerWindow(this);
        if (mapResourceBundle.getBoolean(this.resName("configure"), false)) {
            Configuration.instance().register(ConfigWrapper.makeWrapper(this, this.name + ".dialog"));
        }
        if (mapResourceBundle.getBoolean(this.resName("alwaysontop"), false)) {
            this.setAlwaysOnTop(true);
        }
    }

    private boolean hasIconImage() {
        if (ModalDialog.logger.level >= 7) {
            logger.lvlBuild(7, "hasIconImage()", 565).log();
        }
        for (Container container = this; container != null; container = container.getParent()) {
            if (!(container instanceof Window) || ((Window)container).getIconImages().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public void setMainComponent(Component component) {
        this.mainComponent = component;
        if (this.mainPanel != null) {
            this.mainPanel.removeAll();
            this.mainPanel.add(component, "Center");
            this.panel.revalidate();
            this.fixSize();
        }
    }

    public void addMainComponentToMainPanel() {
        if (this.mainComponent != null) {
            this.mainPanel.add(this.mainComponent, "Center");
        }
    }

    protected void createButtonLine(MapResourceBundle mapResourceBundle) {
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createButtonLine(MapResourceBundle)", 619).addDetail("rb", mapResourceBundle)).log();
        }
        List<Component> list = this.initButtonLines(mapResourceBundle);
        for (Component component : list) {
            ((Grid)this.panel).addLine(new Component[]{Box.createVerticalStrut(10)});
            ((Grid)this.panel).addLine(new Component[]{component});
        }
    }

    protected List<Component> initButtonLines(MapResourceBundle mapResourceBundle) {
        int n;
        ButtonData[] buttonDataArray;
        int n2;
        String[] stringArray;
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "initButtonLines(MapResourceBundle)", 639).addDetail("rb", mapResourceBundle)).log();
        }
        int n3 = (stringArray = this.initListButtonNames(mapResourceBundle)) == null ? 0 : stringArray.length;
        String[] stringArray2 = this.initButtonNames(mapResourceBundle);
        int n4 = stringArray2 == null ? 0 : stringArray2.length;
        int n5 = n3 + n4;
        this.buttons = n5 == 0 ? null : new ButtonData[n5];
        WrappingBox wrappingBox = null;
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        if (box.getAlignmentX() != this.getButtonAlignment()) {
            box.setAlignmentX(this.getButtonAlignment());
        }
        int n6 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            ButtonData buttonData = this.buttons[n2] = this.initButton(stringArray[n2], mapResourceBundle);
            buttonData.listButton = true;
            buttonDataArray = buttonData.button;
            buttonDataArray.setBackground(null);
            buttonDataArray.setHorizontalAlignment(2);
            if (wrappingBox == null) {
                wrappingBox = new WrappingBox(10, 5);
                wrappingBox.setBorder(BorderFactory.createEmptyBorder(0, 47, 0, 0));
                box.setBorder(wrappingBox.getBorder());
            }
            wrappingBox.add((Component)buttonDataArray);
            n6 = Math.max(n6, buttonDataArray.getPreferredSize().width + 1);
        }
        n2 = 0;
        for (n = 0; n < n4; ++n) {
            ButtonData buttonData = this.initButton(stringArray2[n], mapResourceBundle);
            this.buttons[n + n3] = buttonData;
            buttonDataArray = buttonData;
            JButton jButton = buttonDataArray.button;
            box.add(jButton);
            if (box.getAlignmentX() == 1.0f) {
                if (n < n4 - 1) {
                    box.add(Box.createHorizontalStrut(20));
                }
            } else {
                if (n < n4 - 1) {
                    box.add(Box.createHorizontalStrut(20));
                }
                box.add(Box.createHorizontalGlue());
            }
            n2 = Math.max(n2, jButton.getPreferredSize().width + 1);
        }
        if (this.buttons != null) {
            n = this.buttons[0].button.getPreferredSize().height;
            for (ButtonData buttonData : this.buttons) {
                JButton jButton = buttonData.button;
                jButton.addActionListener(this);
                if (this.defaultButton == null && buttonData.deflt) {
                    this.defaultButton = jButton;
                }
                jButton.setPreferredSize(new Dimension(buttonData.listButton ? n6 : n2, n));
                jButton.setMaximumSize(jButton.getPreferredSize());
                jButton.setMinimumSize(new Dimension(0, n));
            }
        }
        if (wrappingBox != null) {
            wrappingBox.relayout();
            return Misc.listOf(wrappingBox, box);
        }
        return Misc.listOf(box);
    }

    public final void setInitialFocusTarget(Component component) {
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setInitialFocusTarget(Component)", 725).addDetail("initialFocusTarget", component)).log();
        }
        this.initialFocusTarget = component;
    }

    public int doModal(Component component, boolean bl) {
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "doModal(Component,boolean)", 747).addDetail("parent", component)).addDetail("resetFocus", bl)).log();
        }
        this.showDialog(component, bl);
        this.defaultButton = null;
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].button.isDefaultButton()) continue;
            this.defaultButton = this.buttons[i].button;
            break;
        }
        this.dispose();
        return this.retval;
    }

    public void setForcePosition(boolean bl) {
        this.maybeForcePosition = bl;
    }

    public void showDialog(Component component, boolean bl) {
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "showDialog(Component,boolean)", 782).addDetail("parent", component)).addDetail("resetFocus", bl)).log();
        }
        if (component != null && !this.maybeForcePosition) {
            SwingUtil.centerWindowOnComponent(this, component, true);
        }
        if (this.initialFocusTarget != null || bl && this.buttons != null) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent windowEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "showDialog(Component,boolean).WindowAdapter.windowActivated(WindowEvent)", 793).addDetail("e", windowEvent)).log();
                    }
                    ModalDialog.this.requestFocus();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (logger.level >= 7) {
                                logger.lvlBuild(7, "showDialog(Component,boolean).WindowAdapter.windowActivated(WindowEvent).Runnable.run()", 799).log();
                            }
                            ModalDialog.this.requestFocus();
                            if (ModalDialog.this.initialFocusTarget != null) {
                                if (logger.level >= 3) {
                                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "showDialog(Component,boolean).WindowAdapter.windowActivated(WindowEvent).Runnable.run()", 802).add("Requesting focus for ")).add(ModalDialog.this.initialFocusTarget)).log();
                                }
                                ModalDialog.this.initialFocusTarget.requestFocus();
                            } else {
                                KeyboardFocusManager.getCurrentKeyboardFocusManager().downFocusCycle(ModalDialog.this);
                            }
                            if (logger.level >= 9) {
                                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                                if (logger.level >= 9) {
                                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "showDialog(Component,boolean).WindowAdapter.windowActivated(WindowEvent).Runnable.run()", 812).add("Focused window: ", keyboardFocusManager.getFocusedWindow())).log();
                                }
                                if (logger.level >= 9) {
                                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "showDialog(Component,boolean).WindowAdapter.windowActivated(WindowEvent).Runnable.run()", 813).add("Focus owner: ", keyboardFocusManager.getFocusOwner())).log();
                                }
                                if (logger.level >= 9) {
                                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "showDialog(Component,boolean).WindowAdapter.windowActivated(WindowEvent).Runnable.run()", 814).add("Window's focus owner: ")).add("getFocusOwner()", ModalDialog.this.getFocusOwner())).log();
                                }
                            }
                        }
                    });
                    ModalDialog.this.removeWindowListener(this);
                }
            });
        }
        if (this.defaultButton != null) {
            this.getRootPane().setDefaultButton(this.defaultButton);
        }
        if (forceToFront) {
            SwingUtilities.invokeLater(() -> {
                if (toFrontHandler == null || !toFrontHandler.apply(this).booleanValue()) {
                    this.setAlwaysOnTop(true);
                    SwingUtilities.invokeLater(() -> this.setAlwaysOnTop(false));
                }
            });
        }
        this.setVisible(true);
    }

    public void setResult(int n) {
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setResult(int)", 850).addDetail("result", n)).log();
        }
        this.retval = n;
    }

    public int getButtonCount() {
        return this.buttons == null ? 0 : this.buttons.length;
    }

    public JButton getButton(int n) throws IndexOutOfBoundsException {
        if (this.buttons == null) {
            throw new IndexOutOfBoundsException("no buttons");
        }
        return this.buttons[n].button;
    }

    public JButton getButton(String string) {
        if (this.buttons == null) {
            return null;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].name.equals(string)) continue;
            return this.buttons[i].button;
        }
        return null;
    }

    public void setDefaultButton(JButton jButton) {
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setDefaultButton(JButton)", 924).addDetail("btn", jButton)).log();
        }
        this.defaultButton = jButton;
        if (this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.defaultButton);
        }
    }

    @Override
    public void dispose() {
        if (ModalDialog.logger.level >= 7) {
            logger.lvlBuild(7, "dispose()", 938).log();
        }
        super.dispose();
        SwingUtil.cleanupKeystrokeMap(this);
    }

    protected String[] initButtonNames(MapResourceBundle mapResourceBundle) {
        return this.initButtonNames(mapResourceBundle, "buttons", defaultButtons);
    }

    private String[] initButtonNames(MapResourceBundle mapResourceBundle, String string, String[] stringArray) {
        String string2;
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "initButtonNames(MapResourceBundle,String,String[])", 968).addDetail("rb", mapResourceBundle)).addDetail("baseResName", string)).addDetail("defaultButtons", stringArray)).log();
        }
        if ((string2 = this.getButtonResource(mapResourceBundle, string)) == null) {
            return stringArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\r\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[0]);
    }

    protected String[] initListButtonNames(MapResourceBundle mapResourceBundle) {
        return this.initButtonNames(mapResourceBundle, "listButtons", new String[0]);
    }

    private String getButtonResource(MapResourceBundle mapResourceBundle, String string) {
        String string2;
        String string3;
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getButtonResource(MapResourceBundle,String)", 995).addDetail("rb", mapResourceBundle)).addDetail("baseResName", string)).log();
        }
        if ((string3 = mapResourceBundle.getString(string2 = this.resName(string), null)) == null) {
            string2 = this.name + "." + string;
            string3 = mapResourceBundle.getString(string2, null);
        }
        return string3;
    }

    protected ButtonData initButton(String string, MapResourceBundle mapResourceBundle) {
        ButtonData buttonData = new ButtonData(string, mapResourceBundle);
        if (buttonData.focus) {
            this.setInitialFocusTarget(buttonData.button);
        }
        return buttonData;
    }

    protected void initComponent() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            if (this.isVisible()) {
                int n = this.findButton((JButton)actionEvent.getSource());
                if (n >= 0) {
                    this.retval = this.buttons[n].hasRetval ? this.buttons[n].retval : n;
                    if (this.buttons[n].close) {
                        this.close();
                    }
                }
            } else if (ModalDialog.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "actionPerformed(ActionEvent)", 1071).add("Ignoring action performed on invisible dialog.")).log();
            }
        } else if ("defaultAction".equals(actionEvent.getActionCommand())) {
            if (this.defaultButton != null && this.defaultButton.isEnabled()) {
                this.defaultButton.doClick(20);
            }
        } else if ("returnAction".equals(actionEvent.getActionCommand()) && returnTriggersFocusedButton) {
            int n;
            Component component = this.getFocusOwner();
            JButton jButton = this.defaultButton;
            if (component instanceof JButton && (n = this.findButton((JButton)component)) >= 0) {
                jButton = (JButton)component;
            }
            if (jButton != null && jButton.isEnabled()) {
                jButton.doClick(20);
            }
        }
    }

    public void close() {
        SwingUtil.deactivateInputContexts(this);
        this.setVisible(false);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.retval = -1;
        this.close();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    protected void fixSize() {
        GraphicsConfiguration graphicsConfiguration;
        int n;
        int n2;
        Serializable serializable;
        Object object;
        if (ModalDialog.logger.level >= 7) {
            logger.lvlBuild(7, "fixSize()", 1199).log();
        }
        this.pack();
        Dimension dimension = this.getSize();
        if (this.maybeForceSize) {
            object = new AWTTreeAdapter();
            serializable = (Boolean)TreeUtil.visitTree((TreeAdapter)object, new SearchPaneVisitor(), this);
            boolean bl = this.forceSize = serializable != null && serializable != false;
        }
        if (this.forceSize && this.minWidth > 0 && this.minHeight > 0) {
            n2 = this.minWidth;
            n = this.minHeight;
        } else {
            n2 = Math.max(this.minWidth, dimension.width);
            n = Math.max(this.minHeight, dimension.height);
        }
        object = this.getOwner();
        serializable = null;
        if (object != null && (graphicsConfiguration = ((Component)object).getGraphicsConfiguration()) != null) {
            serializable = SwingUtil.getUsableBounds(graphicsConfiguration);
        }
        if (serializable == null) {
            serializable = SwingUtil.getUsableBoundsOfDefaultScreen();
        }
        n2 = Math.min(n2, ((Rectangle)serializable).width);
        n = Math.min(n, ((Rectangle)serializable).height);
        this.setSize(n2, n);
        this.pack();
        if (!this.forceSize) {
            dimension = this.getSize();
            n2 = Math.max(this.minWidth, dimension.width);
            n = Math.max(this.minHeight, dimension.height);
        }
        this.setSize(n2, n);
        double d = Math.max(1.0, ThemeSupport.getFontScale());
        this.setMinimumSize(new Dimension((int)Math.min((double)n2, 300.0 * d), (int)Math.min((double)n, 200.0 * d)));
    }

    protected String resName(String string) {
        return "dialog." + this.name + "." + string;
    }

    protected static String buttonResName(String string, String string2) {
        return "dialog.button." + string + "." + string2;
    }

    protected int findButton(JButton jButton) {
        if (this.buttons == null) {
            return -1;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i].button != jButton) continue;
            return i;
        }
        return -1;
    }

    @Deprecated
    public static Image getDefaultIconImage() {
        if (ModalDialog.logger.level >= 7) {
            logger.lvlBuild(7, "getDefaultIconImage()", 1316).log();
        }
        if (defaultIconImage == null) {
            defaultIconImage = ModalDialog.loadIconImage("default.icon");
        }
        return defaultIconImage;
    }

    public static List<Image> getDefaultIconImages() {
        if (ModalDialog.logger.level >= 7) {
            logger.lvlBuild(7, "getDefaultIconImages()", 1327).log();
        }
        if (defaultIconImages == null) {
            defaultIconImages = ModalDialog.loadIconImages("default.icon");
        }
        return defaultIconImages;
    }

    @Nullable
    @Deprecated
    public static Image loadIconImage(@NonNull String string) {
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "loadIconImage(String)", 1349).addDetail("resourceName", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("resourceName is marked non-null but is null");
        }
        MapResourceBundle mapResourceBundle = Option.getResources();
        if (mapResourceBundle == null) {
            return defaultIconImage;
        }
        Icon icon = mapResourceBundle.getIcon(string, null);
        if (icon == null) {
            return defaultIconImage;
        }
        if (icon instanceof SVGIcon) {
            SVGIcon sVGIcon = (SVGIcon)icon;
            Image image = sVGIcon.getImage(1.0, 1.0);
            if (image == null) {
                return defaultIconImage;
            }
            return image;
        }
        ImageIcon imageIcon = (ImageIcon)icon;
        Image image = imageIcon.getImage();
        if (image == null) {
            return defaultIconImage;
        }
        return image;
    }

    @Nullable
    public static List<Image> loadIconImages(@NonNull String string) {
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "loadIconImages(String)", 1380).addDetail("resourceName", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("resourceName is marked non-null but is null");
        }
        MapResourceBundle mapResourceBundle = Option.getResources();
        ArrayList<Image> arrayList = new ArrayList<Image>();
        if (mapResourceBundle == null) {
            arrayList.add(defaultIconImage);
            return arrayList;
        }
        Icon icon = mapResourceBundle.getIcon(string, null);
        if (icon == null) {
            arrayList.add(defaultIconImage);
            return arrayList;
        }
        if (icon instanceof SVGIcon) {
            SVGIcon sVGIcon = (SVGIcon)icon;
            for (int n : defaultIconSizes) {
                double d = 1.0 * (double)n / (1.0 * (double)sVGIcon.getIconWidth());
                arrayList.add(sVGIcon.getImage(d, d));
            }
            return arrayList;
        }
        ImageIcon imageIcon = (ImageIcon)icon;
        Image image = imageIcon.getImage();
        if (image == null) {
            image = defaultIconImage;
        }
        arrayList.add(image);
        return arrayList;
    }

    @Generated
    public static boolean isForceToFront() {
        if (ModalDialog.logger.level >= 7) {
            logger.lvlBuild(7, "isForceToFront()", 263).log();
        }
        return forceToFront;
    }

    @Generated
    public static void setForceToFront(boolean bl) {
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setForceToFront(boolean)", 263).addDetail("forceToFront", bl)).log();
        }
        forceToFront = bl;
    }

    @Generated
    public static Function<Dialog, Boolean> getToFrontHandler() {
        if (ModalDialog.logger.level >= 7) {
            logger.lvlBuild(7, "getToFrontHandler()", 266).log();
        }
        return toFrontHandler;
    }

    @Generated
    public static void setToFrontHandler(Function<Dialog, Boolean> function) {
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setToFrontHandler(Function<Dialog, Boolean>)", 266).addDetail("toFrontHandler", function)).log();
        }
        toFrontHandler = function;
    }

    @Generated
    public String getResourceName() {
        if (ModalDialog.logger.level >= 7) {
            logger.lvlBuild(7, "getResourceName()", 283).log();
        }
        return this.resourceName;
    }

    @Generated
    public JButton getDefaultButton() {
        if (ModalDialog.logger.level >= 7) {
            logger.lvlBuild(7, "getDefaultButton()", 309).log();
        }
        return this.defaultButton;
    }

    @Generated
    public float getButtonAlignment() {
        if (ModalDialog.logger.level >= 7) {
            logger.lvlBuild(7, "getButtonAlignment()", 357).log();
        }
        return this.buttonAlignment;
    }

    @Generated
    public ModalDialog setButtonAlignment(float f) {
        if (ModalDialog.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setButtonAlignment(float)", 358).addDetail("buttonAlignment", f)).log();
        }
        this.buttonAlignment = f;
        return this;
    }

    public static class SearchPaneVisitor {
        public SearchPaneVisitor() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "SearchPaneVisitor.SearchPaneVisitor()", 1562).log();
            }
        }

        public Object visit(Object object) {
            return null;
        }

        public Object visit(JEditorPane jEditorPane) {
            if ("text/html".equals(jEditorPane.getContentType())) {
                throw new ReturnFromTraversalException(Boolean.TRUE);
            }
            return null;
        }
    }

    public static class ButtonData {
        public String name;
        public JButton button;
        public int retval;
        public boolean hasRetval;
        public boolean close;
        public boolean deflt;
        public boolean focus;
        public boolean listButton;

        public ButtonData() {
        }

        public ButtonData(String string, MapResourceBundle mapResourceBundle) {
            String string2;
            Cloneable cloneable;
            Icon icon;
            this.name = string;
            String string3 = mapResourceBundle.getString(ModalDialog.buttonResName(string, "label"), "MISSING: " + string);
            KeyStroke keyStroke = KeyOptionEdit.getKeyStrokeForResource("dialog.button." + string);
            if (keyStroke != null) {
                string3 = Message.format(string3, new String[]{KeyOptionEdit.getKeyStrokeAsString(keyStroke)});
            }
            this.button = new JButton(string3);
            this.button.setName(mapResourceBundle.getString(ModalDialog.buttonResName(string, "name"), "Button-" + string));
            String string4 = mapResourceBundle.getString(ModalDialog.buttonResName(string, "mnemonic"), null);
            if (!Misc.emptyOrNull(string4)) {
                this.button.setMnemonic(string4.charAt(0));
            }
            if ((icon = mapResourceBundle.getThemedIcon(ModalDialog.buttonResName(string, "icon"), null, true)) != null) {
                this.button.setIcon(icon);
                int n = mapResourceBundle.getInt(ModalDialog.buttonResName(string, "icon.margin"), 0);
                if (n != 0) {
                    cloneable = this.button.getMargin();
                    this.button.setMargin(new Insets(cloneable.top + n, cloneable.left + n, cloneable.bottom + n, cloneable.right));
                }
            }
            if ((string2 = mapResourceBundle.getString(ModalDialog.buttonResName(string, "tooltip"), null)) != null) {
                this.button.setToolTipText(string2);
            }
            if (mapResourceBundle.getString(ModalDialog.buttonResName(string, "retval"), null) != null) {
                this.hasRetval = true;
                this.retval = mapResourceBundle.getInt(ModalDialog.buttonResName(string, "retval"), -1);
            }
            this.deflt = mapResourceBundle.getBoolean(ModalDialog.buttonResName(string, "default"), false);
            if (!this.deflt) {
                this.button.setDefaultCapable(false);
            }
            this.close = mapResourceBundle.getBoolean(ModalDialog.buttonResName(string, "close"), true);
            this.button.setEnabled(!mapResourceBundle.getBoolean(ModalDialog.buttonResName(string, "disabled"), false));
            this.focus = mapResourceBundle.getBoolean(ModalDialog.buttonResName(string, "focus"), false);
            cloneable = this.button.getPreferredSize();
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "ButtonData.ButtonData(String,MapResourceBundle)", 1535).add("prefSize", cloneable)).log();
            }
            if (((Dimension)cloneable).width < 50) {
                this.button.setPreferredSize(new Dimension(50, ((Dimension)cloneable).height));
            }
            String string5 = mapResourceBundle.getString(ModalDialog.buttonResName(string, "action"), string);
            try {
                Object object = Reflector.createInstance(Class.forName(string5));
                if (!(object instanceof ActionListener)) {
                    throw new Exception();
                }
                this.button.addActionListener((ActionListener)object);
            }
            catch (Throwable throwable) {
                this.button.setActionCommand(string5);
            }
        }
    }
}

