/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.config.Configurable;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.config.JSplitPaneConfigWrapper;
import de.qfs.lib.config.RegistrationHelper;
import de.qfs.lib.gui.MultiPaneEvent;
import de.qfs.lib.gui.MultiPaneListener;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.Logger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class MultiPane
extends JPanel
implements Configurable,
PropertyChangeListener {
    private static final Logger logger = new Logger("de.qfs.lib.gui.MultiPane");
    public static final int SHOW_BOTH = 0;
    public static final int SHOW_FIRST = 1;
    public static final int SHOW_SECOND = 2;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 0;
    private Component first;
    private Component second;
    private JSplitPane split;
    private int shown = 0;
    private int divider = -1;
    private double relDivider = -1.0;
    private boolean override = true;
    private JSplitPaneConfigWrapper wrapper;
    private String name;
    private Vector listeners = new Vector();
    private RegistrationHelper regHelper = new RegistrationHelper();
    private boolean proportionalResize = true;

    public MultiPane(int n) {
        this(n, null, null);
    }

    public MultiPane(int n, Component component, Component component2) {
        this("MultiPane", n, component, component2, 0.5, 0, false);
    }

    public MultiPane(String string, int n, Component component, Component component2, int n2, int n3) throws IllegalArgumentException {
        if (MultiPane.logger.level >= 7) {
            logger.log(7, "MultiPane(String,int,Component,Component,int,int)", MultiPane.logger.level < 8 ? "" : "name: " + string + ", orientation: " + n + ", firstComponent: " + component + ", secondComponent: " + component2 + ", divider: " + n2 + ", show: " + n3);
        }
        this.name = string;
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        this.first = component;
        this.second = component2;
        this.split = new JSplitPane(n){

            @Override
            public void setDividerLocation(int n) {
                n = MultiPane.this.enforceConstraints(this, n);
                super.setDividerLocation(n);
            }
        };
        this.split.addPropertyChangeListener(this);
        this.split.setBorder(null);
        this.wrapper = new JSplitPaneConfigWrapper(this.split, string, n2);
        this.divider = n2;
        this.shown = -1;
        this.setShowing(n3);
    }

    public MultiPane(String string, int n, Component component, Component component2, double d, int n2, final boolean bl) throws IllegalArgumentException {
        if (MultiPane.logger.level >= 7) {
            Logger.Builder builder = logger.build("MultiPane(String,int,Component,Component,double,int,boolean)");
            (MultiPane.logger.level < 8 ? builder : builder.add("name: ").add(string).add(", orientation: ").add(n).add(", firstComponent: ").add(component).add(", secondComponent: ").add(component2).add(", divider: ").add(d).add(", show: ").add(n2).add(", resizeProportionally: ").add(bl)).log(7);
        }
        this.name = string;
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        this.first = component;
        this.second = component2;
        this.split = new JSplitPane(n){

            @Override
            public void setDividerLocation(int n) {
                n = MultiPane.this.enforceConstraints(this, n);
                super.setDividerLocation(n);
                if (!bl) {
                    return;
                }
                Dimension dimension = this.getSize();
                double d = (double)n / (double)((this.getOrientation() == 0 ? dimension.height : dimension.width) - this.getDividerSize());
                if (d >= 0.0 && d <= 1.0) {
                    this.setResizeWeight(d);
                }
            }
        };
        this.split.addPropertyChangeListener(this);
        this.split.setBorder(null);
        this.wrapper = new JSplitPaneConfigWrapper(this.split, string, d);
        this.relDivider = d;
        this.shown = -1;
        this.setShowing(n2);
    }

    public JSplitPane getSplitPane() {
        if (MultiPane.logger.level >= 7) {
            logger.log(7, "getSplitPane()", MultiPane.logger.level < 8 ? "" : "myName: " + this.name);
        }
        return this.split;
    }

    public final int getShowing() {
        if (MultiPane.logger.level >= 7) {
            logger.log(7, "getShowing()", MultiPane.logger.level < 8 ? "" : "myName: " + this.name);
        }
        return this.shown;
    }

    public void setShowing(int n) throws IllegalArgumentException {
        Window window;
        Component component;
        if (MultiPane.logger.level >= 7) {
            logger.log(7, "setShowing(int)", MultiPane.logger.level < 8 ? "" : "myName: " + this.name + ", show: " + n + " (divider: " + this.divider + ")");
        }
        if (n < 0 && n > 2) {
            throw new IllegalArgumentException("setShowing: argument " + n + " must be oned of SHOW_BOTH, SHOW_FIRST or SHOW_SECOND");
        }
        if (this.shown == n) {
            if (this.shown == 0 && this.divider >= 0) {
                final int n2 = this.divider;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (logger.level >= 9) {
                            logger.log(9, "run()", "Setting tmp:" + n2 + ", myName: " + MultiPane.this.name);
                        }
                        MultiPane.this.split.setDividerLocation(n2);
                    }
                });
            }
            return;
        }
        if (this.shown == 0) {
            // empty if block
        }
        Component component2 = component = (window = SwingUtilities.getWindowAncestor(this)) == null ? null : window.getMostRecentFocusOwner();
        if (component != null && !SwingUtilities.isDescendingFrom(component, this)) {
            component = null;
        }
        if (MultiPane.logger.level >= 10) {
            logger.log(10, "setShowing(int)", "focusOwner: " + component);
        }
        if (component != null) {
            this.requestFocusInWindow();
        }
        this.shown = n;
        switch (this.shown) {
            case 0: {
                final int n3 = this.divider;
                if (MultiPane.logger.level >= 9) {
                    logger.log(9, "setShowing(int)", "Old divider: " + n3);
                }
                this.split.setLeftComponent(this.first);
                this.split.setRightComponent(this.second);
                this.add((Component)this.split, "Center");
                if (n3 >= 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (logger.level >= 9) {
                                logger.log(9, "run()", "Setting tmp:" + n3 + ", myName: " + MultiPane.this.name);
                            }
                            MultiPane.this.split.setDividerLocation(n3);
                        }
                    });
                } else if (this.relDivider >= 0.0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (logger.level >= 9) {
                                logger.log(9, "run()", "Setting relDivider: " + MultiPane.this.relDivider + ", myName: " + MultiPane.this.name);
                            }
                            MultiPane.this.split.setDividerLocation(MultiPane.this.relDivider);
                        }
                    });
                }
                if (component == null) break;
                component.requestFocusInWindow();
                break;
            }
            case 1: {
                this.removeAll();
                this.add(this.first, "Center");
                if (component == null) break;
                if (SwingUtilities.isDescendingFrom(component, this.first)) {
                    component.requestFocusInWindow();
                    break;
                }
                this.first.requestFocusInWindow();
                break;
            }
            case 2: {
                this.removeAll();
                this.add(this.second, "Center");
                if (component == null) break;
                if (SwingUtilities.isDescendingFrom(component, this.second)) {
                    component.requestFocusInWindow();
                    break;
                }
                this.second.requestFocusInWindow();
            }
        }
        this.revalidate();
        if (component != null) {
            // empty if block
        }
        this.fireShowingChanged(this.shown);
    }

    public final Component getFirstComponent() {
        if (MultiPane.logger.level >= 7) {
            logger.log(7, "getFirstComponent()", MultiPane.logger.level < 8 ? "" : "myName: " + this.name);
        }
        return this.first;
    }

    public final void setFirstComponent(Component component) {
        if (MultiPane.logger.level >= 7) {
            logger.log(7, "setFirstComponent(Component)", MultiPane.logger.level < 8 ? "" : "myName: " + this.name + ", first: " + component);
        }
        if (this.first == component) {
            if (MultiPane.logger.level >= 9) {
                logger.log(9, "setFirstComponent(Component)", "No change");
            }
            return;
        }
        this.first = component;
        if (this.shown == 0) {
            this.split.setLeftComponent(component);
        } else if (this.shown == 1) {
            this.removeAll();
            if (component != null) {
                this.add(component, "Center");
            }
        }
    }

    public final Component getSecondComponent() {
        if (MultiPane.logger.level >= 7) {
            logger.log(7, "getSecondComponent()", MultiPane.logger.level < 8 ? "" : "myName: " + this.name);
        }
        return this.second;
    }

    public final void setSecondComponent(Component component) {
        if (MultiPane.logger.level >= 7) {
            logger.log(7, "setSecondComponent(Component)", MultiPane.logger.level < 8 ? "" : "myName: " + this.name + ", second: " + component);
        }
        if (this.second == component) {
            if (MultiPane.logger.level >= 9) {
                logger.log(9, "setSecondComponent(Component)", "No change");
            }
            return;
        }
        this.second = component;
        if (this.shown == 0) {
            this.split.setRightComponent(component);
        } else if (this.shown == 2) {
            this.removeAll();
            if (component != null) {
                this.add(component, "Center");
            }
        }
    }

    public void addMultiPaneListener(MultiPaneListener multiPaneListener) {
        this.listeners.addElement(multiPaneListener);
    }

    public void removeMultiPaneListener(MultiPaneListener multiPaneListener) {
        this.listeners.removeElement(multiPaneListener);
    }

    private void fireShowingChanged(int n) {
        Vector vector = (Vector)this.listeners.clone();
        MultiPaneEvent multiPaneEvent = new MultiPaneEvent(this, n);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((MultiPaneListener)enumeration.nextElement()).showingChanged(multiPaneEvent);
        }
        this.regHelper.stateChanged(this);
    }

    @Override
    public final String getConfigurableName() {
        return this.name;
    }

    @Override
    public final void setConfigurableName(String string) {
        if (MultiPane.logger.level >= 7) {
            logger.log(7, "setConfigurableName(String)", MultiPane.logger.level < 8 ? "" : "name: " + string);
        }
        this.name = string;
    }

    @Override
    public Properties getConfigurableState() {
        Properties properties;
        if (MultiPane.logger.level >= 7) {
            logger.log(7, "getConfigurableState()", "");
        }
        if (this.shown == 0) {
            properties = this.wrapper.getConfigurableState();
        } else {
            properties = new Properties();
            if (this.divider >= 0) {
                properties.put("divider", "" + this.divider);
            } else if (this.relDivider >= 0.0) {
                properties.put("divider", "" + this.relDivider);
            }
        }
        properties.put("show", "" + this.shown);
        return properties;
    }

    @Override
    public void setConfigurableState(Properties properties) {
        if (MultiPane.logger.level >= 7) {
            logger.log(7, "setConfigurableState(Properties)", MultiPane.logger.level < 8 ? "" : "myName: " + this.name + ", state: " + properties);
        }
        this.wrapper.setConfigurableState(properties);
        String string = properties.getProperty("divider");
        if (MultiPane.logger.level >= 9) {
            logger.log(9, "setConfigurableState(Properties)", "divider: " + string);
        }
        if (string == null) {
            if (MultiPane.logger.level >= 3) {
                logger.log(3, "setConfigurableState(Properties)", "Invalid state: divider: " + string);
            }
            return;
        }
        try {
            this.divider = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                this.relDivider = Double.valueOf(string);
                this.divider = -1;
            }
            catch (NumberFormatException numberFormatException2) {
                logger.log(3, "setConfigurableState(Properties)", numberFormatException2);
                return;
            }
        }
        int n = this.divider;
        String string2 = properties.getProperty("show");
        if (MultiPane.logger.level >= 9) {
            logger.log(9, "setConfigurableState(Properties)", "show: " + string2);
        }
        if (string2 == null) {
            if (MultiPane.logger.level >= 3) {
                logger.log(3, "setConfigurableState(Properties)", "Invalid state: show: " + string2);
            }
            return;
        }
        try {
            final int n2 = Integer.parseInt(string2);
            SwingUtil.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MultiPane.this.setShowing(n2);
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            logger.log(3, "setConfigurableState(Properties)", numberFormatException);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.log(3, "setConfigurableState(Properties)", illegalArgumentException);
            return;
        }
        this.divider = n;
    }

    @Override
    public void registrationChanged(Configuration configuration, String string, boolean bl, boolean bl2) {
        if (MultiPane.logger.level >= 7) {
            logger.log(7, "registrationChanged(Configuration,String,boolean,boolean)", MultiPane.logger.level < 8 ? "" : "name: " + string + ", registered: " + bl);
        }
        this.regHelper.registrationChanged(configuration, bl);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (MultiPane.logger.level >= 7) {
            logger.log(7, "propertyChanged(PropertyChangeEvent)", MultiPane.logger.level < 8 ? "" : "myName: " + this.getConfigurableName() + ", propertyName: " + propertyChangeEvent.getPropertyName());
        }
        if (propertyChangeEvent.getPropertyName().endsWith("ividerLocation")) {
            if (!this.isShowing() && (this.divider >= 0 || this.relDivider >= 0.0)) {
                if (MultiPane.logger.level >= 9) {
                    logger.log(9, "propertyChange(PropertyChangeEvent)", "not showing, ignored");
                }
                if (this.override) {
                    this.override = false;
                    if (this.divider >= 0) {
                        if (MultiPane.logger.level >= 9) {
                            logger.log(9, "propertyChange(PropertyChangeEvent)", "Setting divider: " + this.divider + ", myName: " + this.name);
                        }
                        this.split.setDividerLocation(this.divider);
                    } else {
                        if (MultiPane.logger.level >= 9) {
                            logger.log(9, "propertyChange(PropertyChangeEvent)", "Setting divider: " + this.divider + ", myName: " + this.name);
                        }
                        this.split.setDividerLocation(this.divider);
                        if (MultiPane.logger.level >= 9) {
                            logger.log(9, "propertyChange(PropertyChangeEvent)", "Setting relDivider: " + this.relDivider + ", myName: " + this.name);
                        }
                        this.split.setDividerLocation(this.relDivider);
                    }
                }
            } else {
                this.divider = this.split.getDividerLocation();
                if (MultiPane.logger.level >= 9) {
                    logger.log(9, "propertyChange(PropertyChangeEvent)", "divider: " + this.divider);
                }
                this.regHelper.stateChanged(this);
            }
        }
    }

    protected int enforceConstraints(JSplitPane jSplitPane, int n) {
        if (MultiPane.logger.level >= 7) {
            Logger.Builder builder = logger.build("enforceConstraints(JSplitPane,int)");
            (MultiPane.logger.level < 8 ? builder : builder.add("pane: ").add(jSplitPane).add(", loc: ").add(n)).dumpStack(7);
        }
        if (jSplitPane.getLeftComponent() == null || jSplitPane.getRightComponent() == null) {
            if (MultiPane.logger.level >= 9) {
                logger.log(9, "enforceConstraints(JSplitPane,int)", "Null component");
            }
            return n;
        }
        boolean bl = jSplitPane.getOrientation() == 1;
        Dimension dimension = jSplitPane.getLeftComponent().getMinimumSize();
        int n2 = (int)Math.floor(bl ? dimension.getWidth() : dimension.getHeight());
        Dimension dimension2 = jSplitPane.getRightComponent().getMinimumSize();
        int n3 = (int)Math.floor(bl ? dimension2.getWidth() : dimension2.getHeight());
        if (MultiPane.logger.level >= 9) {
            logger.build("enforceConstraints(JSplitPane,int)").add("minFirst: ").add(n2).log(9);
        }
        if (MultiPane.logger.level >= 9) {
            logger.build("enforceConstraints(JSplitPane,int)").add("minSecond: ").add(n3).log(9);
        }
        Dimension dimension3 = jSplitPane.getSize();
        if (MultiPane.logger.level >= 9) {
            logger.build("enforceConstraints(JSplitPane,int)").add("mySize: ").add(dimension3).log(9);
        }
        if (dimension3.getWidth() == 0.0 || dimension3.getHeight() == 0.0) {
            if (MultiPane.logger.level >= 9) {
                logger.log(9, "enforceConstraints(JSplitPane,int)", "Zero size");
            }
            return n;
        }
        int n4 = (int)Math.floor(bl ? dimension3.getWidth() : dimension3.getHeight());
        if (n4 - n - jSplitPane.getDividerSize() < n3) {
            n = Math.max(0, n4 - n3 - jSplitPane.getDividerSize());
            if (MultiPane.logger.level >= 9) {
                logger.build("enforceConstraints(JSplitPane,int)").add("loc corrected for second: ").add(n).log(9);
            }
        }
        if (n < n2) {
            n = Math.min(n2, n4 - jSplitPane.getDividerSize());
            if (MultiPane.logger.level >= 9) {
                logger.build("enforceConstraints(JSplitPane,int)").add("loc corrected for first: ").add(n).log(9);
            }
        }
        return n;
    }
}

