/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import lombok.Generated;

public class PlaceholderTextField
extends JTextField {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.PlaceholderTextField");
    private String placeholder;
    private String cssClass = "FilteredTextField";
    private boolean emptyTextBorder = false;

    public PlaceholderTextField(String string) {
        super(string);
        if (PlaceholderTextField.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "PlaceholderTextField(String)", 69).addDetail("text", string)).log();
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (PlaceholderTextField.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "paintComponent(Graphics)", 81).addDetail("pG", graphics)).log();
        }
        super.paintComponent(graphics);
        if (UIManager.getColor(this.cssClass + ".background") != null) {
            this.setBackground(UIManager.getColor(this.cssClass + ".background"));
        }
        if (this.placeholder == null || this.placeholder.isEmpty() || !this.getText().isEmpty()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(UIManager.getColor(this.cssClass + ".textColor"));
        graphics2D.drawString(this.placeholder, this.getInsets().left, graphics.getFontMetrics().getMaxAscent() + this.getInsets().top);
    }

    @Override
    public void updateUI() {
        if (PlaceholderTextField.logger.level >= 7) {
            logger.lvlBuild(7, "updateUI()", 107).log();
        }
        super.updateUI();
        this.setBackground(UIManager.getColor(this.cssClass + ".background"));
        if (this.emptyTextBorder) {
            this.setBorder(BorderFactory.createEmptyBorder());
        } else if (this.getBorder() instanceof CompoundBorder) {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(1, 1, 0, 1, UIManager.getColor(this.cssClass + ".borderColor"));
            Border border = BorderFactory.createEmptyBorder(2, 2, 3, 0);
            this.setBorder(new CompoundBorder(matteBorder, border));
        } else {
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.getDisabledTextColor()));
        }
    }

    @Override
    public boolean isFocusTraversable() {
        if (PlaceholderTextField.logger.level >= 7) {
            logger.lvlBuild(7, "isFocusTraversable()", 129).log();
        }
        return this.isEditable() && this.isEnabled();
    }

    @Override
    public boolean isFocusable() {
        if (PlaceholderTextField.logger.level >= 7) {
            logger.lvlBuild(7, "isFocusable()", 141).log();
        }
        return true;
    }

    @Generated
    public PlaceholderTextField() {
        if (PlaceholderTextField.logger.level >= 7) {
            logger.lvlBuild(7, "PlaceholderTextField()", 39).log();
        }
    }

    @Generated
    public String getPlaceholder() {
        return this.placeholder;
    }

    @Generated
    public PlaceholderTextField setPlaceholder(String string) {
        this.placeholder = string;
        return this;
    }

    @Generated
    public String getCssClass() {
        return this.cssClass;
    }

    @Generated
    public PlaceholderTextField setCssClass(String string) {
        this.cssClass = string;
        return this;
    }

    @Generated
    public PlaceholderTextField setEmptyTextBorder(boolean bl) {
        this.emptyTextBorder = bl;
        return this;
    }
}

