/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.gui.Message;
import de.qfs.lib.gui.PopupHandler;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.edit.KeyOptionEdit;
import de.qfs.lib.util.MapResourceBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import lombok.Generated;

public class PopupManager
implements PopupHandler,
MouseListener,
PopupMenuListener {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.PopupManager");
    protected static PopupManager instance;
    protected static final String POPUP_HANDLER_KEY = "qflib:popupHandler";
    protected static MapResourceBundle rb;
    protected JPopupMenu popup;
    protected Point popupPosition = new Point();
    protected static PopupCleanupListener popupCleanupListener;
    protected transient JMenuItem pmiCut;
    protected transient JMenuItem pmiCopy;
    protected transient JMenuItem pmiPaste;
    protected transient JMenuItem pmiDelete;
    protected transient JMenuItem pmiSelectAll;
    protected boolean needsTextModificationItems = true;

    protected PopupManager() {
    }

    public static PopupManager instance() {
        return instance;
    }

    public void registerPopupHandler(PopupHandler popupHandler, JComponent jComponent) {
        Vector<PopupHandler> vector;
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "registerPopupHandler(PopupHandler,JComponent)", 262).addDetail("handler", popupHandler)).addDetail("com", jComponent)).log();
        }
        if ((vector = (Vector<PopupHandler>)jComponent.getClientProperty(POPUP_HANDLER_KEY)) == null) {
            vector = new Vector<PopupHandler>();
            jComponent.putClientProperty(POPUP_HANDLER_KEY, vector);
            jComponent.removeMouseListener(this);
            jComponent.addMouseListener(this);
        } else if (vector.contains(popupHandler)) {
            return;
        }
        vector.add(popupHandler);
        if (jComponent.isFocusable()) {
            jComponent.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.isShiftDown()) {
                        Component component = (Component)keyEvent.getSource();
                        Dimension dimension = component.getSize();
                        PopupManager.this.maybeShowPopup(component, dimension.width / 2, dimension.height / 2, false);
                        keyEvent.consume();
                    }
                }
            });
        }
    }

    public void unregisterPopupHandler(PopupHandler popupHandler, JComponent jComponent) {
        Vector vector;
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "unregisterPopupHandler(PopupHandler,JComponent)", 303).addDetail("handler", popupHandler)).addDetail("com", jComponent)).log();
        }
        if ((vector = (Vector)jComponent.getClientProperty(POPUP_HANDLER_KEY)) != null && vector.contains(popupHandler)) {
            vector.remove(popupHandler);
            if (vector.size() == 0) {
                jComponent.removeMouseListener(this);
                jComponent.putClientProperty(POPUP_HANDLER_KEY, null);
            }
            if (jComponent.isFocusable()) {
                jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(525, 0));
                KeyStroke keyStroke = KeyOptionEdit.getKeyStrokeForResource("popup.contextmenutrigger");
                if (keyStroke != null) {
                    jComponent.unregisterKeyboardAction(keyStroke);
                }
            }
        }
    }

    public Point getPopupPosition() {
        if (PopupManager.logger.level >= 7) {
            logger.lvlBuild(7, "getPopupPosition()", 332).log();
        }
        return this.popupPosition;
    }

    public void setPopupPosition(Point point) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setPopupPosition(Point)", 347).addDetail("pos", point)).log();
        }
        this.popupPosition = point;
    }

    @Override
    public boolean fillPopup(PopupManager popupManager, Component component, JPopupMenu jPopupMenu, MapResourceBundle mapResourceBundle, int n, int n2, boolean bl) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fillPopup(PopupManager,Component,JPopupMenu,MapResourceBundle,int,int,boolean)", 373).addDetail("manager", popupManager)).addDetail("parent", component)).addDetail("popup", jPopupMenu)).addDetail("rb", mapResourceBundle)).addDetail("x", n)).addDetail("y", n2)).addDetail("popupTrigger", bl)).log();
        }
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent;
            block21: {
                Object object;
                KeyStroke keyStroke;
                KeyStroke keyStroke2;
                AbstractAction abstractAction;
                jTextComponent = (JTextComponent)component;
                if (this.doesNeedTextModificationItems()) {
                    abstractAction = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            jTextComponent.cut();
                        }
                    };
                    this.setupAction(abstractAction, mapResourceBundle, "popup.cut");
                    this.pmiCut = this.createMenuItem("cut", mapResourceBundle, "popup.cut", (ActionListener)abstractAction, false);
                    keyStroke2 = KeyOptionEdit.getKeyStrokeForResource("popup.cut");
                    if (keyStroke2 != null) {
                        this.pmiCut.setAccelerator(keyStroke2);
                    }
                    popupManager.addMenuItem(this.pmiCut, -1, "");
                }
                abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        jTextComponent.copy();
                    }
                };
                this.setupAction(abstractAction, mapResourceBundle, "popup.copy");
                this.pmiCopy = this.createMenuItem("copy", mapResourceBundle, "popup.copy", (ActionListener)abstractAction, false);
                keyStroke2 = KeyOptionEdit.getKeyStrokeForResource("popup.copy");
                if (keyStroke2 != null) {
                    this.pmiCopy.setAccelerator(keyStroke2);
                }
                popupManager.addMenuItem(this.pmiCopy, -1, "");
                if (this.doesNeedTextModificationItems()) {
                    abstractAction = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            jTextComponent.paste();
                        }
                    };
                    this.setupAction(abstractAction, mapResourceBundle, "popup.paste");
                    this.pmiPaste = this.createMenuItem("paste", mapResourceBundle, "popup.paste", (ActionListener)abstractAction, false);
                    keyStroke = KeyOptionEdit.getKeyStrokeForResource("popup.paste");
                    if (keyStroke != null) {
                        this.pmiPaste.setAccelerator(keyStroke);
                    }
                    popupManager.addMenuItem(this.pmiPaste, -1, "");
                    abstractAction = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            jTextComponent.replaceSelection("");
                        }
                    };
                    this.setupAction(abstractAction, mapResourceBundle, "popup.delete");
                    this.pmiDelete = this.createMenuItem("delete", mapResourceBundle, "popup.delete", (ActionListener)abstractAction, false);
                    object = KeyOptionEdit.getKeyStrokeForResource("popup.delete");
                    if (object != null) {
                        this.pmiDelete.setAccelerator((KeyStroke)object);
                    }
                    popupManager.addMenuItem(this.pmiDelete, -1, "");
                }
                popupManager.addSeparator(-1, "");
                abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        jTextComponent.requestFocus();
                        jTextComponent.selectAll();
                    }
                };
                this.setupAction(abstractAction, mapResourceBundle, "popup.selectall");
                this.pmiSelectAll = this.createMenuItem("selectall", mapResourceBundle, "popup.selectall", (ActionListener)abstractAction, false);
                keyStroke = KeyOptionEdit.getKeyStrokeForResource("popup.selectall");
                if (keyStroke != null) {
                    this.pmiSelectAll.setAccelerator(keyStroke);
                }
                popupManager.addMenuItem(this.pmiSelectAll, -1, "");
                if (this.pmiPaste != null) {
                    this.pmiPaste.setEnabled(false);
                    object = SwingUtil.safeGetClipboard(null);
                    if (object != null && object.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        try {
                            String string = (String)object.getTransferData(DataFlavor.stringFlavor);
                            if (string != null && string.length() > 0) {
                                this.pmiPaste.setEnabled(true);
                            }
                        }
                        catch (Exception exception) {
                            if (PopupManager.logger.level < 3) break block21;
                            ((LevelAwareLogBuilder)logger.lvlBuild(3, "fillPopup(PopupManager,Component,JPopupMenu,MapResourceBundle,int,int,boolean)", 480).add("ex", exception)).log();
                        }
                    }
                }
            }
            if (jTextComponent.getSelectedText() != null && jTextComponent.getSelectedText().length() > 0) {
                this.pmiCopy.setEnabled(true);
                if (this.doesNeedTextModificationItems()) {
                    this.pmiCut.setEnabled(true);
                    this.pmiDelete.setEnabled(true);
                }
            } else {
                this.pmiCopy.setEnabled(false);
                if (this.doesNeedTextModificationItems()) {
                    this.pmiCut.setEnabled(false);
                    this.pmiDelete.setEnabled(false);
                }
            }
            if (jTextComponent.getText().length() > 0) {
                this.pmiSelectAll.setEnabled(true);
            } else {
                this.pmiSelectAll.setEnabled(false);
            }
            if (!jTextComponent.isEditable() && this.doesNeedTextModificationItems()) {
                this.pmiCut.setEnabled(false);
                this.pmiPaste.setEnabled(false);
                this.pmiDelete.setEnabled(false);
            }
            return true;
        }
        return false;
    }

    public void setNeedTextModificationItems(boolean bl) {
        this.needsTextModificationItems = bl;
    }

    public boolean doesNeedTextModificationItems() {
        return this.needsTextModificationItems;
    }

    public static final ResourceBundle getResources() {
        return rb;
    }

    public static final void setResources(ResourceBundle resourceBundle) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setResources(ResourceBundle)", 560).addDetail("resources", resourceBundle)).log();
        }
        rb = resourceBundle == null ? new MapResourceBundle() : (resourceBundle instanceof MapResourceBundle ? (MapResourceBundle)resourceBundle : new MapResourceBundle(resourceBundle));
    }

    public static final void addResources(ResourceBundle resourceBundle) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addResources(ResourceBundle)", 579).addDetail("resources", resourceBundle)).log();
        }
        rb.addResources(resourceBundle);
    }

    public JMenu createMenu(String string, Object[] objectArray, MapResourceBundle mapResourceBundle, String string2) {
        String string3 = Message.format(string2 + ".name", objectArray);
        if (string3.contains(string2)) {
            string3 = Message.format(string2 + ".label", objectArray);
        }
        if (string3.contains(string2)) {
            string3 = Message.format(string2, objectArray);
        }
        JMenu jMenu = new JMenu(string3){

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        jMenu.setRequestFocusEnabled(false);
        String string4 = mapResourceBundle.getString(string2 + ".mnemonic", null);
        if (string4 != null) {
            jMenu.setMnemonic(string4.charAt(0));
        }
        jMenu.setName("m_" + string);
        return jMenu;
    }

    public JMenu createMenu(String string, MapResourceBundle mapResourceBundle, String string2) {
        return this.createMenu(string, new Object[0], mapResourceBundle, string2);
    }

    public JMenuItem createMenuItem(String string, MapResourceBundle mapResourceBundle, String string2, ActionListener actionListener, boolean bl) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createMenuItem(String,MapResourceBundle,String,ActionListener,boolean)", 663).addDetail("name", string)).addDetail("rb", mapResourceBundle)).addDetail("resource", string2)).addDetail("action", actionListener)).addDetail("checkbox", bl)).log();
        }
        String string3 = mapResourceBundle.getString(string2 + ".name", mapResourceBundle.getString(string2 + ".label", mapResourceBundle.getString(string2, string2)));
        String string4 = mapResourceBundle.getString(string2 + ".mnemonic", null);
        return this.createMenuItem(string, string3, string4, actionListener, bl);
    }

    public JMenuItem createMenuItem(String string, MapResourceBundle mapResourceBundle, String string2, Object[] objectArray, ActionListener actionListener, boolean bl) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createMenuItem(String,MapResourceBundle,String,Object[],ActionListener,boolean)", 689).addDetail("name", string)).addDetail("rb", mapResourceBundle)).addDetail("resource", string2)).addDetail("params", objectArray)).addDetail("action", actionListener)).addDetail("checkbox", bl)).log();
        }
        String string3 = Message.format(string2, objectArray);
        String string4 = mapResourceBundle.getString(string2 + ".mnemonic", null);
        return this.createMenuItem(string, string3, string4, actionListener, bl);
    }

    private JMenuItem createMenuItem(String string, String string2, String string3, ActionListener actionListener, boolean bl) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createMenuItem(String,String,String,ActionListener,boolean)", 698).addDetail("name", string)).addDetail("miname", string2)).addDetail("mnemo", string3)).addDetail("action", actionListener)).addDetail("checkbox", bl)).log();
        }
        JMenuItem jMenuItem = bl ? new JCheckBoxMenuItem(string2) : new JMenuItem(string2);
        if (string3 != null) {
            jMenuItem.setMnemonic(string3.charAt(0));
        }
        if (actionListener != null) {
            jMenuItem.setActionCommand(string);
            jMenuItem.addActionListener(actionListener);
        }
        jMenuItem.setName("mi_" + string);
        return jMenuItem;
    }

    public void setupAction(Action action, MapResourceBundle mapResourceBundle, String string) {
        Icon icon;
        String string2;
        String string3;
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setupAction(Action,MapResourceBundle,String)", 728).addDetail("action", action)).addDetail("rb", mapResourceBundle)).addDetail("resource", string)).log();
        }
        if ((string3 = mapResourceBundle.getString(string + ".name", null)) != null) {
            action.putValue("Name", string3);
        }
        if ((string2 = mapResourceBundle.getString(string + ".icon", null)) != null && (icon = mapResourceBundle.getIcon(string2, null)) != null) {
            action.putValue("SmallIcon", icon);
        }
    }

    public boolean addMenuItem(JMenuItem jMenuItem, int n, String string) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addMenuItem(JMenuItem,int,String)", 767).addDetail("item", jMenuItem)).addDetail("index", n)).addDetail("name", string)).log();
        }
        if (this.popup == null) {
            this.popup = new JPopupMenu();
        }
        if ("".equals(string)) {
            if (n < 0) {
                n = Math.max(this.popup.getComponentCount() + n + 1, 0);
            }
            this.popup.insert(jMenuItem, n);
            this.popup.revalidate();
            return true;
        }
        JComponent jComponent = this.getMenuItem(string);
        if (jComponent instanceof JPopupMenu) {
            if (n < 0) {
                n = ((JPopupMenu)jComponent).getComponentCount();
            }
            jComponent.revalidate();
            return true;
        }
        if (jComponent instanceof JMenu) {
            if (n < 0) {
                n = Math.max(((JMenu)jComponent).getItemCount() + n + 1, 0);
            }
            ((JMenu)jComponent).insert(jMenuItem, n);
            jComponent.revalidate();
            return true;
        }
        return false;
    }

    public boolean addMenuItemBefore(JMenuItem jMenuItem, String string) {
        int n;
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addMenuItemBefore(JMenuItem,String)", 815).addDetail("item", jMenuItem)).addDetail("name", string)).log();
        }
        if ((n = this.getMenuItemIndex(string)) < 0) {
            return false;
        }
        int n2 = string.lastIndexOf(46);
        return this.addMenuItem(jMenuItem, n, n2 < 0 ? "" : string.substring(0, n2));
    }

    public boolean addMenuItemAfter(JMenuItem jMenuItem, String string) {
        int n;
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addMenuItemAfter(JMenuItem,String)", 838).addDetail("item", jMenuItem)).addDetail("name", string)).log();
        }
        if ((n = this.getMenuItemIndex(string)) < 0) {
            if (PopupManager.logger.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "addMenuItemAfter(JMenuItem,String)", 842).add("oops name: ")).add(string)).log();
            }
            return false;
        }
        int n2 = string.lastIndexOf(46);
        return this.addMenuItem(jMenuItem, n + 1, n2 < 0 ? "" : string.substring(0, n2));
    }

    public boolean addSeparator(int n, String string) {
        JComponent jComponent;
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addSeparator(int,String)", 865).addDetail("index", n)).addDetail("name", string)).log();
        }
        if ((jComponent = this.getMenuItem(string)) instanceof JPopupMenu) {
            if (n < 0) {
                n = Math.max(jComponent.getComponentCount() + n + 1, 0);
            }
            if (n > jComponent.getComponentCount()) {
                n = jComponent.getComponentCount();
            }
            JPopupMenu.Separator separator = new JPopupMenu.Separator();
            ((JPopupMenu)jComponent).insert(separator, n);
            return true;
        }
        if (jComponent instanceof JMenu) {
            if (n < 0) {
                n = Math.max(((JMenu)jComponent).getItemCount() + n + 1, 0);
            }
            ((JMenu)jComponent).insertSeparator(n);
            return true;
        }
        return false;
    }

    protected JMenuItem findMenuItem(String string) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "findMenuItem(String)", 902).addDetail("name", string)).log();
        }
        if (this.popup == null) {
            return null;
        }
        int n = this.popup.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.popup.getComponent(i);
            if (!(component instanceof JMenu ? ("m_" + string).equals(component.getName()) : component != null && ("mi_" + string).equals(component.getName()))) continue;
            return (JMenuItem)component;
        }
        return null;
    }

    protected JMenuItem findMenuItem(JMenu jMenu, String string) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "findMenuItem(JMenu,String)", 933).addDetail("menu", jMenu)).addDetail("name", string)).log();
        }
        if (jMenu == null) {
            return this.findMenuItem(string);
        }
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (!(jMenuItem instanceof JMenu ? ("m_" + string).equals(jMenuItem.getName()) : jMenuItem != null && ("mi_" + string).equals(jMenuItem.getName()))) continue;
            return jMenuItem;
        }
        return null;
    }

    protected int findMenuItemIndex(String string) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "findMenuItemIndex(String)", 963).addDetail("name", string)).log();
        }
        if (this.popup == null) {
            return -1;
        }
        int n = this.popup.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.popup.getComponent(i);
            if (!(component instanceof JMenu ? ("m_" + string).equals(component.getName()) : component != null && ("mi_" + string).equals(component.getName()))) continue;
            return i;
        }
        return -1;
    }

    protected int findMenuItemIndex(JMenu jMenu, String string) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "findMenuItemIndex(JMenu,String)", 994).addDetail("menu", jMenu)).addDetail("name", string)).log();
        }
        if (jMenu == null) {
            return this.findMenuItemIndex(string);
        }
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (!(jMenuItem instanceof JMenu ? ("m_" + string).equals(jMenuItem.getName()) : jMenuItem != null && ("mi_" + string).equals(jMenuItem.getName()))) continue;
            return i;
        }
        return -1;
    }

    public JComponent getMenuItem(String string) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getMenuItem(String)", 1026).addDetail("name", string)).log();
        }
        if ("".equals(string)) {
            return this.popup;
        }
        int n = string.indexOf(".");
        if (n < 0) {
            return this.findMenuItem(string);
        }
        JMenuItem jMenuItem = this.findMenuItem(string.substring(0, n));
        while (jMenuItem instanceof JMenu) {
            if ((n = (string = n >= string.length() ? "" : string.substring(n + 1)).indexOf(".")) < 0) {
                return this.findMenuItem((JMenu)jMenuItem, string);
            }
            jMenuItem = this.findMenuItem((JMenu)jMenuItem, string.substring(0, n));
        }
        return null;
    }

    public int getMenuItemIndex(String string) {
        int n;
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getMenuItemIndex(String)", 1062).addDetail("name", string)).log();
        }
        if ((n = string.indexOf(".")) < 0) {
            return this.findMenuItemIndex(string);
        }
        JMenuItem jMenuItem = this.findMenuItem(string.substring(0, n));
        while (jMenuItem instanceof JMenu) {
            if ((n = (string = n >= string.length() ? "" : string.substring(n + 1)).indexOf(".")) < 0) {
                return this.findMenuItemIndex((JMenu)jMenuItem, string);
            }
            jMenuItem = this.findMenuItem((JMenu)jMenuItem, string.substring(0, n));
        }
        return -1;
    }

    public JMenuItem removeMenuItem(String string) {
        int n;
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeMenuItem(String)", 1090).addDetail("name", string)).log();
        }
        if ((n = this.getMenuItemIndex(string)) < 0) {
            return null;
        }
        int n2 = string.lastIndexOf(46);
        return this.removeMenuItem(n, n2 < 0 ? "" : string.substring(0, n2));
    }

    public JMenuItem removeMenuItem(int n, String string) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "removeMenuItem(int,String)", 1115).addDetail("index", n)).addDetail("name", string)).log();
        }
        if (this.popup == null) {
            return null;
        }
        if ("".equals(string)) {
            Component component = this.popup.getComponent(n);
            this.popup.remove(n);
            return component instanceof JMenuItem ? (JMenuItem)component : null;
        }
        JComponent jComponent = this.getMenuItem(string);
        if (jComponent instanceof JMenu && n >= 0 && n <= ((JMenu)jComponent).getItemCount()) {
            JMenuItem jMenuItem = ((JMenu)jComponent).getItem(n);
            ((JMenu)jComponent).remove(n);
            jComponent.revalidate();
            return jMenuItem;
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "mousePressed(MouseEvent)", 1150).addDetail("e", mouseEvent)).log();
        }
        if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 3 && (mouseEvent.getSource() instanceof JComboBox || mouseEvent.getSource() instanceof Component && ((Component)mouseEvent.getSource()).getParent() instanceof JComboBox)) {
            this.maybeShowPopup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "mouseReleased(MouseEvent)", 1167).addDetail("e", mouseEvent)).log();
        }
        if (mouseEvent.isPopupTrigger()) {
            this.maybeShowPopup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "popupMenuCanceled(PopupMenuEvent)", 1218).addDetail("e", popupMenuEvent)).log();
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "popupMenuWillBecomeVisible(PopupMenuEvent)", 1226).addDetail("e", popupMenuEvent)).log();
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "popupMenuWillBecomeInvisible(PopupMenuEvent)", 1234).addDetail("e", popupMenuEvent)).log();
        }
        if (this.popup != null) {
            SwingUtil.cleanup(this.popup);
            this.popup = null;
        }
    }

    public void maybeShowPopup(Component component, int n, int n2, boolean bl) {
        if (PopupManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "maybeShowPopup(Component,int,int,boolean)", 1258).addDetail("com", component)).addDetail("x", n)).addDetail("y", n2)).addDetail("popupTrigger", bl)).log();
        }
        if (component instanceof JComponent) {
            Vector vector = (Vector)((JComponent)component).getClientProperty(POPUP_HANDLER_KEY);
            boolean bl2 = false;
            if (vector != null && vector.size() > 0) {
                if (this.popup != null) {
                    return;
                }
                this.popup = new JPopupMenu();
                this.popup.addPopupMenuListener(this);
                this.popupPosition.x = n;
                this.popupPosition.y = n2;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    if (!((PopupHandler)enumeration.nextElement()).fillPopup(this, component, this.popup, rb, n, n2, bl)) continue;
                    bl2 = true;
                }
            }
            component.requestFocusInWindow();
            if (bl2) {
                popupCleanupListener = new PopupCleanupListener();
                this.popup.addComponentListener(popupCleanupListener);
                SwingUtil.showPopup(this.popup, component, this.popupPosition.x, this.popupPosition.y, false);
            } else {
                if (this.popup != null) {
                    SwingUtil.cleanup(this.popup);
                }
                this.popup = null;
            }
        }
    }

    static {
        rb = new MapResourceBundle();
        instance = new PopupManager();
        try {
            rb.fetchProperties("/de/qfs/lib/resources/properties/qflib", PopupManager.class);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    protected class PopupCleanupListener
    extends ComponentAdapter {
        protected PopupCleanupListener() {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "PopupCleanupListener.componentHidden(ComponentEvent)", 1325).addDetail("e", componentEvent)).log();
            }
            PopupManager.this.popup.removeComponentListener(popupCleanupListener);
            popupCleanupListener = null;
            SwingUtil.cleanup(PopupManager.this.popup);
            PopupManager.this.popup = null;
        }
    }
}

