/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lombok.Generated;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGConverter {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.SVGConverter");
    private static final String XML_PARSER_FACTORY_SYSPROP_KEY = "javax.xml.parsers.SAXParserFactory";
    private static final String XML_PARSER_FACTORY_SYSPROP_DEFAULT = "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl";
    private static final ThreadLocal<SAXSVGDocumentFactory> factory = new ThreadLocal<SAXSVGDocumentFactory>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected SAXSVGDocumentFactory initialValue() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ThreadLocal<SAXSVGDocumentFactory>.initialValue()", 82).log();
            }
            String string = System.getProperty(SVGConverter.XML_PARSER_FACTORY_SYSPROP_KEY);
            try {
                System.setProperty(SVGConverter.XML_PARSER_FACTORY_SYSPROP_KEY, SVGConverter.XML_PARSER_FACTORY_SYSPROP_DEFAULT);
                String string2 = XMLResourceDescriptor.getXMLParserClassName();
                SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(string2);
                return sAXSVGDocumentFactory;
            }
            finally {
                if (string == null) {
                    System.getProperties().remove(SVGConverter.XML_PARSER_FACTORY_SYSPROP_KEY);
                } else {
                    System.setProperty(SVGConverter.XML_PARSER_FACTORY_SYSPROP_KEY, string);
                }
            }
        }
    };
    private final URL svgResource;
    private double originalWidth;
    private double originalHeight;
    private Document svgDocument;
    private Element svgRoot;
    BufferedImage convertedBufferedImage = null;

    public SVGConverter(URL uRL) {
        if (SVGConverter.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "SVGConverter(URL)", 140).addDetail("svgResource", uRL)).dumpStack();
        }
        this.svgResource = uRL;
        this.loadSVGDocument();
    }

    public ImageIcon convertSVG(double d, double d2, boolean bl) {
        if (SVGConverter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "convertSVG(double,double,boolean)", 152).addDetail("uiScaleX", d)).addDetail("uiScaleY", d2)).addDetail("freeScaling", bl)).add("svgResource", this.svgResource)).log();
        }
        int n = this.findIconSize(this.originalWidth, d, false, bl);
        int n2 = this.findIconSize(this.originalHeight, d2, false, bl);
        if (d != d2) {
            this.svgRoot.setAttributeNS(null, "width", String.valueOf(n));
            this.svgRoot.setAttributeNS(null, "height", String.valueOf(n2));
            this.svgRoot.setAttributeNS(null, "preserveAspectRatio", "none");
        }
        TranscoderInput transcoderInput = new TranscoderInput(this.svgDocument);
        this.convertedBufferedImage = this.generateBufferedImage(transcoderInput, n, n2);
        return new ImageIcon(this.convertedBufferedImage);
    }

    private void loadSVGDocument() {
        block6: {
            if (SVGConverter.logger.level >= 7) {
                logger.lvlBuild(7, "loadSVGDocument()", 179).log();
            }
            try {
                this.svgDocument = factory.get().createDocument(this.svgResource.toString());
            }
            catch (IOException iOException) {
                if (SVGConverter.logger.level >= 1) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "loadSVGDocument()", 184).add("e", iOException)).log();
                }
                try {
                    this.svgDocument = factory.get().createDocument(this.getMissingIcon());
                }
                catch (IOException iOException2) {
                    if (SVGConverter.logger.level < 1) break block6;
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "loadSVGDocument()", 191).add("e", iOException)).log();
                }
            }
        }
        this.svgRoot = this.svgDocument.getDocumentElement();
        this.originalWidth = Double.parseDouble(this.svgRoot.getAttributeNS(null, "width"));
        this.originalHeight = Double.parseDouble(this.svgRoot.getAttributeNS(null, "height"));
    }

    private String getMissingIcon() {
        if (SVGConverter.logger.level >= 7) {
            logger.lvlBuild(7, "getMissingIcon()", 208).log();
        }
        String string = "<svg version=\"1.1\" baseProfile=\"full\" xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewbox = \"0 0 16 16\">\n    <rect x=\"0.0\" y=\"0.0\" width=\"16\" height=\"16\" style=\"stroke:#5050aa;stroke-width:0;fill:#fce803;shape-rendering=geometricPrecision;\" transform=\"rotate(0,8.0,8.0)\"/>\n    <line x1=\"8.5\" y1=\"8.5\" x2=\"14.0\" y2=\"14.0\" style=\"stroke:#000000;stroke-width:2.0;stroke-linecap:round;shape-rendering=geometricPrecision;\" transform=\"rotate(0,11.25,11.25)\"/>\n    <circle cx=\"5.333333333333333\" cy=\"5.333333333333333\" r=\"4.0\" style=\"stroke:#808080;stroke-width:1.75;fill:none;stroke-linecap:round;shape-rendering=geometricPrecision;\"/>\n    <text x=\"5.333333333333333\" y=\"5.333333333333333\" writing-mode=\"lr\" dy=\"+.4em\" text-anchor=\"middle\" rotate=\"0\" style=\"stroke:#000000;stroke-width:0;fill:#aa0000;letter-spacing:0;font-family:sans-serif;font-size:2.0;font-weight:normal;\" >Icon?</text>\n    <text x=\"12.0\" y=\"4.0\" writing-mode=\"lr\" dy=\"+.4em\" text-anchor=\"middle\" rotate=\"0\" style=\"stroke:#000000;stroke-width:0;fill:#aa0000;letter-spacing:1;font-family:sans-serif;font-size:8.0;font-weight:normal;\" >?</text>\n    <text x=\"4.0\" y=\"13.0\" writing-mode=\"lr\" dy=\"+.4em\" text-anchor=\"middle\" rotate=\"0\" style=\"stroke:#000000;stroke-width:0;fill:#aa0000;letter-spacing:1;font-family:sans-serif;font-size:5.333333333333333;font-weight:normal;\" >!</text>\n</svg>";
        return string;
    }

    private int findIconSize(double d, double d2, boolean bl, boolean bl2) {
        if (SVGConverter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "findIconSize(double,double,boolean,boolean)", 232).addDetail("baseSize", d)).addDetail("scaling", d2)).addDetail("base2Mode", bl)).addDetail("freeScaling", bl2)).log();
        }
        if (d2 < 1.0 && !bl2) {
            return (int)d;
        }
        int n = (int)d;
        if (bl) {
            for (double d3 = 1.5; d2 > d3; d3 *= 2.0) {
                n *= 2;
            }
        } else {
            n = bl2 ? (int)Math.round(d * d2) : this.roundToNearestEvenNumber(d * d2);
        }
        return n;
    }

    public static void printDocument(Document document, OutputStream outputStream) throws IOException, TransformerException {
        if (SVGConverter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "printDocument(Document,OutputStream)", 265).addDetail("doc", document)).addDetail("out", outputStream)).log();
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(document), new StreamResult(new OutputStreamWriter(outputStream, "UTF-8")));
    }

    protected BufferedImage generateBufferedImage(TranscoderInput transcoderInput, int n, int n2) {
        if (SVGConverter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "generateBufferedImage(TranscoderInput,int,int)", 285).addDetail("in", transcoderInput)).addDetail("w", n)).addDetail("h", n2)).log();
        }
        BufferedImageTranscoder bufferedImageTranscoder = new BufferedImageTranscoder();
        if (n != 0 && n2 != 0) {
            bufferedImageTranscoder.setDimensions(n, n2);
        }
        try {
            bufferedImageTranscoder.transcode(transcoderInput, null);
        }
        catch (TranscoderException transcoderException) {
            transcoderException.printStackTrace();
        }
        BufferedImage bufferedImage = bufferedImageTranscoder.getBufferedImage();
        return bufferedImage;
    }

    private int roundToNearestEvenNumber(double d) {
        if (SVGConverter.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "roundToNearestEvenNumber(double)", 308).addDetail("number", d)).log();
        }
        return (int)Math.round(d / 2.0) * 2;
    }

    @Generated
    public double getOriginalWidth() {
        if (SVGConverter.logger.level >= 7) {
            logger.lvlBuild(7, "getOriginalWidth()", 107).log();
        }
        return this.originalWidth;
    }

    @Generated
    public double getOriginalHeight() {
        if (SVGConverter.logger.level >= 7) {
            logger.lvlBuild(7, "getOriginalHeight()", 113).log();
        }
        return this.originalHeight;
    }

    @Generated
    public BufferedImage getConvertedBufferedImage() {
        if (SVGConverter.logger.level >= 7) {
            logger.lvlBuild(7, "getConvertedBufferedImage()", 130).log();
        }
        return this.convertedBufferedImage;
    }

    protected class BufferedImageTranscoder
    extends ImageTranscoder {
        protected BufferedImage bufferedImage;

        protected BufferedImageTranscoder() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "BufferedImageTranscoder.BufferedImageTranscoder()", 326).log();
            }
        }

        public BufferedImage createImage(int n, int n2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "BufferedImageTranscoder.createImage(int,int)", 340).addDetail("width", n)).addDetail("height", n2)).log();
            }
            return new BufferedImage(n, n2, 2);
        }

        public void writeImage(BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "BufferedImageTranscoder.writeImage(BufferedImage,TranscoderOutput)", 352).addDetail("img", bufferedImage)).addDetail("output", transcoderOutput)).log();
            }
            this.bufferedImage = bufferedImage;
        }

        protected ImageRenderer createRenderer() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "BufferedImageTranscoder.createRenderer()", 362).log();
            }
            ImageRenderer imageRenderer = super.createRenderer();
            RenderingHints renderingHints = imageRenderer.getRenderingHints();
            renderingHints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP));
            imageRenderer.setRenderingHints(renderingHints);
            return imageRenderer;
        }

        public BufferedImage getBufferedImage() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "BufferedImageTranscoder.getBufferedImage()", 402).log();
            }
            return this.bufferedImage;
        }

        public void setDimensions(int n, int n2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "BufferedImageTranscoder.setDimensions(int,int)", 410).addDetail("w", n)).addDetail("h", n2)).log();
            }
            if (n < 0) {
                if (logger.level >= 3) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "BufferedImageTranscoder.setDimensions(int,int)", 413).add("Negative SVGImage dimension width. Will calculate with 0!")).dumpStack();
                }
                n = 0;
            }
            if (n2 < 0) {
                if (logger.level >= 3) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "BufferedImageTranscoder.setDimensions(int,int)", 417).add("Negative SVGImage dimension height. Will calculate with 0!")).dumpStack();
                }
                n2 = 0;
            }
            this.hints.put((Object)KEY_WIDTH, (Object)Float.valueOf(n));
            this.hints.put((Object)KEY_HEIGHT, (Object)Float.valueOf(n2));
        }

        public void setTranscodingHints() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "BufferedImageTranscoder.setTranscodingHints()", 427).log();
            }
        }
    }
}

