/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.gui.SVGConverter;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Pair;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import lombok.Generated;
import lombok.NonNull;

public class SVGIcon
implements Cloneable,
Icon {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.SVGIcon");
    public static long renderingTime = 0L;
    private static ImageIconConverter iconConverter;
    private Map<Pair<Double, Double>, ImageIcon> cache = new HashMap<Pair<Double, Double>, ImageIcon>();
    private static int globalCacheReset;
    private int myCacheReset;
    private URL resource;
    private boolean disabled;
    private boolean preferPNG;
    private SVGIcon disabledIcon;
    private double scale = 1.0;
    private int width;
    private int height;

    public SVGIcon(URL uRL) {
        this(uRL, false, 1.0, false);
    }

    public SVGIcon(URL uRL, boolean bl, boolean bl2) {
        this(uRL, false, 1.0, bl2);
    }

    public SVGIcon(URL uRL, boolean bl) {
        this(uRL, bl, 1.0, false);
    }

    public SVGIcon(URL uRL, boolean bl, double d, boolean bl2) {
        if (SVGIcon.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "SVGIcon(URL,boolean,double,boolean)", 171).addDetail("resource", uRL)).addDetail("disabled", bl)).addDetail("scale", d)).addDetail("preferPNG", bl2)).log();
        }
        if (SVGIcon.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "SVGIcon(URL,boolean,double,boolean)", 173).addDetail("resource", uRL)).addDetail("disabled", bl)).addDetail("scale", d)).addDetail("preferPNG", bl2)).dumpStack();
        }
        this.resource = uRL;
        this.disabled = bl;
        this.scale = d;
        this.myCacheReset = globalCacheReset;
        this.preferPNG = bl2;
        this.getScaledIcon(1.0, 1.0, true);
    }

    public SVGIcon forScale(double d) {
        if (SVGIcon.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "forScale(double)", 186).addDetail("scale", d)).log();
        }
        return new SVGIcon(this.resource, this.disabled, d, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVGIcon getDisabledIcon() {
        if (SVGIcon.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getDisabledIcon()", 202).add("resource", this.resource)).log();
        }
        if (this.disabledIcon == null) {
            SVGIcon sVGIcon = this;
            synchronized (sVGIcon) {
                if (this.disabledIcon == null) {
                    this.disabledIcon = new SVGIcon(this.resource, true, this.scale, false);
                }
            }
        }
        return this.disabledIcon;
    }

    public ImageIcon getScaledIcon(double d, double d2) {
        if (SVGIcon.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getScaledIcon(double,double)", 216).addDetail("scalex", d)).addDetail("scaley", d2)).log();
        }
        return this.getScaledIcon(d, d2, true);
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (SVGIcon.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "paintIcon(Component,Graphics,int,int)", 228).addDetail("c", component)).addDetail("g", graphics)).addDetail("x", n)).addDetail("y", n2)).log();
        }
        this.paintIcon(component, graphics, (double)n, (double)n2);
    }

    public void paintIcon(Component component, Graphics graphics2, double d, double d2) {
        if (SVGIcon.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "paintIcon(Component,Graphics,double,double)", 236).addDetail("c", component)).addDetail("g", graphics2)).addDetail("x", d)).addDetail("y", d2)).log();
        }
        SwingUtil.getGraphicsScaleData(component, graphics2).onScaledGraphics((graphics, d3, d4) -> {
            ImageIcon imageIcon = this.getScaledIcon(d3, d4, true);
            imageIcon.paintIcon(component, graphics, (int)Math.round(d * d3), (int)Math.round(d2 * d4));
        });
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public Image getImage(double d, double d2) {
        if (SVGIcon.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getImage(double,double)", 277).addDetail("scaleX", d)).addDetail("scaleY", d2)).log();
        }
        return this.getScaledIcon(d, d2, false).getImage();
    }

    private ImageIcon getScaledIcon(double d, double d2, boolean bl) {
        Pair<Double, Double> pair;
        ImageIcon imageIcon;
        if (SVGIcon.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getScaledIcon(double,double,boolean)", 288).addDetail("scalex", d)).addDetail("scaley", d2)).addDetail("freeScaling", bl)).add("resource", this.resource)).log();
        }
        if (this.scale != 1.0) {
            d *= this.scale;
            d2 *= this.scale;
            if (SVGIcon.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getScaledIcon(double,double,boolean)", 292).add("Scale adjusted for override")).add("scale", this.scale)).add("scalex", d)).add("scalex", d)).log();
            }
        }
        if (this.myCacheReset != globalCacheReset) {
            this.cache.clear();
            this.myCacheReset = globalCacheReset;
        }
        if ((imageIcon = this.cache.get(pair = new Pair<Double, Double>(d, d2))) == null) {
            GrayFilter grayFilter;
            long l;
            block19: {
                l = System.currentTimeMillis();
                if (this.preferPNG && (imageIcon = this.tryToReadPNG(d, pair)) != null) {
                    long l2 = System.currentTimeMillis() - l;
                    if (SVGIcon.logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getScaledIcon(double,double,boolean)", 306).add("delta", l2)).add("resource", this.resource)).log();
                    }
                    renderingTime += l2;
                    return imageIcon;
                }
                SVGConverter sVGConverter = new SVGConverter(this.resource);
                if (this.width == 0 && this.height == 0) {
                    this.width = (int)Math.round(this.scale * sVGConverter.getOriginalWidth());
                    this.height = (int)Math.round(this.scale * sVGConverter.getOriginalHeight());
                }
                imageIcon = sVGConverter.convertSVG(d, d2, bl);
                if (iconConverter != null) {
                    try {
                        imageIcon = iconConverter.convertIcon(imageIcon);
                    }
                    catch (Throwable throwable) {
                        if (SVGIcon.logger.level < 3) break block19;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "getScaledIcon(double,double,boolean)", 322).add("Exception in IconConverter", throwable)).log();
                    }
                }
            }
            if (this.disabled && this.resource.toString().endsWith("sol_dark.svg")) {
                grayFilter = new GrayFilter(true, 0){

                    @Override
                    public int filterRGB(int n, int n2, int n3) {
                        float f = (float)(n3 >> 16 & 0xFF) / 255.0f;
                        float f2 = (float)(n3 >> 8 & 0xFF) / 255.0f;
                        float f3 = (float)(n3 & 0xFF) / 255.0f;
                        float f4 = (float)(n3 >> 24 & 0xFF) / 255.0f;
                        float f5 = Math.min(1.0f, 0.35f + 0.65f * ((f + f2 + f3) / 4.0f));
                        float f6 = Math.min(1.0f, (f5 + 0.05f) * 0.43f);
                        float f7 = Math.min(1.0f, (f5 + 0.05f) * 0.45f);
                        float f8 = Math.min(1.0f, (f5 + 0.05f) * 0.5f);
                        return (int)(f4 * 255.0f) << 24 | (int)(f6 * 255.0f) << 16 | (int)(f7 * 255.0f) << 8 | (int)(f8 * 255.0f);
                    }
                };
                FilteredImageSource filteredImageSource = new FilteredImageSource(imageIcon.getImage().getSource(), grayFilter);
                Image image = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
                imageIcon = new ImageIcon(image);
            } else if (this.disabled && this.resource.toString().endsWith("_sol.svg")) {
                grayFilter = new GrayFilter(true, 0){

                    @Override
                    public int filterRGB(int n, int n2, int n3) {
                        float f = (float)(n3 >> 16 & 0xFF) / 255.0f;
                        float f2 = (float)(n3 >> 8 & 0xFF) / 255.0f;
                        float f3 = (float)(n3 & 0xFF) / 255.0f;
                        float f4 = (float)(n3 >> 24 & 0xFF) / 255.0f;
                        float f5 = Math.min(1.0f, 0.35f + 0.65f * ((f + f2 + f3) / 3.0f));
                        float f6 = Math.min(1.0f, (f5 + 0.05f) * 0.93f);
                        float f7 = Math.min(1.0f, (f5 + 0.05f) * 0.93f);
                        float f8 = f5 * 0.9f;
                        return (int)(f4 * 255.0f) << 24 | (int)(f6 * 255.0f) << 16 | (int)(f7 * 255.0f) << 8 | (int)(f8 * 255.0f);
                    }
                };
                FilteredImageSource filteredImageSource = new FilteredImageSource(imageIcon.getImage().getSource(), grayFilter);
                Image image = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
                imageIcon = new ImageIcon(image);
            } else if (this.disabled && this.resource.toString().endsWith("_dark.svg")) {
                grayFilter = new GrayFilter(true, 10);
                FilteredImageSource filteredImageSource = new FilteredImageSource(imageIcon.getImage().getSource(), grayFilter);
                Image image = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
                imageIcon = new ImageIcon(image);
            } else if (this.disabled) {
                grayFilter = new GrayFilter(true, 0){

                    @Override
                    public int filterRGB(int n, int n2, int n3) {
                        float f = (float)(n3 >> 16 & 0xFF) / 255.0f;
                        float f2 = (float)(n3 >> 8 & 0xFF) / 255.0f;
                        float f3 = (float)(n3 & 0xFF) / 255.0f;
                        float f4 = (float)(n3 >> 24 & 0xFF) / 255.0f;
                        float f5 = Math.min(1.0f, 0.35f + 0.65f * ((f + f2 + f3) / 3.0f));
                        float f6 = Math.min(1.0f, (f5 + 0.05f) * 0.9f);
                        float f7 = Math.min(1.0f, (f5 + 0.05f) * 0.9f);
                        float f8 = Math.min(1.0f, (f5 + 0.05f) * 0.9f);
                        return (int)(f4 * 255.0f) << 24 | (int)(f6 * 255.0f) << 16 | (int)(f7 * 255.0f) << 8 | (int)(f8 * 255.0f);
                    }
                };
                FilteredImageSource filteredImageSource = new FilteredImageSource(imageIcon.getImage().getSource(), grayFilter);
                Image image = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
                imageIcon = new ImageIcon(image);
            }
            this.cache.put(pair, imageIcon);
            long l3 = System.currentTimeMillis() - l;
            if (SVGIcon.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getScaledIcon(double,double,boolean)", 404).add("delta", l3)).add("resource", this.resource)).log();
            }
            renderingTime += l3;
        }
        return imageIcon;
    }

    @Nullable
    private ImageIcon tryToReadPNG(double d, Pair<Double, Double> pair) {
        if (SVGIcon.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "tryToReadPNG(double,Pair<Double, Double>)", 425).addDetail("scalex", d)).addDetail("key", pair)).add("resource", this.resource)).log();
        }
        String string = "";
        if (this.resource.toString().endsWith(".svg")) {
            string = this.resource.toString().replace(".svg", "_" + (int)(d * 100.0) + ".png");
        }
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            inputStream.close();
            ImageIcon imageIcon = new ImageIcon(uRL);
            if (this.width == 0 && this.height == 0) {
                this.width = imageIcon.getIconWidth();
                this.height = imageIcon.getIconHeight();
            }
            this.cache.put(pair, imageIcon);
            return imageIcon;
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void setIconConverter(final ImageIconConverter imageIconConverter) {
        if (SVGIcon.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setIconConverter(ImageIconConverter)", 456).addDetail("_iconConverter", imageIconConverter)).log();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "setIconConverter(ImageIconConverter).Runnable.run()", 459).log();
                }
                if (!Misc.equalOrNull(imageIconConverter, iconConverter)) {
                    iconConverter = imageIconConverter;
                    globalCacheReset++;
                    for (Window window : Window.getWindows()) {
                        window.repaint();
                    }
                }
            }
        });
    }

    public String createTempPngFileFromSVGIcon(String string, Component component) throws Exception {
        if (SVGIcon.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createTempPngFileFromSVGIcon(String,Component)", 481).addDetail("filename", string)).addDetail("component", component)).log();
        }
        SwingUtil.GraphicsScaleData graphicsScaleData = SwingUtil.getGraphicsScaleData(component, component.getGraphics());
        graphicsScaleData.onScaledGraphics((graphics, d, d2) -> {});
        SVGIcon sVGIcon = this.forScale(graphicsScaleData.x);
        File file = File.createTempFile(string, ".png");
        file.deleteOnExit();
        BufferedImage bufferedImage = new BufferedImage(sVGIcon.getIconWidth(), sVGIcon.getIconHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        sVGIcon.paintIcon(component, (Graphics)graphics2D, 0, 0);
        graphics2D.dispose();
        ImageIO.write((RenderedImage)bufferedImage, "png", file);
        return SVGIcon.getWebCompatiblePath(file);
    }

    @NonNull
    private static String getWebCompatiblePath(File file) {
        String string;
        if (SVGIcon.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getWebCompatiblePath(File)", 505).addDetail("file", file)).log();
        }
        if (!(string = file.getAbsolutePath().replace(File.separatorChar, '/')).startsWith("/")) {
            string = "/" + string;
        }
        return string;
    }

    @Generated
    public boolean isDisabled() {
        if (SVGIcon.logger.level >= 7) {
            logger.lvlBuild(7, "isDisabled()", 100).log();
        }
        return this.disabled;
    }

    static {
        globalCacheReset = 0;
    }

    public static interface ImageIconConverter {
        public ImageIcon convertIcon(ImageIcon var1);
    }
}

