/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.gui.TableModelSorterEvent;
import de.qfs.lib.gui.TableModelSorterListener;
import de.qfs.lib.log.Logger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SortedTableHeaderCellRenderer
extends JLabel
implements TableCellRenderer,
TableModelSorterListener,
TableColumnModelListener {
    private static Logger logger = new Logger("de.qfs.lib.gui.SortedTableHeaderCellRenderer");
    private static final Object classlock = new Object();
    private static boolean initialized;
    private static Icon upArrow;
    private static Icon downArrow;
    private static Icon noArrow;
    private JTable table;
    private TableColumnModel columnModel;
    private int sortColumn = -1;
    private boolean ascending = true;

    public SortedTableHeaderCellRenderer(JTable jTable) {
        if (SortedTableHeaderCellRenderer.logger.level >= 7) {
            logger.log(7, "SortedTableHeaderCellRenderer(JTable)", SortedTableHeaderCellRenderer.logger.level < 8 ? "" : "table: " + jTable);
        }
        SortedTableHeaderCellRenderer.initIcons();
        this.table = jTable;
        JTableHeader jTableHeader = jTable.getTableHeader();
        if (jTableHeader != null) {
            this.setForeground(jTableHeader.getForeground());
            this.setBackground(jTableHeader.getBackground());
            this.setFont(jTableHeader.getFont());
        } else {
            LookAndFeel.installColorsAndFont(this, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        }
        LookAndFeel.installBorder(this, "TableHeader.cellBorder");
        this.setOpaque(true);
        this.setIconTextGap(2);
        this.initColumns();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor("TableHeader.background"));
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initIcons() {
        Object object = classlock;
        synchronized (object) {
            if (!initialized) {
                if (SortedTableHeaderCellRenderer.logger.level >= 7) {
                    logger.log(7, "initIcons()", "");
                }
                SortedTableHeaderCellRenderer.setDefaultUIManagerValue("ScrollBar.arrowForeground", Color.BLACK);
                SortedTableHeaderCellRenderer.setDefaultUIManagerValue("ScrollBar.arrowDisabledForeground", Color.DARK_GRAY);
                upArrow = new ArrowIcon(0);
                downArrow = new ArrowIcon(1);
                noArrow = new ArrowIcon(2);
            }
        }
    }

    private static void setDefaultUIManagerValue(String string, Object object) {
        if (UIManager.get(string) == null) {
            UIManager.put(string, object);
        }
    }

    public void reinit() {
        if (SortedTableHeaderCellRenderer.logger.level >= 7) {
            logger.log(7, "reinit()", "");
        }
        if (this.columnModel != null) {
            this.columnModel.removeColumnModelListener(this);
        }
        this.initColumns();
    }

    private void initColumns() {
        if (SortedTableHeaderCellRenderer.logger.level >= 7) {
            logger.log(7, "initColumns()", "");
        }
        this.columnModel = this.table.getColumnModel();
        Enumeration<TableColumn> enumeration = this.columnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(this);
        }
        this.columnModel.addColumnModelListener(this);
    }

    public void cleanup() {
        if (this.columnModel != null) {
            this.columnModel.removeColumnModelListener(this);
            Enumeration<TableColumn> enumeration = this.columnModel.getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                tableColumn.setHeaderRenderer(null);
            }
        }
        this.columnModel = null;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.setText(object.toString());
        if (jTable != null) {
            int n3 = jTable.convertColumnIndexToModel(n2);
            if (n3 == this.sortColumn) {
                this.setIcon(this.ascending ? upArrow : downArrow);
            } else {
                this.setIcon(noArrow);
            }
        }
        return this;
    }

    @Override
    public void sortOrderChanged(TableModelSorterEvent tableModelSorterEvent) {
        if (SortedTableHeaderCellRenderer.logger.level >= 7) {
            logger.log(7, "sortOrderChanged(TableModelSorterEvent)", SortedTableHeaderCellRenderer.logger.level < 8 ? "" : "e: " + tableModelSorterEvent + ", column: " + tableModelSorterEvent.getColumn() + ", ascending: " + tableModelSorterEvent.isAscending());
        }
        this.sortColumn = tableModelSorterEvent.getColumn();
        this.ascending = tableModelSorterEvent.isAscending();
        this.table.getTableHeader().repaint();
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        ((TableColumnModel)tableColumnModelEvent.getSource()).getColumn(tableColumnModelEvent.getToIndex()).setHeaderRenderer(this);
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    private static class ArrowIcon
    implements Icon,
    Serializable {
        public static final int KIND_UP = 0;
        public static final int KIND_DOWN = 1;
        public static final int KIND_EMPTY = 2;
        private int kind;

        public ArrowIcon(int n) {
            this.kind = n;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.kind == 2) {
                return;
            }
            Object object = RenderingHints.VALUE_ANTIALIAS_ON;
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints.Key key = RenderingHints.KEY_ANTIALIASING;
            Object object2 = graphics2D.getRenderingHint(key);
            if (object != object2) {
                graphics2D.setRenderingHint(key, object);
            } else {
                object2 = null;
            }
            JComponent jComponent = (JComponent)component;
            graphics2D.setColor(jComponent.isEnabled() ? UIManager.getColor("ScrollBar.arrowForeground") : UIManager.getColor("ScrollBar.arrowDisabledForeground"));
            if (this.kind == 0) {
                this.getArrowIcon("Up", component, graphics2D, n, n2);
            } else {
                this.getArrowIcon("Down", component, graphics2D, n, n2);
            }
            if (object2 != null) {
                graphics2D.setRenderingHint(key, object2);
            }
        }

        private void getArrowIcon(String string, Component component, Graphics2D graphics2D, int n, int n2) {
            String string2 = "TableHeader.arrow" + string + "Icon";
            Icon icon = UIManager.getIcon(string2);
            if (icon != null) {
                icon.paintIcon(component, graphics2D, n + 2, n2 + 2);
            } else {
                int n3 = this.getIconWidth();
                int n4 = n3 / 2;
                int n5 = 3;
                graphics2D.translate(n + 1, n2 + 4);
                switch (string) {
                    case "Up": {
                        graphics2D.drawLine(n4, -1, n4 - n5 + 1, n5 - 2);
                        graphics2D.drawLine(n4, -1, n4 + n5 - 1, n5 - 2);
                        graphics2D.drawLine(n4, n5 - 3, n4 - n5 + 1, 2 * n5 - 4);
                        graphics2D.drawLine(n4, n5 - 3, n4 + n5 - 1, 2 * n5 - 4);
                        for (int i = 0; i <= n5; ++i) {
                            graphics2D.drawLine(n4 - i, i - 1, n4 - i, i + n5 - 3);
                            if (i <= 0) continue;
                            graphics2D.drawLine(n4 + i, i - 1, n4 + i, i + n5 - 3);
                        }
                        break;
                    }
                    default: {
                        graphics2D.drawLine(n4, n5, n4 - n5 + 1, 1);
                        graphics2D.drawLine(n4, n5, n4 + n5 - 1, 1);
                        graphics2D.drawLine(n4, 2, n4 - n5 + 1, 3 - n5);
                        graphics2D.drawLine(n4, 2, n4 + n5 - 1, 3 - n5);
                        for (int i = 0; i <= n5; ++i) {
                            graphics2D.drawLine(n4 - i, n5 - i, n4 - i, 2 - i);
                            if (i <= 0) continue;
                            graphics2D.drawLine(n4 + i, n5 - i, n4 + i, 2 - i);
                        }
                    }
                }
                graphics2D.translate(-n - 1, -n2 - 4);
            }
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }
}

