/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.gui.DefaultTableModelSorter;
import de.qfs.lib.gui.FilteredAndSortedTableModel;
import de.qfs.lib.gui.SortedTableHeaderCellRenderer;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.gui.TableModelFilter;
import de.qfs.lib.gui.TableModelFilterEvent;
import de.qfs.lib.gui.TableModelFilterListener;
import de.qfs.lib.gui.TableModelSorter;
import de.qfs.lib.gui.TableModelSorterEvent;
import de.qfs.lib.gui.TableModelSorterListener;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.Logger;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.DelayedAction;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import lombok.Generated;

public class SortedTableHelper
implements TableModelFilterListener,
TableModelSorterListener {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.SortedTableHelper");
    private static final Logger hlLogger = new Logger("de.qfs.lib.gui.HeaderListener");
    private JTable table;
    private TableModel model;
    private FilteredAndSortedTableModel sortedModel;
    private TableModelSorter sorter;
    private TableModelFilter filter;
    private TableCellRenderer renderer;
    private HeaderListener headerListener;

    public SortedTableHelper(JTable jTable) {
        this(jTable, null, new DefaultTableModelSorter());
        this.sorter.setSortColumn(0);
    }

    public SortedTableHelper(JTable jTable, TableModelFilter tableModelFilter, TableModelSorter tableModelSorter) {
        if (SortedTableHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "SortedTableHelper(JTable,TableModelFilter,TableModelSorter)", 151).addDetail("table", jTable)).addDetail("filter", tableModelFilter)).addDetail("sorter", tableModelSorter)).log();
        }
        this.table = jTable;
        this.model = jTable.getModel();
        this.filter = tableModelFilter;
        this.sorter = tableModelSorter;
        this.sortedModel = new FilteredAndSortedTableModel(this.model, this.filter, this.sorter);
        this.renderer = new SortedTableHeaderCellRenderer(jTable);
    }

    public SortedTableHelper(JTable jTable, FilteredAndSortedTableModel filteredAndSortedTableModel) {
        if (SortedTableHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "SortedTableHelper(JTable,FilteredAndSortedTableModel)", 174).addDetail("table", jTable)).addDetail("sortedModel", filteredAndSortedTableModel)).log();
        }
        this.table = jTable;
        this.sortedModel = filteredAndSortedTableModel;
        this.model = filteredAndSortedTableModel.getModel();
        this.filter = filteredAndSortedTableModel.getFilter();
        this.sorter = filteredAndSortedTableModel.getSorter();
        this.renderer = new SortedTableHeaderCellRenderer(jTable);
    }

    public void prepareTable() {
        int n;
        if (SortedTableHelper.logger.level >= 7) {
            logger.lvlBuild(7, "prepareTable()", 199).log();
        }
        int n2 = this.table.getColumnModel().getColumnCount();
        Integer[] integerArray = new Integer[n2];
        for (n = 0; n < n2; ++n) {
            integerArray[n] = this.table.getColumnModel().getColumn(n).getPreferredWidth();
        }
        this.table.setModel(this.sortedModel);
        for (n = 0; n < n2; ++n) {
            this.table.getColumnModel().getColumn(n).setPreferredWidth(integerArray[n]);
        }
        if (this.renderer instanceof SortedTableHeaderCellRenderer) {
            ((SortedTableHeaderCellRenderer)this.renderer).reinit();
        }
        if (this.sorter != null) {
            this.sorter.removeTableModelSorterListener(this);
            this.sorter.addTableModelSorterListener(this);
        }
        if (this.filter != null) {
            this.filter.removeTableModelFilterListener(this);
            this.filter.addTableModelFilterListener(this);
        }
        if (this.sorter != null && this.renderer instanceof TableModelSorterListener) {
            this.sorter.removeTableModelSorterListener((TableModelSorterListener)((Object)this.renderer));
            this.sorter.addTableModelSorterListener((TableModelSorterListener)((Object)this.renderer));
            ((TableModelSorterListener)((Object)this.renderer)).sortOrderChanged(new TableModelSorterEvent(this.sorter, this.sorter.getSortColumn(), this.sorter.isSortAscending()));
        }
        if (this.sorter != null || this.filter != null) {
            this.saveSelection(true);
        }
        if (this.headerListener == null) {
            this.headerListener = this.createNewHeaderListener();
        } else {
            this.table.getTableHeader().removeMouseListener(this.headerListener);
        }
        this.table.getTableHeader().addMouseListener(this.headerListener);
    }

    public void cleanup() {
        if (SortedTableHelper.logger.level >= 7) {
            logger.lvlBuild(7, "cleanup()", 256).log();
        }
        if (this.renderer instanceof SortedTableHeaderCellRenderer) {
            ((SortedTableHeaderCellRenderer)this.renderer).cleanup();
        }
        if (this.sorter != null) {
            this.sorter.removeTableModelSorterListener(this);
            if (this.renderer instanceof TableModelSorterListener) {
                this.sorter.removeTableModelSorterListener((TableModelSorterListener)((Object)this.renderer));
            }
        }
        if (this.filter != null) {
            this.filter.removeTableModelFilterListener(this);
            this.filter = null;
        }
        if (this.headerListener != null) {
            this.table.getTableHeader().removeMouseListener(this.headerListener);
            this.headerListener = null;
        }
        if (this.sortedModel != null) {
            this.sortedModel.cleanup();
        }
        this.setHeaderCellRenderer(null);
        this.sortedModel = null;
        this.model = null;
    }

    public HeaderListener createNewHeaderListener() {
        return new HeaderListener();
    }

    public void saveSelection(boolean bl) {
        if (bl) {
            if (this.sortedModel != null && this.table != null) {
                this.sortedModel.setSavedSelectionModel(this.table.getSelectionModel());
            }
        } else if (this.sortedModel != null) {
            this.sortedModel.setSavedSelectionModel(null);
        }
    }

    public void updateUI() {
        if (this.renderer instanceof SortedTableHeaderCellRenderer) {
            this.setHeaderCellRenderer(new SortedTableHeaderCellRenderer(this.table));
        }
    }

    public final void setAlwaysSort(boolean bl) {
        if (SortedTableHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setAlwaysSort(boolean)", 366).addDetail("alwaysSort", bl)).log();
        }
        this.sortedModel.setAlwaysSort(bl);
    }

    public final TableModel getTableModel() {
        if (SortedTableHelper.logger.level >= 7) {
            logger.lvlBuild(7, "getTableModel()", 383).log();
        }
        return this.model;
    }

    public void setTableModel(TableModel tableModel) {
        if (SortedTableHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setTableModel(TableModel)", 398).addDetail("model", tableModel)).log();
        }
        this.model = tableModel;
        this.sortedModel.setModel(tableModel);
        if (this.renderer instanceof SortedTableHeaderCellRenderer) {
            ((SortedTableHeaderCellRenderer)this.renderer).reinit();
        }
    }

    public final FilteredAndSortedTableModel getSortedTableModel() {
        if (SortedTableHelper.logger.level >= 7) {
            logger.lvlBuild(7, "getSortedTableModel()", 424).log();
        }
        return this.sortedModel;
    }

    public void setSortedTableModel(FilteredAndSortedTableModel filteredAndSortedTableModel) {
        if (SortedTableHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setSortedTableModel(FilteredAndSortedTableModel)", 439).addDetail("model", filteredAndSortedTableModel)).log();
        }
        if (this.sorter != null) {
            this.sorter.removeTableModelSorterListener(this);
            if (this.sortedModel != null) {
                this.sorter.removeTableModelSorterListener(this.sortedModel);
            }
            if (this.renderer instanceof TableModelSorterListener) {
                this.sorter.removeTableModelSorterListener((TableModelSorterListener)((Object)this.renderer));
            }
        }
        if (this.filter != null) {
            this.filter.removeTableModelFilterListener(this);
        }
        this.sortedModel = filteredAndSortedTableModel;
        if (this.sortedModel != null) {
            this.model = this.sortedModel.getModel();
            this.sorter = this.sortedModel.getSorter();
            if (this.sorter != null) {
                this.sorter.addTableModelSorterListener(this);
            }
            this.filter = this.sortedModel.getFilter();
            if (this.filter != null) {
                this.filter.addTableModelFilterListener(this);
            }
            if (this.table.getCellEditor() != null) {
                this.table.getCellEditor().cancelCellEditing();
            }
            this.table.setModel(this.sortedModel);
            if (this.renderer instanceof SortedTableHeaderCellRenderer) {
                ((SortedTableHeaderCellRenderer)this.renderer).reinit();
            }
            if (this.sorter != null && this.renderer instanceof TableModelSorterListener) {
                this.sorter.addTableModelSorterListener((TableModelSorterListener)((Object)this.renderer));
                ((TableModelSorterListener)((Object)this.renderer)).sortOrderChanged(new TableModelSorterEvent(this.sorter, this.sorter.getSortColumn(), this.sorter.isSortAscending()));
            }
        }
    }

    public final TableModelSorter getTableModelSorter() {
        if (SortedTableHelper.logger.level >= 7) {
            logger.lvlBuild(7, "getTableModelSorter()", 497).log();
        }
        return this.sorter;
    }

    public final void setTableModelSorter(TableModelSorter tableModelSorter) {
        if (SortedTableHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setTableModelSorter(TableModelSorter)", 512).addDetail("sorter", tableModelSorter)).log();
        }
        if (this.sorter != null) {
            this.sorter.removeTableModelSorterListener(this);
            if (this.renderer instanceof TableModelSorterListener) {
                this.sorter.removeTableModelSorterListener((TableModelSorterListener)((Object)this.renderer));
            }
        }
        this.sorter = tableModelSorter;
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        this.sortedModel.setSorter(tableModelSorter);
        if (tableModelSorter != null) {
            tableModelSorter.addTableModelSorterListener(this);
            if (this.renderer instanceof TableModelSorterListener) {
                tableModelSorter.addTableModelSorterListener((TableModelSorterListener)((Object)this.renderer));
                ((TableModelSorterListener)((Object)this.renderer)).sortOrderChanged(new TableModelSorterEvent(tableModelSorter, tableModelSorter.getSortColumn(), tableModelSorter.isSortAscending()));
            }
        }
    }

    public final TableModelFilter getTableModelFilter() {
        if (SortedTableHelper.logger.level >= 7) {
            logger.lvlBuild(7, "getTableModelFilter()", 548).log();
        }
        return this.filter;
    }

    public final void setTableModelFilter(TableModelFilter tableModelFilter) {
        if (SortedTableHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setTableModelFilter(TableModelFilter)", 563).addDetail("filter", tableModelFilter)).log();
        }
        if (this.filter != null) {
            this.filter.removeTableModelFilterListener(this);
        }
        this.filter = tableModelFilter;
        if (tableModelFilter != null) {
            tableModelFilter.addTableModelFilterListener(this);
        }
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        this.sortedModel.setFilter(tableModelFilter);
    }

    public final TableCellRenderer getHeaderCellRenderer() {
        if (SortedTableHelper.logger.level >= 7) {
            logger.lvlBuild(7, "getHeaderCellRenderer()", 587).log();
        }
        return this.renderer;
    }

    public final void setHeaderCellRenderer(TableCellRenderer tableCellRenderer) {
        if (SortedTableHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setHeaderCellRenderer(TableCellRenderer)", 600).addDetail("renderer", tableCellRenderer)).log();
        }
        if (this.sorter != null && this.renderer instanceof TableModelSorterListener) {
            this.sorter.removeTableModelSorterListener((TableModelSorterListener)((Object)this.renderer));
        }
        this.renderer = tableCellRenderer;
        if (tableCellRenderer instanceof SortedTableHeaderCellRenderer) {
            ((SortedTableHeaderCellRenderer)tableCellRenderer).reinit();
        }
        if (this.sorter != null && tableCellRenderer instanceof TableModelSorterListener) {
            this.sorter.addTableModelSorterListener((TableModelSorterListener)((Object)tableCellRenderer));
            ((TableModelSorterListener)((Object)tableCellRenderer)).sortOrderChanged(new TableModelSorterEvent(this.sorter, this.sorter.getSortColumn(), this.sorter.isSortAscending()));
        }
    }

    @Override
    public void filterChanged(TableModelFilterEvent tableModelFilterEvent) {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
    }

    @Override
    public void sortOrderChanged(TableModelSorterEvent tableModelSorterEvent) {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
    }

    protected class HeaderListener
    extends MouseAdapter {
        private DelayedAction delay = new DelayedAction(300);

        protected HeaderListener() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "HeaderListener.HeaderListener()", 674).log();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (hlLogger.level >= 7) {
                hlLogger.log(7, "mouseClicked(MouseEvent)", hlLogger.level < 8 ? "" : "e: " + mouseEvent);
            }
            int n = SortedTableHelper.this.table.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
            final int n2 = SortedTableHelper.this.table.convertColumnIndexToModel(n);
            if (n != -1) {
                if (mouseEvent.getClickCount() == 1) {
                    if (SortedTableHelper.this.sorter != null) {
                        this.delay.perform(new Runnable(){

                            @Override
                            public void run() {
                                HeaderListener.this.customPreSortAction();
                                if (SortedTableHelper.this.sorter != null) {
                                    SortedTableHelper.this.sorter.setSortColumn(n2);
                                }
                                HeaderListener.this.customPostSortAction();
                            }
                        });
                    }
                } else {
                    this.delay.cancel();
                    if (mouseEvent.getClickCount() == 2) {
                        SwingUtil.autoSizeTableColumn(SortedTableHelper.this.table, n);
                    }
                }
            }
        }

        protected void customPreSortAction() {
        }

        protected void customPostSortAction() {
        }
    }
}

