/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.gui.ThemeAwareJLabel;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.CountEvent;
import de.qfs.lib.util.CountListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.UIManager;
import lombok.Generated;
import lombok.NonNull;

public class StatusLine
extends JComponent
implements CountListener {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.StatusLine");
    private static final int DEFAULT_DELAY = 1500;
    protected JLabel message = new ThemeAwareJLabel("statusline", "");
    private String permanentMessage = " ";
    private Stack<String> pushedMessages = new Stack();
    private String currentMessage = this.permanentMessage;
    private ActionListener resetAction = actionEvent -> this.resetMessage();
    private Timer timer;
    private int delay = 1500;
    protected JProgressBar progress;
    protected boolean progressShowing;
    protected boolean showPercent;
    protected long lastUpdateTime;

    public StatusLine() {
        this.message.setText(this.permanentMessage);
        this.message.setBorder(UIManager.getBorder("StatusLine.border"));
        this.timer = new Timer(1500, this.resetAction);
        this.timer.setRepeats(false);
        this.timer.stop();
        this.init();
    }

    protected void init() {
        if (StatusLine.logger.level >= 7) {
            logger.lvlBuild(7, "init()", 194).log();
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.message, "Center");
    }

    public void resetMessage() {
        if (StatusLine.logger.level >= 7) {
            logger.lvlBuild(7, "resetMessage()", 207).log();
        }
        this.currentMessage = this.pushedMessages.isEmpty() ? this.permanentMessage : this.pushedMessages.peek();
        this.forceUpdate();
    }

    public final JLabel getMessageLabel() {
        return this.message;
    }

    public void setPermanentMessage(String string) {
        if (StatusLine.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setPermanentMessage(String)", 237).addDetail("msg", string)).log();
        }
        this.permanentMessage = string;
        if (this.pushedMessages.isEmpty() && !this.timer.isRunning()) {
            this.currentMessage = this.permanentMessage;
            this.forceUpdate();
        }
    }

    public void resetPermanentMessage() {
        if (StatusLine.logger.level >= 7) {
            logger.lvlBuild(7, "resetPermanentMessage()", 252).log();
        }
        this.setPermanentMessage(" ");
    }

    public void pushMessage(String string) {
        if (StatusLine.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "pushMessage(String)", 266).addDetail("msg", string)).log();
        }
        this.pushedMessages.push(string);
        this.currentMessage = string;
        this.timer.stop();
        this.forceUpdate();
    }

    public void popMessage(@NonNull String string) {
        if (StatusLine.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "popMessage(String)", 282).addDetail("msg", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("msg is marked non-null but is null");
        }
        if (!this.pushedMessages.contains(string) && StatusLine.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "popMessage(String)", 285).add("Trying to remove a status line message that is not there (anymore): \"" + string + "\"", this.pushedMessages)).log();
        }
        while (!this.pushedMessages.isEmpty() && !string.equals(this.pushedMessages.lastElement())) {
            if (StatusLine.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "popMessage(String)", 288).add("Found orphaned status line message \"" + (String)this.pushedMessages.lastElement() + "\"", this.pushedMessages)).log();
            }
            this.pushedMessages.pop();
        }
        this.pushedMessages.remove(string);
        if (!this.timer.isRunning()) {
            this.resetMessage();
        }
    }

    public void clearMessages() {
        if (StatusLine.logger.level >= 7) {
            logger.lvlBuild(7, "clearMessages()", 305).log();
        }
        this.pushedMessages.clear();
        if (!this.timer.isRunning()) {
            this.resetMessage();
        }
    }

    public void setTemporaryMessage(String string) {
        if (StatusLine.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setTemporaryMessage(String)", 322).addDetail("msg", string)).log();
        }
        this.setTemporaryMessage(string, this.delay);
    }

    public void setTemporaryMessage(String string, int n) {
        if (StatusLine.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setTemporaryMessage(String,int)", 340).addDetail("msg", string)).addDetail("delay", n)).log();
        }
        this.currentMessage = string;
        this.forceUpdate();
        this.timer.setInitialDelay(n);
        this.timer.restart();
    }

    public void setTemporaryMessageDelay(int n) {
        if (StatusLine.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setTemporaryMessageDelay(int)", 357).addDetail("delay", n)).log();
        }
        this.delay = n;
    }

    public void forceUpdate() {
        if (StatusLine.logger.level >= 7) {
            logger.lvlBuild(7, "forceUpdate()", 370).log();
        }
        this.message.setText(this.currentMessage);
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Graphics graphics = StatusLine.this.message.getGraphics();
                if (graphics != null) {
                    Dimension dimension = StatusLine.this.message.getSize();
                    graphics.setClip(0, 0, dimension.width, dimension.height);
                    graphics.clearRect(0, 0, dimension.width, dimension.height);
                    StatusLine.this.message.update(graphics);
                }
            }
        });
    }

    public void showProgressBar(int n, int n2, String string, boolean bl) {
        if (this.progress == null) {
            this.progress = new JProgressBar();
            this.progress.setBorder(UIManager.getBorder("ProgressBar.border"));
        }
        this.progress.setMinimum(n);
        this.progress.setMaximum(n2);
        this.showPercent = bl;
        this.progress.setStringPainted(bl);
        this.add((Component)this.progress, string);
        this.validate();
        this.progressShowing = true;
        this.setProgressValue(n);
        this.forceUpdate();
    }

    public void removeProgressBar() {
        if (StatusLine.logger.level >= 7) {
            logger.lvlBuild(7, "removeProgressBar()", 434).log();
        }
        if (this.progressShowing) {
            this.remove(this.progress);
            this.validate();
            this.progressShowing = false;
            this.forceUpdate();
        }
    }

    public void setProgressValue(int n) {
        if (StatusLine.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setProgressValue(int)", 455).addDetail("value", n)).log();
        }
        if (this.progressShowing) {
            this.progress.setValue(n);
            if (this.showPercent) {
                this.progress.setString("" + (int)(this.progress.getPercentComplete() * 100.0) + "%");
            }
            SwingUtil.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Graphics graphics = StatusLine.this.progress.getGraphics();
                    if (graphics != null) {
                        Dimension dimension = StatusLine.this.progress.getSize();
                        graphics.setClip(0, 0, dimension.width, dimension.height);
                        graphics.clearRect(0, 0, dimension.width, dimension.height);
                        StatusLine.this.progress.paint(graphics);
                    }
                }
            });
        }
    }

    @Override
    public void countChanged(CountEvent countEvent) {
        if (StatusLine.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "countChanged(CountEvent)", 491).addDetail("event", countEvent)).log();
        }
        long l = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L || l < this.lastUpdateTime || l - this.lastUpdateTime > 200L) {
            this.setProgressValue((int)countEvent.getCount());
            this.lastUpdateTime = l;
        }
    }

    public JProgressBar getProgressBar() {
        return this.progress;
    }
}

