/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.gui.AWTTreeAdapter;
import de.qfs.lib.gui.AugmentedTextActions;
import de.qfs.lib.gui.EventQueue;
import de.qfs.lib.gui.ModalDialog;
import de.qfs.lib.gui.SwingUtilExceptionHolder;
import de.qfs.lib.gui.SwingUtilRunnerThread;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.Logger;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.edit.KeyOptionEdit;
import de.qfs.lib.tree.Traversal;
import de.qfs.lib.tree.TraversalCallback;
import de.qfs.lib.tree.TreeUtil;
import de.qfs.lib.util.ExecutorWithTimeout;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Pair;
import de.qfs.lib.util.Reflector;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.im.InputContext;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import lombok.Generated;
import lombok.NonNull;
import sun.awt.AWTAccessor;

public abstract class SwingUtil {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.SwingUtil");
    public static final int NO_EVENTS = 0;
    public static final int ALL_EVENTS = -1;
    public static final int PAINT_EVENTS = 1;
    public static final int INPUT_EVENTS = 2;
    public static final int OTHER_EVENTS = -4;
    private static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    private static final Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    private static final AWTTreeAdapter adapter = new AWTTreeAdapter();
    private static final Object cLock = new Object();
    private static int withEventsDepth;
    private static WindowTracker windowTracker;
    private static Keymap defaultKeymap;
    private static HashSet forwardKeys;
    private static HashSet backwardKeys;
    static WeakReference<GraphicsDevice> lastScalingGraphicsDevice;
    static double lastScalingFactor;
    private static ExecutorWithTimeout executorWithTimeout;
    private static Object executorWithTimeoutMonitor;

    public SwingUtil() {
        if (SwingUtil.logger.level >= 7) {
            logger.lvlBuild(7, "SwingUtil.SwingUtil()", 150).log();
        }
    }

    public static boolean invokeAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)invocationTargetException.getTargetException();
                }
                if (SwingUtil.logger.level >= 1) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "invokeAndWait(Runnable)", 280).add("ex.getTargetException()", invocationTargetException.getTargetException())).log();
                }
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    public static <T> T invokeAndWait(final @NonNull Callable<T> callable) {
        if (callable == null) {
            throw new IllegalArgumentException("callable is marked non-null but is null");
        }
        final Object[] objectArray = new Object[1];
        final Exception[] exceptionArray = new Exception[1];
        boolean bl = SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    objectArray[0] = callable.call();
                }
                catch (Exception exception) {
                    exceptionArray[0] = exception;
                }
            }
        });
        if (!bl) {
            throw new InterruptedException();
        }
        if (exceptionArray[0] != null) {
            throw exceptionArray[0];
        }
        return (T)objectArray[0];
    }

    public static void invokeNowOrLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void invokeLaterOutsideDispatchThread(@NonNull Runnable runnable, long l, @Nullable Runnable runnable2) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "invokeLaterOutsideDispatchThread(Runnable,long,Runnable)", 357).addDetail("task", runnable)).addDetail("timeout", l)).addDetail("timeoutHandler", runnable2)).log();
        }
        if (runnable == null) {
            throw new IllegalArgumentException("task is marked non-null but is null");
        }
        ExecutorWithTimeout executorWithTimeout = SwingUtil.getExecutorWithTimeout();
        executorWithTimeout.submit(runnable, l, TimeUnit.MILLISECONDS, runnable2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutorWithTimeout getExecutorWithTimeout() {
        if (SwingUtil.logger.level >= 7) {
            logger.lvlBuild(7, "getExecutorWithTimeout()", 366).log();
        }
        Object object = executorWithTimeoutMonitor;
        synchronized (object) {
            if (executorWithTimeout == null) {
                executorWithTimeout = new ExecutorWithTimeout(1, 2);
            }
            return executorWithTimeout;
        }
    }

    public static Object withEvents(UnsafeRunnable unsafeRunnable, boolean bl) throws InvocationTargetException {
        if (bl) {
            return SwingUtil.withEvents(unsafeRunnable, -3, 2, null, false);
        }
        return SwingUtil.withEvents(unsafeRunnable, -1, 0, null, false);
    }

    public static Object withEvents(UnsafeRunnable unsafeRunnable, int n, int n2) throws InvocationTargetException {
        return SwingUtil.withEvents(unsafeRunnable, n, n2, null, false);
    }

    public static Object withEvents(UnsafeRunnable unsafeRunnable, int n, int n2, Component[] componentArray, boolean bl) throws InvocationTargetException {
        return SwingUtil.withEvents(unsafeRunnable, n, n2, componentArray, bl, 300, false);
    }

    public static Object withEvents(UnsafeRunnable unsafeRunnable, int n, int n2, Component[] componentArray, boolean bl, boolean bl2) throws InvocationTargetException {
        return SwingUtil.withEvents(unsafeRunnable, n, n2, componentArray, bl, 300, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object withEvents(final UnsafeRunnable var0, int var1_1, int var2_2, Component[] var3_3, boolean var4_4, int var5_5, boolean var6_6) throws InvocationTargetException {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)SwingUtil.logger.lvlBuild(7, "withEvents(UnsafeRunnable,int,int,Component[],boolean,int,boolean)", 672).addDetail("runnable", var0)).addDetail("delay", var1_1)).addDetail("discard", var2_2)).addDetail("exceptions", var3_3)).addDetail("showWaitCursor", var4_4)).addDetail("delayCursor", var5_5)).addDetail("dontShowOnModalDialogs", var6_6)).log();
        }
        var7_7 = new Throwable[1];
        var8_8 = new Object[1];
        var9_9 = new EventLock();
        var9_9.setLocked(true);
        var10_10 = new ArrayList<Pair<Component, Cursor>>();
        var11_11 = null;
        var12_12 = SwingUtilExceptionHolder.getInstance().getAndRegisterExceptions(var3_3);
        if (var4_4) {
            if (SwingUtil.logger.level >= 5) {
                ((LevelAwareLogBuilder)SwingUtil.logger.lvlBuild(5, "withEvents(UnsafeRunnable,int,int,Component[],boolean,int,boolean)", 687).add("Setting wait cursor")).log();
            }
            if (var5_5 > 0) {
                var13_13 = var6_6;
                var11_11 = new Timer(var5_5, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Frame[] frameArray;
                        CursorSetter cursorSetter = new CursorSetter(var10_10, var12_12, var13_13);
                        for (Frame frame : frameArray = Frame.getFrames()) {
                            SwingUtil.setWaitCursor(frame, cursorSetter);
                        }
                        if (logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "withEvents(UnsafeRunnable,int,int,Component[],boolean,int,boolean).Timer.ActionListener.actionPerformed(ActionEvent)", 699).add("Cursor list entries", var10_10.size())).log();
                        }
                    }
                });
                var11_11.setRepeats(false);
                var11_11.start();
            } else {
                var13_14 = new CursorSetter(var10_10, var3_3, var6_6);
                var14_16 = Frame.getFrames();
                for (Frame var18_22 : var14_16) {
                    SwingUtil.setWaitCursor(var18_22, var13_14);
                }
                if (SwingUtil.logger.level >= 9) {
                    ((LevelAwareLogBuilder)SwingUtil.logger.lvlBuild(9, "withEvents(UnsafeRunnable,int,int,Component[],boolean,int,boolean)", 710).add("Cursor list entries", var10_10.size())).log();
                }
            }
        }
        var13_15 = null;
        try {
            var14_16 = SwingUtil.cLock;
            synchronized (SwingUtil.cLock) {
                // ** MonitorExit[var14_16] (shouldn't be in output)
                var13_15 = new SwingUtilRunnerThread("SwingUtil-withEventsThread-" + ++SwingUtil.withEventsDepth){

                    @Override
                    public void run() {
                        try {
                            var8_8[0] = var0.run();
                        }
                        catch (Throwable throwable) {
                            var7_7[0] = throwable;
                        }
                        finally {
                            if (logger.level >= 9) {
                                ((LevelAwareLogBuilder)logger.lvlBuild(9, "withEvents(UnsafeRunnable,int,int,Component[],boolean,int,boolean).SwingUtilRunnerThread.run()", 731).add("finished, posting DoneEvent")).log();
                            }
                            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new DoneEvent(var9_9));
                        }
                    }
                };
                var13_15.start();
                SwingUtilExceptionHolder.getInstance().addThread(var13_15);
                SwingUtil.poll(var1_1, var2_2, var9_9, var12_12, var13_15);
                if (!var13_15.isRunning()) {
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new DoneEvent(var9_9));
                }
                SwingUtilExceptionHolder.getInstance().removeThread(var13_15);
                var13_15 = null;
                SwingUtilExceptionHolder.getInstance().removeExceptions(var3_3);
                var14_16 = SwingUtil.cLock;
            }
        }
        catch (Throwable var21_23) {
            SwingUtilExceptionHolder.getInstance().removeThread(var13_15);
            var13_15 = null;
            SwingUtilExceptionHolder.getInstance().removeExceptions(var3_3);
            var22_24 = SwingUtil.cLock;
            synchronized (var22_24) {
                --SwingUtil.withEventsDepth;
                ** if (!var4_4) goto lbl61
            }
lbl-1000:
            // 1 sources

            {
                if (var11_11 != null) {
                    var11_11.stop();
                }
                if (SwingUtil.logger.level >= 5) {
                    ((LevelAwareLogBuilder)SwingUtil.logger.lvlBuild(5, "withEvents(UnsafeRunnable,int,int,Component[],boolean,int,boolean)", 765).add("Resetting cursors")).log();
                }
                for (Pair<Component, Cursor> var23_25 : var10_10) {
                    if (SwingUtil.logger.level >= 10) {
                        ((LevelAwareLogBuilder)SwingUtil.logger.lvlBuild(10, "withEvents(UnsafeRunnable,int,int,Component[],boolean,int,boolean)", 767).add("pair", var23_25)).log();
                    }
                    var23_25.getFirst().setCursor(var23_25.getSecond() == SwingUtil.DEFAULT_CURSOR ? null : var23_25.getSecond());
                    if (SwingUtil.logger.level < 9) continue;
                    ((LevelAwareLogBuilder)SwingUtil.logger.lvlBuild(9, "withEvents(UnsafeRunnable,int,int,Component[],boolean,int,boolean)", 770).add("cursor for " + var23_25.getFirst() + "", var23_25.getFirst().getCursor())).log();
                }
            }
lbl61:
            // 2 sources

            throw var21_23;
        }
        {
            synchronized (var14_16) {
                --SwingUtil.withEventsDepth;
                ** if (!var4_4) goto lbl76
            }
lbl-1000:
            // 1 sources

            {
                if (var11_11 != null) {
                    var11_11.stop();
                }
                if (SwingUtil.logger.level >= 5) {
                    ((LevelAwareLogBuilder)SwingUtil.logger.lvlBuild(5, "withEvents(UnsafeRunnable,int,int,Component[],boolean,int,boolean)", 765).add("Resetting cursors")).log();
                }
                for (Pair var15_19 : var10_10) {
                    if (SwingUtil.logger.level >= 10) {
                        ((LevelAwareLogBuilder)SwingUtil.logger.lvlBuild(10, "withEvents(UnsafeRunnable,int,int,Component[],boolean,int,boolean)", 767).add("pair", var15_19)).log();
                    }
                    ((Component)var15_19.getFirst()).setCursor(var15_19.getSecond() == SwingUtil.DEFAULT_CURSOR ? null : (Cursor)var15_19.getSecond());
                    if (SwingUtil.logger.level < 9) continue;
                    ((LevelAwareLogBuilder)SwingUtil.logger.lvlBuild(9, "withEvents(UnsafeRunnable,int,int,Component[],boolean,int,boolean)", 770).add("cursor for " + var15_19.getFirst() + "", ((Component)var15_19.getFirst()).getCursor())).log();
                }
            }
lbl76:
            // 2 sources

            if (var7_7[0] == null) {
                return var8_8[0];
            }
            if (var7_7[0] instanceof RuntimeException) {
                throw (RuntimeException)var7_7[0];
            }
            throw new InvocationTargetException(var7_7[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getWithEventsDepth() {
        Object object = cLock;
        synchronized (object) {
            return withEventsDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void poll(int n, int n2, EventLock eventLock, Component[] componentArray, SwingUtilRunnerThread swingUtilRunnerThread) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "poll(int,int,EventLock,Component[],SwingUtilRunnerThread)", 815).addDetail("delay", n)).addDetail("discard", n2)).addDetail("lock", eventLock)).addDetail("exceptions", componentArray)).addDetail("thread", swingUtilRunnerThread)).log();
        }
        java.awt.EventQueue eventQueue = EventQueue.instance();
        if (SwingUtil.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "poll(int,int,EventLock,Component[],SwingUtilRunnerThread)", 819).add("queue", eventQueue)).log();
        }
        boolean bl = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (!bl && swingUtilRunnerThread.isRunning()) {
            block37: {
                Object object;
                if (SwingUtilities.isEventDispatchThread()) {
                    if (SwingUtil.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "poll(int,int,EventLock,Component[],SwingUtilRunnerThread)", 825).add("getting next event")).log();
                    }
                    try {
                        Object object2 = object = eventQueue.getNextEvent();
                        if (object instanceof EventQueue.WrapperEvent) {
                            object = ((EventQueue.WrapperEvent)object).getWrappedEvent();
                        }
                        if (SwingUtil.logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "poll(int,int,EventLock,Component[],SwingUtilRunnerThread)", 833).add("event", object)).log();
                        }
                        boolean bl2 = false;
                        boolean bl3 = false;
                        if (!(object instanceof DoneEvent)) {
                            if (object instanceof InputEvent || ((AWTEvent)object).getID() == 201) {
                                bl3 |= (n2 & 2) != 0;
                                bl2 |= (n & 2) != 0;
                            } else if (object instanceof PaintEvent) {
                                bl3 |= (n2 & 1) != 0;
                                bl2 |= (n & 1) != 0;
                            } else {
                                bl3 |= (n2 & 0xFFFFFFFC) != 0;
                                bl2 |= (n & 0xFFFFFFFC) != 0;
                            }
                        }
                        if (bl3 | bl2 && componentArray != null && ((EventObject)object).getSource() instanceof Component) {
                            Component component = (Component)((EventObject)object).getSource();
                            Component component2 = null;
                            if (object instanceof MouseEvent) {
                                component2 = SwingUtilities.getDeepestComponentAt(component, ((MouseEvent)object).getX(), ((MouseEvent)object).getY());
                            } else if (object instanceof KeyEvent && (component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && !SwingUtilities.isDescendingFrom(component2, component)) {
                                component2 = null;
                            }
                            if (SwingUtil.logger.level >= 9) {
                                ((LevelAwareLogBuilder)logger.lvlBuild(9, "poll(int,int,EventLock,Component[],SwingUtilRunnerThread)", 865).add("target2", component2)).log();
                            }
                            if (component2 != null) {
                                component = component2;
                            }
                            for (Component component3 : componentArray) {
                                if (component3 == null || !SwingUtilities.isDescendingFrom(component, component3)) continue;
                                bl3 = false;
                                bl2 = false;
                                break;
                            }
                        }
                        if (SwingUtil.logger.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "poll(int,int,EventLock,Component[],SwingUtilRunnerThread)", 879).add("shouldDiscard", bl3)).add("shouldDelay", bl2)).log();
                        }
                        if (bl3) {
                            Reflector.safeCall(object, "consume", true);
                            break block37;
                        }
                        if (bl2) {
                            arrayList.add(object);
                            break block37;
                        }
                        try {
                            SwingUtil.doDispatch((AWTEvent)object2, (AWTEvent)object);
                        }
                        catch (RuntimeException runtimeException) {
                            if (SwingUtil.logger.level >= 1) {
                                ((LevelAwareLogBuilder)logger.lvlBuild(1, "poll(int,int,EventLock,Component[],SwingUtilRunnerThread)", 890).add("ex", runtimeException)).log();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    if (SwingUtil.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "poll(int,int,EventLock,Component[],SwingUtilRunnerThread)", 896).add("waiting for lock")).log();
                    }
                    object = eventLock;
                    synchronized (object) {
                        try {
                            eventLock.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            boolean bl4 = bl = !eventLock.isLocked();
            if (SwingUtil.logger.level < 9) continue;
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "poll(int,int,EventLock,Component[],SwingUtilRunnerThread)", 905).add("done", bl)).log();
        }
        if (arrayList.size() > 0) {
            for (Object object2 : arrayList) {
                if (SwingUtil.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "poll(int,int,EventLock,Component[],SwingUtilRunnerThread)", 912).add("pevent", object2)).log();
                }
                eventQueue.postEvent((AWTEvent)object2);
            }
        }
    }

    private static void doDispatch(AWTEvent aWTEvent, AWTEvent aWTEvent2) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "doDispatch(AWTEvent,AWTEvent)", 928).addDetail("orig", aWTEvent)).addDetail("event", aWTEvent2)).log();
        }
        if (aWTEvent instanceof EventQueue.WrapperEvent) {
            ((EventQueue.WrapperEvent)aWTEvent).dispatch();
        } else if (EventQueue.isInstalled()) {
            ((EventQueue)EventQueue.instance()).dispatchEvent(aWTEvent2);
        } else {
            java.awt.EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            if (eventQueue instanceof EventQueue) {
                ((EventQueue)eventQueue).dispatchEvent(aWTEvent2);
            } else {
                Object object = aWTEvent2.getSource();
                if (aWTEvent2 instanceof ActiveEvent) {
                    ((ActiveEvent)((Object)aWTEvent2)).dispatch();
                } else if (object instanceof Component) {
                    ((Component)object).dispatchEvent(aWTEvent2);
                } else if (object instanceof MenuComponent) {
                    ((MenuComponent)object).dispatchEvent(aWTEvent2);
                }
            }
        }
    }

    private static void setWaitCursor(Window window, CursorSetter cursorSetter) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setWaitCursor(Window,CursorSetter)", 958).addDetail("window", window)).addDetail("cs", cursorSetter)).log();
        }
        TreeUtil.traverse(adapter, window, cursorSetter);
        Window[] windowArray = window.getOwnedWindows();
        if (windowArray != null) {
            for (Window window2 : windowArray) {
                SwingUtil.setWaitCursor(window2, cursorSetter);
            }
        }
    }

    public static void prepareKeymaps() {
        KeyStroke keyStroke;
        JTextField jTextField;
        Keymap keymap;
        Action action;
        if (SwingUtil.logger.level >= 7) {
            logger.lvlBuild(7, "prepareKeymaps()", 1208).log();
        }
        if (defaultKeymap == null && (action = (keymap = (jTextField = new JTextField()).getKeymap()).getAction(keyStroke = KeyStroke.getKeyStroke(10, 0))) != null) {
            keymap.removeKeyStrokeBinding(keyStroke);
            new JPasswordField().getKeymap().removeKeyStrokeBinding(keyStroke);
            defaultKeymap = JTextComponent.addKeymap("old", keymap);
            defaultKeymap.addActionForKeyStroke(keyStroke, action);
        }
    }

    public static void setDefaultEnterBinding(JTextComponent jTextComponent) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setDefaultEnterBinding(JTextComponent)", 1235).addDetail("text", jTextComponent)).log();
        }
        jTextComponent.setKeymap(defaultKeymap);
    }

    public static void setTextActionsForInputMap(InputMap inputMap) {
        KeyStroke keyStroke;
        KeyStroke keyStroke2;
        KeyStroke keyStroke3 = KeyOptionEdit.getKeyStrokeForResource("popup.copy");
        if (keyStroke3 != null) {
            inputMap.put(keyStroke3, "copy-to-clipboard");
        }
        if ((keyStroke2 = KeyOptionEdit.getKeyStrokeForResource("popup.paste")) != null) {
            inputMap.put(keyStroke2, "paste-from-clipboard");
        }
        if ((keyStroke = KeyOptionEdit.getKeyStrokeForResource("popup.cut")) != null) {
            inputMap.put(keyStroke, "cut-to-clipboard");
        }
        SwingUtil.replaceExistingKeystroke(inputMap, KeyStroke.getKeyStroke(38, 0), AugmentedTextActions.upOrStartAction);
        SwingUtil.replaceExistingKeystroke(inputMap, KeyStroke.getKeyStroke(40, 0), AugmentedTextActions.downOrEndAction);
        SwingUtil.replaceExistingKeystroke(inputMap, KeyStroke.getKeyStroke(38, 1), AugmentedTextActions.selectionUpOrStartAction);
        SwingUtil.replaceExistingKeystroke(inputMap, KeyStroke.getKeyStroke(40, 1), AugmentedTextActions.selectionDownOrEndAction);
        if (Misc.OS_IS_MAC_OS_X) {
            KeyStroke keyStroke4 = KeyOptionEdit.getKeyStrokeForResource("popup.selectall");
            if (keyStroke4 != null) {
                inputMap.put(keyStroke4, "select-all");
            }
            inputMap.put(KeyStroke.getKeyStroke(37, 4), "caret-begin-line");
            inputMap.put(KeyStroke.getKeyStroke(39, 4), "caret-end-line");
            inputMap.put(KeyStroke.getKeyStroke(38, 4), "caret-begin");
            inputMap.put(KeyStroke.getKeyStroke(40, 4), "caret-end");
            inputMap.put(KeyStroke.getKeyStroke(37, 5), "selection-begin-line");
            inputMap.put(KeyStroke.getKeyStroke(39, 5), "selection-end-line");
            inputMap.put(KeyStroke.getKeyStroke(38, 5), "selection-begin");
            inputMap.put(KeyStroke.getKeyStroke(40, 5), "selection-end");
            inputMap.put(KeyStroke.getKeyStroke(37, 8), "caret-previous-word");
            inputMap.put(KeyStroke.getKeyStroke(39, 8), "caret-next-word");
            inputMap.put(KeyStroke.getKeyStroke(37, 9), "selection-previous-word");
            inputMap.put(KeyStroke.getKeyStroke(39, 9), "selection-next-word");
            inputMap.put(KeyStroke.getKeyStroke(40, 8), AugmentedTextActions.endLineOrNextAction);
            inputMap.put(KeyStroke.getKeyStroke(38, 8), AugmentedTextActions.beginLineOrPreviousAction);
            inputMap.put(KeyStroke.getKeyStroke(40, 9), AugmentedTextActions.selectionEndLineOrNextAction);
            inputMap.put(KeyStroke.getKeyStroke(38, 9), AugmentedTextActions.selectionBeginLineOrPreviousAction);
        }
    }

    private static void replaceExistingKeystroke(InputMap inputMap, KeyStroke keyStroke, Object object) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "replaceExistingKeystroke(InputMap,KeyStroke,Object)", 1302).addDetail("inputMap", inputMap)).addDetail("keyStroke", keyStroke)).addDetail("actionMapKey", object)).log();
        }
        if (inputMap.get(keyStroke) != null) {
            inputMap.put(keyStroke, object);
        }
    }

    public static JFileChooser createFileChooser(String string, File file, FileSystemView fileSystemView) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createFileChooser(String,File,FileSystemView)", 1328).addDetail("currentDirectoryPath", string)).addDetail("currentDirectory", file)).addDetail("fsv", fileSystemView)).log();
        }
        if (fileSystemView == null) {
            if (string == null) {
                return file == null ? new JFileChooser() : new JFileChooser(file);
            }
            return new JFileChooser(string);
        }
        if (string == null) {
            return file == null ? new JFileChooser(fileSystemView) : new JFileChooser(file, fileSystemView);
        }
        return new JFileChooser(string, fileSystemView);
    }

    public static void closeOnEscape(final Window window) {
        window.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27 && keyEvent.getModifiers() == 0) {
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(window, 201));
                    keyEvent.consume();
                }
            }
        });
        JRootPane jRootPane = null;
        if (window instanceof JFrame) {
            jRootPane = ((JFrame)window).getRootPane();
        }
        if (window instanceof JDialog) {
            jRootPane = ((JDialog)window).getRootPane();
        }
        if (jRootPane != null) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(window, 201));
                }
            };
            jRootPane.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 1);
        }
    }

    public static void unregisterKey(JComponent jComponent, KeyStroke keyStroke, int n) {
        jComponent.unregisterKeyboardAction(keyStroke);
        Object object = Reflector.safeCall((Object)jComponent, "getInputMap", Integer.TYPE, (Object)n);
        if (object != null) {
            Reflector.safeCall(object, "put", new Class[]{KeyStroke.class, Object.class}, new Object[]{keyStroke, "__dummy__"});
        }
    }

    public static void disableInternalTabTraversal(JComponent jComponent) {
        Reflector.safeCall((Object)jComponent, "setFocusTraversalKeys", new Class[]{Integer.TYPE, Set.class}, new Object[]{0, forwardKeys});
        Reflector.safeCall((Object)jComponent, "setFocusTraversalKeys", new Class[]{Integer.TYPE, Set.class}, new Object[]{1, backwardKeys});
    }

    public static void showPopup(JPopupMenu jPopupMenu, Component component, int n, int n2, boolean bl) {
        GraphicsConfiguration graphicsConfiguration;
        Cloneable cloneable;
        Point point;
        Window window;
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "showPopup(JPopupMenu,Component,int,int,boolean)", 1487).addDetail("menu", jPopupMenu)).addDetail("parent", component)).addDetail("x", n)).addDetail("y", n2)).addDetail("constrain", bl)).log();
        }
        if (component == null || !component.isShowing()) {
            jPopupMenu.show(component, n, n2);
            return;
        }
        jPopupMenu.pack();
        Dimension dimension = jPopupMenu.getPreferredSize();
        if (component instanceof Window) {
            window = (Window)component;
            point = new Point(n, n2);
        } else {
            window = SwingUtilities.windowForComponent(component);
            point = SwingUtilities.convertPoint(component, n, n2, window);
            n = point.x;
            n2 = point.y;
        }
        Point point2 = window.getLocation();
        if (SwingUtil.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "showPopup(JPopupMenu,Component,int,int,boolean)", 1511).add("x", n)).add("y", n2)).add("wPos", point2)).add("size", dimension)).log();
        }
        if (bl) {
            cloneable = window.getSize();
            if (n + dimension.width > cloneable.width) {
                n = cloneable.width - dimension.width;
            }
            if (n < 0) {
                n = 0;
            }
            if (n2 + dimension.height > cloneable.height) {
                n2 = cloneable.height - dimension.height;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (SwingUtil.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "showPopup(JPopupMenu,Component,int,int,boolean)", 1527).add("Window constrain x", n)).add("y", n2)).log();
            }
        }
        if ((graphicsConfiguration = SwingUtil.getClosestGraphicsConfiguration(n += point2.x, n2 += point2.y)) != null) {
            cloneable = SwingUtil.getUsableBounds(graphicsConfiguration);
        } else {
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            cloneable = new Rectangle(0, 0, dimension2.width, dimension2.height);
        }
        if (n + dimension.width > ((Rectangle)cloneable).x + ((Rectangle)cloneable).width) {
            n = ((Rectangle)cloneable).x + ((Rectangle)cloneable).width - dimension.width;
        }
        if (n < ((Rectangle)cloneable).x) {
            n = ((Rectangle)cloneable).x;
        }
        if (n2 + dimension.height > ((Rectangle)cloneable).y + ((Rectangle)cloneable).height) {
            n2 = ((Rectangle)cloneable).y + ((Rectangle)cloneable).height - dimension.height;
        }
        if (n2 < ((Rectangle)cloneable).y) {
            n2 = ((Rectangle)cloneable).y;
        }
        if (SwingUtil.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "showPopup(JPopupMenu,Component,int,int,boolean)", 1554).add("Screen constrain x", n)).add("y", n2)).log();
        }
        point = SwingUtilities.convertPoint(window, n - point2.x, n2 - point2.y, component);
        if (SwingUtil.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "showPopup(JPopupMenu,Component,int,int,boolean)", 1556).add("Converted back x", point.x)).add("y", point.y)).log();
        }
        jPopupMenu.show(component, point.x, point.y);
    }

    public static void scrollUpLine(JScrollPane jScrollPane) {
        Component component;
        JViewport jViewport = jScrollPane.getViewport();
        Component component2 = component = jViewport == null ? null : jViewport.getView();
        if (!(component instanceof Scrollable)) {
            return;
        }
        Rectangle rectangle = jViewport.getViewRect();
        Dimension dimension = component.getSize();
        int n = ((Scrollable)((Object)component)).getScrollableUnitIncrement(rectangle, 1, -1);
        rectangle.y += n;
        if (rectangle.y + rectangle.height > dimension.height) {
            rectangle.y = Math.max(0, dimension.height - rectangle.height);
        }
        jViewport.setViewPosition(rectangle.getLocation());
    }

    public static void scrollDownLine(JScrollPane jScrollPane) {
        Component component;
        JViewport jViewport = jScrollPane.getViewport();
        Component component2 = component = jViewport == null ? null : jViewport.getView();
        if (!(component instanceof Scrollable)) {
            return;
        }
        Rectangle rectangle = jViewport.getViewRect();
        int n = ((Scrollable)((Object)component)).getScrollableUnitIncrement(rectangle, 1, -1);
        rectangle.y -= n;
        if (rectangle.y < 0) {
            rectangle.y = 0;
        }
        jViewport.setViewPosition(rectangle.getLocation());
    }

    public static void XXXdisableScrollBarFocus(Component component) {
        TreeUtil.visitTree(adapter, new FocusDisabler(), component);
    }

    public static void focusLater(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                component.requestFocus();
            }
        });
    }

    public static void cleanup(Component component) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "cleanup(Component)", 1687).addDetail("c", component)).log();
        }
        if (component instanceof JMenuBar && Misc.OS_IS_MAC_OS_X) {
            return;
        }
        Component[] componentArray = null;
        if (component instanceof ModalDialog) {
            ((ModalDialog)component).setReusable(false);
        }
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                SwingUtil.cleanup(componentArray[i]);
                ((Container)component).remove(componentArray[i]);
            }
        }
        if (component instanceof JMenu) {
            ((JMenu)component).removeAll();
        }
        if (component.getParent() != null) {
            component.getParent().remove(component);
        }
    }

    public static void deactivateInputContexts(Window window) {
        Object object;
        if (Misc.IS_JAVA_VERSION_AT_LEAST_9) {
            if (SwingUtil.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "deactivateInputContexts(Window)", 1738).add("Cannot access currentClientComponent in Java versions 9 and up")).log();
            }
            return;
        }
        InputContext inputContext = window.getInputContext();
        if (inputContext != null && (object = Reflector.safeGet(inputContext, "currentClientComponent", true)) != null) {
            inputContext.removeNotify((Component)object);
        }
        object = window.getOwnedWindows();
        for (int i = 0; object != null && i < ((Window[])object).length; ++i) {
            SwingUtil.deactivateInputContexts(object[i]);
        }
    }

    public static boolean expandAll(JTree jTree, TreePath treePath, int n) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "expandAll(JTree,TreePath,int)", 1780).addDetail("tree", jTree)).addDetail("path", treePath)).addDetail("limit", n)).log();
        }
        return SwingUtil._expandAll(jTree, treePath, new int[]{n});
    }

    public static boolean collapseAll(JTree jTree, TreePath treePath, int n) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "collapseAll(JTree,TreePath,int)", 1798).addDetail("tree", jTree)).addDetail("path", treePath)).addDetail("limit", n)).log();
        }
        return SwingUtil._collapseAll(jTree, treePath, new int[]{n});
    }

    private static boolean _expandAll(JTree jTree, TreePath treePath, int[] nArray) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "_expandAll(JTree,TreePath,int[])", 1816).addDetail("tree", jTree)).addDetail("path", treePath)).addDetail("limit", nArray)).log();
        }
        Object object = treePath.getLastPathComponent();
        TreeModel treeModel = jTree.getModel();
        if (treeModel.isLeaf(object)) {
            return true;
        }
        jTree.expandPath(treePath);
        nArray[0] = nArray[0] - 1;
        if (nArray[0] <= 0) {
            return false;
        }
        int n = treeModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            if (SwingUtil._expandAll(jTree, treePath.pathByAddingChild(treeModel.getChild(object, i)), nArray)) continue;
            return false;
        }
        return true;
    }

    private static boolean _collapseAll(JTree jTree, TreePath treePath, int[] nArray) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "_collapseAll(JTree,TreePath,int[])", 1851).addDetail("tree", jTree)).addDetail("path", treePath)).addDetail("limit", nArray)).log();
        }
        Object object = treePath.getLastPathComponent();
        TreeModel treeModel = jTree.getModel();
        if (treeModel.isLeaf(object)) {
            return true;
        }
        int n = treeModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            if (SwingUtil._collapseAll(jTree, treePath.pathByAddingChild(treeModel.getChild(object, i)), nArray)) continue;
            return false;
        }
        jTree.collapsePath(treePath);
        nArray[0] = nArray[0] - 1;
        return nArray[0] > 0;
    }

    public static void cleanupKeyHandlers(Component component) {
        KeyListener[] keyListenerArray;
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "cleanupKeyHandlers(Component)", 1877).addDetail("com", component)).log();
        }
        if ((keyListenerArray = component.getKeyListeners()) != null) {
            for (KeyListener keyListener : keyListenerArray) {
                String string = keyListener.getClass().getName();
                if (!string.endsWith("BasicButtonUI$KeyHandler") && !string.endsWith("BasicRadioButtonUI$KeyHandler")) continue;
                component.removeKeyListener(keyListener);
            }
        }
    }

    public static void cleanupFocusListeners(Component component) {
        FocusListener[] focusListenerArray;
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "cleanupFocusListeners(Component)", 1901).addDetail("com", component)).log();
        }
        if ((focusListenerArray = component.getFocusListeners()) != null) {
            for (FocusListener focusListener : focusListenerArray) {
                if (focusListener.getClass().getName().indexOf("BasicTableHeaderUI$") < 0) continue;
                component.removeFocusListener(focusListener);
            }
        }
    }

    public static void cleanupKeystrokeMap(Component component) {
        block7: {
            if (SwingUtil.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "cleanupKeystrokeMap(Component)", 1922).addDetail("com", component)).log();
            }
            try {
                Object object = Reflector.get(Class.forName("javax.swing.KeyboardManager"), "currentManager", true);
                Hashtable hashtable = (Hashtable)Reflector.get(object, "containerMap", true);
                if (hashtable != null && hashtable.containsKey(component)) {
                    if (SwingUtil.logger.level >= 5) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "cleanupKeystrokeMap(Component)", 1928).add("com", component)).add("cMap", hashtable)).log();
                    }
                    hashtable.remove(component);
                }
                Hashtable hashtable2 = (Hashtable)Reflector.get(object, "componentKeyStrokeMap", true);
                Iterator iterator = hashtable2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (entry.getValue() != component) continue;
                    if (SwingUtil.logger.level >= 5) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "cleanupKeystrokeMap(Component)", 1935).add("com", component)).add("entry", entry)).log();
                    }
                    iterator.remove();
                }
            }
            catch (Throwable throwable) {
                if (SwingUtil.logger.level < 3) break block7;
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "cleanupKeystrokeMap(Component)", 1940).add("ex", throwable)).log();
            }
        }
    }

    public static void autoSizeTableColumn(JTable jTable, int n) {
        SwingUtil.autoSizeTableColumn(jTable, n, true);
    }

    public static void autoSizeTableColumn(JTable jTable, int n, boolean bl) {
        Object object;
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "autoSizeTableColumn(JTable,int,boolean)", 1979).addDetail("table", jTable)).addDetail("column", n)).addDetail("respectHeader", bl)).log();
        }
        if (jTable.getRowCount() == 0 || !(jTable.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)jTable.getParent();
        Rectangle rectangle = jViewport.getViewRect();
        int n2 = jTable.rowAtPoint(new Point(0, rectangle.y));
        int n3 = jTable.rowAtPoint(new Point(0, rectangle.y + rectangle.height));
        if (n3 < 0) {
            n3 = jTable.getRowCount() - 1;
        }
        int n4 = 0;
        int n5 = jTable.getColumnModel().getColumnMargin();
        for (int i = n2; i <= n3; ++i) {
            object = jTable.prepareRenderer(jTable.getCellRenderer(i, n), i, n);
            n4 = object instanceof JComponent ? Math.max(n4, n5 + ((JComponent)object).getPreferredSize().width) : Math.max(n4, n5 + ((Component)object).getSize().width);
        }
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        if (SwingUtil.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "autoSizeTableColumn(JTable,int,boolean)", 2009).add("col", tableColumn)).log();
        }
        if (bl) {
            object = tableColumn.getHeaderRenderer();
            if (object == null) {
                object = jTable.getTableHeader().getDefaultRenderer();
            }
            if (object != null) {
                Component component = object.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, n);
                n4 = component instanceof JComponent ? Math.max(n4, n5 + ((JComponent)component).getPreferredSize().width + 2) : Math.max(n4, n5 + component.getSize().width + 2);
            }
        }
        tableColumn.setPreferredWidth(n4);
        tableColumn.setWidth(n4);
        jTable.revalidate();
    }

    public static void centerWindow(Window window) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment != null) {
            Point point = graphicsEnvironment.getCenterPoint();
            Dimension dimension = window.getSize();
            if (point != null) {
                window.setLocation(point.x - dimension.width / 2, point.y - dimension.height / 2);
            }
            return;
        }
        SwingUtil.centerWindow(window, null);
    }

    public static void centerWindow(Window window, GraphicsConfiguration graphicsConfiguration) {
        Rectangle rectangle;
        Dimension dimension;
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "centerWindow(Window,GraphicsConfiguration)", 2072).addDetail("win", window)).addDetail("gc", graphicsConfiguration)).log();
        }
        if (graphicsConfiguration == null) {
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
            rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        } else {
            rectangle = SwingUtil.getUsableBounds(graphicsConfiguration);
        }
        dimension = window.getSize();
        window.setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
    }

    public static void centerWindowOnComponent(Window window, Component component, boolean bl) {
        Point point;
        Dimension dimension;
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "centerWindowOnComponent(Window,Component,boolean)", 2100).addDetail("win", window)).addDetail("com", component)).addDetail("constrain", bl)).log();
        }
        if (component == null) {
            SwingUtil.centerWindow(window);
            return;
        }
        Dimension dimension2 = window.getSize();
        try {
            dimension = component.getSize();
            point = component.getLocationOnScreen();
        }
        catch (Throwable throwable) {
            SwingUtil.centerWindow(window);
            return;
        }
        int n = point.x + (dimension.width - dimension2.width) / 2;
        int n2 = point.y + (dimension.height - dimension2.height) / 2;
        if (bl) {
            GraphicsConfiguration graphicsConfiguration = SwingUtil.getClosestGraphicsConfiguration(n, n2);
            Point point2 = SwingUtil.getLocationInsideGraphicsConfiguration(new Rectangle(n, n2, dimension2.width, dimension2.height), graphicsConfiguration);
            n = point2.x;
            n2 = point2.y;
        }
        window.setLocation(n, n2);
    }

    public static GraphicsConfiguration getGraphicsConfiguration(int n, int n2) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getGraphicsConfiguration(int,int)", 2146).addDetail("x", n)).addDetail("y", n2)).log();
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; graphicsDeviceArray != null && i < graphicsDeviceArray.length; ++i) {
            GraphicsConfiguration graphicsConfiguration;
            Rectangle rectangle;
            if (graphicsDeviceArray[i].getType() != 0 || !(rectangle = (graphicsConfiguration = graphicsDeviceArray[i].getDefaultConfiguration()).getBounds()).contains(n, n2)) continue;
            return graphicsConfiguration;
        }
        return null;
    }

    public static GraphicsConfiguration getClosestGraphicsConfiguration(int n, int n2) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getClosestGraphicsConfiguration(int,int)", 2175).addDetail("x", n)).addDetail("y", n2)).log();
        }
        try {
            GraphicsConfiguration graphicsConfiguration = null;
            int n3 = -1;
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
            for (int i = 0; graphicsDeviceArray != null && i < graphicsDeviceArray.length; ++i) {
                if (graphicsDeviceArray[i].getType() != 0) continue;
                GraphicsConfiguration graphicsConfiguration2 = graphicsDeviceArray[i].getDefaultConfiguration();
                Rectangle rectangle = graphicsConfiguration2.getBounds();
                if (rectangle.contains(n, n2)) {
                    return graphicsConfiguration2;
                }
                int n4 = 0;
                int n5 = 0;
                if (n < rectangle.x) {
                    n4 = rectangle.x - n;
                } else if (n >= rectangle.x + rectangle.width) {
                    n4 = n - (rectangle.x + rectangle.width) - 1;
                }
                if (n2 < rectangle.y) {
                    n5 = rectangle.y - n2;
                } else if (n2 >= rectangle.y + rectangle.height) {
                    n5 = n2 - (rectangle.y + rectangle.height) - 1;
                }
                int n6 = n4 * n4 + n5 * n5;
                if (n3 >= 0 && n6 >= n3) continue;
                n3 = n6;
                graphicsConfiguration = graphicsConfiguration2;
            }
            return graphicsConfiguration;
        }
        catch (Throwable throwable) {
            if (SwingUtil.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "getClosestGraphicsConfiguration(int,int)", 2212).add("ex", throwable)).log();
            }
            return null;
        }
    }

    public static Point getLocationInsideGraphicsConfiguration(Rectangle rectangle, GraphicsConfiguration graphicsConfiguration) {
        Point point;
        block9: {
            if (SwingUtil.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getLocationInsideGraphicsConfiguration(Rectangle,GraphicsConfiguration)", 2228).addDetail("rect", rectangle)).addDetail("gc", graphicsConfiguration)).log();
            }
            point = new Point(rectangle.x, rectangle.y);
            try {
                Rectangle rectangle2 = SwingUtil.getUsableBounds(graphicsConfiguration);
                if (SwingUtil.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "getLocationInsideGraphicsConfiguration(Rectangle,GraphicsConfiguration)", 2234).add("bounds", rectangle2)).log();
                }
                if (point.x + rectangle.width > rectangle2.x + rectangle2.width) {
                    point.x = rectangle2.x + rectangle2.width - rectangle.width;
                }
                if (point.y + rectangle.height > rectangle2.y + rectangle2.height) {
                    point.y = rectangle2.y + rectangle2.height - rectangle.height;
                }
                if (point.x < rectangle2.x) {
                    point.x = rectangle2.x;
                }
                if (point.y < rectangle2.y) {
                    point.y = rectangle2.y;
                }
            }
            catch (Throwable throwable) {
                if (SwingUtil.logger.level < 3) break block9;
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "getLocationInsideGraphicsConfiguration(Rectangle,GraphicsConfiguration)", 2248).add("ex", throwable)).log();
            }
        }
        if (SwingUtil.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getLocationInsideGraphicsConfiguration(Rectangle,GraphicsConfiguration)", 2250).add("ret", point)).log();
        }
        return point;
    }

    public static Rectangle getUsableBounds(GraphicsConfiguration graphicsConfiguration) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getUsableBounds(GraphicsConfiguration)", 2264).addDetail("gc", graphicsConfiguration)).log();
        }
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        return rectangle;
    }

    public static Vector<Rectangle> getDimensionsOfAllScreens() {
        if (SwingUtil.logger.level >= 7) {
            logger.lvlBuild(7, "getDimensionsOfAllScreens()", 2285).log();
        }
        Vector<Rectangle> vector = new Vector<Rectangle>();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            if (graphicsDeviceArray[i].getType() != 0) continue;
            GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[i].getDefaultConfiguration();
            vector.add(graphicsConfiguration.getBounds());
            if (SwingUtil.logger.level < 9) continue;
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getDimensionsOfAllScreens()", 2294).add("Bounds", graphicsConfiguration.getBounds())).log();
        }
        return vector;
    }

    public static Rectangle getUsableBoundsOfDefaultScreen() {
        if (SwingUtil.logger.level >= 7) {
            logger.lvlBuild(7, "getUsableBoundsOfDefaultScreen()", 2303).log();
        }
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            return SwingUtil.getUsableBounds(graphicsDevice.getDefaultConfiguration());
        }
        catch (HeadlessException headlessException) {
            if (SwingUtil.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "getUsableBoundsOfDefaultScreen()", 2312).add("Simulating screen bounds in headless mode")).log();
            }
            return new Rectangle(0, 0, 1024, 768);
        }
    }

    public static Vector<Rectangle> getUsableBoundsOfAllScreens() {
        if (SwingUtil.logger.level >= 7) {
            logger.lvlBuild(7, "getUsableBoundsOfAllScreens()", 2325).log();
        }
        Vector<Rectangle> vector = new Vector<Rectangle>();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            if (graphicsDeviceArray[i].getType() != 0) continue;
            GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[i].getDefaultConfiguration();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            Rectangle rectangle = graphicsConfiguration.getBounds();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            if (SwingUtil.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getUsableBoundsOfAllScreens()", 2339).add("Bounds", rectangle)).log();
            }
            vector.add(rectangle);
        }
        return vector;
    }

    public static Transferable safeGetClipboard(Clipboard clipboard) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "safeGetClipboard(Clipboard)", 2356).addDetail("clipboard", clipboard)).log();
        }
        return SwingUtil.safeGetClipboard(clipboard, 3, 100L);
    }

    public static Transferable safeGetClipboard(Clipboard clipboard, int n, long l) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "safeGetClipboard(Clipboard,int,long)", 2374).addDetail("clipboard", clipboard)).addDetail("retries", n)).addDetail("sleep", l)).log();
        }
        IllegalStateException illegalStateException = null;
        for (int i = 0; i < Math.max(1, n); ++i) {
            try {
                Clipboard clipboard2 = clipboard == null ? Toolkit.getDefaultToolkit().getSystemClipboard() : clipboard;
                return clipboard2.getContents(SwingUtil.class);
            }
            catch (IllegalStateException illegalStateException2) {
                illegalStateException = illegalStateException2;
                Misc.safeSleep(Math.max(1L, l));
                continue;
            }
        }
        if (SwingUtil.logger.level >= 5) {
            ((LevelAwareLogBuilder)logger.lvlBuild(5, "safeGetClipboard(Clipboard,int,long)", 2390).add("caught", illegalStateException)).log();
        }
        return null;
    }

    public static boolean safeSetClipboard(Clipboard clipboard, Transferable transferable, ClipboardOwner clipboardOwner) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "safeSetClipboard(Clipboard,Transferable,ClipboardOwner)", 2406).addDetail("clipboard", clipboard)).addDetail("transferable", transferable)).addDetail("owner", clipboardOwner)).log();
        }
        return SwingUtil.safeSetClipboard(clipboard, transferable, clipboardOwner, 3, 100L);
    }

    public static boolean safeSetClipboard(Clipboard clipboard, Transferable transferable, ClipboardOwner clipboardOwner, int n, long l) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "safeSetClipboard(Clipboard,Transferable,ClipboardOwner,int,long)", 2427).addDetail("clipboard", clipboard)).addDetail("transferable", transferable)).addDetail("owner", clipboardOwner)).addDetail("retries", n)).addDetail("sleep", l)).log();
        }
        IllegalStateException illegalStateException = null;
        for (int i = 0; i < Math.max(1, n); ++i) {
            try {
                Clipboard clipboard2 = clipboard == null ? Toolkit.getDefaultToolkit().getSystemClipboard() : clipboard;
                clipboard2.setContents(transferable, clipboardOwner);
                return true;
            }
            catch (IllegalStateException illegalStateException2) {
                illegalStateException = illegalStateException2;
                Misc.safeSleep(Math.max(1L, l));
                continue;
            }
        }
        if (SwingUtil.logger.level >= 5) {
            ((LevelAwareLogBuilder)logger.lvlBuild(5, "safeSetClipboard(Clipboard,Transferable,ClipboardOwner,int,long)", 2445).add("caught", illegalStateException)).log();
        }
        return false;
    }

    public static synchronized void activateWindowTracking() {
        if (SwingUtil.logger.level >= 7) {
            logger.lvlBuild(7, "activateWindowTracking()", 2459).log();
        }
        if (windowTracker == null) {
            windowTracker = new WindowTracker();
            Toolkit.getDefaultToolkit().addAWTEventListener(windowTracker, 64L);
        }
    }

    public static synchronized void deactivateWindowTracking() {
        if (SwingUtil.logger.level >= 7) {
            logger.lvlBuild(7, "deactivateWindowTracking()", 2474).log();
        }
        if (windowTracker != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(windowTracker);
            windowTracker = null;
        }
    }

    public static Window getLastActiveWindow() {
        if (windowTracker != null) {
            return windowTracker.lastActive;
        }
        return null;
    }

    public static boolean verifyDispatchThread(Logger logger, String string) {
        if (!SwingUtilities.isEventDispatchThread()) {
            if (logger.level >= 1) {
                logger.dumpStack(1, string, "Called from non-dispatch thread");
            }
            return false;
        }
        return true;
    }

    public static double getScreenScalingFactor(Component component) {
        if (Misc.OS_IS_MAC_OS_X) {
            if (component == null) {
                return lastScalingFactor;
            }
            GraphicsConfiguration graphicsConfiguration = component == null ? null : component.getGraphicsConfiguration();
            GraphicsDevice graphicsDevice = graphicsConfiguration == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice() : graphicsConfiguration.getDevice();
            if (lastScalingGraphicsDevice != null && lastScalingGraphicsDevice.get() == graphicsDevice) {
                return lastScalingFactor;
            }
            Object object = Reflector.safeCall(graphicsDevice, "getScaleFactor");
            if (object instanceof Number) {
                lastScalingFactor = ((Number)object).doubleValue();
                lastScalingGraphicsDevice = new WeakReference<GraphicsDevice>(graphicsDevice);
                return lastScalingFactor;
            }
        }
        return 1.0;
    }

    public static GraphicsScaleData getGraphicsScaleData(Component component, Graphics graphics) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getGraphicsScaleData(Component,Graphics)", 2562).addDetail("c", component)).addDetail("g", graphics)).log();
        }
        return new GraphicsScaleData(component, graphics);
    }

    public static int scaledDistance(int n, int n2, double d) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "scaledDistance(int,int,double)", 2573).addDetail("start", n)).addDetail("distance", n2)).addDetail("scale", d)).log();
        }
        return (int)(Math.round((double)(n + n2) * d) - Math.round((double)n * d));
    }

    public static Rectangle scaledRectangle(Rectangle rectangle, double d, double d2) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "scaledRectangle(Rectangle,double,double)", 2585).addDetail("rect", rectangle)).addDetail("scaleX", d)).addDetail("scaleY", d2)).log();
        }
        return new Rectangle((int)Math.round((double)rectangle.x * d), (int)Math.round((double)rectangle.y * d2), SwingUtil.scaledDistance(rectangle.x, rectangle.width, d), SwingUtil.scaledDistance(rectangle.y, rectangle.height, d2));
    }

    public static long getWindowHandle(Component component) {
        block11: {
            if (SwingUtil.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "getWindowHandle(Component)", 2803).addDetail("window", component)).log();
            }
            try {
                Object var1_1 = null;
                while (component != null && var1_1 == null) {
                    if (SwingUtil.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "getWindowHandle(Component)", 2809).add("window", component)).log();
                    }
                    if (component instanceof Window) {
                        var1_1 = AWTAccessor.getComponentAccessor().getPeer(component);
                        if (SwingUtil.logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getWindowHandle(Component)", 2812).add("peer", (Object)var1_1)).log();
                        }
                    }
                    component = component.getParent();
                }
                if (SwingUtil.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "getWindowHandle(Component)", 2816).add("peer", (Object)var1_1)).log();
                }
                if (var1_1 == null) {
                    return 0L;
                }
                String string = Misc.OS_IS_WINDOWS ? "getHWnd" : "getWindow";
                Long l = (Long)Reflector.safeCall(var1_1, string, false);
                if (SwingUtil.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "getWindowHandle(Component)", 2821).add("handle", l)).log();
                }
                if (l != null) {
                    return l;
                }
            }
            catch (Throwable throwable) {
                if (SwingUtil.logger.level < 5) break block11;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "getWindowHandle(Component)", 2826).add("ex", throwable)).log();
            }
        }
        return 0L;
    }

    public static final int getComponentIndex(Component component) {
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getComponentIndex(Component)", 2834).addDetail("component", component)).log();
        }
        if (component != null && component.getParent() != null) {
            Container container = component.getParent();
            for (int i = 0; i < container.getComponentCount(); ++i) {
                if (container.getComponent(i) != component) continue;
                return i;
            }
        }
        return -1;
    }

    public static JMenuItem cloneMenu(JMenuItem jMenuItem, @Nullable Predicate<JMenuItem> predicate) {
        JMenuItem jMenuItem2;
        if (SwingUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "cloneMenu(JMenuItem,Predicate<JMenuItem>)", 2854).addDetail("root", jMenuItem)).addDetail("filter", predicate)).log();
        }
        if (predicate != null && !predicate.test(jMenuItem)) {
            return null;
        }
        if (jMenuItem instanceof JMenu) {
            jMenuItem2 = new JMenu();
            JMenu object = (JMenu)jMenuItem;
            JMenu jMenu = (JMenu)jMenuItem2;
            int n = object.getMenuComponentCount();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                JMenuItem jMenuItem3;
                Component component = object.getMenuComponent(i);
                if (component instanceof JSeparator) {
                    bl = jMenu.getMenuComponentCount() > 0;
                    continue;
                }
                if (!(component instanceof JMenuItem) || (jMenuItem3 = SwingUtil.cloneMenu((JMenuItem)component, predicate)) == null) continue;
                if (bl) {
                    jMenu.add(new JSeparator());
                }
                jMenu.add(jMenuItem3);
                bl = false;
            }
            for (MenuListener menuListener : object.getMenuListeners()) {
                jMenu.addMenuListener(menuListener);
            }
        } else {
            jMenuItem2 = new JMenuItem();
        }
        jMenuItem2.setName(jMenuItem.getName());
        jMenuItem2.setVisible(jMenuItem.isVisible());
        jMenuItem2.setEnabled(jMenuItem.isEnabled());
        jMenuItem2.setText(jMenuItem.getText());
        jMenuItem2.setToolTipText(jMenuItem.getToolTipText());
        jMenuItem2.setMnemonic(jMenuItem2.getMnemonic());
        jMenuItem2.setDisplayedMnemonicIndex(jMenuItem2.getDisplayedMnemonicIndex());
        jMenuItem2.setIcon(jMenuItem.getIcon());
        jMenuItem2.setIconTextGap(jMenuItem.getIconTextGap());
        jMenuItem2.setDisabledIcon(jMenuItem.getDisabledIcon());
        jMenuItem2.setActionCommand(jMenuItem.getActionCommand());
        for (ActionListener actionListener : jMenuItem.getActionListeners()) {
            jMenuItem2.addActionListener(actionListener);
        }
        for (ActionListener actionListener : jMenuItem.getActionListeners()) {
            jMenuItem2.addActionListener(actionListener);
        }
        Action action = jMenuItem.getAction();
        if (action != null) {
            jMenuItem2.setAction(action);
        }
        return jMenuItem2;
    }

    static {
        forwardKeys = new HashSet();
        forwardKeys.add(KeyStroke.getKeyStroke(9, 0));
        forwardKeys.add(KeyStroke.getKeyStroke(9, 2));
        backwardKeys = new HashSet();
        backwardKeys.add(KeyStroke.getKeyStroke(9, 1));
        backwardKeys.add(KeyStroke.getKeyStroke(9, 3));
        if (Misc.IS_JAVA_VERSION_AT_LEAST_9) {
            Reflector.openModule("java.desktop", "sun.awt", SwingUtil.class);
        }
        lastScalingFactor = 1.0;
        executorWithTimeoutMonitor = new Object();
    }

    public static interface ScaledPainter {
        public void paint(Graphics var1, double var2, double var4);
    }

    public static class GraphicsScaleData {
        public Graphics g;
        public Graphics2D g2d;
        final Component c;
        AffineTransform originalTransform;
        private Rectangle scaledClip;
        public double x;
        public double y;

        public GraphicsScaleData(Component component, Graphics graphics) {
            this.c = component;
            this.g = graphics;
        }

        public void scaleToNative() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "GraphicsScaleData.scaleToNative()", 2733).log();
            }
            if (this.g2d != null) {
                return;
            }
            if (this.g instanceof Graphics2D) {
                this.g2d = (Graphics2D)this.g.create();
                double d = Misc.OS_IS_MAC_OS_X && Misc.IS_JAVA_VERSION_AT_LEAST_9 ? 1.0 : SwingUtil.getScreenScalingFactor(this.c);
                this.originalTransform = this.g2d.getTransform();
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "GraphicsScaleData.scaleToNative()", 2742).add("originalTransform", this.originalTransform)).log();
                }
                this.x = Math.abs(this.originalTransform.getScaleX() * d);
                this.y = Math.abs(this.originalTransform.getScaleY() * d);
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "GraphicsScaleData.scaleToNative()", 2745).add("x", this.x)).add("y", this.y)).log();
                }
                Rectangle rectangle = this.g2d.getClipBounds();
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "GraphicsScaleData.scaleToNative()", 2747).add("originalClip", rectangle)).log();
                }
                if (this.x != 1.0 || this.y != 1.0) {
                    this.g2d.scale(1.0 / this.x, 1.0 / this.y);
                    double d2 = this.originalTransform.getTranslateX();
                    d2 -= (double)Math.round(d2 - 0.01);
                    double d3 = this.originalTransform.getTranslateY();
                    d3 -= (double)Math.round(d3 - 0.01);
                    if (d2 != 0.0 || d3 != 0.0) {
                        this.g2d.translate(-d2, -d3);
                    }
                    if (rectangle != null) {
                        this.scaledClip = this.g2d.getClipBounds();
                        Rectangle rectangle2 = SwingUtil.scaledRectangle(rectangle, this.x, this.y);
                        if (!rectangle2.equals(this.scaledClip)) {
                            if (logger.level >= 5) {
                                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "GraphicsScaleData.scaleToNative()", 2764).add("Scaled clip mismatch")).add("originalClip", rectangle)).add("scaledClip", this.scaledClip)).add("scaledOrigClip", rectangle2)).dumpStack();
                            }
                            if (this.g2d.getClip() instanceof Rectangle) {
                                this.g2d.setClip(rectangle2);
                            }
                        }
                    }
                }
            }
        }

        public void revert() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "GraphicsScaleData.revert()", 2774).log();
            }
            if (this.g2d != null) {
                this.g2d.dispose();
                this.g2d = null;
            }
        }

        public void onScaledGraphics(ScaledPainter scaledPainter) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "GraphicsScaleData.onScaledGraphics(ScaledPainter)", 2781).addDetail("painter", scaledPainter)).log();
            }
            try {
                this.scaleToNative();
                scaledPainter.paint(this.g2d == null ? this.g : this.g2d, this.x, this.y);
            }
            finally {
                this.revert();
            }
        }

        @Generated
        public Graphics getG() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "GraphicsScaleData.getG()", 2718).log();
            }
            return this.g;
        }

        @Generated
        public Graphics2D getG2d() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "GraphicsScaleData.getG2d()", 2719).log();
            }
            return this.g2d;
        }

        @Generated
        public Component getC() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "GraphicsScaleData.getC()", 2720).log();
            }
            return this.c;
        }

        @Generated
        public AffineTransform getOriginalTransform() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "GraphicsScaleData.getOriginalTransform()", 2721).log();
            }
            return this.originalTransform;
        }

        @Generated
        public Rectangle getScaledClip() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "GraphicsScaleData.getScaledClip()", 2722).log();
            }
            return this.scaledClip;
        }

        @Generated
        public double getX() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "GraphicsScaleData.getX()", 2723).log();
            }
            return this.x;
        }

        @Generated
        public double getY() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "GraphicsScaleData.getY()", 2724).log();
            }
            return this.y;
        }

        @Generated
        public GraphicsScaleData setG(Graphics graphics) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "GraphicsScaleData.setG(Graphics)", 2716).addDetail("g", graphics)).log();
            }
            this.g = graphics;
            return this;
        }

        @Generated
        public GraphicsScaleData setG2d(Graphics2D graphics2D) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "GraphicsScaleData.setG2d(Graphics2D)", 2716).addDetail("g2d", graphics2D)).log();
            }
            this.g2d = graphics2D;
            return this;
        }

        @Generated
        public GraphicsScaleData setOriginalTransform(AffineTransform affineTransform) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "GraphicsScaleData.setOriginalTransform(AffineTransform)", 2716).addDetail("originalTransform", affineTransform)).log();
            }
            this.originalTransform = affineTransform;
            return this;
        }

        @Generated
        public GraphicsScaleData setScaledClip(Rectangle rectangle) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "GraphicsScaleData.setScaledClip(Rectangle)", 2716).addDetail("scaledClip", rectangle)).log();
            }
            this.scaledClip = rectangle;
            return this;
        }

        @Generated
        public GraphicsScaleData setX(double d) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "GraphicsScaleData.setX(double)", 2716).addDetail("x", d)).log();
            }
            this.x = d;
            return this;
        }

        @Generated
        public GraphicsScaleData setY(double d) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "GraphicsScaleData.setY(double)", 2716).addDetail("y", d)).log();
            }
            this.y = d;
            return this;
        }

        @Generated
        public boolean equals(Object object) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "GraphicsScaleData.equals(Object)", 2716).addDetail("o", object)).log();
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof GraphicsScaleData)) {
                return false;
            }
            GraphicsScaleData graphicsScaleData = (GraphicsScaleData)object;
            if (!graphicsScaleData.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getX(), graphicsScaleData.getX()) != 0) {
                return false;
            }
            if (Double.compare(this.getY(), graphicsScaleData.getY()) != 0) {
                return false;
            }
            Graphics graphics = this.getG();
            Graphics graphics2 = graphicsScaleData.getG();
            if (graphics == null ? graphics2 != null : !graphics.equals(graphics2)) {
                return false;
            }
            Graphics2D graphics2D = this.getG2d();
            Graphics2D graphics2D2 = graphicsScaleData.getG2d();
            if (graphics2D == null ? graphics2D2 != null : !graphics2D.equals(graphics2D2)) {
                return false;
            }
            Component component = this.getC();
            Component component2 = graphicsScaleData.getC();
            if (component == null ? component2 != null : !component.equals(component2)) {
                return false;
            }
            AffineTransform affineTransform = this.getOriginalTransform();
            AffineTransform affineTransform2 = graphicsScaleData.getOriginalTransform();
            if (affineTransform == null ? affineTransform2 != null : !((Object)affineTransform).equals(affineTransform2)) {
                return false;
            }
            Rectangle rectangle = this.getScaledClip();
            Rectangle rectangle2 = graphicsScaleData.getScaledClip();
            return !(rectangle == null ? rectangle2 != null : !((Object)rectangle).equals(rectangle2));
        }

        @Generated
        protected boolean canEqual(Object object) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "GraphicsScaleData.canEqual(Object)", 2716).addDetail("other", object)).log();
            }
            return object instanceof GraphicsScaleData;
        }

        @Generated
        public int hashCode() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "GraphicsScaleData.hashCode()", 2716).log();
            }
            int n = 1;
            long l = Double.doubleToLongBits(this.getX());
            n = n * 59 + (int)(l >>> 32 ^ l);
            long l2 = Double.doubleToLongBits(this.getY());
            n = n * 59 + (int)(l2 >>> 32 ^ l2);
            Graphics graphics = this.getG();
            n = n * 59 + (graphics == null ? 43 : graphics.hashCode());
            Graphics2D graphics2D = this.getG2d();
            n = n * 59 + (graphics2D == null ? 43 : graphics2D.hashCode());
            Component component = this.getC();
            n = n * 59 + (component == null ? 43 : component.hashCode());
            AffineTransform affineTransform = this.getOriginalTransform();
            n = n * 59 + (affineTransform == null ? 43 : ((Object)affineTransform).hashCode());
            Rectangle rectangle = this.getScaledClip();
            n = n * 59 + (rectangle == null ? 43 : ((Object)rectangle).hashCode());
            return n;
        }

        @Generated
        public String toString() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "GraphicsScaleData.toString()", 2716).log();
            }
            return "SwingUtil.GraphicsScaleData(g=" + this.getG() + ", g2d=" + this.getG2d() + ", c=" + this.getC() + ", originalTransform=" + this.getOriginalTransform() + ", scaledClip=" + this.getScaledClip() + ", x=" + this.getX() + ", y=" + this.getY() + ")";
        }
    }

    private static class WindowTracker
    implements AWTEventListener {
        private Window lastActive;

        private WindowTracker() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "WindowTracker.WindowTracker()", 2663).log();
            }
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "WindowTracker.eventDispatched(AWTEvent)", 2686).addDetail("e", aWTEvent)).log();
            }
            if (aWTEvent.getID() == 205) {
                this.lastActive = (Window)aWTEvent.getSource();
            }
        }
    }

    public static class FocusDisabler {
        public void visit(Object object) {
        }

        public void visit(JScrollPane jScrollPane) {
            Reflector.safeCall((Object)jScrollPane.getHorizontalScrollBar(), "setFocusable", new Class[]{Boolean.TYPE}, new Object[]{Boolean.FALSE});
            Reflector.safeCall((Object)jScrollPane.getVerticalScrollBar(), "setFocusable", new Class[]{Boolean.TYPE}, new Object[]{Boolean.FALSE});
        }
    }

    public static class CursorSetter
    implements TraversalCallback {
        private ArrayList<Pair<Component, Cursor>> list;
        private Component[] exceptions;
        private boolean dontShowOnModalDialogs;

        public CursorSetter(ArrayList<Pair<Component, Cursor>> arrayList, Component[] componentArray, boolean bl) {
            this.list = arrayList;
            this.exceptions = componentArray;
            this.dontShowOnModalDialogs = bl;
        }

        @Override
        public boolean nodeEntered(Traversal traversal) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "CursorSetter.nodeEntered(Traversal)", 1130).addDetail("traversal", traversal)).log();
            }
            Component component = (Component)traversal.getNode();
            if (this.exceptions != null) {
                for (Component component2 : this.exceptions) {
                    if (component != component2) continue;
                    return false;
                }
            }
            return !this.dontShowOnModalDialogs || !(component instanceof JDialog) || !((JDialog)component).isModal();
        }

        @Override
        public void nodeExited(Traversal traversal) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "CursorSetter.nodeExited(Traversal)", 1161).addDetail("traversal", traversal)).log();
            }
            Component component = (Component)traversal.getNode();
            Cursor cursor = component.getCursor();
            if (this.exceptions != null) {
                for (Component component2 : this.exceptions) {
                    if (component != component2) continue;
                    this.list.add(new Pair<Component, Cursor>(component, cursor));
                    component.setCursor(DEFAULT_CURSOR);
                    return;
                }
            }
            if (this.dontShowOnModalDialogs && component instanceof ModalDialog && ((JDialog)component).isModal()) {
                this.list.add(new Pair<Component, Cursor>(component, cursor));
                component.setCursor(DEFAULT_CURSOR);
                return;
            }
            if (cursor != WAIT_CURSOR) {
                this.list.add(new Pair<Component, Cursor>(component, cursor));
                component.setCursor(WAIT_CURSOR);
            }
        }
    }

    private static class EventLock {
        private boolean locked;

        public EventLock() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "EventLock.EventLock()", 1039).log();
            }
        }

        public final synchronized boolean isLocked() {
            return this.locked;
        }

        public final synchronized void setLocked(boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "EventLock.setLocked(boolean)", 1066).addDetail("locked", bl)).log();
            }
            this.locked = bl;
            this.notifyAll();
        }
    }

    private static class DoneEvent
    extends AWTEvent
    implements ActiveEvent {
        private static Label dummy = new Label();
        private EventLock lock;

        public DoneEvent(EventLock eventLock) {
            super(dummy, 1999);
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "DoneEvent.DoneEvent(EventLock)", 994).addDetail("lock", eventLock)).log();
            }
            this.lock = eventLock;
        }

        @Override
        public String toString() {
            return "DoneEvent[lock=" + this.lock + "]";
        }

        @Override
        public void dispatch() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "DoneEvent.dispatch()", 1011).log();
            }
            this.lock.setLocked(false);
        }
    }

    public static interface UnsafeRunnable {
        public Object run() throws Exception;
    }
}

