/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.gui.SwingUtilRunnerThread;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import lombok.Generated;

public class SwingUtilExceptionHolder {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.SwingUtilExceptionHolder");
    protected static SwingUtilExceptionHolder exceptionHolder = new SwingUtilExceptionHolder();
    private static final Object classLock = new Object();
    private ArrayList<Component> exceptions = new ArrayList();
    private Stack<SwingUtilRunnerThread> threads = new Stack();

    protected SwingUtilExceptionHolder() {
        if (SwingUtilExceptionHolder.logger.level >= 7) {
            logger.lvlBuild(7, "SwingUtilExceptionHolder()", 87).log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SwingUtilExceptionHolder getInstance() {
        if (SwingUtilExceptionHolder.logger.level >= 7) {
            logger.lvlBuild(7, "getInstance()", 103).log();
        }
        Object object = classLock;
        synchronized (object) {
            if (exceptionHolder != null) {
                return exceptionHolder;
            }
        }
        return new SwingUtilExceptionHolder();
    }

    public Component[] getAndRegisterExceptions(Component[] componentArray) {
        if (SwingUtilExceptionHolder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getAndRegisterExceptions(Component[])", 122).addDetail("new_exceptions", componentArray)).log();
        }
        if (componentArray == null || componentArray.length == 0) {
            return this.getExceptions();
        }
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        this.exceptions.addAll(Arrays.asList(componentArray));
        return this.getExceptions();
    }

    public Component[] getExceptions() {
        if (SwingUtilExceptionHolder.logger.level >= 7) {
            logger.lvlBuild(7, "getExceptions()", 144).log();
        }
        if (this.exceptions == null) {
            return null;
        }
        return this.exceptions.toArray(new Component[this.exceptions.size()]);
    }

    public void removeExceptions(Component[] componentArray) {
        if (SwingUtilExceptionHolder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeExceptions(Component[])", 161).addDetail("remove_exceptions", componentArray)).log();
        }
        if (this.exceptions != null && componentArray != null) {
            this.exceptions.removeAll(Arrays.asList(componentArray));
        }
    }

    public void addThread(SwingUtilRunnerThread swingUtilRunnerThread) {
        if (SwingUtilExceptionHolder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addThread(SwingUtilRunnerThread)", 176).addDetail("t", swingUtilRunnerThread)).log();
        }
        this.threads.add(swingUtilRunnerThread);
    }

    public void removeThread(SwingUtilRunnerThread swingUtilRunnerThread) {
        if (SwingUtilExceptionHolder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeThread(SwingUtilRunnerThread)", 189).addDetail("t", swingUtilRunnerThread)).log();
        }
        if (swingUtilRunnerThread != null) {
            this.threads.remove(swingUtilRunnerThread);
        }
    }

    public void interrupt() {
        if (SwingUtilExceptionHolder.logger.level >= 7) {
            logger.lvlBuild(7, "interrupt()", 202).log();
        }
        SwingUtilRunnerThread swingUtilRunnerThread = null;
        do {
            swingUtilRunnerThread = this.threads.pop();
            try {
                if (SwingUtilExceptionHolder.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "interrupt()", 208).add("Interrupt Thread:")).add("st", swingUtilRunnerThread)).log();
                }
                swingUtilRunnerThread.setRunning(false);
                swingUtilRunnerThread.interrupt();
            }
            catch (Exception exception) {
                if (SwingUtilExceptionHolder.logger.level < 3) continue;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "interrupt()", 212).add("Exception on interrupting thread")).add("e", exception)).log();
            }
        } while (!this.threads.isEmpty());
    }
}

