/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.notifications.DefaultNotificationCenter;
import de.qfs.lib.notifications.NotificationName;
import de.qfs.lib.notifications.Notifier;
import de.qfs.lib.notifications.Observer;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.edit.OptionEdit;
import java.util.function.Function;
import java.util.regex.Matcher;
import javax.swing.UIManager;
import lombok.Generated;

public abstract class ThemeSupport {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.ThemeSupport");
    static String themeName;
    static boolean darkTheme;
    static String themeSuffix;
    static double fontScale;
    static Observer themeChangeObserver;

    public ThemeSupport() {
        if (ThemeSupport.logger.level >= 7) {
            logger.lvlBuild(7, "ThemeSupport.ThemeSupport()", 31).log();
        }
    }

    public static void init() {
        if (ThemeSupport.logger.level >= 7) {
            logger.lvlBuild(7, "init()", 73).log();
        }
        DefaultNotificationCenter.instance().addWeakObserver(themeChangeObserver, "user.theme.changed", null);
        DefaultNotificationCenter.instance().addWeakObserver(themeChangeObserver, "user.theme.initialized", null);
    }

    public static String extendHtmlWrapping(String string, String string2) {
        if (ThemeSupport.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "extendHtmlWrapping(String,String)", 96).addDetail("resourceName", string)).addDetail("value", string2)).log();
        }
        if (string2 == null) {
            return null;
        }
        boolean bl = "text/html".equals(Option.getResources().getString(string + ".type", "text/plain"));
        if (string2.startsWith("<html>")) {
            bl = true;
            string2 = string2.substring(6);
        }
        if (!bl) {
            return string2;
        }
        if (string2.endsWith("</html>")) {
            string2 = string2.substring(0, string2.length() - 7);
        }
        return ThemeSupport.prefixHtml(string, "default", string2);
    }

    public static String prefixHtml(String string, String string2) {
        if (ThemeSupport.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "prefixHtml(String,String)", 116).addDetail("resourceName", string)).addDetail("body", string2)).log();
        }
        return ThemeSupport.prefixHtml(string, "default", string2);
    }

    public static String prefixHtml(String string, String string2, String string3) {
        Object object;
        if (ThemeSupport.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "prefixHtml(String,String,String)", 124).addDetail("resourceName", string)).addDetail("defaultCssClass", string2)).addDetail("body", string3)).log();
        }
        if (string3 == null || string3.startsWith("<html")) {
            return string3;
        }
        String string4 = ThemeSupport.getCssClass(string, string2);
        boolean bl = string3.startsWith("<body");
        if (bl) {
            object = OptionEdit.BODY_CLASS_PATTERN.matcher(string3);
            if (((Matcher)object).matches()) {
                string4 = ((Matcher)object).group(1);
            } else {
                string3 = "<body class='" + string4 + "'" + string3.substring(5);
            }
        }
        object = ThemeSupport.getCss("." + string4);
        return "<html><head><style type=\"text/css\">" + (String)object + "</style></head>" + (bl ? "" : "<body class='" + string4 + "'>") + string3 + (bl ? "" : "</body>") + "</html>";
    }

    protected static String getCssClass(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return Option.getResources().getString(string + ".css", string2);
    }

    public static String getCss(String string) {
        Function function;
        if (ThemeSupport.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getCss(String)", 166).addDetail("prefix", string)).log();
        }
        String string2 = (function = (Function)UIManager.get("css:factory")) == null ? "" : (String)function.apply(string);
        return string2;
    }

    @Generated
    public static String getThemeName() {
        if (ThemeSupport.logger.level >= 7) {
            logger.lvlBuild(7, "getThemeName()", 44).log();
        }
        return themeName;
    }

    @Generated
    public static boolean isDarkTheme() {
        if (ThemeSupport.logger.level >= 7) {
            logger.lvlBuild(7, "isDarkTheme()", 49).log();
        }
        return darkTheme;
    }

    @Generated
    public static String getThemeSuffix() {
        if (ThemeSupport.logger.level >= 7) {
            logger.lvlBuild(7, "getThemeSuffix()", 54).log();
        }
        return themeSuffix;
    }

    @Generated
    public static double getFontScale() {
        if (ThemeSupport.logger.level >= 7) {
            logger.lvlBuild(7, "getFontScale()", 59).log();
        }
        return fontScale;
    }

    @Generated
    public static void setFontScale(double d) {
        if (ThemeSupport.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setFontScale(double)", 59).addDetail("fontScale", d)).log();
        }
        fontScale = d;
    }

    static {
        fontScale = 1.0;
        themeChangeObserver = notification -> {
            themeName = (String)notification.getUserInfo().get("theme");
            darkTheme = (Boolean)notification.getUserInfo().get("isDarkTheme");
            themeSuffix = (String)notification.getUserInfo().get("suffix");
        };
    }

    public static interface Reusable {
        public boolean isReusable();
    }

    public static class Notifications {
        public static final Notifier NOTIFIER = Notifier.instance("user.theme");
        public static final int POST_LEVEL = 1;
        @NotificationName
        public static final String INITIALIZED = "user.theme.initialized";
        @NotificationName
        public static final String WILL_CHANGE = "user.theme.willChange";
        @NotificationName
        public static final String CHANGED = "user.theme.changed";
        @NotificationName
        public static final String UPDATED_UI = "user.theme.updatedUI";

        public Notifications() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Notifications.Notifications()", 36).log();
            }
        }
    }
}

