/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

public class WholeRowFocusRenderer
extends DefaultTableCellRenderer
implements Border,
FocusListener {
    private static final Insets insets = new Insets(1, 1, 1, 1);
    private static Icon stippleIcon;
    private boolean hasFocus;
    private Icon icon;
    private int iconWidth;
    private int iconHeight;
    private int xOffset;
    private Color borderColor;
    private Color userBorderColor;
    boolean left;
    boolean right;

    public WholeRowFocusRenderer() {
        if (UIManager.getLookAndFeel().getID().indexOf("Windows") > 0) {
            this.setStippleBorder();
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        int n3 = jTable.getSelectionModel().getAnchorSelectionIndex();
        this.hasFocus = n == n3 && jTable.hasFocus();
        JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        jLabel.setBorder(this);
        this.left = n2 == 0;
        boolean bl3 = this.right = n2 == jTable.getColumnCount() - 1;
        if (this.hasFocus) {
            if (this.icon != null) {
                this.xOffset = jTable.getCellRect((int)n, (int)n2, (boolean)true).x % this.iconWidth;
            } else if (this.userBorderColor == null) {
                this.borderColor = bl ? jTable.getSelectionForeground() : this.getForeground();
            }
        }
        return jLabel;
    }

    public void setBorderColor(Color color) {
        this.userBorderColor = color;
        if (color != null) {
            this.borderColor = color;
            this.icon = null;
        }
    }

    public void setStippleBorder() {
        if (stippleIcon == null) {
            stippleIcon = new ImageIcon(this.getClass().getResource("/de/qfs/lib/resources/icons/stipple.gif"));
        }
        this.setBorderIcon(stippleIcon);
    }

    public void setBorderIcon(Icon icon) {
        this.icon = icon;
        if (icon != null) {
            this.iconWidth = icon.getIconWidth();
            this.iconHeight = icon.getIconHeight();
            if (this.iconWidth <= 0 || this.iconHeight <= 0) {
                this.icon = null;
            } else {
                this.userBorderColor = null;
            }
        }
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (!this.hasFocus) {
            return;
        }
        if (this.icon != null) {
            int n5 = 0;
            int n6 = 0;
            Graphics graphics2 = graphics.create();
            graphics.translate(n, n2);
            graphics2.setClip(0, 0, n3, 1);
            for (n5 = -this.xOffset; n5 < n3; n5 += this.iconWidth) {
                this.icon.paintIcon(component, graphics2, n5, 0);
            }
            graphics2.setClip(0, n4 - 1, n3, 1);
            n6 = n4 - 1 - (n4 - 1) % this.iconHeight;
            for (n5 = -this.xOffset; n5 < n3; n5 += this.iconWidth) {
                this.icon.paintIcon(component, graphics2, n5, n6);
            }
            if (this.left) {
                graphics2.setClip(0, 1, 1, n4 - 2);
                for (n6 = 0; n6 < n4; n6 += this.iconHeight) {
                    this.icon.paintIcon(component, graphics2, -this.xOffset, n6);
                }
            }
            if (this.right) {
                graphics2.setClip(n3 - 1, 1, 1, n4 - 2);
                n5 = n3 - 1 - (n3 - 1 - this.xOffset) % this.iconWidth;
                for (n6 = 0; n6 < n4; n6 += this.iconHeight) {
                    this.icon.paintIcon(component, graphics2, n5, n6);
                }
            }
            graphics2.dispose();
            graphics.translate(-n, -n2);
        } else {
            graphics.setColor(this.borderColor);
            graphics.drawLine(n, n2, n + n3 - 1, n2);
            graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            if (this.left) {
                graphics.drawLine(n, n2, n, n2 + n4 - 1);
            }
            if (this.right) {
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof JTable) {
            this.repaintFocusRow((JTable)focusEvent.getSource());
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof JTable) {
            this.repaintFocusRow((JTable)focusEvent.getSource());
        }
    }

    private void repaintFocusRow(JTable jTable) {
        int n = jTable.getSelectionModel().getAnchorSelectionIndex();
        if (n < 0) {
            return;
        }
        Rectangle rectangle = jTable.getCellRect(n, 0, true);
        Rectangle rectangle2 = jTable.getCellRect(n, jTable.getColumnCount() - 1, true);
        jTable.repaint(rectangle.x, rectangle.y, rectangle2.x - rectangle.x + rectangle2.width, rectangle2.height);
    }
}

