/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui.toolbar;

import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.notifications.DefaultNotificationCenter;
import de.qfs.lib.notifications.NotificationName;
import de.qfs.lib.notifications.Notifier;
import de.qfs.lib.notifications.Observer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import lombok.Generated;

public class ToolbarItemDragHelper {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.toolbar.ToolbarItemDragHelper");
    public static final int EXTRA_MOVE_DISTANCE = 10;
    public static final int MIN_PRESS_MS = 250;
    private Component component;
    private int startScreenXY = 0;
    private int startLocalXY = 0;
    private int startIndex;
    private Orientation orientation;
    private Placeholder placeholder;
    private Dimension compSize;
    private Dimension minimumSize;
    private Dimension maximumSize;
    private boolean moving = false;
    private long downStartTimestamp;
    private Rectangle startingBounds;
    private Observer cancelMoveListener = notification -> this.resetMove();
    private boolean canceled = false;

    private ToolbarItemDragHelper(final Component component, final Orientation orientation) {
        if (ToolbarItemDragHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ToolbarItemDragHelper(Component,Orientation)", 115).addDetail("component", component)).addDetail("orientation", (Object)orientation)).log();
        }
        this.component = component;
        this.orientation = orientation;
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Point point;
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "ToolbarItemDragHelper(Component,Orientation).MouseAdapter.mousePressed(MouseEvent)", 122).addDetail("e", mouseEvent)).log();
                }
                try {
                    point = component.getLocationOnScreen();
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "ToolbarItemDragHelper(Component,Orientation).MouseAdapter.mousePressed(MouseEvent)", 128).add("Mouse pressed on a not showing component", component)).log();
                    }
                    return;
                }
                ToolbarItemDragHelper.this.startScreenXY = orientation == Orientation.HORIZONTAL ? mouseEvent.getXOnScreen() : mouseEvent.getYOnScreen();
                ToolbarItemDragHelper.this.startLocalXY = orientation == Orientation.HORIZONTAL ? component.getX() : component.getY();
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "ToolbarItemDragHelper(Component,Orientation).MouseAdapter.mousePressed(MouseEvent)", 133).add("Set startLocalXY: ")).add(ToolbarItemDragHelper.this.startLocalXY)).log();
                }
                ToolbarItemDragHelper.this.downStartTimestamp = System.currentTimeMillis();
                ToolbarItemDragHelper.this.canceled = false;
                ToolbarItemDragHelper.this.startIndex = SwingUtil.getComponentIndex(component);
                ToolbarItemDragHelper.this.startingBounds = component.getBounds();
                Dimension dimension = ToolbarItemDragHelper.this.startingBounds.getSize();
                ToolbarItemDragHelper.this.startingBounds.setLocation(point.x - 10, point.y - 10);
                ToolbarItemDragHelper.this.startingBounds.setSize(dimension.width + 20, dimension.height + 20);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "ToolbarItemDragHelper(Component,Orientation).MouseAdapter.mouseReleased(MouseEvent)", 146).addDetail("e", mouseEvent)).log();
                }
                ToolbarItemDragHelper.this.canceled = false;
                ToolbarItemDragHelper.this.stopMove();
            }
        });
        component.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "ToolbarItemDragHelper(Component,Orientation).MouseMotionAdapter.mouseDragged(MouseEvent)", 154).addDetail("e", mouseEvent)).log();
                }
                if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    return;
                }
                int n = mouseEvent.getXOnScreen();
                int n2 = mouseEvent.getYOnScreen();
                int n3 = (orientation == Orientation.HORIZONTAL ? n : n2) - ToolbarItemDragHelper.this.startScreenXY;
                if (!ToolbarItemDragHelper.this.moving && !ToolbarItemDragHelper.this.canceled && System.currentTimeMillis() - ToolbarItemDragHelper.this.downStartTimestamp > 250L) {
                    if (ToolbarItemDragHelper.this.startingBounds != null && ToolbarItemDragHelper.this.startingBounds.contains(n, n2)) {
                        if (component instanceof AbstractButton) {
                            ((AbstractButton)component).getModel().setArmed(false);
                        }
                        ToolbarItemDragHelper.this.startMove();
                    }
                    ToolbarItemDragHelper.this.startingBounds = null;
                }
                if (ToolbarItemDragHelper.this.moving && !ToolbarItemDragHelper.this.canceled) {
                    if (orientation == Orientation.HORIZONTAL) {
                        component.setLocation(ToolbarItemDragHelper.this.startLocalXY + n3, component.getLocation().y);
                    } else {
                        component.setLocation(component.getLocation().x, ToolbarItemDragHelper.this.startLocalXY + n3);
                    }
                    if (ToolbarItemDragHelper.this.moveButtons(false)) {
                        SwingUtilities.invokeLater(() -> {
                            if (orientation == Orientation.HORIZONTAL) {
                                component.setLocation(ToolbarItemDragHelper.this.startLocalXY + n3, component2.getLocation().y);
                            } else {
                                component.setLocation(component2.getLocation().x, ToolbarItemDragHelper.this.startLocalXY + n3);
                            }
                            component.setSize(ToolbarItemDragHelper.this.compSize);
                            component.setMinimumSize(ToolbarItemDragHelper.this.minimumSize);
                            component.setMaximumSize(ToolbarItemDragHelper.this.maximumSize);
                        });
                    }
                }
            }
        });
        DefaultNotificationCenter.instance().addWeakObserver(this.cancelMoveListener, "de.qfs.lib.gui.toolbar.ToolbarItemDragHelper.ToolbarItemDrag.Cancel Move");
    }

    protected void startMove() {
        if (ToolbarItemDragHelper.logger.level >= 7) {
            logger.lvlBuild(7, "startMove()", 204).log();
        }
        this.moving = true;
        this.compSize = this.component.getSize();
        this.minimumSize = this.component.getMinimumSize();
        this.maximumSize = this.component.getMaximumSize();
        Container container = this.component.getParent();
        this.placeholder = new Placeholder(this.component);
        container.add(this.placeholder);
        container.setComponentZOrder(this.placeholder, container.getComponentZOrder(this.component));
        container.setComponentZOrder(this.component, 0);
        if (ToolbarItemDrag.NOTIFIER.level >= 1) {
            ToolbarItemDrag.NOTIFIER.postNotification(1, "de.qfs.lib.gui.toolbar.ToolbarItemDragHelper.ToolbarItemDrag.Toolbar Button Drag started", (Object)container, "component", this.component);
        }
    }

    protected void stopMove() {
        if (ToolbarItemDragHelper.logger.level >= 7) {
            logger.lvlBuild(7, "stopMove()", 223).log();
        }
        if (!this.moving) {
            return;
        }
        Container container = this.component.getParent();
        if (ToolbarItemDrag.NOTIFIER.level >= 1) {
            ToolbarItemDrag.NOTIFIER.postNotification(1, "de.qfs.lib.gui.toolbar.ToolbarItemDragHelper.ToolbarItemDrag.Toolbar Button Drag stopped", (Object)container, "component", this.component);
        }
        this.moveButtons(true);
        int n = container.getComponentZOrder(this.placeholder);
        container.setComponentZOrder(this.component, n);
        this.component.setSize(this.compSize);
        this.component.setMinimumSize(this.minimumSize);
        this.component.setMaximumSize(this.maximumSize);
        this.component.setLocation(this.placeholder.getLocation());
        container.remove(this.placeholder);
        this.placeholder = null;
        container.revalidate();
        container.repaint();
        this.downStartTimestamp = 0L;
        this.moving = false;
        if (ToolbarItemDrag.NOTIFIER.level >= 1) {
            ToolbarItemDrag.NOTIFIER.postNotification(1, "de.qfs.lib.gui.toolbar.ToolbarItemDragHelper.ToolbarItemDrag.Toolbar Buttons reordered", (Object)container, "component", this.component, "index", n);
        }
    }

    private void resetMove() {
        if (ToolbarItemDragHelper.logger.level >= 7) {
            logger.lvlBuild(7, "resetMove()", 254).log();
        }
        if (!this.moving) {
            return;
        }
        this.canceled = true;
        Container container = this.component.getParent();
        int n = this.startIndex + 1;
        int n2 = SwingUtil.getComponentIndex(this.placeholder);
        if (n != n2) {
            int n3 = n < n2 ? -1 : 1;
            int n4 = Math.min(n, n2);
            int n5 = Math.max(n, n2);
            Point point = container.getComponent(n4).getLocation();
            int n6 = point.x;
            int n7 = point.y;
            for (int i = n4; i <= n5; ++i) {
                Component component = i == n ? this.placeholder : container.getComponent(i + n3);
                component.setLocation(n6, n7);
                if (this.orientation == Orientation.HORIZONTAL) {
                    n6 += component.getWidth();
                    continue;
                }
                n7 += component.getHeight();
            }
            this.component.setLocation(this.placeholder.getLocation());
        }
        this.stopMove();
    }

    protected boolean moveButtons(boolean bl) {
        if (ToolbarItemDragHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "moveButtons(boolean)", 294).addDetail("forceRepaint", bl)).log();
        }
        Container container = this.component.getParent();
        Component[] componentArray = container.getComponents();
        Arrays.sort(componentArray, new Comparator<Component>(){

            @Override
            public int compare(Component component, Component component2) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "moveButtons(boolean).Comparator<Component>.compare(Component,Component)", 301).addDetail("o1", component)).addDetail("o2", component2)).log();
                }
                if (component == ToolbarItemDragHelper.this.component) {
                    return -1;
                }
                if (component2 == ToolbarItemDragHelper.this.component) {
                    return 1;
                }
                if (component == ToolbarItemDragHelper.this.placeholder) {
                    component = ToolbarItemDragHelper.this.component;
                }
                if (component2 == ToolbarItemDragHelper.this.placeholder) {
                    component2 = ToolbarItemDragHelper.this.component;
                }
                return ToolbarItemDragHelper.this.orientation == Orientation.HORIZONTAL ? component.getLocation().x + component.getSize().width / 2 - (component2.getLocation().x + component2.getSize().width / 2) : component.getLocation().y + component.getSize().height / 2 - (component2.getLocation().y + component2.getSize().height / 2);
            }
        });
        boolean bl2 = false;
        int n = 0;
        for (Component component : componentArray) {
            if (component != this.component) {
                assert (n > 0);
                if (!bl2 && (bl || container.getComponent(n) != component)) {
                    bl2 = true;
                    Dimension dimension = this.orientation == Orientation.HORIZONTAL ? new Dimension(0, this.compSize.height) : new Dimension(this.compSize.width, 0);
                    this.component.setSize(dimension);
                    this.component.setMinimumSize(dimension);
                    this.component.setMaximumSize(dimension);
                }
                if (bl2) {
                    container.setComponentZOrder(component, n);
                }
            }
            ++n;
        }
        if (bl2) {
            container.revalidate();
            container.repaint();
        }
        return bl2;
    }

    public boolean isMoving() {
        if (ToolbarItemDragHelper.logger.level >= 7) {
            logger.lvlBuild(7, "isMoving()", 351).log();
        }
        return this.moving;
    }

    public static final <T extends Component> T makeDraggable(T t) {
        if (ToolbarItemDragHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "makeDraggable(T)", 362).addDetail("component", t)).log();
        }
        ToolbarItemDragHelper.attachDragHelper(t);
        return t;
    }

    private static final ToolbarItemDragHelper attachDragHelper(Component component) {
        if (ToolbarItemDragHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "attachDragHelper(Component)", 373).addDetail("component", component)).log();
        }
        Orientation orientation = Orientation.HORIZONTAL;
        return new ToolbarItemDragHelper(component, orientation);
    }

    public static class Placeholder
    extends JComponent {
        public Placeholder(Component component) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Placeholder.Placeholder(Component)", 78).addDetail("original", component)).log();
            }
            this.setBorder(new LineBorder(Color.DARK_GRAY, 3));
            this.setLocation(component.getLocation());
            Dimension dimension = component.getSize();
            this.setSize(dimension);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
        }
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;


        private Orientation() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Orientation.Orientation()", 68).log();
            }
        }
    }

    public static class ToolbarItemDrag {
        public static final Notifier NOTIFIER = Notifier.instance("de.qfs.lib.gui.toolbar.ToolbarItemDragHelper.ToolbarItemDrag");
        public static final int POST_LEVEL = 1;
        @NotificationName
        public static final String TOOLBAR_BUTTONS_REORDERED = "de.qfs.lib.gui.toolbar.ToolbarItemDragHelper.ToolbarItemDrag.Toolbar Buttons reordered";
        @NotificationName
        public static final String TOOLBAR_BUTTON_DRAG_STARTED = "de.qfs.lib.gui.toolbar.ToolbarItemDragHelper.ToolbarItemDrag.Toolbar Button Drag started";
        @NotificationName
        public static final String TOOLBAR_BUTTON_DRAG_STOPPED = "de.qfs.lib.gui.toolbar.ToolbarItemDragHelper.ToolbarItemDrag.Toolbar Button Drag stopped";
        @NotificationName
        public static final String CANCEL_MOVE = "de.qfs.lib.gui.toolbar.ToolbarItemDragHelper.ToolbarItemDrag.Cancel Move";

        public ToolbarItemDrag() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ToolbarItemDrag.ToolbarItemDrag()", 66).log();
            }
        }
    }
}

