/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui.tree;

import de.qfs.lib.gui.tree.TreeModelFilter;
import de.qfs.lib.gui.tree.TreeModelFilterEvent;
import de.qfs.lib.gui.tree.TreeModelFilterListener;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;

public abstract class AbstractTreeModelFilter
implements TreeModelFilter {
    private boolean active = false;
    private final FilterType type;
    private CopyOnWriteArrayList<TreeModelFilterListener> listeners = new CopyOnWriteArrayList();

    protected AbstractTreeModelFilter(FilterType filterType) {
        this.type = filterType;
    }

    public boolean isFlatFilter() {
        return this.type == FilterType.FLAT;
    }

    public boolean isHierarchyFilter() {
        return this.type == FilterType.HIERARCHY;
    }

    @Override
    public void addTreeModelFilterListener(TreeModelFilterListener treeModelFilterListener) {
        this.listeners.add(treeModelFilterListener);
    }

    @Override
    public void removeTreeModelFilterListener(TreeModelFilterListener treeModelFilterListener) {
        this.listeners.remove(treeModelFilterListener);
    }

    public void fireFilterChanged() {
        TreeModelFilterEvent treeModelFilterEvent = new TreeModelFilterEvent(this);
        for (TreeModelFilterListener treeModelFilterListener : this.listeners) {
            treeModelFilterListener.filterChanged(treeModelFilterEvent);
        }
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    protected AbstractTreeModelFilter setActive(boolean bl) {
        this.active = bl;
        return this;
    }

    @Generated
    public FilterType getType() {
        return this.type;
    }

    @Generated
    public CopyOnWriteArrayList<TreeModelFilterListener> getListeners() {
        return this.listeners;
    }

    public static enum FilterType {
        FLAT,
        HIERARCHY;

    }
}

