/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui.tree;

import de.qfs.lib.gui.tree.AbstractTreeFilterTraversal;
import de.qfs.lib.gui.tree.AbstractTreeModelFilter;
import de.qfs.lib.gui.tree.FilteredTreeModel;
import de.qfs.lib.gui.tree.FilteredTreeModelAdapter;
import de.qfs.lib.gui.tree.flatfilter.DefaultFlatTreeNodeRenderer;
import de.qfs.lib.gui.tree.flatfilter.FlatTreeFilterTraversal;
import de.qfs.lib.gui.tree.flatfilter.FlatTreeModelAdapter;
import de.qfs.lib.gui.tree.hierarchyfilter.HierarchicalTreeFilterTraversal;
import de.qfs.lib.gui.tree.hierarchyfilter.HierarchicalTreeModelAdapter;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.tree.TreeAdapter;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import lombok.Generated;

public class FilteredTreeContextFactory {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.tree.FilteredTreeContextFactory");

    private FilteredTreeContextFactory() {
        if (FilteredTreeContextFactory.logger.level >= 7) {
            logger.lvlBuild(7, "FilteredTreeContextFactory()", 57).log();
        }
    }

    public static AbstractTreeFilterTraversal createFilterTraversal(FilteredTreeModel filteredTreeModel, AbstractTreeModelFilter abstractTreeModelFilter) {
        if (FilteredTreeContextFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createFilterTraversal(FilteredTreeModel,AbstractTreeModelFilter)", 75).addDetail("model", filteredTreeModel)).addDetail("filter", abstractTreeModelFilter)).log();
        }
        if (abstractTreeModelFilter != null) {
            if (abstractTreeModelFilter.isHierarchyFilter()) {
                return new HierarchicalTreeFilterTraversal(filteredTreeModel);
            }
            if (abstractTreeModelFilter.isFlatFilter()) {
                return new FlatTreeFilterTraversal(filteredTreeModel);
            }
        }
        return null;
    }

    public static FilteredTreeModelAdapter createFilteredTreeModelAdapter(TreeModel treeModel, TreeAdapter treeAdapter, AbstractTreeModelFilter abstractTreeModelFilter) {
        if (FilteredTreeContextFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createFilteredTreeModelAdapter(TreeModel,TreeAdapter,AbstractTreeModelFilter)", 101).addDetail("model", treeModel)).addDetail("adapter", treeAdapter)).addDetail("filter", abstractTreeModelFilter)).log();
        }
        if (abstractTreeModelFilter != null) {
            if (abstractTreeModelFilter.isHierarchyFilter()) {
                return new HierarchicalTreeModelAdapter(treeModel, treeAdapter);
            }
            if (abstractTreeModelFilter.isFlatFilter()) {
                return new FlatTreeModelAdapter(treeModel, treeAdapter);
            }
        }
        return null;
    }

    public static TreeCellRenderer createFilteredTreeCellRenderer(AbstractTreeModelFilter abstractTreeModelFilter) {
        if (FilteredTreeContextFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createFilteredTreeCellRenderer(AbstractTreeModelFilter)", 125).addDetail("filter", abstractTreeModelFilter)).log();
        }
        if (abstractTreeModelFilter != null && abstractTreeModelFilter.isFlatFilter()) {
            return new DefaultFlatTreeNodeRenderer();
        }
        return null;
    }
}

