/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui.tree;

import de.qfs.lib.gui.tree.AbstractTreeModelFilter;
import de.qfs.lib.gui.tree.FilteredTreeModel;
import de.qfs.lib.gui.tree.FilteredTreeModelAdapter;
import de.qfs.lib.gui.tree.TreeModelFilter;
import de.qfs.lib.gui.tree.TreeModelFilterEvent;
import de.qfs.lib.gui.tree.TreeModelFilterListener;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.tree.TreeAdapter;
import javax.annotation.Nullable;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import lombok.Generated;

public class FilteredTreeHelper
implements TreeModelFilterListener {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.tree.FilteredTreeHelper");
    private JTree tree;
    private FilteredTreeModel filteredModel;
    private TreeModelFilter filter;
    private TreeCellRenderer treeNodeRenderer;

    public FilteredTreeHelper(JTree jTree, TreeAdapter treeAdapter, @Nullable AbstractTreeModelFilter abstractTreeModelFilter) {
        if (FilteredTreeHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "FilteredTreeHelper(JTree,TreeAdapter,AbstractTreeModelFilter)", 116).addDetail("tree", jTree)).addDetail("adapter", treeAdapter)).addDetail("filter", abstractTreeModelFilter)).dumpStack();
        }
        this.tree = jTree;
        this.filter = abstractTreeModelFilter;
        TreeModel treeModel = jTree.getModel();
        if (FilteredTreeHelper.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "FilteredTreeHelper(JTree,TreeAdapter,AbstractTreeModelFilter)", 122).add("model", treeModel)).log();
        }
        if (treeModel instanceof FilteredTreeModel) {
            FilteredTreeModel filteredTreeModel = (FilteredTreeModel)treeModel;
            treeModel = filteredTreeModel.getModel();
            if (FilteredTreeHelper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "FilteredTreeHelper(JTree,TreeAdapter,AbstractTreeModelFilter)", 126).add("model", treeModel)).log();
            }
            treeModel.removeTreeModelListener(filteredTreeModel);
        }
        if (treeAdapter instanceof FilteredTreeModelAdapter) {
            treeAdapter = ((FilteredTreeModelAdapter)treeAdapter).getDefaultAdapter();
        }
        this.filteredModel = new FilteredTreeModel(treeModel, treeAdapter, abstractTreeModelFilter);
        if (this.filter != null) {
            this.filter.removeTreeModelFilterListener(this);
            this.filter.addTreeModelFilterListener(this);
        }
        this.saveSelection(true);
    }

    public void saveSelection(boolean bl) {
        if (FilteredTreeHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "saveSelection(boolean)", 159).addDetail("save", bl)).log();
        }
        if (bl) {
            if (this.filteredModel != null && this.tree != null) {
                this.filteredModel.setTree(this.tree);
                this.filteredModel.setDoSaveSelection(true);
            }
        } else if (this.filteredModel != null) {
            this.filteredModel.setDoSaveSelection(false);
        }
    }

    public void prepareTree() {
        if (FilteredTreeHelper.logger.level >= 7) {
            logger.lvlBuild(7, "prepareTree()", 182).log();
        }
        try {
            this.filteredModel.getFilteredTreeAdapter().setUseFullModel(true);
            this.tree.setModel(this.filteredModel);
            this.filteredModel.initialize();
            if (this.getTreeNodeRenderer() != null) {
                this.tree.setCellRenderer(this.getTreeNodeRenderer());
            }
        }
        finally {
            this.filteredModel.getFilteredTreeAdapter().setUseFullModel(false);
        }
        if (this.filter != null) {
            this.filter.removeTreeModelFilterListener(this);
            this.filter.addTreeModelFilterListener(this);
        }
    }

    public void cleanup() {
        if (FilteredTreeHelper.logger.level >= 7) {
            logger.lvlBuild(7, "cleanup()", 212).log();
        }
        if (this.filter != null) {
            this.filter.removeTreeModelFilterListener(this);
            this.filter = null;
        }
        if (this.filteredModel != null) {
            this.filteredModel.cleanup();
        }
        this.filteredModel = null;
        this.tree = null;
    }

    @Override
    public void filterChanged(TreeModelFilterEvent treeModelFilterEvent) {
        if (FilteredTreeHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "filterChanged(TreeModelFilterEvent)", 235).addDetail("event", treeModelFilterEvent)).log();
        }
        if (this.tree.getCellEditor() != null) {
            this.tree.getCellEditor().cancelCellEditing();
        }
    }

    @Generated
    public JTree getTree() {
        return this.tree;
    }

    @Generated
    public FilteredTreeHelper setTree(JTree jTree) {
        this.tree = jTree;
        return this;
    }

    @Generated
    public FilteredTreeModel getFilteredModel() {
        return this.filteredModel;
    }

    @Generated
    public FilteredTreeHelper setFilteredModel(FilteredTreeModel filteredTreeModel) {
        this.filteredModel = filteredTreeModel;
        return this;
    }

    @Generated
    public TreeModelFilter getFilter() {
        return this.filter;
    }

    @Generated
    public FilteredTreeHelper setFilter(TreeModelFilter treeModelFilter) {
        this.filter = treeModelFilter;
        return this;
    }

    @Generated
    public TreeCellRenderer getTreeNodeRenderer() {
        return this.treeNodeRenderer;
    }

    @Generated
    public FilteredTreeHelper setTreeNodeRenderer(TreeCellRenderer treeCellRenderer) {
        this.treeNodeRenderer = treeCellRenderer;
        return this;
    }
}

