/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui.tree;

import de.qfs.lib.gui.AdapterTreeModel;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.gui.tree.AbstractTreeFilterTraversal;
import de.qfs.lib.gui.tree.AbstractTreeModelFilter;
import de.qfs.lib.gui.tree.FilteredTreeContextFactory;
import de.qfs.lib.gui.tree.FilteredTreeModelAdapter;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.tree.TreeAdapter;
import de.qfs.lib.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Vector;
import javax.annotation.Nullable;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import lombok.Generated;

public class FilteredTreeModel
extends AdapterTreeModel
implements TreeModelListener {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.tree.FilteredTreeModel");
    protected TreeModel model;
    protected AbstractTreeModelFilter filter;
    private Object leadSelectionNode;
    private final ArrayList<Object> allSelectedNodes = new ArrayList();
    private final ArrayList<Object> allExpandedNodes = new ArrayList();
    private boolean selectionSaved;
    private AbstractTreeFilterTraversal filterTraversal;
    private JTree tree;
    private boolean doSaveSelection = false;

    public FilteredTreeModel(TreeModel treeModel, TreeAdapter treeAdapter, @Nullable AbstractTreeModelFilter abstractTreeModelFilter) {
        super(FilteredTreeContextFactory.createFilteredTreeModelAdapter(treeModel, treeAdapter, abstractTreeModelFilter), treeModel.getRoot());
        if (FilteredTreeModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "FilteredTreeModel(TreeModel,TreeAdapter,AbstractTreeModelFilter)", 142).addDetail("model", treeModel)).addDetail("adapter", treeAdapter)).addDetail("filter", abstractTreeModelFilter)).dumpStack();
        }
        this.model = treeModel;
        if ((treeModel instanceof FilteredTreeModel || treeAdapter instanceof FilteredTreeModelAdapter) && FilteredTreeModel.logger.level >= 5) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "FilteredTreeModel(TreeModel,TreeAdapter,AbstractTreeModelFilter)", 147).add("Nested filtering is probably a bug")).add("model", treeModel)).add("adapter", treeAdapter)).dumpStack();
        }
        this.filter = abstractTreeModelFilter;
        if (abstractTreeModelFilter != null) {
            this.filterTraversal = FilteredTreeContextFactory.createFilterTraversal(this, abstractTreeModelFilter);
        }
        treeModel.addTreeModelListener(this);
    }

    public void setFilter(@Nullable AbstractTreeModelFilter abstractTreeModelFilter) {
        if (FilteredTreeModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setFilter(AbstractTreeModelFilter)", 173).addDetail("filter", abstractTreeModelFilter)).log();
        }
        this.saveSelection();
        this.filter = abstractTreeModelFilter;
        this.validateMap();
        if (this.isDoSaveSelection()) {
            this.validateMap();
            this.restoreSavedSelection();
        }
        this.validateMap();
    }

    public void cleanup() {
        if (FilteredTreeModel.logger.level >= 7) {
            logger.lvlBuild(7, "cleanup()", 197).log();
        }
        this.filter = null;
        this.leadSelectionNode = null;
        this.allSelectedNodes.clear();
        this.allExpandedNodes.clear();
        if (this.isDoSaveSelection()) {
            this.tree.clearSelection();
        }
        this.getFilteredTreeAdapter().getModel().removeTreeModelListener(this);
        this.getFilteredTreeAdapter().cleanup();
        this.getFilterTraversal().cleanup();
        this.adapter = null;
        this.tree = null;
    }

    public void initialize() {
        if (FilteredTreeModel.logger.level >= 7) {
            logger.lvlBuild(7, "initialize()", 221).log();
        }
        this.filterTraversal.initialize();
    }

    public FilteredTreeModelAdapter getFilteredTreeAdapter() {
        return (FilteredTreeModelAdapter)this.getAdapter();
    }

    private void saveSelection() {
        if (FilteredTreeModel.logger.level >= 7) {
            logger.lvlBuild(7, "saveSelection()", 245).log();
        }
        this.saveSelection(false);
    }

    private void saveSelection(boolean bl) {
        if (FilteredTreeModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "saveSelection(boolean)", 256).addDetail("withExpansion", bl)).log();
        }
        if (this.selectionSaved) {
            return;
        }
        if (this.isDoSaveSelection() && !this.tree.isSelectionEmpty()) {
            if (FilteredTreeModel.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "saveSelection(boolean)", 263).add("Save selection")).log();
            }
            this.leadSelectionNode = this.tree.getLastSelectedPathComponent();
            this.allSelectedNodes.clear();
            for (TreePath treePath : this.tree.getSelectionPaths()) {
                this.allSelectedNodes.add(treePath.getLastPathComponent());
            }
            if (bl) {
                this.allExpandedNodes.clear();
                for (int i = this.getTree().getRowCount() - 1; i >= 0; --i) {
                    if (!this.getTree().isExpanded(i)) continue;
                    Object object = this.getTree().getPathForRow(i).getLastPathComponent();
                    if (this.filter.isActive() && !this.getFilteredTreeAdapter().containsNode(object)) continue;
                    this.allExpandedNodes.add(0, object);
                    if (this.getTree().isRootVisible() && (!this.getTree().isRootVisible() || i == 0)) continue;
                    this.getTree().collapseRow(i);
                }
            }
            this.selectionSaved = true;
            this.tree.clearSelection();
        }
    }

    private void restoreSavedSelection() {
        if (FilteredTreeModel.logger.level >= 7) {
            logger.lvlBuild(7, "restoreSavedSelection()", 305).log();
        }
        this.restoreSavedSelection(false);
    }

    private void restoreSavedSelection(boolean bl) {
        if (FilteredTreeModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "restoreSavedSelection(boolean)", 316).addDetail("withExpansion", bl)).log();
        }
        if (this.isDoSaveSelection() && this.selectionSaved) {
            if (FilteredTreeModel.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "restoreSavedSelection(boolean)", 319).add("Restore selection")).log();
            }
            if (bl) {
                for (Object iterator : this.allExpandedNodes) {
                    Object[] objectArray = TreeUtil.getPath(this.getFilteredTreeAdapter(), iterator);
                    if (objectArray == null) continue;
                    TreePath treePath = new TreePath(objectArray);
                    int n = this.getTree().getRowForPath(treePath);
                    if (n <= -1 || this.filter.isActive() && !this.getFilteredTreeAdapter().containsNode(iterator) || this.getTree().isExpanded(n)) continue;
                    this.getTree().makeVisible(treePath);
                    this.getTree().expandPath(treePath);
                }
            }
            if (this.leadSelectionNode != null) {
                this.tree.clearSelection();
                boolean bl2 = this.selectPathOfNode(this.leadSelectionNode, true);
                for (Object object : this.allSelectedNodes) {
                    bl2 = this.selectPathOfNode(object, !bl2);
                }
            }
            this.selectionSaved = false;
        }
    }

    public boolean selectPathOfNode(Object object, boolean bl) {
        if (FilteredTreeModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "selectPathOfNode(Object,boolean)", 370).addDetail("node", object)).addDetail("setOrAdd", bl)).log();
        }
        if (this.filter.isActive() && !this.getFilteredTreeAdapter().containsNode(this.leadSelectionNode)) {
            return false;
        }
        Object[] objectArray = TreeUtil.getPath(this.getFilteredTreeAdapter(), object);
        if (objectArray == null) {
            return false;
        }
        TreePath treePath = new TreePath(objectArray);
        int n = this.tree.getRowForPath(treePath);
        this.tree.makeVisible(treePath);
        if (n > -1) {
            if (bl) {
                if (FilteredTreeModel.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "selectPathOfNode(Object,boolean)", 388).add("Start new selection")).log();
                }
                this.tree.clearSelection();
                if (this.getTree().getRowCount() > n) {
                    this.tree.setSelectionRow(n);
                    this.tree.scrollRowToVisible(n);
                    return true;
                }
            } else if (this.getTree().getRowCount() > n) {
                if (FilteredTreeModel.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "selectPathOfNode(Object,boolean)", 397).add("Add to selection")).log();
                }
                this.tree.addSelectionRow(n);
                return true;
            }
        }
        return false;
    }

    public void scrollPathToVisible(TreePath treePath, boolean bl) {
        if (FilteredTreeModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "scrollPathToVisible(TreePath,boolean)", 414).addDetail("path", treePath)).addDetail("doSelect", bl)).log();
        }
        if (treePath != null) {
            int n;
            if (bl) {
                this.tree.setSelectionPath(treePath);
            }
            if ((n = this.tree.getRowForPath(treePath)) > -1) {
                int n2 = this.tree.getVisibleRowCount();
                if (n2 > 4) {
                    treePath = this.tree.getPathForRow(n - 3);
                }
                this.tree.makeVisible(treePath);
                this.tree.scrollPathToVisible(treePath);
            }
        }
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        if (FilteredTreeModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "valueForPathChanged(TreePath,Object)", 451).addDetail("path", treePath)).addDetail("newValue", object)).dumpStack();
        }
        if (this.filter.isActive()) {
            Object object2 = treePath.getLastPathComponent();
            if (!this.getFilteredTreeAdapter().containsNode(object2)) {
                if (FilteredTreeModel.logger.level >= 5) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "valueForPathChanged(TreePath,Object)", 456).add("Node not shown: ", object2)).log();
                }
                return;
            }
        }
        super.valueForPathChanged(treePath, object);
    }

    @Override
    public void nodeInserted(Object[] objectArray, int n) {
        if (FilteredTreeModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "nodeInserted(Object[],int)", 476).addDetail("parentPath", objectArray)).addDetail("index", n)).dumpStack();
        }
        super.nodeInserted(objectArray, n);
    }

    @Override
    public void nodeRemoved(Object[] objectArray, int n) {
        if (FilteredTreeModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "nodeRemoved(Object[],int)", 495).addDetail("parentPath", objectArray)).addDetail("index", n)).dumpStack();
        }
        super.nodeRemoved(objectArray, n);
    }

    private void buildMap() {
        if (FilteredTreeModel.logger.level >= 7) {
            logger.lvlBuild(7, "buildMap()", 512).log();
        }
        this.filterTraversal.buildMap();
    }

    private void validateMap() {
        if (FilteredTreeModel.logger.level >= 7) {
            logger.lvlBuild(7, "validateMap()", 524).log();
        }
        this.initialize();
        this.restoreSavedSelection();
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (FilteredTreeModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "treeNodesChanged(TreeModelEvent)", 538).addDetail("arg0", treeModelEvent)).log();
        }
        this.validateMap();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (FilteredTreeModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "treeNodesInserted(TreeModelEvent)", 547).addDetail("arg0", treeModelEvent)).log();
        }
        this.validateMap();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (FilteredTreeModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "treeNodesRemoved(TreeModelEvent)", 556).addDetail("arg0", treeModelEvent)).log();
        }
        this.validateMap();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (FilteredTreeModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "treeStructureChanged(TreeModelEvent)", 565).addDetail("arg0", treeModelEvent)).log();
        }
        this.validateMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeStructureChanged(Object[] objectArray) {
        Vector vector;
        if (FilteredTreeModel.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "fireTreeStructureChanged(Object[])", 578).addDetail("path", objectArray)).log();
        }
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, objectArray);
        FilteredTreeModel filteredTreeModel = this;
        synchronized (filteredTreeModel) {
            vector = (Vector)this.listeners.clone();
        }
        SwingUtil.invokeAndWait(() -> {
            for (int i = 0; i < vector.size(); ++i) {
                ((TreeModelListener)vector.elementAt(i)).treeStructureChanged(treeModelEvent);
            }
        });
    }

    public void maybeUpdateFilter() {
        if (FilteredTreeModel.logger.level >= 7) {
            logger.lvlBuild(7, "maybeUpdateFilter()", 599).log();
        }
        this.saveSelection(true);
        this.buildMap();
        this.restoreSavedSelection(true);
    }

    @Generated
    public TreeModel getModel() {
        return this.model;
    }

    @Generated
    public AbstractTreeModelFilter getFilter() {
        return this.filter;
    }

    @Generated
    public AbstractTreeFilterTraversal getFilterTraversal() {
        return this.filterTraversal;
    }

    @Generated
    public JTree getTree() {
        return this.tree;
    }

    @Generated
    public FilteredTreeModel setTree(JTree jTree) {
        this.tree = jTree;
        return this;
    }

    @Generated
    public boolean isDoSaveSelection() {
        if (FilteredTreeModel.logger.level >= 7) {
            logger.lvlBuild(7, "isDoSaveSelection()", 123).log();
        }
        return this.doSaveSelection;
    }

    @Generated
    public FilteredTreeModel setDoSaveSelection(boolean bl) {
        this.doSaveSelection = bl;
        return this;
    }
}

