/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.json;

import de.qfs.lib.json.JsonArray;
import de.qfs.lib.json.JsonBuilder;
import de.qfs.lib.json.JsonHandler;
import de.qfs.lib.json.JsonLiteral;
import de.qfs.lib.json.JsonNumber;
import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonParser;
import de.qfs.lib.json.JsonString;
import de.qfs.lib.json.JsonValue;
import java.io.IOException;
import java.io.Reader;

public final class Json {
    public static final JsonValue NULL = new JsonLiteral("null");
    public static final JsonValue TRUE = new JsonLiteral("true");
    public static final JsonValue FALSE = new JsonLiteral("false");

    private Json() {
    }

    public static JsonValue value(int n) {
        return new JsonNumber(Integer.toString(n, 10));
    }

    public static JsonValue value(long l) {
        return new JsonNumber(Long.toString(l, 10));
    }

    public static JsonValue value(float f) {
        if (Float.isInfinite(f) || Float.isNaN(f)) {
            throw new IllegalArgumentException("Infinite and NaN values not permitted in JSON");
        }
        return new JsonNumber(Json.cutOffPointZero(Float.toString(f)));
    }

    public static JsonValue value(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Infinite and NaN values not permitted in JSON");
        }
        return new JsonNumber(Json.cutOffPointZero(Double.toString(d)));
    }

    public static JsonValue value(String string) {
        return string == null ? NULL : new JsonString(string);
    }

    public static JsonValue value(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static JsonValue value(Object object) {
        return JsonBuilder.toJsonValue(object);
    }

    public static JsonArray array() {
        return new JsonArray();
    }

    public static JsonArray array(int ... nArray) {
        if (nArray == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray jsonArray = new JsonArray();
        for (int n : nArray) {
            jsonArray.add(n);
        }
        return jsonArray;
    }

    public static JsonArray array(long ... lArray) {
        if (lArray == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray jsonArray = new JsonArray();
        for (long l : lArray) {
            jsonArray.add(l);
        }
        return jsonArray;
    }

    public static JsonArray array(float ... fArray) {
        if (fArray == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray jsonArray = new JsonArray();
        for (float f : fArray) {
            jsonArray.add(f);
        }
        return jsonArray;
    }

    public static JsonArray array(double ... dArray) {
        if (dArray == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray jsonArray = new JsonArray();
        for (double d : dArray) {
            jsonArray.add(d);
        }
        return jsonArray;
    }

    public static JsonArray array(boolean ... blArray) {
        if (blArray == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray jsonArray = new JsonArray();
        for (boolean bl : blArray) {
            jsonArray.add(bl);
        }
        return jsonArray;
    }

    public static JsonArray array(String ... stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray jsonArray = new JsonArray();
        for (String string : stringArray) {
            jsonArray.add(string);
        }
        return jsonArray;
    }

    public static JsonObject object() {
        return new JsonObject();
    }

    public static JsonValue parse(String string) {
        if (string == null) {
            throw new NullPointerException("string is null");
        }
        DefaultHandler defaultHandler = new DefaultHandler();
        new JsonParser(defaultHandler).parse(string);
        return defaultHandler.getValue();
    }

    public static JsonValue parse(Reader reader) throws IOException {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        DefaultHandler defaultHandler = new DefaultHandler();
        new JsonParser(defaultHandler).parse(reader);
        return defaultHandler.getValue();
    }

    private static String cutOffPointZero(String string) {
        if (string.endsWith(".0")) {
            return string.substring(0, string.length() - 2);
        }
        return string;
    }

    static class DefaultHandler
    extends JsonHandler<JsonArray, JsonObject> {
        protected JsonValue value;

        DefaultHandler() {
        }

        @Override
        public JsonArray startArray() {
            return new JsonArray();
        }

        @Override
        public JsonObject startObject() {
            return new JsonObject();
        }

        @Override
        public void endNull() {
            this.value = NULL;
        }

        @Override
        public void endBoolean(boolean bl) {
            this.value = bl ? TRUE : FALSE;
        }

        @Override
        public void endString(String string) {
            this.value = new JsonString(string);
        }

        @Override
        public void endNumber(String string) {
            this.value = new JsonNumber(string);
        }

        @Override
        public void endArray(JsonArray jsonArray) {
            this.value = jsonArray;
        }

        @Override
        public void endObject(JsonObject jsonObject) {
            this.value = jsonObject;
        }

        @Override
        public void endArrayValue(JsonArray jsonArray) {
            jsonArray.add(this.value);
        }

        @Override
        public void endObjectValue(JsonObject jsonObject, String string) {
            jsonObject.add(string, this.value);
        }

        JsonValue getValue() {
            return this.value;
        }
    }
}

