/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.json;

import de.qfs.lib.json.JsonValue;
import de.qfs.lib.json.JsonWriter;
import java.io.IOException;

class JsonLiteral
extends JsonValue {
    private final String value;
    private final boolean isNull;
    private final boolean isTrue;
    private final boolean isFalse;

    JsonLiteral(String string) {
        this.value = string;
        this.isNull = "null".equals(string);
        this.isTrue = "true".equals(string);
        this.isFalse = "false".equals(string);
    }

    @Override
    void write(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeLiteral(this.value);
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean isNull() {
        return this.isNull;
    }

    @Override
    public boolean isTrue() {
        return this.isTrue;
    }

    @Override
    public boolean isFalse() {
        return this.isFalse;
    }

    @Override
    public boolean isBoolean() {
        return this.isTrue || this.isFalse;
    }

    @Override
    public boolean asBoolean() {
        return this.isNull ? super.asBoolean() : this.isTrue;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JsonLiteral jsonLiteral = (JsonLiteral)object;
        return this.value.equals(jsonLiteral.value);
    }
}

