/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.junit.converters;

import de.qfs.lib.util.Misc;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.params.converter.ArgumentConversionException;
import org.junit.jupiter.params.converter.ArgumentConverter;
import org.junit.jupiter.params.converter.ConvertWith;

public class ArrayConverter
implements ArgumentConverter {
    public Object convert(Object object, ParameterContext parameterContext) throws ArgumentConversionException {
        return this.convert(object, parameterContext.getParameter().getType());
    }

    protected Object convert(Object object, Class<?> clazz) throws ArgumentConversionException {
        String[] stringArray;
        if (!(object instanceof String)) {
            throw new ArgumentConversionException("Input must be a String");
        }
        String[] stringArray2 = stringArray = "".equals(object) ? new String[]{} : Misc.fastSplit((String)object, ',', -1);
        if (clazz == String[].class) {
            return stringArray;
        }
        if (clazz == int[].class) {
            return Arrays.stream(stringArray).mapToInt(Integer::parseInt).toArray();
        }
        if (clazz == Integer[].class) {
            return Arrays.stream(stringArray).map(Integer::valueOf).toArray(Integer[]::new);
        }
        if (clazz == long[].class) {
            return Arrays.stream(stringArray).mapToLong(Long::parseLong).toArray();
        }
        if (clazz == Long[].class) {
            return Arrays.stream(stringArray).map(Long::valueOf).toArray(Long[]::new);
        }
        if (clazz == double[].class) {
            return Arrays.stream(stringArray).mapToDouble(Double::parseDouble).toArray();
        }
        if (clazz == Double[].class) {
            return Arrays.stream(stringArray).map(Double::valueOf).toArray(Double[]::new);
        }
        if (clazz == boolean[].class) {
            return Arrays.stream(stringArray).map(Boolean::valueOf).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                int n = list.size();
                boolean[] blArray = new boolean[n];
                for (int i = 0; i < n; ++i) {
                    blArray[i] = (Boolean)list.get(i);
                }
                return blArray;
            }));
        }
        if (clazz == Boolean[].class) {
            return Arrays.stream(stringArray).map(Boolean::valueOf).toArray(Boolean[]::new);
        }
        throw new ArgumentConversionException("No argument conversion defined for expected " + clazz);
    }

    @Target(value={ElementType.ANNOTATION_TYPE, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @ConvertWith(value=ArrayConverter.class)
    public static @interface AsArray {
    }
}

