/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.junit.extensions;

import de.qfs.lib.util.Misc;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class CatchSystemOutErr
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        ExtensionContext.Store store = this.getStore(extensionContext);
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        store.put((Object)"originalOut", (Object)printStream);
        store.put((Object)"originalErr", (Object)printStream2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        store.put((Object)"outContent", (Object)byteArrayOutputStream);
        store.put((Object)"errContent", (Object)byteArrayOutputStream2);
        System.setOut(Misc.createCompatibleStream(byteArrayOutputStream, printStream));
        System.setErr(Misc.createCompatibleStream(byteArrayOutputStream2, printStream2));
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        ExtensionContext.Store store = this.getStore(extensionContext);
        PrintStream printStream = (PrintStream)store.get((Object)"originalOut");
        PrintStream printStream2 = (PrintStream)store.get((Object)"originalErr");
        System.setOut(printStream);
        System.setErr(printStream2);
        store.remove((Object)"originalOut");
        store.remove((Object)"originalErr");
        store.remove((Object)"outContent");
        store.remove((Object)"errContent");
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().isAssignableFrom(ByteArrayOutputStream.class) && (parameterContext.isAnnotated(SystemOut.class) || parameterContext.isAnnotated(SystemErr.class));
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ExtensionContext.Store store = this.getStore(extensionContext);
        String string = parameterContext.isAnnotated(SystemOut.class) ? "outContent" : "errContent";
        ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)store.get((Object)string);
        return byteArrayOutputStream;
    }

    protected ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), extensionContext.getRequiredTestMethod()}));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface SystemErr {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface SystemOut {
    }
}

