/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.junit.extensions;

import de.qfs.lib.log.DefaultLogFormat;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.LogFormat;
import de.qfs.lib.log.LogWriter;
import de.qfs.lib.log.Logger;
import de.qfs.lib.util.Misc;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.LinkedList;
import lombok.Generated;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class QFLogExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        WithLogLevel[] withLogLevelArray;
        ExtensionContext.Store store = this.getStore(extensionContext);
        boolean bl = Log.isQueueing();
        store.put((Object)"prevLogQueueing", (Object)bl);
        Log.setQueueing(false);
        LogWriter logWriter = Log.getLogWriter();
        store.put((Object)"prevLogWriter", (Object)logWriter);
        LogBuffer logBuffer = new LogBuffer();
        store.put((Object)"logWriter", (Object)logBuffer);
        Log.setLogWriter(logBuffer);
        for (WithLogLevel withLogLevel : withLogLevelArray = (WithLogLevel[])extensionContext.getRequiredTestMethod().getAnnotationsByType(WithLogLevel.class)) {
            Logger.setLogLevel(this.getLoggerName(withLogLevel), this.getLoggerLevel(withLogLevel));
        }
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        WithLogLevel[] withLogLevelArray;
        ExtensionContext.Store store = this.getStore(extensionContext);
        for (WithLogLevel withLogLevel : withLogLevelArray = (WithLogLevel[])extensionContext.getRequiredTestMethod().getAnnotationsByType(WithLogLevel.class)) {
            Logger.removeLogLevel(this.getLoggerName(withLogLevel));
        }
        store.remove((Object)"logWriter");
        Log.setLogWriter((LogWriter)store.remove((Object)"prevLogWriter"));
        Log.setQueueing((Boolean)store.remove((Object)"prevLogQueueing"));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().isAssignableFrom(LogBuffer.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ExtensionContext.Store store = this.getStore(extensionContext);
        return store.get((Object)"logWriter");
    }

    protected ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), extensionContext.getRequiredTestMethod()}));
    }

    private String getLoggerName(WithLogLevel withLogLevel) {
        String[] stringArray;
        String string = withLogLevel.value();
        if (!"".equals(string) && (stringArray = Misc.fastSplit(string, '=')).length >= 1) {
            return stringArray[0].trim();
        }
        return withLogLevel.logger();
    }

    private int getLoggerLevel(WithLogLevel withLogLevel) {
        String[] stringArray;
        String string = withLogLevel.value();
        if (!"".equals(string) && (stringArray = Misc.fastSplit(string, '=')).length >= 2) {
            try {
                return Integer.parseInt(stringArray[1].trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return withLogLevel.level();
    }

    public static class LogBuffer
    implements LogWriter {
        final LinkedList<LogEntry> entries = new LinkedList();
        LogFormat format = new DefaultLogFormat();

        @Override
        public void write(LogEntry logEntry) {
            this.entries.add(logEntry);
        }

        @Override
        public void write(LogEntry[] logEntryArray) {
            for (LogEntry logEntry : logEntryArray) {
                this.write(logEntry);
            }
        }

        @Override
        public void close() {
        }

        @Override
        public void setFormat(LogFormat logFormat) {
            this.format = logFormat;
        }

        public void clear() {
            this.entries.clear();
        }

        @Generated
        public LinkedList<LogEntry> getEntries() {
            return this.entries;
        }

        @Override
        @Generated
        public LogFormat getFormat() {
            return this.format;
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Inherited
    @Repeatable(value=WithLogLevels.class)
    public static @interface WithLogLevel {
        public String value() default "";

        public String logger() default "";

        public int level() default 10;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Inherited
    private static @interface WithLogLevels {
        public WithLogLevel[] value();
    }
}

