/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.logrmi;

import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.LogUser;
import de.qfs.lib.log.Logger;
import de.qfs.lib.logrmi.LogClient;
import de.qfs.lib.logrmi.LogListener;
import de.qfs.lib.logrmi.LogServer;
import de.qfs.lib.logrmi.RemoteLogLevelAdapter;
import de.qfs.lib.logrmi.RemoteLogLevelListener;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;

public class RemoteLogFilter
extends UnicastRemoteObject
implements LogClient,
LogUser {
    private static RemoteLogFilter instance;
    private int mode = 3;
    private String name;
    private String bound;
    private boolean localOnly;
    private LogServer logServer;
    private int id;
    private boolean connected;
    private LogListener listener;
    private RemoteLogLevelListener levelListener;
    private RemoteLogLevelAdapter adapter;
    private int failure = 0;
    private static final int MAX_FAILURES = 3;

    public RemoteLogFilter(String string) throws RemoteException {
        this.name = string;
    }

    public static void logRemote(String string, String string2) throws MalformedURLException, NotBoundException, RemoteException {
        instance = new RemoteLogFilter(string2);
        instance.connect(string);
        Log.addFilter(instance);
    }

    public static void logRemote(String string, int n, boolean bl, boolean bl2) throws RemoteException {
        instance = new RemoteLogFilter(string);
        instance.register(n, bl, bl2);
        Log.addFilter(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logRemote(String string, String string2, int n, boolean bl, boolean bl2) throws MalformedURLException, NotBoundException, RemoteException {
        instance = new RemoteLogFilter(string2);
        boolean bl3 = false;
        RemoteException remoteException = null;
        try {
            try {
                instance.register(n, bl, bl2);
                bl3 = true;
            }
            catch (RemoteException remoteException2) {
                remoteException = remoteException2;
            }
            instance.connect(string);
            bl3 = true;
            if (remoteException != null) {
                throw remoteException;
            }
        }
        finally {
            Log.addFilter(instance);
        }
    }

    public static void stopLogging() {
        if (instance != null) {
            Log.removeFilter(instance);
            instance.disconnect();
        }
    }

    public static RemoteLogFilter getInstance() {
        return instance;
    }

    public void connect(String string) throws MalformedURLException, NotBoundException, RemoteException {
        this.logServer = (LogServer)Naming.lookup(string);
        this.id = this.logServer.getId(this.name);
        this.connect();
    }

    public void register(int n, boolean bl, boolean bl2) throws RemoteException {
        this.localOnly = bl2;
        Registry registry = null;
        RemoteException remoteException = null;
        try {
            registry = LocateRegistry.getRegistry(n > 0 ? n : 1099);
        }
        catch (RemoteException remoteException2) {
            remoteException = remoteException2;
        }
        this.bound = "LogClient-" + this.name + "-" + (int)(Math.random() * 100000.0);
        if (registry != null) {
            try {
                registry.bind(this.bound, this);
                return;
            }
            catch (AlreadyBoundException alreadyBoundException) {
            }
            catch (RemoteException remoteException3) {
                registry = null;
                remoteException = remoteException3;
            }
        }
        if (registry == null) {
            if (bl) {
                registry = LocateRegistry.createRegistry(n > 0 ? n : 1099);
            } else {
                if (remoteException != null) {
                    throw remoteException;
                }
                System.err.println("RemoteLogFilter.register: internal error");
            }
        }
        boolean bl3 = false;
        while (!bl3) {
            this.bound = "LogClient-" + this.name + "-" + (int)(Math.random() * 100000.0);
            try {
                registry.bind(this.bound, this);
                bl3 = true;
            }
            catch (AlreadyBoundException alreadyBoundException) {}
        }
    }

    public void disconnect() {
        if (this.connected) {
            try {
                this.logServer.disconnect(this.id);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (this.bound != null) {
            try {
                Naming.unbind(this.bound);
            }
            catch (RemoteException remoteException) {
            }
            catch (NotBoundException notBoundException) {
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.listener = null;
        if (this.adapter != null) {
            Logger.removeLogLevelListener(this.adapter);
            this.adapter = null;
            this.levelListener = null;
        }
    }

    @Override
    public boolean filter(LogEntry logEntry) {
        boolean bl = false;
        if (this.failure >= 0) {
            if (this.failure >= 3) {
                this.failure = -1;
            } else if (this.listener != null) {
                try {
                    this.listener.log(logEntry);
                    bl = true;
                }
                catch (RemoteException remoteException) {
                    ++this.failure;
                }
            }
        }
        return this.mode != 2 && (bl && this.mode != 0 || !bl && this.mode != 1);
    }

    @Override
    public LogEntry[] filter(LogEntry[] logEntryArray) {
        boolean bl = false;
        if (this.failure >= 0) {
            if (this.failure >= 3) {
                this.failure = -1;
            } else if (this.listener != null) {
                try {
                    this.listener.log(logEntryArray);
                    bl = true;
                }
                catch (RemoteException remoteException) {
                    ++this.failure;
                }
            }
        }
        if (this.mode == 2 || bl && this.mode == 0 || !bl && this.mode == 1) {
            return new LogEntry[0];
        }
        return logEntryArray;
    }

    @Override
    public void setFilterMode(int n) {
        this.mode = n;
    }

    @Override
    public void connect(LogServer logServer) throws RemoteException {
        if (this.localOnly) {
            try {
                String string = RemoteLogFilter.getClientHost();
                InetAddress inetAddress = InetAddress.getByName(string);
                if (!inetAddress.getHostAddress().startsWith("127.0.0.") && !inetAddress.equals(InetAddress.getLocalHost())) {
                    throw new AccessException("RemoteLogFilter.connect: " + string + " is not a local address");
                }
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
        }
        if (this.connected) {
            try {
                this.logServer.disconnect(this.id);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (this.adapter != null) {
            Logger.removeLogLevelListener(this.adapter);
            this.adapter = null;
            this.levelListener = null;
        }
        try {
            this.logServer = logServer;
            this.id = logServer.getId(this.name);
            this.connect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void connect() throws RemoteException {
        this.listener = this.logServer.getLogListener(this.id);
        this.levelListener = this.logServer.getLogLevelListener(this.id);
        this.adapter = new RemoteLogLevelAdapter();
        this.adapter.setRemoteListener(this.levelListener);
        Logger.addLogLevelListener(this.adapter);
        this.failure = 0;
        this.connected = true;
    }
}

