/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.logrmi;

import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogLevelCallback;
import de.qfs.lib.log.LogLevelEvent;
import de.qfs.lib.log.LogLevelListener;
import de.qfs.lib.log.Logger;
import de.qfs.lib.logrmi.RemoteLogLevelCallback;
import de.qfs.lib.logrmi.RemoteLogLevelListener;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class RemoteLogLevelAdapter
extends UnicastRemoteObject
implements RemoteLogLevelCallback,
LogLevelListener {
    private static final int MAX_FAILURES = 3;
    RemoteLogLevelListener listener;
    private int failures;

    public RemoteLogLevelAdapter() throws RemoteException {
    }

    public RemoteLogLevelAdapter(RemoteLogLevelListener remoteLogLevelListener) throws RemoteException {
        this.listener = remoteLogLevelListener;
    }

    public void setRemoteListener(RemoteLogLevelListener remoteLogLevelListener) {
        this.listener = remoteLogLevelListener;
        try {
            remoteLogLevelListener.setLogLevelCallback(this);
        }
        catch (RemoteException remoteException) {
            this.failed();
        }
    }

    @Override
    public Object[] getLogLevels() {
        return Logger.getLogLevels();
    }

    @Override
    public void setLogLevel(String string, int n) {
        Logger.setLogLevel(this, string, n);
    }

    @Override
    public void removeLogLevel(String string) {
        Logger.removeLogLevel(this, string);
    }

    @Override
    public int getOutputLevel() {
        return Log.getOutputLevel();
    }

    @Override
    public void setOutputLevel(int n) {
        Log.setOutputLevel(n);
    }

    @Override
    public int getPreQueueLevel() {
        return Log.getPreQueueLevel();
    }

    @Override
    public void setPreQueueLevel(int n) {
        Log.setPreQueueLevel(n);
    }

    @Override
    public boolean isQueueing() {
        return Log.isQueueing();
    }

    @Override
    public void setQueueing(boolean bl) {
        Log.setQueueing(bl);
    }

    @Override
    public int getQueueSize() {
        return Log.getQueueSize();
    }

    @Override
    public void setQueueSize(int n) {
        Log.setQueueSize(n);
    }

    @Override
    public boolean isDropOnOverflow() {
        return Log.isDropOnOverflow();
    }

    @Override
    public void setDropOnOverflow(boolean bl) {
        Log.setDropOnOverflow(bl);
    }

    @Override
    public int getFlushBufferSize() {
        return Log.getFlushBufferSize();
    }

    @Override
    public void setFlushBufferSize(int n) {
        Log.setFlushBufferSize(n);
    }

    @Override
    public int getFlushTriggerLevel() {
        return Log.getFlushTriggerLevel();
    }

    @Override
    public void setFlushTriggerLevel(int n) {
        Log.setFlushTriggerLevel(n);
    }

    @Override
    public int getPostFlushSize() {
        return Log.getPostFlushSize();
    }

    @Override
    public void setPostFlushSize(int n) {
        Log.setPostFlushSize(n);
    }

    @Override
    public void disconnect() throws RemoteException {
    }

    @Override
    public void classAdded(final LogLevelEvent logLevelEvent) {
        if (this.listener != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        RemoteLogLevelAdapter.this.listener.classAdded(logLevelEvent);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void levelChanged(final LogLevelEvent logLevelEvent) {
        if (this.listener != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        RemoteLogLevelAdapter.this.listener.levelChanged(logLevelEvent);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void levelRemoved(final LogLevelEvent logLevelEvent) {
        if (this.listener != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        RemoteLogLevelAdapter.this.listener.levelRemoved(logLevelEvent);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void setLogLevelCallback(LogLevelCallback logLevelCallback) {
    }

    private void failed() {
        if (++this.failures >= 3) {
            this.listener = null;
        }
    }
}

