/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.notifications;

import de.qfs.lib.json.JsonObject;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.notifications.DefaultNotification;
import de.qfs.lib.notifications.Notification;
import de.qfs.lib.notifications.Observer;
import de.qfs.lib.notifications.WeakNotificationCenter;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

public class DefaultNotificationCenter
implements WeakNotificationCenter {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.notifications.DefaultNotificationCenter");
    private static final String ANY_NOTIFICATION_NAME = "###RESERVERD_KEY_FOR_ANY_NAME###".intern();
    protected static final DefaultNotificationCenter instance = new DefaultNotificationCenter();
    final ConcurrentHashMap<String, Queue<ObserverReference>> observers = new ConcurrentHashMap();

    public DefaultNotificationCenter() {
        if (DefaultNotificationCenter.logger.level >= 7) {
            logger.lvlBuild(7, "DefaultNotificationCenter.DefaultNotificationCenter()", 57).log();
        }
    }

    @NonNull
    public static DefaultNotificationCenter instance() {
        if (DefaultNotificationCenter.logger.level >= 7) {
            logger.lvlBuild(7, "instance()", 82).log();
        }
        return instance;
    }

    @NonNull
    public static Map<String, Object> createUserInfo(Object ... objectArray) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createUserInfo(Object[])", 99).addDetail("userInfo", objectArray)).log();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object;
            String string = "" + objectArray[i];
            Object object2 = object = i + 1 < objectArray.length ? objectArray[i + 1] : null;
            if (hashMap.containsKey(string)) {
                throw new IllegalArgumentException("Duplicate key " + string + " in userInfo");
            }
            hashMap.put(string, object);
        }
        return hashMap;
    }

    @NonNull
    public static DefaultNotification createNotification(@NonNull String string, @Nullable Object object) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createNotification(String,Object)", 121).addDetail("notificationName", string)).addDetail("notificationSender", object)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        return DefaultNotification.builder().name(string).object(object).build();
    }

    @NonNull
    public static DefaultNotification createNotification(@NonNull String string, @Nullable Object object, Object ... objectArray) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createNotification(String,Object,Object[])", 136).addDetail("notificationName", string)).addDetail("notificationSender", object)).addDetail("userInfo", objectArray)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object2;
            String string2 = "" + objectArray[i];
            Object object3 = object2 = i + 1 < objectArray.length ? objectArray[i + 1] : null;
            if (hashMap.containsKey(string2)) {
                throw new IllegalArgumentException("Duplicate key " + string2 + " in userInfo");
            }
            hashMap.put(string2, object2);
        }
        return DefaultNotification.builder().name(string).object(object).userInfo(hashMap).build();
    }

    @Nullable
    public static DefaultNotification createNotification(@NonNull JsonObject jsonObject) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createNotification(JsonObject)", 159).addDetail("jsonNotification", jsonObject)).log();
        }
        if (jsonObject == null) {
            throw new IllegalArgumentException("jsonNotification is marked non-null but is null");
        }
        return DefaultNotification.fromJson(jsonObject);
    }

    @Override
    public void addObserver(@NonNull Observer observer, @Nullable String string, @Nullable Object object) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addObserver(Observer,String,Object)", 174).addDetail("observer", observer)).addDetail("notificationName", string)).addDetail("notificationSender", object)).log();
        }
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        this.addObserverReference(new StrongObserverReference(observer, object), string);
    }

    public void addAndCallObserver(@NonNull Observer observer, @Nullable String string, @Nullable Object object, @Nullable Notification notification) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addAndCallObserver(Observer,String,Object,Notification)", 189).addDetail("observer", observer)).addDetail("notificationName", string)).addDetail("notificationSender", object)).addDetail("initialNotification", notification)).log();
        }
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        this.addObserver(observer, string, object);
        DefaultNotificationCenter.initialObserverCall(observer, string, notification);
    }

    public void addObserver(@NonNull Observer observer, @Nullable String string) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addObserver(Observer,String)", 202).addDetail("observer", observer)).addDetail("notificationName", string)).log();
        }
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        this.addObserver(observer, string, null);
    }

    public void addAndCallObserver(@NonNull Observer observer, @Nullable String string, @Nullable Notification notification) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addAndCallObserver(Observer,String,Notification)", 216).addDetail("observer", observer)).addDetail("notificationName", string)).addDetail("initialNotification", notification)).log();
        }
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        this.addAndCallObserver(observer, string, null, null);
    }

    private static void initialObserverCall(@NonNull Observer observer, @Nullable String string, @Nullable Notification notification) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "initialObserverCall(Observer,String,Notification)", 224).addDetail("observer", observer)).addDetail("notificationName", string)).addDetail("initialNotification", notification)).log();
        }
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        if (notification == null) {
            notification = DefaultNotificationCenter.createNotification(string, null);
        }
        observer.receivedNotification(notification);
    }

    public void addObserver(@NonNull Observer observer) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addObserver(Observer)", 238).addDetail("observer", observer)).log();
        }
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        this.addObserver(observer, null);
    }

    @Override
    public void addWeakObserver(@NonNull Observer observer, @Nullable String string, @Nullable Object object) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addWeakObserver(Observer,String,Object)", 247).addDetail("observer", observer)).addDetail("notificationName", string)).addDetail("notificationSender", object)).log();
        }
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        this.addObserverReference(new WeakObserverReference(observer, object), string);
    }

    public void addAndCallWeakObserver(@NonNull Observer observer, @Nullable String string, @Nullable Object object, @Nullable Notification notification) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addAndCallWeakObserver(Observer,String,Object,Notification)", 262).addDetail("observer", observer)).addDetail("notificationName", string)).addDetail("notificationSender", object)).addDetail("initialNotification", notification)).log();
        }
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        this.addWeakObserver(observer, string, object);
        DefaultNotificationCenter.initialObserverCall(observer, string, notification);
    }

    public void addWeakObserver(@NonNull Observer observer, @Nullable String string) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addWeakObserver(Observer,String)", 275).addDetail("observer", observer)).addDetail("notificationName", string)).log();
        }
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        this.addWeakObserver(observer, string, null);
    }

    public void addAndCallWeakObserver(@NonNull Observer observer, @Nullable String string, @Nullable Notification notification) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addAndCallWeakObserver(Observer,String,Notification)", 284).addDetail("observer", observer)).addDetail("notificationName", string)).addDetail("initialNotification", notification)).log();
        }
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        this.addAndCallWeakObserver(observer, string, null, notification);
    }

    public void addWeakObserver(@NonNull Observer observer) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addWeakObserver(Observer)", 296).addDetail("observer", observer)).log();
        }
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        this.addWeakObserver(observer, null);
    }

    private void addObserverReference(@NonNull ObserverReference observerReference, @Nullable String string) {
        ConcurrentLinkedQueue<ObserverReference> concurrentLinkedQueue;
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addObserverReference(ObserverReference,String)", 304).addDetail("observerReference", observerReference)).addDetail("notificationName", string)).log();
        }
        if (observerReference == null) {
            throw new IllegalArgumentException("observerReference is marked non-null but is null");
        }
        if (string == null) {
            string = ANY_NOTIFICATION_NAME;
        }
        assert (string != null);
        ConcurrentLinkedQueue<ObserverReference> concurrentLinkedQueue2 = this.observers.get(string);
        if (concurrentLinkedQueue2 == null && (concurrentLinkedQueue2 = (ConcurrentLinkedQueue<ObserverReference>)this.observers.putIfAbsent(string, concurrentLinkedQueue = new ConcurrentLinkedQueue<ObserverReference>())) == null) {
            concurrentLinkedQueue2 = concurrentLinkedQueue;
        }
        assert (concurrentLinkedQueue2 != null);
        concurrentLinkedQueue2.add(observerReference);
    }

    @Override
    public void removeObserver(@NonNull Observer observer, @Nullable String string, @Nullable Object object) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "removeObserver(Observer,String,Object)", 335).addDetail("observer", observer)).addDetail("notificationName", string)).addDetail("notificationSender", object)).log();
        }
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        if (string != null) {
            this.removeObserverWithName(observer, string, object);
        } else {
            for (String string2 : this.observers.keySet()) {
                this.removeObserverWithName(observer, string2, object);
            }
        }
    }

    public void removeObserver(@NonNull Observer observer, @Nullable String string) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "removeObserver(Observer,String)", 354).addDetail("observer", observer)).addDetail("notificationName", string)).log();
        }
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        this.removeObserver(observer, string, null);
    }

    @Override
    public void removeObserver(@NonNull Observer observer) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeObserver(Observer)", 363).addDetail("observer", observer)).log();
        }
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        this.removeObserver(observer, null);
    }

    public void removeObservers(@NonNull String string) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeObservers(String)", 371).addDetail("notificationName", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        this.observers.remove(string);
    }

    private void removeObserverWithName(@NonNull Observer observer, @NonNull String string, @Nullable Object object) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "removeObserverWithName(Observer,String,Object)", 379).addDetail("observer", observer)).addDetail("notificationName", string)).addDetail("notificationSender", object)).log();
        }
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        Queue<ObserverReference> queue = this.observers.get(string);
        if (queue != null) {
            this.removeObserverFromQueue(queue, observer, object);
            if (queue.isEmpty()) {
                this.observers.remove(string, queue);
            }
        }
    }

    private void removeObserverFromQueue(@NonNull Queue<ObserverReference> queue, @NonNull Observer observer, @Nullable Object object) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "removeObserverFromQueue(Queue<ObserverReference>,Observer,Object)", 397).addDetail("queue", queue)).addDetail("targetObserver", observer)).addDetail("notificationSender", object)).log();
        }
        if (queue == null) {
            throw new IllegalArgumentException("queue is marked non-null but is null");
        }
        if (observer == null) {
            throw new IllegalArgumentException("targetObserver is marked non-null but is null");
        }
        Iterator iterator = queue.iterator();
        try {
            ObserverReference observerReference;
            while ((observerReference = (ObserverReference)iterator.next()) != null) {
                Object t;
                WeakReference<Object> weakReference;
                Observer observer2 = observerReference.get();
                if (observer2 == null) {
                    iterator.remove();
                    continue;
                }
                if (observer2 != observer || object != null && ((weakReference = observerReference.getSenderReference()) == null || (t = weakReference.get()) != null && object != t)) continue;
                iterator.remove();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    public void postNotification(@NonNull Notification notification) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "postNotification(Notification)", 449).addDetail("notification", notification)).log();
        }
        if (notification == null) {
            throw new IllegalArgumentException("notification is marked non-null but is null");
        }
        String string = notification.getName();
        if (this.canDispatch(string)) {
            this.doPostNotification(string, notification);
        }
    }

    public boolean canDispatch(@NonNull String string) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "canDispatch(String)", 464).addDetail("notificationName", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        return this.observers.containsKey(string) || this.observers.containsKey(ANY_NOTIFICATION_NAME);
    }

    private void doPostNotification(@NonNull String string, @NonNull Notification notification) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "doPostNotification(String,Notification)", 473).addDetail("notificationName", string)).addDetail("notification", notification)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        if (notification == null) {
            throw new IllegalArgumentException("notification is marked non-null but is null");
        }
        this.dispatchNotifications(string, notification);
        this.dispatchNotifications(ANY_NOTIFICATION_NAME, notification);
    }

    @Override
    public void postNotification(@NonNull String string, @Nullable Object object, @Nullable Map<String, ? extends Object> map) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "postNotification(String,Object,Map<String, ? extends Object>)", 483).addDetail("notificationName", string)).addDetail("notificationSender", object)).addDetail("userInfo", map)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        if (this.canDispatch(string)) {
            this.doPostNotification(string, object, map, null);
        }
    }

    public void postNotification(@NonNull String string, @Nullable Object object, @Nullable Map<String, ? extends Object> map, @Nullable DefaultNotification.ExceptionHandler exceptionHandler) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "postNotification(String,Object,Map<String, ? extends Object>,ExceptionHandler)", 507).addDetail("notificationName", string)).addDetail("notificationSender", object)).addDetail("userInfo", map)).addDetail("exceptionHandler", exceptionHandler)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        if (this.canDispatch(string)) {
            this.doPostNotification(string, object, map, exceptionHandler);
        }
    }

    private void doPostNotification(@NonNull String string, @Nullable Object object, @Nullable Map<String, ? extends Object> map, @Nullable DefaultNotification.ExceptionHandler exceptionHandler) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "doPostNotification(String,Object,Map<String, ? extends Object>,ExceptionHandler)", 519).addDetail("notificationName", string)).addDetail("notificationSender", object)).addDetail("userInfo", map)).addDetail("exceptionHandler", exceptionHandler)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        DefaultNotification defaultNotification = DefaultNotification.builder().name(string).object(object).exceptionHandler(exceptionHandler).userInfo(map).build();
        this.doPostNotification(string, defaultNotification);
    }

    public void postNotification(@NonNull String string, @Nullable Object object, Object ... objectArray) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "postNotification(String,Object,Object[])", 542).addDetail("notificationName", string)).addDetail("notificationSender", object)).addDetail("userInfoKeyValuePairs", objectArray)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        if (this.canDispatch(string)) {
            Object object2;
            int n;
            DefaultNotification.ExceptionHandler exceptionHandler = null;
            if (objectArray != null && (n = objectArray.length) > 0 && (object2 = objectArray[n - 1]) instanceof DefaultNotification.ExceptionHandler) {
                exceptionHandler = (DefaultNotification.ExceptionHandler)object2;
                Object[] objectArray2 = new Object[n - 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, n - 1);
                objectArray = objectArray2;
            }
            this.doPostNotification(string, object, DefaultNotificationCenter.createUserInfo(objectArray), exceptionHandler);
        }
    }

    @Override
    public void postNotification(@NonNull String string, @Nullable Object object) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "postNotification(String,Object)", 571).addDetail("notificationName", string)).addDetail("notificationSender", object)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        if (this.canDispatch(string)) {
            this.doPostNotification(string, object, null, null);
        }
    }

    public void postNotification(@NonNull String string) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "postNotification(String)", 584).addDetail("notificationName", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        if (this.canDispatch(string)) {
            this.doPostNotification(string, null, null, null);
        }
    }

    private void dispatchNotifications(@NonNull String string, @NonNull Notification notification) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "dispatchNotifications(String,Notification)", 594).addDetail("notificationName", string)).addDetail("notification", notification)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        if (notification == null) {
            throw new IllegalArgumentException("notification is marked non-null but is null");
        }
        Queue<ObserverReference> queue = this.observers.get(string);
        if (queue != null) {
            this.dispatchNotifications(queue, notification);
            if (queue.isEmpty()) {
                this.observers.remove(string, queue);
            }
        }
    }

    private void dispatchNotifications(@NonNull Queue<ObserverReference> queue, @NonNull Notification notification) {
        if (DefaultNotificationCenter.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "dispatchNotifications(Queue<ObserverReference>,Notification)", 610).addDetail("queue", queue)).addDetail("notification", notification)).log();
        }
        if (queue == null) {
            throw new IllegalArgumentException("queue is marked non-null but is null");
        }
        if (notification == null) {
            throw new IllegalArgumentException("notification is marked non-null but is null");
        }
        Iterator iterator = queue.iterator();
        block4: while (true) {
            try {
                ObserverReference observerReference;
                while ((observerReference = (ObserverReference)iterator.next()) != null) {
                    Object object;
                    WeakReference<Object> weakReference;
                    Observer observer = observerReference.get();
                    if (observer == null) {
                        iterator.remove();
                        continue;
                    }
                    Object object2 = notification.getObject();
                    if (object2 != null && (weakReference = observerReference.getSenderReference()) != null) {
                        object = weakReference.get();
                        if (object == null) {
                            iterator.remove();
                            continue;
                        }
                        if (object2 != object) continue;
                    }
                    try {
                        observer.receivedNotification(notification);
                        continue block4;
                    }
                    catch (Throwable throwable) {
                        object = notification instanceof DefaultNotification ? ((DefaultNotification)notification).getExceptionHandler() : DefaultNotification.DEFAULT_EXCEPTION_HANDLER;
                        object.handleException(throwable, notification, observer);
                    }
                }
                break;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
                break;
            }
        }
    }

    private static class StrongObserverReference
    implements ObserverReference {
        @NonNull
        final Observer observer;
        @Nullable
        final WeakReference<Object> senderReference;

        @Override
        public Observer get() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "StrongObserverReference.get()", 700).log();
            }
            return this.observer;
        }

        public StrongObserverReference(@NonNull Observer observer, @Nullable Object object) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "StrongObserverReference.StrongObserverReference(Observer,Object)", 705).addDetail("observer", observer)).addDetail("sender", object)).log();
            }
            if (observer == null) {
                throw new IllegalArgumentException("observer is marked non-null but is null");
            }
            this.observer = observer;
            this.senderReference = object == null ? null : new WeakReference<Object>(object);
        }

        @Override
        @Nullable
        @Generated
        public WeakReference<Object> getSenderReference() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "StrongObserverReference.getSenderReference()", 697).log();
            }
            return this.senderReference;
        }
    }

    private static class WeakObserverReference
    extends WeakReference<Observer>
    implements ObserverReference {
        @Nullable
        final WeakReference<Object> senderReference;

        public WeakObserverReference(@NonNull Observer observer, @Nullable Object object) {
            super(observer);
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "WeakObserverReference.WeakObserverReference(Observer,Object)", 683).addDetail("observer", observer)).addDetail("sender", object)).log();
            }
            if (observer == null) {
                throw new IllegalArgumentException("observer is marked non-null but is null");
            }
            this.senderReference = object == null ? null : new WeakReference<Object>(object);
        }

        @Override
        @Nullable
        @Generated
        public WeakReference<Object> getSenderReference() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "WeakObserverReference.getSenderReference()", 681).log();
            }
            return this.senderReference;
        }
    }

    static interface ObserverReference {
        @Nullable
        public Observer get();

        @Nullable
        public WeakReference<Object> getSenderReference();
    }
}

