/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.notifications;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.LogLevels;
import de.qfs.lib.log.Logger;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.notifications.DefaultNotification;
import de.qfs.lib.notifications.DefaultNotificationCenter;
import de.qfs.lib.notifications.NotificationName;
import de.qfs.lib.notifications.Observer;
import de.qfs.lib.util.Reflector;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

public class Notifier
extends QFLogger {
    public static final int FUNDAMENTAL = 1;
    public static final int FUNDAMENTAL_DETAILS = 2;
    public static final int BASIC = 3;
    public static final int BASIC_DETAILS = 4;
    public static final int MESSAGE = 5;
    public static final int MESSAGE_DETAILS = 6;
    public static final int CONFIG = 7;
    public static final int CONFIG_DETAILS = 8;
    public static final int DEBUG = 9;
    public static final int DEBUG_DETAILS = 10;
    static final ConcurrentHashMap<String, Notifier> instances = new ConcurrentHashMap();
    final String prefix;
    final DefaultNotificationCenter notificationCenter = DefaultNotificationCenter.instance();
    final QFLogger backlog;

    static Notifier setupDefaultNotifier() {
        return Notifier.instance("", 1);
    }

    public Notifier() {
        super(Notifier.throwException());
        this.prefix = "This will never be executed, but be happy, compiler!";
        this.backlog = null;
    }

    public static Object throwException() {
        throw new UnsupportedOperationException("Not implemented in QFNotificationLogger");
    }

    Notifier(@NonNull String string, int n) {
        super(Notifier.fullOwnerName(string));
        if (string == null) {
            throw new IllegalArgumentException("topic is marked non-null but is null");
        }
        String string2 = this.prefix = "".equals(string) ? "" : string + ".";
        if (n >= 1) {
            this.setLevel(n);
        }
        this.backlog = new QFLogger(Notifier.backlogOwnerName(string));
    }

    private static LogLevels getLevels() {
        return (LogLevels)Reflector.safeCall(Logger.class, "levels", true);
    }

    protected static String fullOwnerName(String string) {
        return "notify." + Notifier.ownerName(string);
    }

    protected static String backlogOwnerName(String string) {
        return "notify-log." + Notifier.ownerName(string);
    }

    private static String ownerName(String string) {
        return "".equals(string) ? "<default>" : string;
    }

    public static Notifier instance(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("topic is marked non-null but is null");
        }
        return Notifier.instance(string, 0);
    }

    private static Notifier instance(@NonNull String string, int n) {
        Notifier notifier;
        if (string == null) {
            throw new IllegalArgumentException("topic is marked non-null but is null");
        }
        Notifier notifier2 = instances.get(string);
        if (notifier2 != null) {
            return notifier2;
        }
        if (n >= 1 && Notifier.getLevels() != null && Notifier.getLevels().getDedicatedLogLevel(Notifier.fullOwnerName(string)) >= 1) {
            n = 0;
        }
        return (notifier2 = instances.putIfAbsent(string, notifier = new Notifier(string, n))) == null ? notifier : notifier2;
    }

    public Notifier postNotification(int n, @NonNull DefaultNotification defaultNotification) {
        if (defaultNotification == null) {
            throw new IllegalArgumentException("notification is marked non-null but is null");
        }
        if (n > this.level) {
            return this;
        }
        String string = defaultNotification.getName();
        defaultNotification.setName(this.prefixNotificationName(string));
        if (9 <= this.backlog.level) {
            this.log((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)this.backlog.lvlBuild(9, string, 0).add("object", defaultNotification.getObject())).add("userInfo", defaultNotification.getUserInfo())).add("postLevel", n));
        }
        this.notificationCenter.postNotification(defaultNotification);
        return this;
    }

    public Notifier postNotification(int n, @NonNull String string, @Nullable Object object, @Nullable Map<String, Object> map) {
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        if (n > this.level) {
            return this;
        }
        string = this.prefixNotificationName(string);
        if (9 <= this.backlog.level) {
            this.log((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)this.backlog.lvlBuild(9, string, 0).add("notificationSender", object)).add("userInfo", map)).add("postLevel", n));
        }
        this.notificationCenter.postNotification(string, object, map);
        return this;
    }

    public Notifier postNotification(int n, @NonNull String string, @Nullable Object object, @Nullable Map<String, Object> map, @Nullable DefaultNotification.ExceptionHandler exceptionHandler) {
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        if (n > this.level) {
            return this;
        }
        string = this.prefixNotificationName(string);
        if (9 <= this.backlog.level) {
            this.log((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)this.backlog.lvlBuild(9, string, 0).add("notificationSender", object)).add("userInfo", map)).add("exceptionHandler", exceptionHandler)).add("postLevel", n));
        }
        this.notificationCenter.postNotification(string, object, map, exceptionHandler);
        return this;
    }

    public Notifier postNotification(int n, @NonNull String string, @Nullable Object object, Object ... objectArray) {
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        if (n > this.level) {
            return this;
        }
        string = this.prefixNotificationName(string);
        if (9 <= this.backlog.level) {
            this.log((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)this.backlog.lvlBuild(9, string).add("notificationSender", object)).add("userInfoKeyValuePairs", objectArray)).add("postLevel", n));
        }
        this.notificationCenter.postNotification(string, object, objectArray);
        return this;
    }

    public Notifier postNotification(int n, @NonNull String string, @Nullable Object object) {
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        if (n > this.level) {
            return this;
        }
        string = this.prefixNotificationName(string);
        if (9 <= this.backlog.level) {
            this.log((LevelAwareLogBuilder)((LevelAwareLogBuilder)this.backlog.lvlBuild(9, string).add("notificationSender", object)).add("postLevel", n));
        }
        this.notificationCenter.postNotification(string, object);
        return this;
    }

    public Notifier postNotification(int n, @NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        if (n > this.level) {
            return this;
        }
        string = this.prefixNotificationName(string);
        if (9 <= this.backlog.level) {
            this.log(this.backlog.lvlBuild(9, string));
        }
        this.notificationCenter.postNotification(string);
        return this;
    }

    protected String prefixNotificationName(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("notificationName is marked non-null but is null");
        }
        if (string.startsWith(this.prefix)) {
            return string;
        }
        return this.prefix + string;
    }

    private void log(LevelAwareLogBuilder levelAwareLogBuilder) {
        if (this.backlog.level % 2 == 1) {
            levelAwareLogBuilder.log();
        } else {
            levelAwareLogBuilder.dumpStack();
        }
    }

    @Deprecated
    public static Notifier defaultInstance() {
        return Default.NOTIFIER;
    }

    public void activate() {
        Logger.setLogLevel(this.getOwnerName(), 10);
    }

    public void deactivate() {
        Logger.setLogLevel(this.getOwnerName(), 0);
    }

    public static void activatePackage(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("pkgName is marked non-null but is null");
        }
        Logger.setLogLevel(Notifier.fullPackage(string), 10);
    }

    public static void activatePackage(@NonNull String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("pkgName is marked non-null but is null");
        }
        Logger.setLogLevel(Notifier.fullPackage(string), n);
    }

    public static void deactivatePackage(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("pkgName is marked non-null but is null");
        }
        Logger.setLogLevel(Notifier.fullPackage(string), 0);
    }

    private static String fullPackage(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("pkgName is marked non-null but is null");
        }
        String string2 = Notifier.fullOwnerName(string);
        if (string2.endsWith(".")) {
            return string2;
        }
        return string2 + ".";
    }

    public static void addObserverForNotifierSpec(@NonNull Observer observer, @NonNull Class<?> clazz) {
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("notifierSpecClass is marked non-null but is null");
        }
        Notifier.addObserverForNotifierSpec(observer, clazz, null);
    }

    public static void addObserverForNotifierSpec(final @NonNull Observer observer, @NonNull Class<?> clazz, final @Nullable Object object) {
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("notifierSpecClass is marked non-null but is null");
        }
        Notifier.iterateOverNotificationNames(clazz, new NotificationNameHandler(){

            @Override
            public void handleNotificationName(String string) {
                DefaultNotificationCenter.instance().addObserver(observer, string, object);
            }
        });
    }

    public static void addWeakObserverForNotifierSpec(@NonNull Observer observer, @NonNull Class<?> clazz) {
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("notifierSpecClass is marked non-null but is null");
        }
        Notifier.addWeakObserverForNotifierSpec(observer, clazz, null);
    }

    public static void addWeakObserverForNotifierSpec(final @NonNull Observer observer, @NonNull Class<?> clazz, final @Nullable Object object) {
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("notifierSpecClass is marked non-null but is null");
        }
        Notifier.iterateOverNotificationNames(clazz, new NotificationNameHandler(){

            @Override
            public void handleNotificationName(String string) {
                DefaultNotificationCenter.instance().addWeakObserver(observer, string, object);
            }
        });
    }

    public static void removeObserverForNotifierSpec(@NonNull Observer observer, @NonNull Class<?> clazz) {
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("notifierSpecClass is marked non-null but is null");
        }
        Notifier.removeObserverForNotifierSpec(observer, clazz, null);
    }

    public static void removeObserverForNotifierSpec(final @NonNull Observer observer, @NonNull Class<?> clazz, final @Nullable Object object) {
        if (observer == null) {
            throw new IllegalArgumentException("observer is marked non-null but is null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("notifierSpecClass is marked non-null but is null");
        }
        Notifier.iterateOverNotificationNames(clazz, new NotificationNameHandler(){

            @Override
            public void handleNotificationName(String string) {
                DefaultNotificationCenter.instance().removeObserver(observer, string, object);
            }
        });
    }

    private static void iterateOverNotificationNames(@NonNull Class<?> clazz, @NonNull NotificationNameHandler notificationNameHandler) {
        if (clazz == null) {
            throw new IllegalArgumentException("notifierSpecClass is marked non-null but is null");
        }
        if (notificationNameHandler == null) {
            throw new IllegalArgumentException("handler is marked non-null but is null");
        }
        Notifier notifier = (Notifier)Reflector.safeGet(clazz, "NOTIFIER");
        if (notifier != null) {
            for (Field field : clazz.getFields()) {
                if (field.getType() != String.class || field.getAnnotation(NotificationName.class) == null) continue;
                String string = (String)Reflector.safeGet(clazz, field.getName());
                notificationNameHandler.handleNotificationName(string);
            }
        }
    }

    @Override
    public LevelAwareLogBuilder lvlBuild(int n, String string) {
        Notifier.throwException();
        return null;
    }

    @Override
    public LevelAwareLogBuilder lvlBuild(int n, String string, int n2) {
        Notifier.throwException();
        return null;
    }

    @Override
    public void log(int n, String string, String string2) {
        Notifier.throwException();
    }

    @Override
    public void log(String string, Throwable throwable) {
        Notifier.throwException();
    }

    @Override
    public void log(String string, Throwable throwable, String string2) {
        Notifier.throwException();
    }

    @Override
    public void log(int n, String string, Throwable throwable) {
        Notifier.throwException();
    }

    @Override
    public void log(int n, String string, Throwable throwable, String string2) {
        Notifier.throwException();
    }

    @Override
    public void dumpStack(int n, String string, String string2) {
        Notifier.throwException();
    }

    @Override
    public Logger.Builder build(String string) {
        Notifier.throwException();
        return null;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    private static interface NotificationNameHandler {
        public void handleNotificationName(String var1);
    }

    public static final class Default {
        static final String TOPIC = "";
        public static final int POST_LEVEL = 1;
        public static final Notifier NOTIFIER = Notifier.setupDefaultNotifier();
    }
}

