/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option;

import de.qfs.lib.option.ChoiceOption;
import de.qfs.lib.option.Option;
import de.qfs.lib.util.Misc;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public class DynamicChoiceOption
extends ChoiceOption {
    LinkedList<LinkedList<String>> choiceOptionNames = new LinkedList();
    Set<String> allChoiceOptionNames = new LinkedHashSet<String>();
    int numchoices;

    public DynamicChoiceOption(@NonNull String string, int n) {
        super(string, n);
        if (string == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        this.initChoiceOptionNames();
    }

    protected void initChoiceOptionNames() {
        String string = this.getName();
        int n = Option.getResources().getInt("option." + string + ".numchoices", 0);
        for (int i = 0; i < n; ++i) {
            LinkedList<Object> linkedList;
            String string2 = Option.getResources().getString("option." + string + ".choice" + (i + 1) + ".choiceoptions", "").trim();
            if (Misc.emptyOrNull(string2)) {
                linkedList = new LinkedList();
            } else {
                String[] stringArray = Misc.fastSplit(string2, ' ');
                linkedList = new LinkedList<String>(Arrays.asList(stringArray));
            }
            this.choiceOptionNames.add(linkedList);
            this.allChoiceOptionNames.addAll(linkedList);
        }
    }

    @Generated
    public LinkedList<LinkedList<String>> getChoiceOptionNames() {
        return this.choiceOptionNames;
    }

    @Generated
    public Set<String> getAllChoiceOptionNames() {
        return this.allChoiceOptionNames;
    }

    @Override
    @Generated
    public int getNumchoices() {
        return this.numchoices;
    }
}

