/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.ConfigurableOption;
import de.qfs.lib.option.Option;
import java.io.File;
import lombok.Generated;

public class FileOption
extends Option
implements ConfigurableOption {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.FileOption");
    static final long serialVersionUID = -8030424147783998707L;
    public static final int ANY_TYPE = 0;
    public static final int FILE_TYPE = 1;
    public static final int DIRECTORY_TYPE = 2;
    private boolean mustExist;
    private int fileType;
    private File defaultFile;

    public FileOption() {
        if (FileOption.logger.level >= 7) {
            logger.lvlBuild(7, "FileOption()", 99).log();
        }
    }

    public FileOption(String string, File file) {
        super(string, file);
        if (FileOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "FileOption(String,File)", 112).addDetail("name", string)).addDetail("value", file)).log();
        }
    }

    public FileOption(String string, File file, boolean bl, boolean bl2, int n) {
        super(string, file, bl);
        if (FileOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "FileOption(String,File,boolean,boolean,int)", 129).addDetail("name", string)).addDetail("value", file)).addDetail("nullOK", bl)).addDetail("mustExist", bl2)).addDetail("fileType", n)).log();
        }
        this.mustExist = bl2;
        this.fileType = n;
    }

    public FileOption(String string, File file, File file2, boolean bl, boolean bl2, int n) {
        this(string, file, bl, bl2, n);
        if (FileOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "FileOption(String,File,File,boolean,boolean,int)", 150).addDetail("name", string)).addDetail("value", file)).addDetail("defaultVal", file2)).addDetail("nullOK", bl)).addDetail("mustExist", bl2)).addDetail("fileType", n)).log();
        }
        this.defaultFile = file2;
    }

    public final boolean isMustExist() {
        return this.mustExist;
    }

    public final void setMustExist(boolean bl) {
        if (FileOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setMustExist(boolean)", 183).addDetail("mustExist", bl)).log();
        }
        this.mustExist = bl;
    }

    public int getFileType() {
        return this.fileType;
    }

    public void setFileType(int n) {
        if (FileOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setFileType(int)", 210).addDetail("fileType", n)).log();
        }
        this.fileType = n;
    }

    @Override
    public Object getValue() {
        Object object = super.getValue();
        if (!(object == null && this.isNullOK() || object instanceof File)) {
            return this.getDefaultValue();
        }
        return object;
    }

    @Override
    public void setValue(Object object) throws IllegalArgumentException {
        if (FileOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setValue(Object)", 245).addDetail("value", object)).log();
        }
        if (object != null && !(object instanceof File)) {
            throw new IllegalArgumentException("Value is not a File: " + object);
        }
        if (this.defaultFile != null && this.defaultFile.equals(object)) {
            super.setValue(null);
        }
        super.setValue(object);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof FileOption && super.equals(object);
    }

    @Override
    public String getValueAsString() {
        File file = (File)this.getValue();
        return file != null ? file.getPath() : "";
    }

    @Override
    public Object getValueFromString(String string) {
        return string.equals("") ? null : new File(string);
    }
}

