/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.StringOption;
import de.qfs.lib.util.Misc;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.Generated;

public class StringArrayOption
extends StringOption {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.StringArrayOption");
    private String[] valueArray = new String[0];

    public StringArrayOption(String string, String string2) {
        this(string, string2, true);
        if (StringArrayOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "StringArrayOption(String,String)", 70).addDetail("name", string)).addDetail("value", string2)).log();
        }
    }

    public StringArrayOption(String string, String string2, boolean bl) {
        super(string, string2, bl);
        if (StringArrayOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "StringArrayOption(String,String,boolean)", 82).addDetail("name", string)).addDetail("value", string2)).addDetail("nullOK", bl)).log();
        }
        this.updateArray(string2);
    }

    @Override
    public boolean contains(String string) {
        if (StringArrayOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "contains(String)", 98).addDetail("value", string)).log();
        }
        if (Misc.emptyOrNull(this.valueArray)) {
            return false;
        }
        return Arrays.asList(this.valueArray).contains(string);
    }

    @Override
    public void setValue(Object object) throws IllegalArgumentException {
        if (StringArrayOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setValue(Object)", 116).addDetail("value", object)).log();
        }
        if (object != null && !(object instanceof String)) {
            throw new IllegalArgumentException("Value is not a String: " + object);
        }
        this.updateArray((String)object);
        super.setValue(object);
    }

    public String[] getArray() {
        if (StringArrayOption.logger.level >= 7) {
            logger.lvlBuild(7, "getArray()", 135).log();
        }
        return this.valueArray;
    }

    private void updateArray(String string) {
        if (StringArrayOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "updateArray(String)", 150).addDetail("value", string)).log();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            for (String string2 : Misc.fastSplit(string, ',')) {
                String string3 = Misc.safeTrimToNull(string2);
                if (Misc.emptyOrNull(string3)) continue;
                arrayList.add(string3);
            }
        }
        this.valueArray = arrayList.toArray(new String[0]);
    }
}

