/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.StringOption;
import de.qfs.lib.util.Misc;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public class StringListOption
extends StringOption {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.StringListOption");
    private final List<String> valueList = Collections.synchronizedList(new LinkedList());

    public StringListOption(String string, String string2) {
        this(string, string2, true);
        if (StringListOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "StringListOption(String,String)", 70).addDetail("name", string)).addDetail("value", string2)).log();
        }
    }

    public StringListOption(String string, String string2, boolean bl) {
        super(string, string2, bl);
        if (StringListOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "StringListOption(String,String,boolean)", 82).addDetail("name", string)).addDetail("value", string2)).addDetail("nullOK", bl)).log();
        }
        this.updateList(string2);
    }

    @Override
    public void setValue(Object object) throws IllegalArgumentException {
        if (StringListOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setValue(Object)", 100).addDetail("value", object)).log();
        }
        if (object != null && !(object instanceof String)) {
            throw new IllegalArgumentException("Value is not a String: " + object);
        }
        this.updateList((String)object);
        super.setValue(object);
    }

    public List<String> getList() {
        if (StringListOption.logger.level >= 7) {
            logger.lvlBuild(7, "getList()", 119).log();
        }
        if (!Misc.emptyOrNull(this.valueList)) {
            return this.valueList;
        }
        return new LinkedList<String>();
    }

    @Override
    public boolean contains(String string) {
        if (StringListOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "contains(String)", 137).addDetail("value", string)).log();
        }
        if (Misc.emptyOrNull(this.valueList)) {
            return false;
        }
        return this.valueList.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateList(String string) {
        if (StringListOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "updateList(String)", 153).addDetail("value", string)).log();
        }
        List<String> list = this.valueList;
        synchronized (list) {
            this.valueList.clear();
            if (string != null) {
                for (String string2 : Misc.fastSplit(string, ',')) {
                    String string3 = Misc.safeTrimToNull(string2);
                    if (string3 == null) continue;
                    this.valueList.add(string3);
                }
            }
        }
    }
}

