/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.StringOption;
import de.qfs.lib.util.Misc;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

public class StringSetOption
extends StringOption {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.StringSetOption");
    private Set<String> valueSet = Collections.synchronizedSet(new HashSet());

    public StringSetOption() {
        if (StringSetOption.logger.level >= 7) {
            logger.lvlBuild(7, "StringSetOption()", 66).log();
        }
    }

    public StringSetOption(String string, String string2) {
        this(string, string2, true);
        if (StringSetOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "StringSetOption(String,String)", 77).addDetail("name", string)).addDetail("value", string2)).log();
        }
    }

    public StringSetOption(String string, String string2, boolean bl) {
        super(string, string2, bl);
        if (StringSetOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "StringSetOption(String,String,boolean)", 89).addDetail("name", string)).addDetail("value", string2)).addDetail("nullOK", bl)).log();
        }
        this.updateSet(string2);
    }

    @Override
    public void setValue(Object object) throws IllegalArgumentException {
        if (StringSetOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setValue(Object)", 107).addDetail("value", object)).log();
        }
        if (object != null && !(object instanceof String)) {
            throw new IllegalArgumentException("Value is not a String: " + object);
        }
        this.updateSet((String)object);
        super.setValue(object);
    }

    @Override
    public boolean contains(String string) {
        if (StringSetOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "contains(String)", 129).addDetail("key", string)).log();
        }
        return this.valueSet.contains(string);
    }

    public Set<String> getKeys() {
        if (StringSetOption.logger.level >= 7) {
            logger.lvlBuild(7, "getKeys()", 142).log();
        }
        if (!Misc.emptyOrNull(this.valueSet)) {
            return this.valueSet;
        }
        return new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSet(String string) {
        if (StringSetOption.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "updateSet(String)", 160).addDetail("value", string)).log();
        }
        Set<String> set = this.valueSet;
        synchronized (set) {
            this.valueSet.clear();
            if (string != null) {
                for (String string2 : Misc.fastSplit(string, ',')) {
                    String string3 = Misc.safeTrimToNull(string2);
                    if (string3 == null) continue;
                    this.valueSet.add(string3);
                }
            }
        }
    }
}

