/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.gui.PopupHandler;
import de.qfs.lib.gui.PopupManager;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.BooleanOption;
import de.qfs.lib.option.LabelOption;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.edit.BooleanOptionEdit;
import de.qfs.lib.option.edit.KeyOptionEdit;
import de.qfs.lib.option.edit.OptionEdit;
import de.qfs.lib.option.group.OptionGroup;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import lombok.Generated;

public class IncrementalSearch
implements DocumentListener,
PopupMenuListener,
ActionListener,
KeyListener,
PopupHandler,
ItemListener {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.edit.IncrementalSearch");
    static final int OUTER_LOOP_SIZE = 100;
    static final int INNER_LOOP_SIZE = 100;
    protected JTextComponent text;
    protected String content;
    protected int contentStart;
    protected Matcher matcher;
    protected Stack<Pair<Integer, Integer>> history;
    protected ArrayList<Pair<Integer, Integer>> matches;
    protected int matchIndex;
    protected boolean ignoreCase;
    protected boolean regexp;
    protected int flags = 8;
    protected boolean reverse;
    protected boolean overwrap;
    protected boolean highlight;
    protected Action actionIsearch;
    protected Action actionIsearchRegion;
    protected KeyStroke isearchKeyStroke;
    protected KeyStroke isearchRegionKeyStroke;
    protected Timer delayTimer;
    private boolean noSearchYet;
    protected JPopupMenu popup;
    protected JTextField searchField;
    protected static OptionSet staticOptions;
    protected OptionGroup optionGroup;
    private JCheckBox moreCheckBox;
    public static final Color DEFAULT_ISEARCH_HIGHLIGHTING_COLOR;
    protected Color highlightingColor = DEFAULT_ISEARCH_HIGHLIGHTING_COLOR;
    public static final Color DEFAULT_ISEARCH_REGION_HIGHLIGHTING_COLOR;
    private boolean searchRegion;
    protected Color regionHighlightingColor = DEFAULT_ISEARCH_REGION_HIGHLIGHTING_COLOR;
    protected Object regionHighlight;
    public static final Color DEFAULT_ISEARCH_NO_HIT_COLOR;
    protected Color origSearchFieldBackgroundColor;
    protected Color searchFieldNoHitColor = DEFAULT_ISEARCH_NO_HIT_COLOR;
    protected Thread searchThread;
    protected boolean abortSearching;

    public IncrementalSearch(final JTextComponent jTextComponent) {
        this();
        if (IncrementalSearch.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "IncrementalSearch(JTextComponent)", 286).addDetail("text", jTextComponent)).log();
        }
        this.text = jTextComponent;
        this.actionIsearch = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IncrementalSearch.this.showIsearchPopup(jTextComponent, false);
            }
        };
        this.text.registerKeyboardAction(this.actionIsearch, "Isearch", this.isearchKeyStroke, 0);
        this.actionIsearchRegion = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IncrementalSearch.this.getSelectedText() != null) {
                    IncrementalSearch.this.showIsearchPopup(jTextComponent, true);
                }
            }
        };
        this.text.registerKeyboardAction(this.actionIsearchRegion, "IsearchRegion", this.isearchRegionKeyStroke, 0);
    }

    public IncrementalSearch() {
        this.isearchKeyStroke = KeyOptionEdit.getKeyStrokeForResource("option.isearch");
        this.isearchRegionKeyStroke = KeyOptionEdit.getKeyStrokeForResource("option.isearchregion");
        this.initPopup();
    }

    public void showIsearchPopup(Component component, boolean bl) {
        if (IncrementalSearch.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "showIsearchPopup(Component,boolean)", 340).addDetail("parent", component)).addDetail("bSearchRegion", bl)).log();
        }
        SwingUtilities.updateComponentTreeUI(this.popup);
        if (!this.popup.isVisible()) {
            this.initSearch(bl);
        }
        if (component != null) {
            if (component.getParent() instanceof JViewport && (component = component.getParent()).getParent() instanceof JScrollPane) {
                component = component.getParent();
            }
            if (IncrementalSearch.logger.level >= 10) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(10, "showIsearchPopup(Component,boolean)", 354).add("Parent for popup")).add(component)).log();
            }
            this.optionGroup.update(staticOptions);
            boolean bl2 = staticOptions.getBoolean("isearch.more", false);
            if (!bl2) {
                this.initAdvancedStaticOptions();
            }
            OptionEdit optionEdit = this.optionGroup.findEdit("isearch.reverse");
            optionEdit.getParent().setVisible(bl2);
            int n = component.getSize().width - this.popup.getPreferredSize().width;
            int n2 = this.popup.getPreferredSize().height * -1;
            if (IncrementalSearch.logger.level >= 10) {
                ((LevelAwareLogBuilder)logger.lvlBuild(10, "showIsearchPopup(Component,boolean)", 367).add("Show pupup")).log();
            }
            this.popup.setSize(this.popup.getPreferredSize());
            this.popup.setVisible(false);
            this.popup.show(component, n, n2);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IncrementalSearch.this.searchField.requestFocus();
                }
            });
        }
    }

    public KeyStroke getKeyStroke() {
        return this.isearchKeyStroke;
    }

    public KeyStroke getRegionKeyStroke() {
        return this.isearchRegionKeyStroke;
    }

    protected Document getDocument() {
        return this.text.getDocument();
    }

    protected String getText() {
        return this.text.getText();
    }

    protected JComponent getTextComponent() {
        return this.text;
    }

    protected String getSelectedText() {
        return this.text.getSelectedText();
    }

    protected Pair<Integer, Integer> getCaret() {
        if (IncrementalSearch.logger.level >= 7) {
            logger.lvlBuild(7, "getCaret()", 483).log();
        }
        int n = this.text.getCaret().getMark();
        int n2 = this.text.getCaret().getDot();
        if (n2 > n) {
            return new Pair<Integer, Integer>(n, n2);
        }
        return new Pair<Integer, Integer>(n2, n);
    }

    protected void setCaret(Pair<Integer, Integer> pair) {
        if (IncrementalSearch.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setCaret(Pair<Integer, Integer>)", 502).addDetail("position", pair)).log();
        }
        int n = pair.getFirst();
        int n2 = pair.getSecond();
        this.text.getCaret().setDot(n + this.getContentStart());
        this.text.getCaret().moveDot(n2 + this.getContentStart());
        this.text.getCaret().setSelectionVisible(true);
        this.scrollCaretToCenterLine();
    }

    protected void scrollCaretToCenterLine() {
        if (this.text != null && this.text.getParent() instanceof JViewport) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Point point = ((DefaultCaret)IncrementalSearch.this.text.getCaret()).getLocation();
                    int n = ((DefaultCaret)IncrementalSearch.this.text.getCaret()).width;
                    int n2 = ((DefaultCaret)IncrementalSearch.this.text.getCaret()).height;
                    int n3 = IncrementalSearch.this.text.getParent().getHeight();
                    Rectangle rectangle = new Rectangle(point.x, point.y + n2 / 2 - n3 / 2, n, n3);
                    IncrementalSearch.this.text.scrollRectToVisible(rectangle);
                }
            });
        }
    }

    public void highlight(int n, int n2) {
        block4: {
            Highlighter highlighter;
            if (IncrementalSearch.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "highlight(int,int)", 549).addDetail("start", n)).addDetail("end", n2)).log();
            }
            if ((highlighter = this.getHighlighter()) instanceof DefaultHighlighter) {
                try {
                    highlighter.addHighlight(n, n2, new DefaultHighlighter.DefaultHighlightPainter(this.getHighlightingColor()));
                }
                catch (BadLocationException badLocationException) {
                    if (IncrementalSearch.logger.level < 3) break block4;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "highlight(int,int)", 558).add("ex", badLocationException)).log();
                }
            }
        }
    }

    public void dehighlight() {
        if (IncrementalSearch.logger.level >= 7) {
            logger.lvlBuild(7, "dehighlight()", 569).log();
        }
        if (this.getHighlighter() != null) {
            this.getHighlighter().removeAllHighlights();
        }
        this.regionHighlight = null;
    }

    public void regionHighlight(int n, int n2) {
        block4: {
            Highlighter highlighter;
            if (IncrementalSearch.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "regionHighlight(int,int)", 586).addDetail("start", n)).addDetail("end", n2)).log();
            }
            if ((highlighter = this.getHighlighter()) instanceof DefaultHighlighter) {
                try {
                    this.regionHighlight = highlighter.addHighlight(n, n2, new DefaultHighlighter.DefaultHighlightPainter(this.getRegionHighlightingColor()));
                }
                catch (BadLocationException badLocationException) {
                    if (IncrementalSearch.logger.level < 3) break block4;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "regionHighlight(int,int)", 595).add("ex", badLocationException)).log();
                }
            }
        }
    }

    public void removeRegionHighlight() {
        Highlighter highlighter;
        if (IncrementalSearch.logger.level >= 7) {
            logger.lvlBuild(7, "removeRegionHighlight()", 606).log();
        }
        if ((highlighter = this.getHighlighter()) instanceof DefaultHighlighter && this.regionHighlight != null) {
            highlighter.removeHighlight(this.regionHighlight);
        }
    }

    protected void initPopup() {
        if (IncrementalSearch.logger.level >= 7) {
            logger.lvlBuild(7, "initPopup()", 626).log();
        }
        this.popup = new JPopupMenu();
        if (staticOptions == null) {
            this.initStaticOptions();
        }
        this.optionGroup = OptionGroup.makeGroup("isearch", staticOptions);
        if (this.optionGroup != null) {
            OptionEdit optionEdit;
            OptionGroup optionGroup = this.optionGroup.findGroup("isearch.advanced");
            if (optionGroup != null) {
                for (int i = 0; i < optionGroup.getMemberCount(); ++i) {
                    ((BooleanOptionEdit)optionGroup.getMember(i)).getCheckBox().addItemListener(this);
                }
            }
            if ((optionEdit = this.optionGroup.findEdit("isearch.more")) != null) {
                this.moreCheckBox = ((BooleanOptionEdit)optionEdit).getCheckBox();
                if (this.moreCheckBox != null) {
                    this.moreCheckBox.addItemListener(this);
                }
            }
            this.popup.add("Center", this.optionGroup.getComponent());
        }
        this.searchField = new JTextField(10){

            @Override
            public void updateUI() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "initPopup().JTextField.updateUI()", 659).log();
                }
                super.updateUI();
                IncrementalSearch.this.origSearchFieldBackgroundColor = UIManager.getColor("TextField.background");
            }
        };
        this.searchField.setName("searchField");
        this.origSearchFieldBackgroundColor = this.searchField.getBackground();
        this.popup.add("South", this.searchField);
        this.popup.addPopupMenuListener(this);
    }

    protected void initStaticOptions() {
        staticOptions = new OptionSet("isearch.set");
        staticOptions.add(new LabelOption("isearch.titletext"));
        staticOptions.add(new BooleanOption("isearch.more", false));
        this.initAdvancedStaticOptions();
    }

    private void initAdvancedStaticOptions() {
        staticOptions.add(new BooleanOption("isearch.reverse", false));
        staticOptions.add(new BooleanOption("isearch.ignorecase", true));
        staticOptions.add(new BooleanOption("isearch.regexp", false));
        staticOptions.add(new BooleanOption("isearch.highlight", true));
        staticOptions.add(new BooleanOption("isearch.overwrap", false));
    }

    protected void initSearch(boolean bl) {
        if (IncrementalSearch.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "initSearch(boolean)", 708).addDetail("bSearchRegion", bl)).log();
        }
        this.searchRegion = bl;
        this.history = null;
        this.matches = null;
        this.setContentStart(0);
        if (!this.searchRegion && this.getSelectedText() != null) {
            this.searchField.setText(this.getSelectedText());
            this.searchField.selectAll();
        } else if (this.searchField.getText() != null) {
            this.searchField.selectAll();
        }
        this.dehighlight();
        this.setContent();
    }

    protected void setContent() {
        block9: {
            if (IncrementalSearch.logger.level >= 7) {
                logger.lvlBuild(7, "setContent()", 736).log();
            }
            int n = 0;
            try {
                int n2 = this.getCaret().getFirst();
                int n3 = this.getCaret().getSecond();
                if (!this.searchRegion) {
                    this.setContentStart(0);
                    n = this.getDocument().getLength() - this.getContentStart();
                    this.content = this.getDocument().getText(this.getContentStart(), n);
                    this.storeHistory(new Pair<Integer, Integer>(this.getCaret().getFirst(), this.getCaret().getFirst()));
                } else {
                    this.setContentStart(n2);
                    n = n3 - n2;
                    this.content = this.getDocument().getText(n2, n);
                    this.storeHistory(new Pair<Integer, Integer>(this.getCaret().getFirst(), this.getCaret().getFirst()));
                }
            }
            catch (BadLocationException badLocationException) {
                if (IncrementalSearch.logger.level >= 3) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "setContent()", 754).add("ex", badLocationException)).log();
                }
            }
            catch (Throwable throwable) {
                if (IncrementalSearch.logger.level < 1) break block9;
                logger.lvlBuild(1, "setContent()", 756).log();
            }
        }
        if (this.content == null) {
            this.content = this.getText();
            this.setContentStart(0);
        }
        if (IncrementalSearch.logger.level >= 10) {
            ((LevelAwareLogBuilder)logger.lvlBuild(10, "setContent()", 763).add("content", this.content)).log();
        }
        this.resetHighlights();
    }

    protected void delayedNewSearch(final boolean bl) {
        if (IncrementalSearch.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "delayedNewSearch(boolean)", 776).addDetail("fromCurrentPosition", bl)).log();
        }
        this.noSearchYet = false;
        if (this.delayTimer == null) {
            this.delayTimer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    IncrementalSearch.this.runNewSearch(bl);
                }
            });
            this.delayTimer.setRepeats(false);
        }
        this.delayTimer.restart();
    }

    protected void runNewSearch(boolean bl) {
        if (IncrementalSearch.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "runNewSearch(boolean)", 804).addDetail("fromCurrentPosition", bl)).log();
        }
        if (this.isDuringAbortSearching()) {
            this.delayedNewSearch(bl);
            return;
        }
        this.noSearchYet = false;
        this.searchField.setBackground(this.origSearchFieldBackgroundColor);
        int n = 0;
        if (bl && this.history != null && !this.history.isEmpty()) {
            Pair<Integer, Integer> pair = this.history.peek();
            n = pair.getFirst();
        }
        this.matches = null;
        this.optionGroup.readValues();
        this.ignoreCase = staticOptions.getBoolean("isearch.ignorecase", false);
        this.flags = this.ignoreCase ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        this.regexp = staticOptions.getBoolean("isearch.regexp", false);
        this.reverse = staticOptions.getBoolean("isearch.reverse", false);
        this.highlight = staticOptions.getBoolean("isearch.highlight", false);
        this.overwrap = staticOptions.getBoolean("isearch.overwrap", false);
        this.getFirstMatchAndHighlight(n);
    }

    protected void continueSearch() {
        if (IncrementalSearch.logger.level >= 7) {
            logger.lvlBuild(7, "continueSearch()", 846).log();
        }
        if (this.isDuringAbortSearching()) {
            return;
        }
        if (this.optionGroup.isModified()) {
            this.optionGroup.readValues();
            this.runNewSearch(true);
            return;
        }
        if (this.noSearchYet) {
            this.runNewSearch(true);
            return;
        }
        if (this.history == null || this.history.isEmpty()) {
            this.runNewSearch(false);
            return;
        }
        Pair<Integer, Integer> pair = this.getNextMatch();
        if (pair != null && (this.overwrap || !this.history.peek().equals(pair))) {
            this.storeHistory(pair);
            this.setCaret(pair);
        }
    }

    protected void getFirstMatchAndHighlight(final int n) {
        if (IncrementalSearch.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getFirstMatchAndHighlight(int)", 888).addDetail("startingFrom", n)).log();
        }
        this.matches = null;
        this.matchIndex = -1;
        this.resetHighlights();
        if (this.getQuery().length() > 0) {
            String string;
            block6: {
                boolean bl = true;
                string = this.getQuery();
                if (this.regexp) {
                    try {
                        Pattern pattern = Pattern.compile(string, this.flags);
                        this.matcher = pattern.matcher(this.getContent());
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        return;
                    }
                    catch (Exception exception) {
                        if (IncrementalSearch.logger.level < 1) break block6;
                        ((LevelAwareLogBuilder)logger.lvlBuild(1, "getFirstMatchAndHighlight(int)", 908).add("ex", exception)).log();
                    }
                }
            }
            this.searchThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Pair<Integer, Integer> pair = null;
                    int n6 = 0;
                    boolean bl = false;
                    boolean bl2 = false;
                    IncrementalSearch.this.abortSearching = false;
                    for (int i = 0; i < 100; ++i) {
                        int n2;
                        if (IncrementalSearch.this.abortSearching) {
                            if (logger.level < 8) break;
                            ((LevelAwareLogBuilder)logger.lvlBuild(8, "getFirstMatchAndHighlight(int).Thread.Runnable.run()", 925).add("searching abborted...")).log();
                            break;
                        }
                        if (bl2) {
                            if (IncrementalSearch.this.matches == null || IncrementalSearch.this.matchIndex < 0) break;
                            if (IncrementalSearch.this.reverse && IncrementalSearch.this.matchIndex == 0) {
                                IncrementalSearch.this.matchIndex = IncrementalSearch.this.matches.size() - 1;
                            }
                            pair = IncrementalSearch.this.matches.get(IncrementalSearch.this.matchIndex);
                            IncrementalSearch.this.storeHistory(pair);
                            final Pair<Integer, Integer> pair2 = pair;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    IncrementalSearch.this.setCaret(pair2);
                                }
                            });
                            break;
                        }
                        for (n2 = 0; n2 < 100; ++n2) {
                            boolean bl3 = false;
                            int n3 = -1;
                            int n4 = -1;
                            if (n6 < IncrementalSearch.this.getContent().length()) {
                                if (IncrementalSearch.this.regexp) {
                                    if (IncrementalSearch.this.matcher != null && IncrementalSearch.this.matcher.find(n6)) {
                                        bl3 = true;
                                        n3 = IncrementalSearch.this.matcher.start();
                                        n4 = IncrementalSearch.this.matcher.end();
                                    }
                                } else {
                                    String string2 = IncrementalSearch.this.getContent().substring(n6, IncrementalSearch.this.getContent().length());
                                    string2 = string2.replaceAll("\u00a0", " ");
                                    int n5 = (IncrementalSearch.this.ignoreCase ? string2.toLowerCase() : string2).indexOf(IncrementalSearch.this.ignoreCase ? string.toLowerCase() : string);
                                    if (n5 >= 0) {
                                        bl3 = true;
                                        n3 = n6 + n5;
                                        n4 = n6 + n5 + string.length();
                                    }
                                }
                            }
                            if (bl3) {
                                if (IncrementalSearch.this.matches == null) {
                                    IncrementalSearch.this.matches = new ArrayList();
                                }
                                IncrementalSearch.this.matches.add(new Pair<Integer, Integer>(n3, n4));
                                if (!bl && n3 >= n || IncrementalSearch.this.reverse && n4 < n) {
                                    bl = true;
                                    IncrementalSearch.this.matchIndex = IncrementalSearch.this.matches.size() - 1;
                                }
                            } else {
                                bl2 = true;
                                break;
                            }
                            n6 = n3 + 1;
                        }
                        if (!IncrementalSearch.this.highlight || IncrementalSearch.this.matches == null) continue;
                        n2 = i * 100;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                for (int i = n2; i < n2 + 100 && i < IncrementalSearch.this.matches.size(); ++i) {
                                    Pair<Integer, Integer> pair = IncrementalSearch.this.matches.get(i);
                                    int n = pair.getFirst();
                                    int n22 = pair.getSecond();
                                    IncrementalSearch.this.highlight(n, n22);
                                }
                            }
                        });
                    }
                    if (pair == null && !IncrementalSearch.this.abortSearching) {
                        if (UIManager.getColor("highlightErrorColor") != null) {
                            IncrementalSearch.this.searchField.setBackground(new Color(UIManager.getColor("highlightErrorColor").getRGB()));
                        } else {
                            IncrementalSearch.this.searchField.setBackground(IncrementalSearch.this.searchFieldNoHitColor);
                        }
                    }
                    if (logger.level >= 8) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(8, "getFirstMatchAndHighlight(int).Thread.Runnable.run()", 1027).add("firstMatch", pair)).log();
                    }
                    IncrementalSearch.this.abortSearching = false;
                }
            });
            this.searchThread.start();
        }
    }

    protected Pair<Integer, Integer> getNextMatch() {
        if (IncrementalSearch.logger.level >= 7) {
            logger.lvlBuild(7, "getNextMatch()", 1043).log();
        }
        Pair<Integer, Integer> pair = null;
        if (this.matches != null) {
            if (this.reverse) {
                if (this.matchIndex > 0) {
                    --this.matchIndex;
                } else if (this.overwrap) {
                    this.matchIndex = this.matches.size() - 1;
                }
            } else if (this.matchIndex < this.matches.size() - 1) {
                ++this.matchIndex;
            } else if (this.overwrap) {
                this.matchIndex = 0;
            }
            pair = this.matches.get(this.matchIndex);
        }
        return pair;
    }

    protected boolean maybeAbortSearching() {
        if (this.searchThread != null && this.searchThread.isAlive()) {
            this.abortSearching = true;
            return true;
        }
        return false;
    }

    protected boolean isDuringAbortSearching() {
        return this.abortSearching && this.searchThread != null && this.searchThread.isAlive();
    }

    protected String getContent() {
        return this.content;
    }

    protected int getContentStart() {
        return this.contentStart;
    }

    protected void setContentStart(int n) {
        this.contentStart = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int matchHit(String string, String string2) {
        int n = 0;
        if (this.regexp) {
            try {
                Pattern pattern = Pattern.compile(string, this.flags);
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.find(0)) return n;
                if (matcher.start() != 0) return n;
                if (matcher.end() != string.length()) return 2;
                return 1;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return 0;
            }
            catch (Exception exception) {
                if (IncrementalSearch.logger.level < 1) return n;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "matchHit(String,String)", 1181).add("ex", exception)).log();
                return n;
            }
        } else {
            String string3 = this.ignoreCase ? string2.toLowerCase() : string2;
            if ((this.ignoreCase ? string.toLowerCase() : string).equals(string3 = string3.replaceAll("\u00a0", " "))) {
                return 1;
            }
            if (!(this.ignoreCase ? string.toLowerCase() : string).startsWith(string3)) return n;
            return 2;
        }
    }

    protected String getQuery() {
        return this.searchField.getText();
    }

    protected void storeHistory(Pair<Integer, Integer> pair) {
        if (IncrementalSearch.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "storeHistory(Pair<Integer, Integer>)", 1218).addDetail("hit", pair)).log();
        }
        if (pair != null) {
            if (this.history == null) {
                this.history = new Stack();
            }
            if (!this.history.isEmpty()) {
                Pair<Integer, Integer> pair2 = this.history.peek();
                if (!pair.equals(pair2)) {
                    this.history.push(pair);
                }
            } else {
                this.history.push(pair);
            }
        }
    }

    protected Highlighter getHighlighter() {
        if (this.text != null) {
            return this.text.getHighlighter();
        }
        return null;
    }

    protected Color getHighlightingColor() {
        if (UIManager.getColor("searchHighlight") != null) {
            return UIManager.getColor("searchHighlight");
        }
        return this.highlightingColor;
    }

    protected Color getRegionHighlightingColor() {
        return this.regionHighlightingColor;
    }

    protected void resetHighlights() {
        if (IncrementalSearch.logger.level >= 7) {
            logger.lvlBuild(7, "resetHighlights()", 1294).log();
        }
        this.dehighlight();
        if (this.searchRegion) {
            this.regionHighlight(this.getContentStart(), this.getContentStart() + this.getContent().length());
        }
    }

    protected void resetCaret() {
        if (IncrementalSearch.logger.level >= 7) {
            logger.lvlBuild(7, "resetCaret()", 1307).log();
        }
        this.setCaret(new Pair<Integer, Integer>(0, 0));
    }

    protected boolean stepBack() {
        if (IncrementalSearch.logger.level >= 7) {
            logger.lvlBuild(7, "stepBack()", 1320).log();
        }
        boolean bl = true;
        if (this.history == null || this.history.isEmpty()) {
            bl = true;
        } else if (this.history.size() == 1) {
            this.history.pop();
            this.matchIndex = this.reverse ? ++this.matchIndex : --this.matchIndex;
            this.resetHighlights();
            bl = true;
        } else {
            Pair<Integer, Integer> pair = this.history.peek();
            int n = pair.getFirst();
            int n2 = pair.getSecond();
            String string = this.getContent().substring(n, n2);
            switch (this.matchHit(this.getQuery(), string)) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1: {
                    this.history.pop();
                    this.matchIndex = this.reverse ? ++this.matchIndex : --this.matchIndex;
                    Pair<Integer, Integer> pair2 = this.history.peek();
                    int n3 = pair2.getFirst();
                    int n4 = pair2.getSecond();
                    int n5 = n2 - n;
                    int n6 = n4 - n3;
                    if (n6 != n5) {
                        bl = true;
                        break;
                    }
                    this.setCaret(pair2);
                    bl = false;
                    break;
                }
                case 2: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        if (IncrementalSearch.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "popupMenuWillBecomeVisible(PopupMenuEvent)", 1383).addDetail("e", popupMenuEvent)).log();
        }
        this.searchField.getDocument().addDocumentListener(this);
        this.searchField.addActionListener(this);
        this.searchField.addKeyListener(this);
        this.searchField.setBackground(this.origSearchFieldBackgroundColor);
        this.noSearchYet = true;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        if (IncrementalSearch.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "popupMenuWillBecomeInvisible(PopupMenuEvent)", 1396).addDetail("e", popupMenuEvent)).log();
        }
        this.searchField.getDocument().removeDocumentListener(this);
        this.searchField.removeActionListener(this);
        this.searchField.removeKeyListener(this);
        this.removeRegionHighlight();
        this.optionGroup.readValues();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        block3: {
            if (IncrementalSearch.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "insertUpdate(DocumentEvent)", 1423).addDetail("e", documentEvent)).log();
            }
            try {
                this.delayedNewSearch(true);
            }
            catch (Throwable throwable) {
                if (IncrementalSearch.logger.level < 1) break block3;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "insertUpdate(DocumentEvent)", 1428).add("ex", throwable)).log();
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        block3: {
            if (IncrementalSearch.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeUpdate(DocumentEvent)", 1436).addDetail("e", documentEvent)).log();
            }
            try {
                this.delayedNewSearch(true);
            }
            catch (Throwable throwable) {
                if (IncrementalSearch.logger.level < 1) break block3;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "removeUpdate(DocumentEvent)", 1441).add("ex", throwable)).log();
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        block3: {
            if (IncrementalSearch.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "changedUpdate(DocumentEvent)", 1449).addDetail("e", documentEvent)).log();
            }
            try {
                this.delayedNewSearch(true);
            }
            catch (Throwable throwable) {
                if (IncrementalSearch.logger.level < 1) break block3;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "changedUpdate(DocumentEvent)", 1454).add("ex", throwable)).log();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block4: {
            if (IncrementalSearch.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "actionPerformed(ActionEvent)", 1466).addDetail("e", actionEvent)).log();
            }
            try {
                if (!(this.delayTimer != null && this.delayTimer.isRunning() || this.searchThread != null && this.searchThread.isAlive())) {
                    this.continueSearch();
                }
            }
            catch (Throwable throwable) {
                if (IncrementalSearch.logger.level < 1) break block4;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "actionPerformed(ActionEvent)", 1479).add("ex", throwable)).log();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (IncrementalSearch.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "itemStateChanged(ItemEvent)", 1496).addDetail("e", itemEvent)).log();
        }
        if (itemEvent.getSource() == this.moreCheckBox) {
            Component component = this.popup.getInvoker();
            if (component != null) {
                this.optionGroup.readValues();
                this.showIsearchPopup(component, false);
            }
        } else {
            this.searchField.requestFocus();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.popup.setVisible(false);
            this.maybeAbortSearching();
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 8) {
            if (this.history != null) {
                if (this.stepBack()) {
                    this.delayedNewSearch(true);
                } else {
                    keyEvent.consume();
                }
            }
        } else if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 33 || keyEvent.getKeyCode() == 34) {
            this.getTextComponent().dispatchEvent(keyEvent);
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public boolean fillPopup(PopupManager popupManager, Component component, JPopupMenu jPopupMenu, MapResourceBundle mapResourceBundle, int n, int n2, boolean bl) {
        if (component instanceof JTextComponent) {
            popupManager.setupAction(this.actionIsearch, mapResourceBundle, "popup.isearch");
            JMenuItem jMenuItem = popupManager.createMenuItem("isearch", mapResourceBundle, "popup.isearch", (ActionListener)this.actionIsearch, true);
            jMenuItem.setAccelerator(this.isearchKeyStroke);
            popupManager.addSeparator(-1, "");
            popupManager.addMenuItem(jMenuItem, -1, "");
            popupManager.setupAction(this.actionIsearchRegion, mapResourceBundle, "popup.isearchregion");
            jMenuItem = popupManager.createMenuItem("isearchregion", mapResourceBundle, "popup.isearchregion", (ActionListener)this.actionIsearchRegion, true);
            jMenuItem.setAccelerator(this.isearchRegionKeyStroke);
            popupManager.addMenuItem(jMenuItem, -1, "");
            if (this.getSelectedText() != null) {
                jMenuItem.setEnabled(true);
            } else {
                jMenuItem.setEnabled(false);
            }
            return true;
        }
        return false;
    }

    static {
        DEFAULT_ISEARCH_HIGHLIGHTING_COLOR = OptionEdit.DEFAULT_HIGHLIGHTING_COLOR;
        DEFAULT_ISEARCH_REGION_HIGHLIGHTING_COLOR = new Color(255, 255, 0, 46);
        DEFAULT_ISEARCH_NO_HIT_COLOR = new Color(223, 195, 195);
    }
}

