/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.gui.Message;
import de.qfs.lib.gui.PopupManager;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.edit.OptionEdit;
import de.qfs.lib.option.edit.SimpleOptionEdit;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTextField;
import lombok.Generated;

public class IntegerOptionEdit
extends SimpleOptionEdit {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.edit.IntegerOptionEdit");

    @Override
    public void init() {
        super.init();
        this.text = new JTextField(){

            @Override
            public boolean isFocusTraversable() {
                return this.isEditable() && this.isEnabled();
            }

            @Override
            public boolean isFocusable() {
                return true;
            }
        };
        this.label.setLabelFor(this.text);
        this.text.setName("Text-" + this.option.getName());
        this.add((Component)this.text, "Center");
        if (this.selectOnFocus && !this.disabled) {
            this.text.addFocusListener(this);
        }
        if (this.option.getValue() != null) {
            this.text.setText(this.option.getValue().toString());
            this.text.setCaretPosition(0);
        }
        this.text.setPreferredSize(new Dimension(10, this.text.getPreferredSize().height));
        if (this.disabled) {
            this.setEnabled(false);
        }
        if (this.readonly) {
            this.setEditable(false);
        }
        if (this.canPopup) {
            PopupManager.instance().registerPopupHandler(PopupManager.instance(), this.text);
        }
        this.maybeCommonPostInitSteps();
    }

    @Override
    public boolean checkValue() {
        String string = this.text.getText();
        Integer n = null;
        if (!string.equals("")) {
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                Message.showMessageAndHighlight(this, "option.error.notANumber");
                if (!OptionEdit.isHighlightOnCheckOnly()) {
                    this.text.requestFocus();
                }
                return false;
            }
        }
        if (!this.option.checkValue(this, n)) {
            if (!OptionEdit.isHighlightOnCheckOnly()) {
                this.text.requestFocus();
            }
            return false;
        }
        this.dehighlight();
        return true;
    }

    @Override
    public void readValue() {
        Integer n;
        block4: {
            if (IntegerOptionEdit.logger.level >= 7) {
                logger.lvlBuild(7, "readValue()", 206).log();
            }
            String string = this.text.getText();
            n = null;
            if (!string.equals("")) {
                try {
                    n = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (IntegerOptionEdit.logger.level < 1) break block4;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "readValue()", 214).add("ex", numberFormatException)).add("Should have called checkValue")).log();
                }
            }
        }
        this.option.setValue(n);
    }
}

