/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.KeyOption;
import de.qfs.lib.option.KeyOptionsState;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.edit.OptionEdit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lombok.Generated;
import lombok.NonNull;

public class KeyOptionEdit
extends OptionEdit
implements KeyListener {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.edit.KeyOptionEdit");
    private static final Color COLOR_FOCUS_BORDER = new Color(82, 92, 102);
    private static final Color COLOR_DEFAULT_BORDER = new Color(150, 150, 150);
    protected JLabel label;
    protected String ilabel;
    protected KeyLabel key;
    protected int keyCode;
    protected char keyChar = (char)65535;
    protected int modifiers;
    protected Vector listeners = new Vector();

    @Override
    public void init() {
        boolean bl;
        this.setLayout(new BorderLayout());
        this.disabled = this.getBoolean("disabled", false);
        this.ilabel = this.getString("label", "");
        this.label = new OptionEdit.OptionJLabel(this.ilabel);
        if (this.ilabel.length() > 0) {
            this.ilabel = this.ilabel + " ";
        }
        this.label.setName("Label-" + this.option.getName());
        String string = this.getString("mnemonic", null);
        if (string != null && string.length() > 0) {
            this.label.setDisplayedMnemonic(string.charAt(0));
        }
        if (!(bl = this.getBoolean("internal", false))) {
            this.add((Component)this.label, "North");
            this.ilabel = "";
        }
        this.key = new KeyLabel(this.getBoolean("capturetab", false));
        this.key.setName("Key-" + this.option.getName());
        if (bl) {
            if (string != null && string.length() > 0) {
                this.key.setDisplayedMnemonic(string.charAt(0));
            }
            this.key.setLabelFor(this.key);
        } else {
            this.label.setLabelFor(this.key);
        }
        this.key.setForeground(UIManager.getColor("textText"));
        this.key.addKeyListener(this);
        this.add((Component)this.key, "Center");
        if (this.option.getValue() instanceof KeyOption.Data) {
            KeyOption.Data data = (KeyOption.Data)this.option.getValue();
            this.keyCode = data.keyCode;
            this.keyChar = data.keyChar;
            this.modifiers = data.modifiers;
        }
        this.key.setValues(this.ilabel, this.keyCode, this.keyChar, this.modifiers);
        if (this.disabled) {
            this.setEnabled(false);
        }
    }

    @Override
    public void updateUI() {
        if (KeyOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "updateUI()", 230).log();
        }
        super.updateUI();
        if (this.key != null) {
            this.key.setBackground(null);
            this.key.updateUI();
            this.origBackgroundColor = this.key.getBackground();
        }
    }

    @Override
    public boolean isModified() {
        boolean bl;
        if (KeyOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "isModified()", 252).log();
        }
        if (KeyOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "isModified()", 254).add("keyCode", this.keyCode)).log();
        }
        if (KeyOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "isModified()", 255).add("keyChar", (int)this.keyChar)).log();
        }
        if (KeyOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "isModified()", 256).add("option.getValue()", this.option.getValue())).log();
        }
        boolean bl2 = bl = this.keyCode == 0 && this.keyChar == '\uffff' && this.option.getValue() != null || (this.keyCode != 0 || this.keyChar != '\uffff') && !this.getHotkey().equals(this.option.getValue());
        if (KeyOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "isModified()", 260).add("ret", bl)).log();
        }
        return bl;
    }

    @NonNull
    public KeyOption.Data getHotkey() {
        if (KeyOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "getHotkey()", 268).log();
        }
        return new KeyOption.Data(this.keyCode, this.keyChar, this.modifiers);
    }

    @Override
    public boolean checkValue() {
        KeyOption.Data data = this.getHotkey();
        if (!this.option.checkValue(this, data)) {
            if (!OptionEdit.isHighlightOnCheckOnly()) {
                this.key.requestFocus();
            }
            return false;
        }
        if (!data.isUndefined()) {
            KeyOptionsState keyOptionsState = KeyOptionsState.instance();
            KeyOption keyOption = new KeyOption(this.option.getName(), data);
            keyOptionsState.removeHotkeyFromPotentiallyInUse(this.option.getName());
            keyOptionsState.addHotkeyToPotentiallyInUse(keyOption);
        }
        this.dehighlight();
        return true;
    }

    @Override
    public void readValue() {
        Cloneable cloneable;
        if (KeyOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "readValue()", 311).log();
        }
        KeyOptionsState keyOptionsState = KeyOptionsState.instance();
        Object object = this.option.getValue();
        if (object instanceof KeyOption.Data) {
            cloneable = new KeyOption(this.option.getName(), (KeyOption.Data)object);
            keyOptionsState.removeHotkeyFromInUse((KeyOption)cloneable);
        }
        cloneable = this.getHotkey();
        this.option.setValue(cloneable);
        KeyOption keyOption = new KeyOption(this.option.getName(), (KeyOption.Data)cloneable);
        keyOptionsState.addHotkeyToInUse(keyOption);
        keyOptionsState.resetHotkeysPotentiallyInUse();
    }

    @Override
    public void update(Option option) {
        if (KeyOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "update(Option)", 334).addDetail("option", option)).log();
        }
        this.option = option;
        if (option.getValue() instanceof KeyOption.Data) {
            KeyOption.Data data = (KeyOption.Data)option.getValue();
            this.keyCode = data.keyCode;
            this.keyChar = data.keyChar;
            this.modifiers = data.modifiers;
        } else {
            this.keyCode = 0;
            this.keyChar = (char)65535;
            this.modifiers = 0;
        }
        this.key.setValues(this.ilabel, this.keyCode, this.keyChar, this.modifiers);
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.disabled) {
            bl = false;
        }
        this.key.setEnabled(bl);
        if (bl) {
            this.label.setForeground(UIManager.getColor("textText"));
        } else {
            this.label.setForeground(UIManager.getColor("textInactiveText"));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.key.isEnabled();
    }

    @Override
    public void requestFocus() {
        this.key.requestFocus();
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.removeElement(changeListener);
        this.listeners.addElement(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.removeElement(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChanged() {
        Vector vector;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners.isEmpty()) {
                return;
            }
            vector = (Vector)this.listeners.clone();
        }
        serializable = new ChangeEvent(this);
        for (int i = 0; i < vector.size(); ++i) {
            ((ChangeListener)vector.elementAt(i)).stateChanged((ChangeEvent)serializable);
        }
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public char getKeyChar() {
        return this.keyChar;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public static KeyStroke getKeyStroke(KeyOption keyOption) {
        if (KeyOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getKeyStroke(KeyOption)", 514).addDetail("option", keyOption)).log();
        }
        if (keyOption != null && keyOption.getValue() instanceof KeyOption.Data) {
            KeyOption.Data data = (KeyOption.Data)keyOption.getValue();
            return KeyOptionEdit.getKeyStrokeForData(data);
        }
        return null;
    }

    public static String getKeyStrokeAsString(KeyOption keyOption) {
        if (KeyOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getKeyStrokeAsString(KeyOption)", 527).addDetail("option", keyOption)).log();
        }
        String string = "";
        if (keyOption != null && keyOption.getValue() instanceof KeyOption.Data) {
            KeyOption.Data data = (KeyOption.Data)keyOption.getValue();
            String string2 = KeyEvent.getKeyText(data.keyCode);
            String string3 = KeyEvent.getKeyModifiersText(data.modifiers);
            string = data.modifiers != 0 ? string3 + "-" + string2 : string2;
        }
        return string;
    }

    public static String getKeyStrokeAsString(KeyStroke keyStroke) {
        if (KeyOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getKeyStrokeAsString(KeyStroke)", 546).addDetail("keystroke", keyStroke)).log();
        }
        String string = "";
        if (keyStroke != null) {
            String string2 = KeyEvent.getKeyText(keyStroke.getKeyCode());
            String string3 = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
            string = keyStroke.getModifiers() != 0 ? string3 + "-" + string2 : string2;
        }
        return string;
    }

    public static KeyStroke getKeyStrokeForResource(String string) {
        KeyStroke keyStroke;
        block7: {
            if (KeyOptionEdit.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "getKeyStrokeForResource(String)", 564).addDetail("resource", string)).log();
            }
            keyStroke = null;
            try {
                KeyOption.Data data = (KeyOption.Data)Option.getResources().getObject(Option.getResources().getString(string + ".keystrokeoption"));
                if (data != null) {
                    keyStroke = KeyOptionEdit.getKeyStrokeForData(data);
                }
            }
            catch (MissingResourceException missingResourceException) {
                if (KeyOptionEdit.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "getKeyStrokeForResource(String)", 574).add("ex", missingResourceException)).log();
                }
                try {
                    String string2 = Option.getResources().getString(string + ".keystroke.default");
                    String[] stringArray = string2.split(",");
                    keyStroke = KeyStroke.getKeyStroke(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
                }
                catch (Exception exception) {
                    if (KeyOptionEdit.logger.level < 5) break block7;
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "getKeyStrokeForResource(String)", 580).add("ex2", exception)).log();
                }
            }
        }
        return keyStroke;
    }

    public static KeyStroke getKeyStrokeForData(KeyOption.Data data) {
        if (KeyOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getKeyStrokeForData(Data)", 589).addDetail("data", data)).log();
        }
        return KeyStroke.getKeyStroke(data.keyCode, data.modifiers);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (KeyOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "keyPressed(KeyEvent)", 608).addDetail("e", keyEvent)).log();
        }
        if (this.key.isEnabled() && keyEvent.getKeyCode() != 0) {
            this.keyCode = keyEvent.getKeyCode();
            this.keyChar = keyEvent.getKeyChar();
            this.modifiers = keyEvent.getModifiers();
            keyEvent.consume();
            this.key.setValues(this.ilabel, this.keyCode, this.keyChar, this.modifiers);
            this.fireChanged();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (KeyOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "keyTyped(KeyEvent)", 629).addDetail("e", keyEvent)).log();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (KeyOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "keyReleased(KeyEvent)", 642).addDetail("e", keyEvent)).log();
        }
    }

    @Override
    public void dehighlight() {
        if (KeyOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "dehighlight()", 650).log();
        }
        if (this.key != null && this.origBackgroundColor != null) {
            this.key.setBackground(this.origBackgroundColor);
            this.key.repaint();
        }
        super.dehighlight();
    }

    @Override
    public void highlight(int n, int n2, int n3) {
        if (KeyOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "highlight(int,int,int)", 662).addDetail("start", n)).addDetail("end", n2)).addDetail("highlightType", n3)).log();
        }
        this.key.setBackground(this.getHighlightingColorNonTransparent(n3));
        this.key.setOpaque(true);
    }

    public void requestKeyFocus() {
        if (KeyOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "requestKeyFocus()", 670).log();
        }
        this.key.requestFocus();
    }

    @Generated
    public KeyLabel getKey() {
        if (KeyOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "getKey()", 132).log();
        }
        return this.key;
    }

    static /* synthetic */ Color access$000() {
        return COLOR_FOCUS_BORDER;
    }

    static /* synthetic */ Color access$100() {
        return COLOR_DEFAULT_BORDER;
    }

    protected static class KeyLabel
    extends JLabel
    implements FocusListener {
        private static Set<KeyStroke> focusKeys = new HashSet<KeyStroke>();
        private Border focus = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(KeyOptionEdit.access$000(), 2), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        private Border noFocus = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(KeyOptionEdit.access$100(), 1), BorderFactory.createEmptyBorder(3, 3, 3, 3));
        private boolean captureTab;

        public KeyLabel(boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "KeyLabel.KeyLabel(boolean)", 733).addDetail("captureTab", bl)).log();
            }
            this.captureTab = bl;
            if (bl) {
                this.setFocusTraversalKeys(0, focusKeys);
            }
            if (UIManager.getBorder("KeyOptionEdit.focusBorder") != null && UIManager.getBorder("KeyOptionEdit.border") != null) {
                this.noFocus = UIManager.getBorder("KeyOptionEdit.border");
                this.focus = UIManager.getBorder("KeyOptionEdit.focusBorder");
            }
            this.setRequestFocusEnabled(true);
            this.setBorder(this.noFocus);
            this.setText("X");
            this.setPreferredSize(this.getPreferredSize());
            this.addFocusListener(this);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.requestFocus();
                }
            });
        }

        @Override
        public void updateUI() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "KeyLabel.updateUI()", 764).log();
            }
            super.updateUI();
            if (UIManager.getBorder("KeyOptionEdit.focusBorder") != null && UIManager.getBorder("KeyOptionEdit.border") != null) {
                this.noFocus = UIManager.getBorder("KeyOptionEdit.border");
                this.focus = UIManager.getBorder("KeyOptionEdit.focusBorder");
                this.setBorder(this.noFocus);
            }
        }

        @Override
        public boolean isFocusTraversable() {
            return this.isEnabled();
        }

        public void setValues(String string, int n, char c, int n2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "KeyLabel.setValues(String,int,char,int)", 798).addDetail("prefix", string)).addDetail("keyCode", n)).addDetail("keyChar", c)).addDetail("modifiers", n2)).log();
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            if (n2 != 0) {
                stringBuilder.append(KeyEvent.getKeyModifiersText(n2));
                stringBuilder.append('-');
            }
            if (n != 0 && n != 16 && n != 17 && n != 18 && n != 157) {
                stringBuilder.append(KeyEvent.getKeyText(n));
            } else if (n == 0 && c != '\uffff') {
                stringBuilder.append(c);
            }
            this.setText(stringBuilder.toString());
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.setBorder(this.isEnabled() ? this.focus : this.noFocus);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.setBorder(this.noFocus);
        }

        @Override
        public String paramString() {
            Component component = this.labelFor;
            if (component == this) {
                this.labelFor = null;
            }
            String string = super.paramString();
            this.labelFor = component;
            return string;
        }

        static {
            focusKeys.add(KeyStroke.getKeyStroke(9, 128));
        }
    }
}

