/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.gui.AWTTreeAdapter;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.gui.ThemeAwareJLabel;
import de.qfs.lib.gui.ThemeSupport;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.edit.KeyOptionEdit;
import de.qfs.lib.option.edit.OptionEditCallbacks;
import de.qfs.lib.option.group.OptionGroup;
import de.qfs.lib.tree.ReturnFromTraversalException;
import de.qfs.lib.tree.Traversal;
import de.qfs.lib.tree.TraversalCallback;
import de.qfs.lib.tree.TreeUtil;
import de.qfs.lib.util.ClassWrapper;
import de.qfs.lib.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.PanelUI;
import javax.swing.text.JTextComponent;
import javax.swing.undo.AbstractUndoableEdit;
import lombok.Generated;

public abstract class OptionEdit
extends JPanel {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.edit.OptionEdit");
    public static final Pattern BODY_CLASS_PATTERN = Pattern.compile("(?s)<body [^>]*class=[\"']?([^\"' >]+)[\"'][^>]*>.*");
    public static final int ERROR_HIGHLIGHT = 0;
    public static final int INFORMATION_HIGHLIGHT = 1;
    public static final int WARNING_HIGHLIGHT = 2;
    public static final int QUESTION_HIGHLIGHT = 3;
    public static final int PLAIN_HIGHLIGHT = -1;
    public static final int SEARCH_HIGHLIGHT = -2;
    public static final Color DEFAULT_HIGHLIGHTING_COLOR = new Color(223, 195, 195, 142);
    public static final Color DEFAULT_SEARCH_MARK_COLOR = new Color(24, 61, 140);
    private static ClassWrapper wrapper = new ClassWrapper("de.qfs.lib.option.edit", "Edit", false);
    protected static boolean highlightOnCheckOnly;
    protected static boolean highlightWhileEditing;
    protected static boolean showInvalidAttributeTooltip;
    protected boolean disabled;
    protected Option option;
    protected boolean isValid = true;
    protected OptionGroup group;
    protected ArrayList<UndoableEditListener> listeners;
    protected Border originalBorder;
    protected boolean highlightingSetUp;
    protected JPopupMenu popup = null;
    protected transient JMenuItem pmiCut;
    protected transient JMenuItem pmiCopy;
    protected transient JMenuItem pmiPaste;
    protected transient JMenuItem pmiDelete;
    protected transient JMenuItem pmiSelectAll;
    protected Color highlightingColor = DEFAULT_HIGHLIGHTING_COLOR;
    protected boolean isMarked = false;
    protected String themeSuffix;
    protected Double fontFactor;
    protected Color origBackgroundColor;
    protected AbstractButton clipboardButton;
    protected Icon copyIcon;
    protected Icon copyIconDisabled;
    protected Icon checkIcon;

    protected OptionEdit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OptionEdit makeEdit(Option option) {
        if (OptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "makeEdit(Option)", 308).addDetail("option", option)).log();
        }
        Component component = null;
        String string = option.getName();
        if (!OptionEdit.filterOption(option)) {
            return null;
        }
        if (option != null) {
            String string2 = Option.getResources().getString("option." + string + ".edit.class", null);
            if (string2 != null) {
                try {
                    component = (OptionEdit)Class.forName(string2).newInstance();
                }
                catch (Exception exception) {
                    if (OptionEdit.logger.level >= 1) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(1, "makeEdit(Option)", 322).add("ex", exception)).log();
                    }
                }
            } else {
                component = (OptionEdit)wrapper.makeWrapper(option);
            }
        }
        if (component != null) {
            ((OptionEdit)component).option = option;
            component.setName("OptionEdit-" + string);
            ((OptionEdit)component).init();
            ((OptionEdit)component).finishInit();
            boolean bl = highlightOnCheckOnly;
            try {
                highlightOnCheckOnly = true;
                ((OptionEdit)component).checkValue();
            }
            finally {
                highlightOnCheckOnly = bl;
            }
        }
        return component;
    }

    public static boolean filterOption(Option option) {
        if (OptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "filterOption(Option)", 349).addDetail("option", option)).log();
        }
        return OptionEditCallbacks.makeOptionEditFilter == null || OptionEditCallbacks.makeOptionEditFilter.test("option." + option.getName());
    }

    public static void addPackage(String string) {
        if (OptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addPackage(String)", 367).addDetail("packagename", string)).log();
        }
        wrapper.addPackage(string);
    }

    public static final boolean isHighlightOnCheckOnly() {
        if (OptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "isHighlightOnCheckOnly()", 384).log();
        }
        return highlightOnCheckOnly;
    }

    public static final void setHighlightOnCheckOnly(boolean bl) {
        if (OptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setHighlightOnCheckOnly(boolean)", 397).addDetail("_highlightOnCheckOnly", bl)).log();
        }
        highlightOnCheckOnly = bl;
    }

    public static final boolean isHighlightWhileEditing() {
        if (OptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "isHighlightWhileEditing()", 410).log();
        }
        return highlightWhileEditing;
    }

    public static final void setHighlightWhileEditing(boolean bl) {
        if (OptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setHighlightWhileEditing(boolean)", 423).addDetail("_highlightWhileEditing", bl)).log();
        }
        highlightWhileEditing = bl;
    }

    public static final boolean isShowInvalidAttributeTooltip() {
        if (OptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "isShowInvalidAttributeTooltip()", 436).log();
        }
        return showInvalidAttributeTooltip;
    }

    public static final void setShowInvalidAttributeTooltip(boolean bl) {
        if (OptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setShowInvalidAttributeTooltip(boolean)", 449).addDetail("_showInvalidAttributeTooltip", bl)).log();
        }
        showInvalidAttributeTooltip = bl;
    }

    public Option getOption() {
        return this.option;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(OptionSet optionSet) {
        if (OptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "update(OptionSet)", 480).addDetail("options", optionSet)).log();
        }
        if (this.option != null) {
            Option option = optionSet.getOption(this.option.getName());
            if (option != null) {
                this.update(option);
            }
            this.dehighlight();
            boolean bl = highlightOnCheckOnly;
            highlightOnCheckOnly = true;
            try {
                if (!this.checkValue()) {
                    this.highlight(0, 0, 0);
                }
            }
            finally {
                highlightOnCheckOnly = bl;
            }
        }
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean bl) {
        this.disabled = bl;
        if (bl) {
            this.setEnabled(false);
        }
    }

    public OptionGroup getOptionGroup() {
        return this.group;
    }

    public void setOptionGroup(OptionGroup optionGroup) {
        this.group = optionGroup;
    }

    public double getWeight() {
        return 0.0;
    }

    public void cleanup() {
        if (OptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "cleanup()", 596).log();
        }
    }

    @Override
    public void updateUI() {
        if (OptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "updateUI()", 611).dumpStack();
        }
        super.updateUI();
        if (this.highlightingSetUp) {
            if (this.isMarked) {
                this.setBorder(UIManager.getBorder("OptionGroup.markBorder"));
            } else {
                this.setBorder(this.originalBorder);
            }
        }
    }

    @Override
    public void setUI(PanelUI panelUI) {
        if (OptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setUI(PanelUI)", 629).addDetail("newUI", panelUI)).dumpStack();
        }
        super.setUI(panelUI);
    }

    public synchronized void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        if (OptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addUndoableEditListener(UndoableEditListener)", 645).addDetail("listener", undoableEditListener)).log();
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.remove(undoableEditListener);
        this.listeners.add(undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        if (OptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeUndoableEditListener(UndoableEditListener)", 662).addDetail("listener", undoableEditListener)).log();
        }
        if (this.listeners != null) {
            this.listeners.remove(undoableEditListener);
        }
    }

    public void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (this.listeners == null) {
            return;
        }
        UndoableEditListener[] undoableEditListenerArray = this.listeners.toArray(new UndoableEditListener[0]);
        if (OptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "fireUndoableEditHappened(UndoableEditEvent)", 683).add("tmp", undoableEditListenerArray)).log();
        }
        for (int i = 0; i < undoableEditListenerArray.length; ++i) {
            undoableEditListenerArray[i].undoableEditHappened(undoableEditEvent);
        }
    }

    public boolean isMarked() {
        if (OptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "isMarked()", 692).log();
        }
        return this.isMarked;
    }

    public void highlight(int n, int n2, int n3) {
    }

    public void highlight(int n, int n2, int n3, final String string) {
        this.highlight(n, n2, n3);
        if (showInvalidAttributeTooltip && n == 0 && n2 == 0 && n3 == 0 && !Misc.emptyOrNull(string)) {
            TreeUtil.traverse(new AWTTreeAdapter(), this, new TraversalCallback(){

                @Override
                public boolean nodeEntered(Traversal traversal) throws ReturnFromTraversalException {
                    if (traversal.getNode() instanceof JComponent) {
                        ((JComponent)traversal.getNode()).setToolTipText(string);
                    }
                    return true;
                }

                @Override
                public void nodeExited(Traversal traversal) throws ReturnFromTraversalException {
                }
            });
        }
    }

    public boolean matchesFilterText(Predicate<String> predicate) {
        if (OptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "matchesFilterText(Predicate<String>)", 897).addDetail("matcher", predicate)).log();
        }
        if (predicate == null) {
            return true;
        }
        String string = this.getString("label", null);
        if (string != null && predicate.test(string)) {
            return true;
        }
        String string2 = this.getString("title", null);
        if (string2 != null && predicate.test(string2)) {
            return true;
        }
        String string3 = this.getString("aliases", null);
        if (string3 != null) {
            for (String string4 : Misc.fastSplit(string3, ',')) {
                if (!predicate.test(string4)) continue;
                return true;
            }
        }
        return false;
    }

    public void markSearchHit(boolean bl) {
        if (OptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "markSearchHit(boolean)", 937).addDetail("doMark", bl)).log();
        }
        if (bl == this.isMarked) {
            return;
        }
        if (bl) {
            this.setBorder(UIManager.getBorder("OptionGroup.markBorder"));
        } else {
            this.setBorder(this.originalBorder);
        }
        this.isMarked = bl;
    }

    public void setupHighlightingBorder() {
        if (OptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "setupHighlightingBorder()", 954).log();
        }
        if (!this.highlightingSetUp) {
            this.highlightingSetUp = true;
            this.originalBorder = this.getBorder();
            if (this.originalBorder == null) {
                this.originalBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            }
        }
    }

    void setHighlightingColor(Color color) {
        this.highlightingColor = color;
    }

    public Color getHighlightingColor() {
        if (UIManager.getColor("searchHighlight") != null) {
            return UIManager.getColor("searchHighlight");
        }
        return this.highlightingColor;
    }

    public Color getHighlightingColorNonTransparent(int n) {
        Color color = null;
        color = n == 0 ? UIManager.getColor("highlightError") : (n == 2 ? UIManager.getColor("highlightWarning") : UIManager.getColor("searchHighlight"));
        if (color != null) {
            return new Color(color.getRGB());
        }
        return new Color(this.highlightingColor.getRGB());
    }

    public void dehighlight() {
        if (!Misc.emptyOrNull(this.getToolTipText())) {
            TreeUtil.traverse(new AWTTreeAdapter(), this, new TraversalCallback(){

                @Override
                public boolean nodeEntered(Traversal traversal) throws ReturnFromTraversalException {
                    if (traversal.getNode() instanceof JComponent) {
                        ((JComponent)traversal.getNode()).setToolTipText(null);
                    }
                    return true;
                }

                @Override
                public void nodeExited(Traversal traversal) throws ReturnFromTraversalException {
                }
            });
        }
    }

    protected abstract void init();

    protected void finishInit() {
        if (OptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "finishInit()", 1074).log();
        }
    }

    public abstract void update(Option var1);

    public abstract boolean isModified();

    public boolean isSuspect() {
        if (OptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "isSuspect()", 1114).log();
        }
        return false;
    }

    public abstract boolean checkValue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkValue(boolean bl) {
        if (OptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "checkValue(boolean)", 1147).addDetail("highlightOnly", bl)).log();
        }
        boolean bl2 = highlightOnCheckOnly;
        try {
            highlightOnCheckOnly = bl;
            boolean bl3 = this.checkValue();
            return bl3;
        }
        finally {
            highlightOnCheckOnly = bl2;
        }
    }

    public abstract void readValue();

    protected void ignoreDefaultShortcuts(JTextComponent jTextComponent) {
        if (OptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "ignoreDefaultShortcuts(JTextComponent)", 1175).addDetail("text", jTextComponent)).log();
        }
        if (Misc.OS_IS_MAC_OS_X) {
            jTextComponent.getInputMap().put(KeyStroke.getKeyStroke(72, 128), "none");
            jTextComponent.getInputMap().put(KeyStroke.getKeyStroke(8, 128), "none");
        }
        for (int i = 0; i < 10; ++i) {
            try {
                KeyStroke keyStroke = KeyOptionEdit.getKeyStrokeForResource("keystroke.ignore" + i);
                if (keyStroke == null) break;
                jTextComponent.registerKeyboardAction(null, "dummy", KeyStroke.getKeyStroke(keyStroke.getKeyCode(), 2), 0);
                continue;
            }
            catch (MissingResourceException missingResourceException) {
                break;
            }
        }
    }

    public String getResourceName() {
        if (OptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "getResourceName()", 1201).log();
        }
        return "option." + this.option.getName();
    }

    protected String getString(String string, String string2) {
        return Option.getResources().getString(this.getResourceName() + "." + string, string2);
    }

    protected boolean getBoolean(String string, boolean bl) {
        return Option.getResources().getBoolean(this.getResourceName() + "." + string, bl);
    }

    protected int getInt(String string, int n) {
        return Option.getResources().getInt(this.getResourceName() + "." + string, n);
    }

    protected Dimension adjustPreferredSize(Component component, Dimension dimension, Dimension dimension2, int n, int n2) {
        if (OptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "adjustPreferredSize(Component,Dimension,Dimension,int,int)", 1275).addDetail("target", component)).addDetail("targetSize", dimension)).addDetail("vpsize", dimension2)).addDetail("minPrefHeight", n)).addDetail("maxPrefHeight", n2)).log();
        }
        Dimension dimension3 = super.getPreferredSize();
        if (component != null) {
            Dimension dimension4 = this.getSize();
            int n3 = 0;
            if (dimension2.height > 0 && dimension4.height > dimension2.height) {
                n3 = dimension4.height - dimension2.height;
            }
            if (OptionEdit.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "adjustPreferredSize(Component,Dimension,Dimension,int,int)", 1285).add("targetSize", dimension)).add("size", dimension4)).add("vpsize", dimension2)).add("adjust", n3)).log();
            }
            if (n > 0 && dimension.height + n3 < dimension3.height) {
                int n4 = dimension4.height == 0 ? dimension3.height : 0;
                dimension3.height = Math.max(n4, Math.max(dimension.height + n3, n));
            }
            if (n2 != 0) {
                JViewport jViewport;
                if (dimension.height + n3 > dimension3.height) {
                    dimension3.height = Math.min(dimension.height + n3, n2 < 0 ? 10000 : n2);
                }
                if ((jViewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this)) != null) {
                    int n5;
                    Point point = SwingUtilities.convertPoint(this, 0, 0, jViewport.getView());
                    if (OptionEdit.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "adjustPreferredSize(Component,Dimension,Dimension,int,int)", 1300).add("pos", point)).log();
                    }
                    Dimension dimension5 = jViewport.getSize();
                    int n6 = n5 = n2 < 0 ? Math.max(-point.y, n2) : -50;
                    if (OptionEdit.logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "adjustPreferredSize(Component,Dimension,Dimension,int,int)", 1303).add("vsize", dimension5)).add("rest", n5)).log();
                    }
                    if (dimension5.height > 0 && dimension5.height + n5 < dimension3.height) {
                        dimension3.height = n > 0 ? Math.max(n, dimension5.height + n5) : dimension5.height + n5;
                    }
                }
            }
        }
        if (n > 0 && dimension3.height < n) {
            dimension3.height = n;
        }
        if (n2 > 0 && dimension3.height > n2) {
            dimension3.height = n2;
        }
        return dimension3;
    }

    protected void initClipboardButton() {
        double d;
        if (OptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "initClipboardButton()", 1325).log();
        }
        String string = (d = ThemeSupport.getFontScale()) != 1.0 ? "@" + d + "x" : "";
        this.copyIcon = Option.getResources().getIcon("Clipboard.icon" + ThemeSupport.getThemeSuffix() + string, null);
        this.copyIconDisabled = Option.getResources().getIcon("Clipboard.icon.disabled" + ThemeSupport.getThemeSuffix() + string, null);
        this.checkIcon = Option.getResources().getIcon("icon.checkBoxMenuItem" + ThemeSupport.getThemeSuffix() + string, null);
        this.clipboardButton.setRequestFocusEnabled(false);
        this.clipboardButton.setMargin(new Insets(0, 0, 0, 0));
        this.clipboardButton.setIcon(this.copyIcon);
        this.clipboardButton.setDisabledIcon(this.copyIconDisabled);
        String string2 = Option.getResources().getString("Clipboard.tooltip", null);
        if (string2 != null) {
            this.clipboardButton.setToolTipText(string2);
        }
    }

    protected void onButtonPressed() {
        if (OptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "onButtonPressed()", 1363).log();
        }
        this.clipboardButton.setEnabled(false);
        this.clipboardButton.setDisabledIcon(this.checkIcon);
        Timer timer = new Timer(1200, actionEvent -> {
            this.clipboardButton.setEnabled(true);
            this.clipboardButton.setDisabledIcon(this.copyIconDisabled);
        });
        timer.setRepeats(false);
        timer.start();
    }

    public boolean isActive() {
        if (OptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "isActive()", 1385).log();
        }
        return !this.disabled;
    }

    @Generated
    public OptionEdit setOption(Option option) {
        if (OptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setOption(Option)", 174).addDetail("option", option)).log();
        }
        this.option = option;
        return this;
    }

    protected class OptionJRadioButton
    extends JRadioButton {
        String rawText;
        boolean initialized;

        public OptionJRadioButton(String string) {
            super(ThemeSupport.extendHtmlWrapping(OptionEdit.this.getResourceName(), string));
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "OptionJRadioButton.OptionJRadioButton(String)", 1467).addDetail("text", string)).log();
            }
            this.rawText = Misc.equalOrNull(this.getText(), string) ? null : string;
            this.adjustTextColor();
            this.initialized = true;
        }

        public void adjustTextColor() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "OptionJRadioButton.adjustTextColor()", 1475).log();
            }
            this.setForeground(UIManager.getColor(OptionEdit.this.isActive() ? "textText" : "textInactiveText"));
        }

        @Override
        public void setText(String string) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "OptionJRadioButton.setText(String)", 1480).addDetail("text", string)).log();
            }
            if (!this.initialized) {
                super.setText(string);
                return;
            }
            super.setText(ThemeSupport.extendHtmlWrapping(OptionEdit.this.getResourceName(), string));
            this.rawText = Misc.equalOrNull(this.getText(), string) ? null : string;
        }

        @Override
        public void updateUI() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "OptionJRadioButton.updateUI()", 1491).log();
            }
            SwingUtil.cleanupKeyHandlers(this);
            super.updateUI();
            this.adjustTextColor();
            if (this.rawText != null) {
                super.setText(ThemeSupport.extendHtmlWrapping(OptionEdit.this.getResourceName(), this.rawText));
            }
        }
    }

    protected class OptionJCheckBox
    extends JCheckBox {
        String rawText;
        boolean initialized;

        public OptionJCheckBox(String string) {
            super(ThemeSupport.extendHtmlWrapping(OptionEdit.this.getResourceName(), string));
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "OptionJCheckBox.OptionJCheckBox(String)", 1421).addDetail("text", string)).log();
            }
            this.rawText = Misc.equalOrNull(this.getText(), string) ? null : string;
            this.adjustTextColor();
            this.initialized = true;
        }

        public void adjustTextColor() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "OptionJCheckBox.adjustTextColor()", 1429).log();
            }
            this.setForeground(UIManager.getColor(OptionEdit.this.isActive() ? "textText" : "textInactiveText"));
        }

        @Override
        public void setText(String string) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "OptionJCheckBox.setText(String)", 1434).addDetail("text", string)).log();
            }
            if (!this.initialized) {
                super.setText(string);
                return;
            }
            super.setText(ThemeSupport.extendHtmlWrapping(OptionEdit.this.getResourceName(), string));
            this.rawText = Misc.equalOrNull(this.getText(), string) ? null : string;
        }

        @Override
        public void updateUI() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "OptionJCheckBox.updateUI()", 1445).log();
            }
            SwingUtil.cleanupKeyHandlers(this);
            super.updateUI();
            this.adjustTextColor();
            if (this.rawText != null) {
                super.setText(ThemeSupport.extendHtmlWrapping(OptionEdit.this.getResourceName(), this.rawText));
            }
        }
    }

    protected class OptionJLabel
    extends ThemeAwareJLabel {
        String rawText;
        boolean initialized;

        public OptionJLabel(String string) {
            super(OptionEdit.this.getResourceName(), string);
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "OptionJLabel.OptionJLabel(String)", 1400).addDetail("text", string)).log();
            }
        }

        @Override
        public void adjustTextColor() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "OptionJLabel.adjustTextColor()", 1405).log();
            }
            this.setForeground(UIManager.getColor(OptionEdit.this.isActive() ? "textText" : "textInactiveText"));
        }
    }

    public static class UndoBlocker
    extends AbstractUndoableEdit {
        private boolean block;

        public UndoBlocker(boolean bl) {
            this.block = bl;
        }

        @Override
        public boolean isSignificant() {
            return false;
        }

        public final boolean isBlock() {
            return this.block;
        }
    }

    public static class UndoContextSwitch
    extends AbstractUndoableEdit {
        private boolean enter;

        public UndoContextSwitch(boolean bl) {
            this.enter = bl;
        }

        @Override
        public boolean isSignificant() {
            return false;
        }

        public final boolean isEnter() {
            return this.enter;
        }
    }
}

