/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.gui.PopupHandler;
import de.qfs.lib.gui.PopupManager;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.edit.OptionEdit;
import de.qfs.lib.option.edit.SimpleOptionEdit;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import lombok.Generated;

public class RegexEscaper
implements PopupHandler {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.edit.RegexEscaper");
    protected OptionEdit optionEdit;
    protected Component text;
    protected Action actionRegexEscaper;
    protected KeyStroke actionRegexEscaperKeyStroke;

    public RegexEscaper(OptionEdit optionEdit, final Component component) {
        if (RegexEscaper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "RegexEscaper(OptionEdit,Component)", 85).addDetail("oe", optionEdit)).addDetail("text", component)).log();
        }
        this.optionEdit = optionEdit;
        this.text = component;
        if (this.text != null) {
            this.actionRegexEscaper = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RegexEscaper.this.escapeRegex(component);
                    if (RegexEscaper.this.optionEdit != null && RegexEscaper.this.optionEdit instanceof SimpleOptionEdit) {
                        ((SimpleOptionEdit)RegexEscaper.this.optionEdit).customEscapeRegexAction();
                    }
                }
            };
            ((JComponent)this.text).registerKeyboardAction(this.actionRegexEscaper, "regexescaper", this.actionRegexEscaperKeyStroke, 0);
        }
    }

    public void escapeRegex(Component component) {
        if (RegexEscaper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "escapeRegex(Component)", 126).addDetail("text", component)).log();
        }
        if (component instanceof JTextComponent) {
            if (RegexEscaper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "escapeRegex(Component)", 129).add("Escape text for component.")).log();
            }
            String string = ((JTextComponent)component).getText();
            String string2 = ((JTextComponent)component).getSelectedText();
            int n = -1;
            int n2 = -1;
            if (Misc.emptyOrNull(string2)) {
                string2 = string;
            } else {
                n = ((JTextComponent)component).getSelectionStart();
                n2 = ((JTextComponent)component).getSelectionEnd();
            }
            if (Misc.emptyOrNull(string2)) {
                if (RegexEscaper.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "escapeRegex(Component)", 147).add("Component has no text.")).log();
                }
                return;
            }
            String string3 = this.escapeString(string2, string, n, n2);
            if (!string2.equals(string3)) {
                ((JTextComponent)component).setText(string3);
            } else if (RegexEscaper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "escapeRegex(Component)", 156).add("Nothing to escape.")).log();
            }
        } else if (RegexEscaper.logger.level >= 3) {
            ((LevelAwareLogBuilder)logger.lvlBuild(3, "escapeRegex(Component)", 160).add("No text component, no action.")).log();
        }
    }

    public String escapeString(String string, String string2, int n, int n2) {
        String string3 = "<QFSDOLLARREPLACEMENT>";
        string = string.replaceAll("\\$\\$", string3);
        string = Misc.quoteRegex(string);
        string = string.replaceAll(string3, "\\\\\\$\\$");
        return string;
    }

    @Override
    public boolean fillPopup(PopupManager popupManager, Component component, JPopupMenu jPopupMenu, MapResourceBundle mapResourceBundle, int n, int n2, boolean bl) {
        if (component instanceof JTextComponent) {
            this.addToPopupManager(popupManager, mapResourceBundle);
            return true;
        }
        if (RegexEscaper.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "fillPopup(PopupManager,Component,JPopupMenu,MapResourceBundle,int,int,boolean)", 221).add("No popup required.")).log();
        }
        return false;
    }

    public void addToPopupManager(PopupManager popupManager, MapResourceBundle mapResourceBundle) {
        popupManager.addSeparator(-1, "");
        popupManager.setupAction(this.actionRegexEscaper, mapResourceBundle, "popup.regexescaper");
        JMenuItem jMenuItem = popupManager.createMenuItem("regexescaper", mapResourceBundle, "popup.regexescaper", (ActionListener)this.actionRegexEscaper, true);
        jMenuItem.setAccelerator(this.actionRegexEscaperKeyStroke);
        if (this.optionEdit instanceof SimpleOptionEdit) {
            jMenuItem.setEnabled(((SimpleOptionEdit)this.optionEdit).getTextComponent().isEditable());
        }
        popupManager.addMenuItem(jMenuItem, -1, "");
    }

    protected String getSelectedText() {
        if (this.text instanceof JTextComponent) {
            return ((JTextComponent)this.text).getSelectedText();
        }
        return null;
    }
}

