/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.gui.ImageButton;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.edit.FocusingUndoableEdit;
import de.qfs.lib.option.edit.OptionEdit;
import de.qfs.lib.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.function.Predicate;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.PanelUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import lombok.Generated;

public class SimpleOptionEdit
extends OptionEdit
implements FocusListener,
MouseListener,
UndoableEditListener {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.edit.SimpleOptionEdit");
    protected JLabel label;
    protected JTextComponent text;
    protected boolean selectOnFocus;
    protected boolean highlightOnFocus;
    protected boolean canFocus = true;
    protected boolean canPopup;
    protected boolean canClipboard;
    protected boolean suppressOutdatedKeyboardShortcuts = true;
    protected boolean scrolledToVisible;
    protected boolean canIsearch;
    protected boolean canEscapeRegex;
    protected boolean readonly;
    protected boolean nullIfInvisible = false;
    protected Box topbox;
    protected transient boolean internalUpdate;

    protected SimpleOptionEdit() {
        if (SimpleOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "SimpleOptionEdit()", 162).log();
        }
    }

    @Override
    public void init() {
        if (SimpleOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "init()", 177).log();
        }
        this.setLayout(new BorderLayout());
        this.disabled = this.getBoolean("disabled", false);
        this.readonly = this.getBoolean("readonly", false);
        this.label = new OptionEdit.OptionJLabel(this.getString("label", ""));
        this.label.setName("Label-" + this.option.getName());
        String string = this.getString("mnemonic", null);
        if (string != null && string.length() > 0) {
            this.label.setDisplayedMnemonic(string.charAt(0));
        }
        this.label.setForeground(UIManager.getColor(this.disabled ? "textInactiveText" : "textText"));
        this.selectOnFocus = this.getBoolean("select", false);
        this.highlightOnFocus = this.getBoolean("highlightinvalid", true);
        this.canPopup = this.getBoolean("canpopup", true);
        this.canClipboard = this.getBoolean("canclipboard", false);
        this.canIsearch = this.getBoolean("canisearch", false);
        this.canEscapeRegex = this.getBoolean("canescaperegex", false);
        this.nullIfInvisible = this.getBoolean("nullifinvisible", false);
        this.suppressOutdatedKeyboardShortcuts = this.getBoolean("suppressOutdatedKeyboardShortcuts", true);
        this.topbox = Box.createHorizontalBox();
        this.topbox.add(this.label);
        if (this.canClipboard) {
            this.clipboardButton = new ImageButton();
            this.initClipboardButton();
            this.clipboardButton.addActionListener(actionEvent -> this.onButtonPressed());
            this.topbox.add(Box.createHorizontalGlue());
            this.topbox.add(this.clipboardButton);
        }
        if (this.canClipboard && this.clipboardButton != null && this.text != null) {
            this.addClipboardStateListener();
        }
        this.add((Component)this.topbox, "North");
    }

    @Override
    protected void finishInit() {
        if (SimpleOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "finishInit()", 222).log();
        }
        if (this.text != null) {
            this.origBackgroundColor = this.text.getBackground();
            final Runnable runnable = () -> {
                if (highlightWhileEditing) {
                    this.checkValue(true);
                } else if (!this.internalUpdate) {
                    this.dehighlight();
                }
            };
            this.text.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "finishInit().DocumentListener.insertUpdate(DocumentEvent)", 235).addDetail("e", documentEvent)).log();
                    }
                    SwingUtilities.invokeLater(runnable);
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "finishInit().DocumentListener.removeUpdate(DocumentEvent)", 241).addDetail("e", documentEvent)).log();
                    }
                    SwingUtilities.invokeLater(runnable);
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "finishInit().DocumentListener.changedUpdate(DocumentEvent)", 247).addDetail("e", documentEvent)).log();
                    }
                    SwingUtilities.invokeLater(runnable);
                }
            });
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.text != null) {
            this.text.setBackground(null);
            this.text.updateUI();
            this.origBackgroundColor = this.text.getBackground();
            if (!this.isValid) {
                this.highlight(0, 0, 0);
            }
        }
        if (this.clipboardButton != null) {
            this.initClipboardButton();
            this.addClipboardStateListener();
        }
    }

    @Override
    public boolean isActive() {
        if (SimpleOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "isActive()", 279).log();
        }
        return this.text != null && this.text.isEditable();
    }

    public void maybeCommonPostInitSteps() {
        if (SimpleOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "maybeCommonPostInitSteps()", 289).log();
        }
        if (this.text != null) {
            if (Misc.OS_IS_MAC_OS_X) {
                this.text.setAutoscrolls(false);
            }
            if (this.suppressOutdatedKeyboardShortcuts) {
                this.ignoreDefaultShortcuts(this.text);
            }
        }
    }

    @Override
    public boolean isModified() {
        String string;
        boolean bl;
        String string2;
        if (SimpleOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "isModified()", 313).log();
        }
        if (this.disabled || this.readonly) {
            return false;
        }
        String string3 = this.text.getText();
        if ("".equals(string3)) {
            if ("".equals(this.option.getValue())) {
                return false;
            }
            string3 = null;
        }
        try {
            if (SimpleOptionEdit.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "isModified()", 326).add("val: ")).add(string3 == null ? null : Misc.toHex(string3.getBytes()))).add("\ntext:")).add(Misc.toHex(this.text.getDocument().getText(0, this.text.getDocument().getLength()).getBytes()))).log();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string4 = string2 = this.option.getValue() == null ? null : this.option.getValue().toString();
        if (SimpleOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "isModified()", 336).add("oval == null ? null : Misc.toHex(oval.getBytes())", string2 == null ? null : Misc.toHex(string2.getBytes()))).log();
        }
        boolean bl2 = bl = !Misc.equalOrNull(string3, string2);
        if (SimpleOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "isModified()", 344).add("ret", bl)).log();
        }
        if (bl && !this.isMultiLine() && !Misc.emptyOrNull(string2) && !(string = string2.replace("\n", " ")).equals(string2)) {
            if (SimpleOptionEdit.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "isModified()", 350).add("rep: ")).add(Misc.toHex(string.getBytes()))).log();
            }
            if (string.equals(string3)) {
                bl = false;
            }
            if (SimpleOptionEdit.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "isModified()", 354).add("ret", bl)).log();
            }
        }
        return bl;
    }

    protected boolean isMultiLine() {
        if (SimpleOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "isMultiLine()", 363).log();
        }
        return false;
    }

    @Override
    public boolean isSuspect() {
        String string;
        if (!this.isModified()) {
            return false;
        }
        String string2 = string = this.text == null ? null : this.text.getText();
        if (string != null && !string.equals(string.trim())) {
            if (SimpleOptionEdit.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "isSuspect()", 387).add("suspect value: ")).add("val", string)).log();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean checkValue() {
        String string = this.text.getText();
        this.isValid = this.option.checkValue(this, "".equals(string) ? null : string);
        if (!this.isValid) {
            if (!highlightOnCheckOnly) {
                this.text.requestFocus();
            }
            return false;
        }
        this.dehighlight();
        return true;
    }

    @Override
    public void readValue() {
        if (SimpleOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "readValue()", 425).log();
        }
        if (!this.disabled && !this.readonly) {
            String string = this.text.getText();
            if (this.nullIfInvisible && !this.isShowing()) {
                string = "";
            }
            this.option.setValue(string.equals("") ? null : string);
        }
    }

    @Override
    public void update(Option option) {
        this.option = option;
        String string = this.getTextFromOption();
        String string2 = this.text.getText();
        if (SimpleOptionEdit.logger.level >= 9) {
            logger.build("update(Option)").add("equal: ").add(Misc.equalOrEmpty(string2, string)).add(", oldText: ").add(string2).add("\nnewText: ").add(string).log(9);
        }
        if (!Misc.equalOrEmpty(string, string2)) {
            this.internalUpdate = true;
            this.text.setText(string);
            this.text.setCaretPosition(0);
            this.text.revalidate();
            SwingUtilities.invokeLater(() -> {
                this.internalUpdate = false;
            });
        }
    }

    protected String getTextFromOption() {
        Object object;
        if (SimpleOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "getTextFromOption()", 470).log();
        }
        return (object = this.option.getValue()) == null ? "" : object.toString();
    }

    public String getLabelText() {
        return this.label != null ? this.label.getText() : null;
    }

    public String getText() {
        return this.text != null ? this.text.getText() : null;
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        if (this.text != null) {
            int n = this.text.getCaretPosition();
            Point point = null;
            if (this.text.getParent() instanceof JViewport) {
                point = ((JViewport)this.text.getParent()).getViewPosition();
            }
            this.text.setText(string);
            this.text.setCaretPosition(Math.min(n, string.length()));
            if (point != null) {
                ((JViewport)this.text.getParent()).setViewPosition(point);
            }
        }
    }

    public JTextComponent getTextComponent() {
        return this.text;
    }

    public JLabel getLabelComponent() {
        return this.label;
    }

    @Override
    public void setUI(PanelUI panelUI) {
        if (SimpleOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setUI(PanelUI)", 574).addDetail("newUI", panelUI)).dumpStack();
        }
        super.setUI(panelUI);
        if (this.text != null) {
            this.setEnabled(this.isEnabled());
        }
    }

    public Highlighter getHighlighter() {
        if (this.text != null) {
            return this.text.getHighlighter();
        }
        return null;
    }

    public void setHighlighter(Highlighter highlighter) {
        if (this.text != null) {
            this.text.setHighlighter(highlighter);
        }
    }

    @Override
    public void highlight(int n, int n2, int n3) {
        block6: {
            if (SimpleOptionEdit.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "highlight(int,int,int)", 633).addDetail("start", n)).addDetail("end", n2)).addDetail("highlightType", n3)).log();
            }
            if (n == 0 && n2 == 0) {
                Color color = this.getHighlightingColorNonTransparent(n3);
                this.text.setBackground(color);
            } else {
                Highlighter highlighter = this.getHighlighter();
                if (highlighter != null && highlighter instanceof DefaultHighlighter) {
                    try {
                        Object object = highlighter.addHighlight(n, n2, new DefaultHighlighter.DefaultHighlightPainter(this.getHighlightingColor()));
                        this.scrollToVisible(n, n2, true);
                    }
                    catch (BadLocationException badLocationException) {
                        if (SimpleOptionEdit.logger.level < 3) break block6;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "highlight(int,int,int)", 648).add("ex", badLocationException)).log();
                    }
                }
            }
        }
    }

    @Override
    public void dehighlight() {
        if (SimpleOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "dehighlight()", 661).log();
        }
        if (this.getHighlighter() != null) {
            this.getHighlighter().removeAllHighlights();
            this.scrollToVisibleReset();
        }
        if (this.text != null && this.origBackgroundColor != null) {
            this.text.setBackground(this.origBackgroundColor);
            this.text.repaint();
        }
        super.dehighlight();
    }

    @Override
    public boolean matchesFilterText(Predicate<String> predicate) {
        String string;
        if (SimpleOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "matchesFilterText(Predicate<String>)", 678).addDetail("matcher", predicate)).log();
        }
        if (super.matchesFilterText(predicate)) {
            return true;
        }
        String string2 = string = this.option.getValue() == null ? null : this.option.getValue().toString();
        if (string != null && string.contains("<html>")) {
            string = string.replaceAll("(?s)<[^>]*>(\\s*<[^>]*>)*", " ").replace("&nbsp;", "");
        }
        return predicate.test(string);
    }

    protected void scrollToVisible(final int n, final int n2, boolean bl) {
        if (SimpleOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "scrollToVisible(int,int,boolean)", 708).addDetail("start", n)).addDetail("end", n2)).addDetail("onlyOnce", bl)).log();
        }
        if (!(bl && this.scrolledToVisible || this.text == null)) {
            this.scrolledToVisible = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    block4: {
                        if (logger.level >= 7) {
                            logger.lvlBuild(7, "scrollToVisible(int,int,boolean).Runnable.run()", 715).log();
                        }
                        try {
                            Rectangle rectangle = SimpleOptionEdit.this.text.modelToView(n);
                            Rectangle rectangle2 = SimpleOptionEdit.this.text.modelToView(n2);
                            if (rectangle != null && rectangle2 != null) {
                                Rectangle rectangle3 = new Rectangle(Math.min(rectangle.x, rectangle2.x), Math.min(rectangle.y, rectangle2.y), Math.max(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width), Math.max(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height));
                                SimpleOptionEdit.this.text.scrollRectToVisible(rectangle3);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            if (logger.level < 3) break block4;
                            ((LevelAwareLogBuilder)logger.lvlBuild(3, "scrollToVisible(int,int,boolean).Runnable.run()", 728).add("ex", badLocationException)).log();
                        }
                    }
                }
            });
        }
    }

    protected void scrollToVisibleReset() {
        if (SimpleOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "scrollToVisibleReset()", 743).log();
        }
        this.scrolledToVisible = false;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.selectOnFocus && this.canFocus && !focusEvent.isTemporary() && this.selectOnFocus && this.canFocus) {
            this.canFocus = false;
            this.text.setSelectionStart(0);
            this.text.setSelectionEnd(this.text.getDocument().getLength());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.canFocus = true;
            if (this.highlightOnFocus) {
                String string = this.text.getText();
                boolean bl = highlightOnCheckOnly;
                try {
                    highlightOnCheckOnly = true;
                    this.option.checkValue(this, "".equals(string) ? null : string);
                }
                finally {
                    highlightOnCheckOnly = bl;
                }
            }
        }
    }

    @Override
    public void onButtonPressed() {
        String string;
        String string2;
        if (this.text != null && (string2 = (string = this.text.getSelectedText()) != null && !string.isEmpty() ? string : this.text.getText()) != null && !string2.isEmpty()) {
            StringSelection stringSelection = new StringSelection(string2);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
            super.onButtonPressed();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SimpleOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "mouseClicked(MouseEvent)", 876).addDetail("e", mouseEvent)).log();
        }
        this.text.setCaretPosition(this.text.viewToModel(new Point(mouseEvent.getX(), mouseEvent.getY())));
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.disabled) {
            bl = false;
        }
        this.text.setEditable(bl && !this.readonly);
        this.text.setBackground(UIManager.getColor("TextField.background"));
        if (bl) {
            this.label.setForeground(UIManager.getColor("textText"));
        } else {
            this.label.setForeground(UIManager.getColor("textInactiveText"));
        }
        this.label.revalidate();
    }

    @Override
    public boolean isEnabled() {
        return this.text.isEditable();
    }

    public void setEditable(boolean bl) {
        if (this.text == null) {
            return;
        }
        this.text.setEditable(bl && !this.readonly);
    }

    public boolean isEditable() {
        return this.text != null && this.text.isEditable();
    }

    @Override
    public void requestFocus() {
        this.text.requestFocus();
    }

    public void customEscapeRegexAction() {
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (SimpleOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "undoableEditHappened(UndoableEditEvent)", 1020).addDetail("edit", undoableEditEvent)).log();
        }
        this.fireUndoableEditHappened(new UndoableEditEvent(this, new FocusingUndoableEdit(this.text, this, undoableEditEvent.getEdit())));
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        if (SimpleOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addUndoableEditListener(UndoableEditListener)", 1036).addDetail("listener", undoableEditListener)).log();
        }
        super.addUndoableEditListener(undoableEditListener);
        if (this.text != null) {
            this.text.getDocument().removeUndoableEditListener(this);
            this.text.getDocument().addUndoableEditListener(this);
        }
    }

    private void addClipboardStateListener() {
        if (SimpleOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "addClipboardStateListener()", 1048).log();
        }
        if (this.text == null || this.clipboardButton == null) {
            return;
        }
        this.clipboardButton.setEnabled(!this.text.getText().trim().isEmpty());
        this.text.getDocument().addDocumentListener(new DocumentListener(){

            private void updateButtonState() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "addClipboardStateListener().DocumentListener.updateButtonState()", 1055).log();
                }
                boolean bl = !SimpleOptionEdit.this.text.getText().trim().isEmpty();
                SimpleOptionEdit.this.clipboardButton.setEnabled(bl);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "addClipboardStateListener().DocumentListener.insertUpdate(DocumentEvent)", 1061).addDetail("e", documentEvent)).log();
                }
                this.updateButtonState();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "addClipboardStateListener().DocumentListener.removeUpdate(DocumentEvent)", 1066).addDetail("e", documentEvent)).log();
                }
                this.updateButtonState();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "addClipboardStateListener().DocumentListener.changedUpdate(DocumentEvent)", 1071).addDetail("e", documentEvent)).log();
                }
                this.updateButtonState();
            }
        });
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        if (SimpleOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeUndoableEditListener(UndoableEditListener)", 1087).addDetail("listener", undoableEditListener)).log();
        }
        super.removeUndoableEditListener(undoableEditListener);
        if (this.text != null) {
            this.text.getDocument().removeUndoableEditListener(this);
        }
    }
}

