/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.config.ConfigWrapper;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.gui.DefaultTableModelSorter;
import de.qfs.lib.gui.PopupManager;
import de.qfs.lib.gui.SortedTableHelper;
import de.qfs.lib.gui.TableModelFilter;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.edit.TableOptionEdit;
import lombok.Generated;

public class SortedTableOptionEdit
extends TableOptionEdit {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.edit.SortedTableOptionEdit");
    private SortedTableHelper sth;
    private TableModelFilter filter = null;
    private DefaultTableModelSorter sorter = null;

    public SortedTableOptionEdit() {
        if (SortedTableOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "SortedTableOptionEdit.SortedTableOptionEdit()", 51).log();
        }
    }

    public void setSorter(DefaultTableModelSorter defaultTableModelSorter) {
        if (SortedTableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setSorter(DefaultTableModelSorter)", 85).addDetail("sorter", defaultTableModelSorter)).log();
        }
        if (defaultTableModelSorter != null) {
            Configuration.instance().registerAs(defaultTableModelSorter, this.option.getName() + "_sorter");
        }
        if (defaultTableModelSorter != null) {
            this.sth.setTableModelSorter(defaultTableModelSorter);
        }
        this.sorter = defaultTableModelSorter;
    }

    public DefaultTableModelSorter getSorter() {
        if (SortedTableOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "getSorter()", 106).log();
        }
        return this.sorter;
    }

    public void setFilter(TableModelFilter tableModelFilter) {
        if (SortedTableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setFilter(TableModelFilter)", 119).addDetail("filter", tableModelFilter)).log();
        }
        if (tableModelFilter != null) {
            this.sth.setTableModelFilter(tableModelFilter);
        }
        this.filter = tableModelFilter;
    }

    public TableModelFilter getFilter() {
        if (SortedTableOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "getFilter()", 135).log();
        }
        return this.filter;
    }

    public SortedTableHelper getSortedTableHelper() {
        return this.sth;
    }

    public void setSortedTableHelper(SortedTableHelper sortedTableHelper) {
        this.sth = sortedTableHelper;
    }

    @Override
    public void update(Option option) {
        if (SortedTableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "update(Option)", 178).addDetail("option", option)).log();
        }
        this.option = option;
        Object object = option.getValue();
        if (this.wrapper != null) {
            Configuration.instance().unregister(this.wrapper, true);
        }
        if (this.sorter != null) {
            Configuration.instance().unregisterAs(this.sorter, option.getName() + "_sorter", true);
        }
        this.setValue(object);
        if (this.getBoolean("configure", false)) {
            this.wrapper = ConfigWrapper.makeWrapper(this.table, option.getName() + ".table");
            Configuration.instance().register(this.wrapper);
            if (this.sorter != null) {
                Configuration.instance().registerAs(this.sorter, option.getName() + "_sorter");
            }
        }
    }

    @Override
    protected void createModel(Object[][] objectArray) {
        if (SortedTableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createModel(Object[][])", 212).addDetail("data", objectArray)).log();
        }
        super.createModel(objectArray);
        if (this.sth == null) {
            this.sth = new SortedTableHelper(this.table, this.filter, this.sorter);
            this.sth.prepareTable();
            this.sth.saveSelection(true);
            this.sth.setAlwaysSort(false);
        }
    }

    @Override
    public void cleanup() {
        int n;
        if (this.wrapper != null) {
            Configuration.instance().unregister(this.wrapper, true);
        }
        if (this.sorter != null) {
            Configuration.instance().unregisterAs(this.sorter, this.option.getName() + "_sorter", true);
        }
        this.getSortedTableHelper().cleanup();
        this.setSortedTableHelper(null);
        this.setFilter(null);
        this.setSorter(null);
        PopupManager.instance().unregisterPopupHandler(this, this.getTable());
        PopupManager.instance().unregisterPopupHandler(this, this.getTable().getTableHeader());
        PopupManager.instance().unregisterPopupHandler(this, this.scroll.getViewport());
        this.table.resetKeyboardActions();
        this.resetKeyboardActions();
        this.scroll.resetKeyboardActions();
        this.scroll.getViewport().resetKeyboardActions();
        this.table.getTableHeader().resetKeyboardActions();
        this.getTable().setDefaultRenderer(String.class, null);
        this.getTable().getTableHeader().setDefaultRenderer(null);
        for (n = this.scroll.getViewport().getMouseListeners().length - 1; n >= 0; --n) {
            this.scroll.getViewport().removeMouseListener(this.scroll.getViewport().getMouseListeners()[n]);
        }
        for (n = this.scroll.getViewport().getKeyListeners().length - 1; n >= 0; --n) {
            this.scroll.getViewport().removeKeyListener(this.scroll.getViewport().getKeyListeners()[n]);
        }
        for (n = this.scroll.getViewport().getFocusListeners().length - 1; n >= 0; --n) {
            this.scroll.getViewport().removeFocusListener(this.scroll.getViewport().getFocusListeners()[n]);
        }
        for (n = this.scroll.getMouseListeners().length - 1; n >= 0; --n) {
            this.scroll.removeMouseListener(this.scroll.getMouseListeners()[n]);
        }
        for (n = this.scroll.getKeyListeners().length - 1; n >= 0; --n) {
            this.scroll.removeKeyListener(this.scroll.getKeyListeners()[n]);
        }
        for (n = this.scroll.getFocusListeners().length - 1; n >= 0; --n) {
            this.scroll.removeFocusListener(this.scroll.getFocusListeners()[n]);
        }
        for (n = this.getTable().getInputMethodListeners().length - 1; n >= 0; --n) {
            this.getTable().removeInputMethodListener(this.getTable().getInputMethodListeners()[n]);
        }
        for (n = this.getTable().getMouseListeners().length - 1; n >= 0; --n) {
            this.getTable().removeMouseListener(this.getTable().getMouseListeners()[n]);
        }
        for (n = this.getTable().getKeyListeners().length - 1; n >= 0; --n) {
            this.getTable().removeKeyListener(this.getTable().getKeyListeners()[n]);
        }
        for (n = this.getTable().getFocusListeners().length - 1; n >= 0; --n) {
            this.getTable().removeFocusListener(this.getTable().getFocusListeners()[n]);
        }
        for (n = this.getTable().getTableHeader().getMouseListeners().length - 1; n >= 0; --n) {
            this.getTable().getTableHeader().removeMouseListener(this.getTable().getTableHeader().getMouseListeners()[n]);
        }
        for (n = this.getTable().getTableHeader().getKeyListeners().length - 1; n >= 0; --n) {
            this.getTable().getTableHeader().removeKeyListener(this.getTable().getTableHeader().getKeyListeners()[n]);
        }
        for (n = this.getTable().getTableHeader().getFocusListeners().length - 1; n >= 0; --n) {
            this.getTable().getTableHeader().removeFocusListener(this.getTable().getTableHeader().getFocusListeners()[n]);
        }
    }
}

