/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.gui.BetterScrollPane;
import de.qfs.lib.gui.PopupHandler;
import de.qfs.lib.gui.PopupManager;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.edit.Gutter;
import de.qfs.lib.option.edit.IncrementalSearch;
import de.qfs.lib.option.edit.RegexEscaper;
import de.qfs.lib.option.edit.SimpleOptionEdit;
import de.qfs.lib.option.ui.FlatScrollPane;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Reflector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import lombok.Generated;

public class TextOptionEdit
extends SimpleOptionEdit
implements PopupHandler {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.edit.TextOptionEdit");
    protected static Icon LINEBREAK_ICON;
    protected static Icon TAB_ICON;
    private double weight;
    private JScrollPane scroll;
    private Gutter gutter;
    private IncrementalSearch isearch;
    private RegexEscaper regexEscaper;
    protected boolean showWhitespaces = false;
    private int minPrefHeight;
    private int maxPrefHeight;
    private int textLines;
    private int caretLine = -1;

    @Override
    protected boolean isMultiLine() {
        if (TextOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "isMultiLine()", 252).log();
        }
        return true;
    }

    @Override
    public void init() {
        int n;
        block28: {
            String string;
            boolean bl;
            String[] stringArray;
            super.init();
            int n2 = this.getInt("width", -1);
            int n3 = this.getInt("height", -1);
            this.minPrefHeight = this.getInt("minheight", 0);
            this.maxPrefHeight = this.getInt("maxheight", 0);
            this.showWhitespaces = this.getBoolean("showwhitespaces", false);
            this.text = new Text();
            this.label.setLabelFor(this.text);
            if (n3 > 0) {
                ((JTextArea)this.text).setRows(n3);
            }
            if (n2 > 0) {
                ((JTextArea)this.text).setColumns(n2);
            }
            this.text.setName("Text-" + this.option.getName());
            if ((this.selectOnFocus || this.highlightOnFocus) && !this.disabled) {
                this.text.addFocusListener(this);
            }
            this.createBorderForScroll(this.text);
            this.text.setFont(UIManager.getFont("TextField.font"));
            boolean bl2 = false;
            String string2 = this.getString("font", null);
            if (string2 != null && (stringArray = (String[])Reflector.safeCall(this.text.getToolkit(), "getFontList")) != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    if (!stringArray[n].equals(string2)) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) {
                stringArray = this.text.getFont();
                this.text.setFont(new Font(string2, stringArray.getStyle(), stringArray.getSize()));
            }
            if (bl = this.getBoolean("scroll", true)) {
                if (this.minPrefHeight > 0 || this.maxPrefHeight != 0) {
                    this.scroll = new BetterScrollPane(this.text){

                        @Override
                        public boolean isValidateRoot() {
                            return false;
                        }

                        @Override
                        public void updateUI() {
                            super.updateUI();
                            TextOptionEdit.this.createBorderForScroll(this);
                        }
                    };
                    this.putClientProperty("BetterScrollPane.Parent", Boolean.TRUE);
                    this.text.addCaretListener(new CaretListener(){

                        @Override
                        public void caretUpdate(CaretEvent caretEvent) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (TextOptionEdit.this.text.hasFocus()) {
                                        TextOptionEdit.this.scrollCaretVisible();
                                    }
                                }
                            });
                        }
                    });
                } else {
                    this.scroll = new FlatScrollPane(this.text){

                        @Override
                        public void updateUI() {
                            super.updateUI();
                            TextOptionEdit.this.createBorderForScroll(this);
                        }
                    };
                }
                ((FlatScrollPane)this.scroll).setSpecialBorderHandling(true);
                this.scroll.setName("ScrollPane-" + this.option.getName());
                this.scroll.setBorder(this.text.getBorder());
                this.text.setBorder(new EmptyBorder(1, 2, 2, 2));
                this.add((Component)this.scroll, "Center");
                if (n2 < 0) {
                    this.setPreferredSize(new Dimension(10, this.getPreferredSize().height));
                }
            } else {
                this.scroll = null;
                this.add((Component)this.text, "Center");
            }
            if ((n = (int)(this.getBoolean("numbers", false) ? 1 : '\u0000')) != 0) {
                this.gutter = new Gutter((JTextArea)this.text);
                if (bl) {
                    this.scroll.setRowHeaderView(this.gutter);
                    ((FlatScrollPane)this.scroll).setSpecialBorderHandling(false);
                } else {
                    this.add((Component)this.gutter, "West");
                }
            }
            if (this.option.getValue() != null) {
                this.text.setText((String)this.option.getValue());
                this.text.setCaretPosition(0);
            }
            if ((string = this.getString("weight", null)) != null) {
                try {
                    this.weight = Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (TextOptionEdit.logger.level < 3) break block28;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "init()", 397).add("ex", numberFormatException)).log();
                }
            }
        }
        if ("word".equals(this.getString("wrap", null))) {
            ((JTextArea)this.text).setLineWrap(true);
            ((JTextArea)this.text).setWrapStyleWord(true);
        } else {
            ((JTextArea)this.text).setLineWrap(this.getBoolean("wrap", false));
        }
        if (this.disabled) {
            this.setEnabled(false);
        }
        if (this.readonly) {
            this.setEditable(false);
        }
        this.canIsearch = this.getBoolean("canisearch", true);
        if (this.canIsearch) {
            this.isearch = new IncrementalSearch(this.text);
        }
        this.canEscapeRegex = this.getBoolean("canescaperegex", false);
        if (this.canEscapeRegex) {
            this.createRegexEscaper();
        }
        if (this.canPopup) {
            PopupManager.instance().registerPopupHandler(PopupManager.instance(), this.text);
            if (this.canIsearch) {
                PopupManager.instance().registerPopupHandler(this.isearch, this.text);
            }
            if (this.canEscapeRegex) {
                PopupManager.instance().registerPopupHandler(this.regexEscaper, this.text);
            }
            if (n != 0) {
                PopupManager.instance().registerPopupHandler(this, this.text);
            }
        }
        this.maybeCommonPostInitSteps();
    }

    private void createBorderForScroll(JComponent jComponent) {
        if (TextOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createBorderForScroll(JComponent)", 451).addDetail("comp", jComponent)).log();
        }
        int n = this.getInt("border", 0);
        Border border = UIManager.getBorder("TextArea.scrollPaneBorder");
        if (border == null) {
            border = UIManager.getBorder("TextField.border");
        }
        if (n > 0) {
            jComponent.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createLineBorder(this.text.getBackground(), n)));
        } else {
            jComponent.setBorder(border);
        }
    }

    @Override
    public void update(Option option) {
        block5: {
            String string = this.getString("weight", null);
            if (string != null) {
                try {
                    this.weight = Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (TextOptionEdit.logger.level < 3) break block5;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "update(Option)", 482).add("ex", numberFormatException)).log();
                }
            }
        }
        if ("word".equals(this.getString("wrap", null))) {
            ((JTextArea)this.text).setLineWrap(true);
            ((JTextArea)this.text).setWrapStyleWord(true);
        } else {
            ((JTextArea)this.text).setLineWrap(this.getBoolean("wrap", false));
        }
        super.update(option);
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    public void hideGutter() {
        if (this.gutter != null) {
            this.gutter.hide();
        }
    }

    public void unhideGutter() {
        if (this.gutter != null) {
            this.gutter.unhide();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.gutter != null) {
            this.gutter.setEnabled(bl);
        }
        super.setEnabled(bl);
    }

    public boolean doShowWhitespaces() {
        return this.getBoolean("showwhitespaces", false);
    }

    public void createRegexEscaper() {
        if (TextOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "createRegexEscaper()", 569).log();
        }
        this.regexEscaper = new RegexEscaper(this, this.text);
    }

    @Override
    public Dimension getPreferredSize() {
        if (TextOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "getPreferredSize()", 585).log();
        }
        Dimension dimension = null;
        Dimension dimension2 = null;
        if (this.text != null) {
            dimension = this.text.getPreferredSize();
            dimension2 = this.scroll.getViewport().getSize();
            if (TextOptionEdit.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getPreferredSize()", 592).add("tsize", dimension)).add("vpsize", dimension2)).log();
            }
        }
        Dimension dimension3 = this.adjustPreferredSize(this.text, dimension, dimension2, this.minPrefHeight, this.maxPrefHeight);
        if (TextOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getPreferredSize()", 595).add("ret", dimension3)).log();
        }
        return dimension3;
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        if (TextOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "reshape(int,int,int,int)", 607).addDetail("x", n)).addDetail("y", n2)).addDetail("w", n3)).addDetail("h", n4)).log();
        }
        super.reshape(n, n2, n3, n4);
        if (this.text != null) {
            int n5 = ((Text)this.text).getLineCount();
            if (TextOptionEdit.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "reshape(int,int,int,int)", 612).add("new line count", n5)).log();
            }
            if (n5 > this.textLines && this.text.isFocusOwner()) {
                this.textLines = n5;
                if (TextOptionEdit.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "reshape(int,int,int,int)", 615).add("Scrolling...")).log();
                }
                Dimension dimension = this.getSize();
                this.scrollRectToVisible(new Rectangle(0, 0, dimension.width, dimension.height));
            } else {
                this.textLines = n5;
            }
        }
    }

    @Override
    public boolean fillPopup(PopupManager popupManager, Component component, JPopupMenu jPopupMenu, MapResourceBundle mapResourceBundle, int n, int n2, boolean bl) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() instanceof JCheckBoxMenuItem) {
                        if (((JCheckBoxMenuItem)actionEvent.getSource()).getState()) {
                            TextOptionEdit.this.gutter.unhide();
                        } else {
                            TextOptionEdit.this.gutter.hide();
                        }
                    }
                }
            };
            popupManager.setupAction(abstractAction, mapResourceBundle, "popup.linenumbers");
            JMenuItem jMenuItem = popupManager.createMenuItem("linenumbers", mapResourceBundle, "popup.linenumbers", (ActionListener)abstractAction, true);
            ((JCheckBoxMenuItem)jMenuItem).setState(!this.gutter.isHidden());
            popupManager.addSeparator(-1, "");
            popupManager.addMenuItem(jMenuItem, -1, "");
            return true;
        }
        return false;
    }

    private void scrollCaretVisible() {
        block8: {
            if (TextOptionEdit.logger.level >= 7) {
                logger.lvlBuild(7, "scrollCaretVisible()", 691).log();
            }
            int n = this.text.getCaret().getDot();
            try {
                int n2 = ((Text)this.text).getLineOfOffset(n);
                if (n2 != this.caretLine) {
                    Rectangle rectangle = this.text.modelToView(n);
                    if (TextOptionEdit.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "scrollCaretVisible()", 698).add("rect", rectangle)).log();
                    }
                    if (rectangle != null) {
                        rectangle = SwingUtilities.convertRectangle(this.text, rectangle, this);
                        if (TextOptionEdit.logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "scrollCaretVisible()", 701).add("converted rect", rectangle)).log();
                        }
                        Dimension dimension = this.getSize();
                        rectangle.x = 0;
                        rectangle.width = this.getWidth();
                        rectangle.height = ((Text)this.text).getRowHeight();
                        SwingUtilities.computeIntersection(0, 0, dimension.width, dimension.height, rectangle);
                        if (TextOptionEdit.logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "scrollCaretVisible()", 707).add("intersected rect", rectangle)).log();
                        }
                        this.scrollRectToVisible(rectangle);
                    }
                }
                this.caretLine = n2;
            }
            catch (BadLocationException badLocationException) {
                if (TextOptionEdit.logger.level < 3) break block8;
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "scrollCaretVisible()", 714).add("ex", badLocationException)).log();
            }
        }
    }

    @Generated
    public RegexEscaper getRegexEscaper() {
        if (TextOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "getRegexEscaper()", 202).log();
        }
        return this.regexEscaper;
    }

    @Generated
    public TextOptionEdit setRegexEscaper(RegexEscaper regexEscaper) {
        if (TextOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setRegexEscaper(RegexEscaper)", 203).addDetail("regexEscaper", regexEscaper)).log();
        }
        this.regexEscaper = regexEscaper;
        return this;
    }

    protected class Text
    extends JTextArea {
        protected Text() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Text.Text()", 724).log();
            }
        }

        @Override
        public boolean isFocusTraversable() {
            return this.isEditable() && this.isEnabled();
        }

        @Override
        public boolean isFocusable() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics graphics) {
            try {
                super.paintComponent(graphics);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (logger.level >= 5) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "Text.paintComponent(Graphics)", 756).add("ex", arrayIndexOutOfBoundsException)).log();
                }
                this.setHighlighter(null);
                try {
                    super.paintComponent(graphics);
                }
                catch (Throwable throwable) {
                    if (logger.level >= 3) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "Text.paintComponent(Graphics)", 762).add("ex2", throwable)).log();
                    }
                    return;
                }
            }
            if (!(this.getUI().getRootView(this).getView(0) instanceof TabExpander)) {
                return;
            }
            if (TextOptionEdit.this.doShowWhitespaces()) {
                Graphics graphics2 = graphics;
                try {
                    int n = this.getRowHeight();
                    String string = this.getText();
                    int n2 = Utilities.getTabbedTextWidth(new Segment(new char[]{'\t'}, 0, 1), this.getFontMetrics(this.getFont()), 0, (TabExpander)((Object)this.getUI().getRootView(this).getView(0)), 0);
                    for (int i = 0; i < this.getLineCount(); ++i) {
                        int n3;
                        String string2;
                        String string3 = "";
                        try {
                            string3 = string.substring(this.getLineStartOffset(i), this.getLineEndOffset(i));
                        }
                        catch (BadLocationException badLocationException) {
                            break;
                        }
                        if (Misc.emptyOrNull(string3)) continue;
                        String[] stringArray = null;
                        if (string3.endsWith("\t")) {
                            string3 = string3 + " ";
                        }
                        stringArray = string3.split("\t");
                        int n4 = 0;
                        int n5 = 1;
                        if (this.getMargin() != null) {
                            n4 += this.getMargin().top;
                            n5 += this.getMargin().left;
                        }
                        if (stringArray != null) {
                            string2 = "";
                            for (n3 = 0; n3 < stringArray.length && (n3 != stringArray.length - 1 || Misc.emptyOrNull(stringArray[n3])); ++n3) {
                                string2 = string2 + stringArray[n3];
                                int n6 = Utilities.getTabbedTextWidth(new Segment(string2.toCharArray(), 0, string2.length()), this.getFontMetrics(this.getFont()), 0, (TabExpander)((Object)this.getUI().getRootView(this).getView(0)), 0);
                                string2 = string2 + "\t";
                                int n7 = Utilities.getTabbedTextWidth(new Segment(string2.toCharArray(), 0, string2.length()), this.getFontMetrics(this.getFont()), 0, (TabExpander)((Object)this.getUI().getRootView(this).getView(0)), 0);
                                int n8 = n7 - n6;
                                int n9 = n6 + n8 / 2;
                                if (n6 == -1) break;
                                if (TAB_ICON.getIconWidth() > n8) continue;
                                TAB_ICON.paintIcon(this, graphics2, n9 + n5, n * i + n / 2 - TAB_ICON.getIconHeight() / 2 + n4);
                            }
                        }
                        if (!string3.endsWith("\n")) continue;
                        string2 = string3.substring(0, string3.length() - 1);
                        n3 = Utilities.getTabbedTextWidth(new Segment(string2.toCharArray(), 0, string2.length()), this.getFontMetrics(this.getFont()), 0, (TabExpander)((Object)this.getUI().getRootView(this).getView(0)), 0);
                        if (n3 == -1) {
                            break;
                        }
                        if (LINEBREAK_ICON == null) continue;
                        LINEBREAK_ICON.paintIcon(this, graphics2, n3 + n5, n * i + n / 2 - LINEBREAK_ICON.getIconHeight() / 2 + n4);
                    }
                }
                finally {
                    if (graphics2 != null) {
                        graphics2.dispose();
                    }
                }
            }
        }

        @Override
        public void updateUI() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Text.updateUI()", 876).dumpStack();
            }
            Caret caret = this.getCaret();
            int n = 0;
            int n2 = 0;
            if (caret != null) {
                n = caret.getDot();
                n2 = caret.getMark();
            }
            super.updateUI();
            if (caret != null) {
                this.setCaret(caret);
                caret.setDot(n);
                caret.moveDot(n2);
            }
        }

        @Override
        public int getRowHeight() {
            return super.getRowHeight();
        }
    }
}

