/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.edit.BooleanOptionEdit;
import de.qfs.lib.option.edit.DynamicChangingEdit;
import de.qfs.lib.option.edit.OptionEdit;
import de.qfs.lib.option.group.OptionGroup;
import de.qfs.lib.util.Misc;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public class TogglingOptionEdit
extends BooleanOptionEdit
implements DynamicChangingEdit {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.edit.TogglingOptionEdit");
    String[] enabledOptions;
    String[] disabledOptions;
    String[] visibleOptions;
    String[] invisibleOptions;
    List<String> visibleOptionsNullNotAllowed;
    List<String> invisibleOptionsNullNotAllowed;

    @Override
    public void init() {
        String string = this.option.getName();
        String string2 = this.getString("enabledoptions", null);
        String string3 = this.getString("disabledoptions", null);
        String string4 = this.getString("visibleoptions", null);
        String string5 = this.getString("invisibleoptions", null);
        this.enabledOptions = string2 == null ? new String[]{} : Misc.fastSplit(string2, ' ');
        this.disabledOptions = string3 == null ? new String[]{} : Misc.fastSplit(string3, ' ');
        this.visibleOptions = string4 == null ? new String[]{} : Misc.fastSplit(string4, ' ');
        this.invisibleOptions = string5 == null ? new String[]{} : Misc.fastSplit(string5, ' ');
        super.init();
    }

    @Override
    public void update(Option option) {
        super.update(option);
        this.updateOptions();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.updateOptions();
    }

    @Override
    public void updateOptions() {
        OptionEdit optionEdit;
        if (this.check == null) {
            if (TogglingOptionEdit.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "updateOptions()", 102).add("check is still null")).log();
            }
            return;
        }
        this.initializeNullOkayList();
        boolean bl = this.check.isSelected();
        OptionGroup optionGroup = this.getOptionGroup();
        for (String string : this.enabledOptions) {
            optionEdit = optionGroup.findEdit(string);
            if (optionEdit == null) continue;
            optionEdit.setEnabled(bl);
        }
        for (String string : this.disabledOptions) {
            optionEdit = optionGroup.findEdit(string);
            if (optionEdit == null) continue;
            optionEdit.setEnabled(!bl);
        }
        for (String string : this.visibleOptions) {
            optionEdit = optionGroup.findEdit(string);
            if (optionEdit == null) continue;
            if (Misc.isObjectInIterable(string, this.visibleOptionsNullNotAllowed)) {
                optionEdit.getOption().setNullOK(!bl);
            }
            optionEdit.setVisible(bl);
            if (!bl) continue;
            optionEdit.checkValue(true);
        }
        for (String string : this.invisibleOptions) {
            optionEdit = optionGroup.findEdit(string);
            if (optionEdit == null) continue;
            if (Misc.isObjectInIterable(string, this.invisibleOptionsNullNotAllowed)) {
                optionEdit.getOption().setNullOK(bl);
            }
            optionEdit.setVisible(!bl);
            if (bl) continue;
            optionEdit.checkValue(true);
        }
        OptionGroup.fixSpacingOfHierarchy(optionGroup, false);
    }

    private void initializeNullOkayList() {
        boolean bl;
        OptionEdit optionEdit;
        if (this.visibleOptionsNullNotAllowed == null) {
            this.visibleOptionsNullNotAllowed = new LinkedList<String>();
            for (String string : this.visibleOptions) {
                optionEdit = this.getOptionGroup().findEdit(string);
                if (optionEdit == null) {
                    this.visibleOptionsNullNotAllowed = null;
                    return;
                }
                bl = optionEdit.getOption().isNullOK();
                if (bl) continue;
                this.visibleOptionsNullNotAllowed.add(string);
            }
        }
        if (this.invisibleOptionsNullNotAllowed == null) {
            this.invisibleOptionsNullNotAllowed = new LinkedList<String>();
            for (String string : this.invisibleOptions) {
                optionEdit = this.getOptionGroup().findEdit(string);
                if (optionEdit == null) {
                    this.invisibleOptionsNullNotAllowed = null;
                    return;
                }
                bl = optionEdit.getOption().isNullOK();
                if (bl) continue;
                this.invisibleOptionsNullNotAllowed.add(string);
            }
        }
    }
}

