/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.group;

import de.qfs.lib.gui.Grid;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.edit.OptionEdit;
import de.qfs.lib.option.group.OptionGroup;
import java.awt.Component;
import lombok.Generated;

public class PlainOptionGroup
extends OptionGroup {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.group.PlainOptionGroup");
    protected Grid grid;

    protected PlainOptionGroup() {
    }

    public PlainOptionGroup(String string, OptionSet optionSet) {
        super(string, optionSet);
        if (PlainOptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "PlainOptionGroup(String,OptionSet)", 123).addDetail("name", string)).addDetail("options", optionSet)).log();
        }
        this.createMembers();
    }

    @Override
    public Component getComponent() {
        if (this.grid == null) {
            this.makeGrid();
            this.fillGrid();
            this.makeBorder(this.grid);
            if (this.disabled) {
                this.setEnabled(false);
            }
            this.grid.setName("OptionGroup-" + this.name + "-" + this.options.getConfigurableName());
        }
        return this.grid;
    }

    @Override
    public void setVisible(boolean bl) {
        this.grid.setVisible(bl);
    }

    protected void makeGrid() {
        if (PlainOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "makeGrid()", 177).log();
        }
        this.grid = new Grid(editHorizontalDistance, editVerticalDistance){

            @Override
            public void updateUI() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "makeGrid().Grid.updateUI()", 180).log();
                }
                super.updateUI();
                PlainOptionGroup.this.makeBorder(this);
            }
        };
    }

    protected void fillGrid() {
        if (PlainOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "fillGrid()", 188).log();
        }
        int n = this.getInt("columns", 1);
        for (int i = 0; i < this.members.size(); i += n) {
            int n2 = Math.min(n, this.members.size() - i);
            Component[] componentArray = new Component[n2];
            double d = 0.0;
            for (int j = 0; j < n2; ++j) {
                Object e = this.members.get(i + j);
                if (PlainOptionGroup.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "fillGrid()", 197).add("member", e)).log();
                }
                if (e instanceof OptionGroup) {
                    componentArray[j] = ((OptionGroup)e).getComponent();
                    d = Math.max(d, ((OptionGroup)e).getWeight());
                    if (PlainOptionGroup.logger.level < 9) continue;
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "fillGrid()", 202).add("weight", d)).log();
                    continue;
                }
                componentArray[j] = (OptionEdit)e;
                d = Math.max(d, ((OptionEdit)e).getWeight());
                if (PlainOptionGroup.logger.level < 9) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "fillGrid()", 206).add("weight", d)).log();
            }
            this.grid.addLine(componentArray, d);
        }
        if (this.getString("weight", null) == null) {
            this.weight = this.grid.getTotalWeight();
        }
    }
}

