/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.group;

import de.qfs.lib.gui.Grid;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.gui.ThemeSupport;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.group.OptionGroup;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicBorders;
import lombok.Generated;

public class RadioOptionGroup
extends OptionGroup {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.group.RadioOptionGroup");
    protected static final Border SEARCH_HIGHLIGHT_BORDER = BorderFactory.createLineBorder(DEFAULT_SEARCH_MARK_COLOR);
    protected static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    protected static final Border MARGIN_BORDER = new BasicBorders.MarginBorder();
    protected List choices;
    protected Grid grid;
    protected Option option;
    protected String optionName;
    protected ButtonGroup buttonGroup;
    protected List buttons;

    protected RadioOptionGroup() {
    }

    public RadioOptionGroup(String string, OptionSet optionSet) {
        super(string, optionSet);
        if (RadioOptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "RadioOptionGroup(String,OptionSet)", 191).addDetail("name", string)).addDetail("options", optionSet)).log();
        }
        this.getChoices();
    }

    public Option getOption() {
        return this.option;
    }

    @Override
    public boolean isModified() {
        if (this.buttonGroup == null) {
            return false;
        }
        if (!(this.option.getValue() instanceof Integer)) {
            return true;
        }
        int n = (Integer)this.option.getValue();
        ButtonModel buttonModel = this.buttonGroup.getSelection();
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (((JRadioButton)this.buttons.get(i)).getModel() != buttonModel) continue;
            return n != i + 1;
        }
        return true;
    }

    @Override
    public boolean isSuspect() {
        return false;
    }

    @Override
    public boolean checkValues() {
        if (RadioOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "checkValues()", 274).log();
        }
        if (this.isDisabled()) {
            return true;
        }
        if (this.buttonGroup == null) {
            return true;
        }
        ButtonModel buttonModel = this.buttonGroup.getSelection();
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (((JRadioButton)this.buttons.get(i)).getModel() != buttonModel) continue;
            if (this.option.checkValue(this.grid, i + 1)) break;
            ((JRadioButton)this.buttons.get(i)).requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public void readValues() {
        if (RadioOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "readValues()", 305).log();
        }
        if (this.buttonGroup == null) {
            return;
        }
        ButtonModel buttonModel = this.buttonGroup.getSelection();
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (((JRadioButton)this.buttons.get(i)).getModel() != buttonModel) continue;
            this.option.setValue(i + 1);
            return;
        }
        this.option.setValue(0);
    }

    @Override
    public void notifyOptionObservers() {
        if (RadioOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "notifyOptionObservers()", 328).log();
        }
        this.option.notifyObservers();
    }

    @Override
    public void update(OptionSet optionSet) {
        if (RadioOptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "update(OptionSet)", 343).addDetail("options", optionSet)).log();
        }
        if (RadioOptionGroup.logger.level >= 10) {
            ((LevelAwareLogBuilder)logger.lvlBuild(10, "update(OptionSet)", 345).add("options", optionSet.listOptions())).log();
        }
        this.options = optionSet;
        this.option = optionSet.getOption(this.optionName);
        if (this.option == null) {
            throw new NullPointerException();
        }
        if (this.buttonGroup == null) {
            return;
        }
        int n = (Integer)this.option.getValue();
        if (n >= 1 && n <= this.buttons.size()) {
            ((JRadioButton)this.buttons.get(n - 1)).setSelected(true);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (RadioOptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setEnabled(boolean)", 371).addDetail("enabled", bl)).log();
        }
        super.setEnabled(bl);
        Iterator iterator = this.buttons.iterator();
        while (iterator.hasNext()) {
            ((JRadioButton)iterator.next()).setEnabled(this.enabled);
        }
    }

    @Override
    public Component getComponent() {
        if (RadioOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "getComponent()", 389).log();
        }
        if (this.grid == null) {
            this.makeGrid();
        }
        return this.grid;
    }

    public int getCurrentValue() {
        if (RadioOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "getCurrentValue()", 408).log();
        }
        if (this.buttonGroup == null) {
            return 0;
        }
        ButtonModel buttonModel = this.buttonGroup.getSelection();
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (((JRadioButton)this.buttons.get(i)).getModel() != buttonModel) continue;
            return i + 1;
        }
        return 0;
    }

    public void addActionListener(ActionListener actionListener, int n) {
        ((JRadioButton)this.buttons.get(n - 1)).addActionListener(actionListener);
    }

    public void addItemListener(ItemListener itemListener, int n) {
        ((JRadioButton)this.buttons.get(n - 1)).addItemListener(itemListener);
    }

    public void removeAllListeners(int n) {
        int n2;
        for (n2 = ((JRadioButton)this.buttons.get(n - 1)).getItemListeners().length - 1; n2 >= 0; --n2) {
            ((JRadioButton)this.buttons.get(n - 1)).removeItemListener(((JRadioButton)this.buttons.get(n - 1)).getItemListeners()[n2]);
        }
        for (n2 = ((JRadioButton)this.buttons.get(n - 1)).getActionListeners().length - 1; n2 >= 0; --n2) {
            ((JRadioButton)this.buttons.get(n - 1)).removeActionListener(((JRadioButton)this.buttons.get(n - 1)).getActionListeners()[n2]);
        }
    }

    protected void getChoices() {
        if (RadioOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "getChoices()", 494).log();
        }
        MapResourceBundle mapResourceBundle = Option.getResources();
        this.choices = new ArrayList();
        int n = this.getInt("numchoices", -1);
        if (n < 0 && RadioOptionGroup.logger.level >= 1) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "getChoices()", 501).add("No numchoices for RadioOptionGroup ")).add(this.name)).log();
        }
        this.optionName = this.getString("option", null);
        if (this.optionName == null && RadioOptionGroup.logger.level >= 1) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "getChoices()", 506).add("No option for RadioOptionGroup ")).add(this.name)).log();
        }
        this.option = this.options.getOption(this.optionName);
        if (this.option == null && RadioOptionGroup.logger.level >= 1) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "getChoices()", 510).add("No option for RadioOptionGroup ")).add(this.name)).log();
        }
        for (int i = 1; i <= n; ++i) {
            String string = this.getString("choice" + i + ".label", null);
            if (string == null) {
                if (RadioOptionGroup.logger.level < 1) continue;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "getChoices()", 517).add("No label for choice ")).add(i)).add(" in RadioOptionGroup ")).add(this.name)).log();
                continue;
            }
            String string2 = "true";
            String string3 = this.getString("choice" + i + ".visible", null);
            if (!Misc.emptyOrNull(string3) && !Boolean.parseBoolean(string3)) {
                string2 = "false";
            }
            String string4 = this.getString("choice" + i + ".mnemonic", null);
            this.choices.add(new String[]{string, string4, string2});
        }
    }

    protected void makeGrid() {
        int n;
        if (RadioOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "makeGrid()", 539).log();
        }
        MapResourceBundle mapResourceBundle = Option.getResources();
        int n2 = this.getInt("columns", 1);
        this.grid = new Grid(editHorizontalDistance, editVerticalDistance);
        this.grid.setName("OptionGroup-" + this.name + "-" + this.options.getConfigurableName());
        this.buttonGroup = new ButtonGroup();
        this.buttons = new ArrayList();
        for (n = 0; n < this.choices.size(); n += n2) {
            int n3 = Math.min(n2, this.choices.size() - n);
            Component[] componentArray = new ChoiceRadioButton[n3];
            for (int i = 0; i < n3; ++i) {
                boolean bl;
                block8: {
                    componentArray[i] = new ChoiceRadioButton(((String[])this.choices.get(n + i))[0]);
                    String string = ((String[])this.choices.get(n + i))[1];
                    if (string != null && string.length() > 0) {
                        ((AbstractButton)componentArray[i]).setMnemonic(string.charAt(0));
                    }
                    componentArray[i].setName("Choice" + (n + i + 1) + "-" + this.name);
                    ((ChoiceRadioButton)componentArray[i]).setResource("option.group." + this.name + ".choice" + (n + i + 1));
                    this.buttonGroup.add((AbstractButton)componentArray[i]);
                    this.buttons.add(componentArray[i]);
                    bl = true;
                    try {
                        bl = "true".equals(((String[])this.choices.get(n + i))[2]);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        if (RadioOptionGroup.logger.level < 5) break block8;
                        ((LevelAwareLogBuilder)logger.lvlBuild(5, "makeGrid()", 569).add("aiobe", arrayIndexOutOfBoundsException)).log();
                    }
                }
                ((JComponent)componentArray[i]).setVisible(bl);
            }
            this.grid.addLine(componentArray);
        }
        n = (Integer)this.option.getValue();
        if (n >= 1 && n <= this.buttons.size()) {
            ((JRadioButton)this.buttons.get(n - 1)).setSelected(true);
        }
        if (this.disabled) {
            this.setEnabled(false);
        }
        this.makeBorder(this.grid);
    }

    @Override
    public boolean matchesFilterText(Predicate<String> predicate) {
        if (RadioOptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "matchesFilterText(Predicate<String>)", 599).addDetail("matcher", predicate)).log();
        }
        if (predicate == null) {
            return true;
        }
        boolean bl = super.matchesFilterText(predicate);
        for (int i = 0; i < this.choices.size(); ++i) {
            if (!(this.choices.get(i) instanceof String[])) continue;
            String string = ((String[])this.choices.get(i))[0];
            boolean bl2 = predicate.test(string);
            bl |= bl2;
            if (this.buttons == null) continue;
            ((ChoiceRadioButton)this.buttons.get(i)).setIsSearchMatch(bl2);
        }
        this.isMarked |= bl;
        return bl;
    }

    @Override
    public void markSearchHit(boolean bl) {
        if (RadioOptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "markSearchHit(boolean)", 631).addDetail("doMark", bl)).log();
        }
        super.markSearchHit(bl);
        if (!bl && this.buttons != null) {
            for (int i = 0; i < this.buttons.size(); ++i) {
                ((ChoiceRadioButton)this.buttons.get(i)).setIsSearchMatch(false);
            }
        }
    }

    public boolean isActive() {
        if (RadioOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "isActive()", 649).log();
        }
        return !this.disabled;
    }

    @Generated
    public List getButtons() {
        if (RadioOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "getButtons()", 164).log();
        }
        return this.buttons;
    }

    public class ChoiceRadioButton
    extends JRadioButton {
        String rawLabel;
        String resource;
        boolean initialized;
        private boolean isSearchMatch;

        public ChoiceRadioButton(String string) {
            super(ThemeSupport.extendHtmlWrapping(RadioOptionGroup.this.getResourceName(), string));
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "ChoiceRadioButton.ChoiceRadioButton(String)", 666).addDetail("label", string)).log();
            }
            this.setBorder(EMPTY_BORDER);
            this.setBorderPainted(true);
            this.rawLabel = Misc.equalOrNull(this.getText(), string) ? null : string;
            this.adjustTextColor();
            this.initialized = true;
        }

        public void adjustTextColor() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ChoiceRadioButton.adjustTextColor()", 679).log();
            }
            this.setForeground(UIManager.getColor(RadioOptionGroup.this.isActive() ? "textText" : "textInactiveText"));
        }

        @Override
        public void setText(String string) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "ChoiceRadioButton.setText(String)", 687).addDetail("text", string)).log();
            }
            if (!this.initialized) {
                super.setText(string);
                return;
            }
            super.setText(ThemeSupport.extendHtmlWrapping(RadioOptionGroup.this.getResourceName(), string));
            this.rawLabel = Misc.equalOrNull(this.getText(), string) ? null : string;
        }

        @Override
        public void updateUI() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ChoiceRadioButton.updateUI()", 701).log();
            }
            SwingUtil.cleanupKeyHandlers(this);
            super.updateUI();
            this.updateBorder();
            this.adjustTextColor();
            if (this.rawLabel != null) {
                super.setText(ThemeSupport.extendHtmlWrapping(RadioOptionGroup.this.getResourceName(), this.rawLabel));
            }
        }

        public void setIsSearchMatch(boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "ChoiceRadioButton.setIsSearchMatch(boolean)", 715).addDetail("isSearchMatch", bl)).log();
            }
            if (this.isSearchMatch != bl) {
                this.isSearchMatch = bl;
                this.updateBorder();
            }
        }

        private void updateBorder() {
            Border border;
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ChoiceRadioButton.updateBorder()", 726).log();
            }
            if (this.isSearchMatch) {
                border = UIManager.getBorder("OptionGroup.markBorder");
                if (border == null) {
                    border = SEARCH_HIGHLIGHT_BORDER;
                }
            } else {
                border = EMPTY_BORDER;
            }
            this.setBorder(BorderFactory.createCompoundBorder(border, MARGIN_BORDER));
        }

        @Generated
        public String getResource() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ChoiceRadioButton.getResource()", 660).log();
            }
            return this.resource;
        }

        @Generated
        public ChoiceRadioButton setResource(String string) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "ChoiceRadioButton.setResource(String)", 660).addDetail("resource", string)).log();
            }
            this.resource = string;
            return this;
        }
    }
}

