/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.group;

import de.qfs.lib.gui.Grid;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.group.OptionGroup;
import de.qfs.lib.util.MapResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import lombok.Generated;

public class TabbedOptionGroup
extends OptionGroup {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.group.TabbedOptionGroup");
    protected JTabbedPane pane;

    protected TabbedOptionGroup() {
    }

    public TabbedOptionGroup(String string, OptionSet optionSet) {
        super(string, optionSet);
        if (TabbedOptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "TabbedOptionGroup(String,OptionSet)", 145).addDetail("name", string)).addDetail("options", optionSet)).log();
        }
        this.createMembers();
    }

    @Override
    public Component getComponent() {
        if (this.pane == null) {
            this.makePane();
        }
        return this.pane;
    }

    @Override
    protected void createMembers() {
        if (TabbedOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "createMembers()", 184).log();
        }
        MapResourceBundle mapResourceBundle = Option.getResources();
        this.members = new ArrayList();
        int n = this.getInt("numtabs", -1);
        if (n < 0 && TabbedOptionGroup.logger.level >= 1) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "createMembers()", 191).add("No numtabs for TabbedOptionGroup ")).add(this.name)).log();
        }
        for (int i = 1; i <= n; ++i) {
            String string = this.getString("tab" + i + ".group", null);
            if (string == null) {
                if (TabbedOptionGroup.logger.level < 1) continue;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "createMembers()", 197).add("No group for tab ")).add(i)).add(" in TabbedOptionGroup ")).add(this.name)).log();
                continue;
            }
            OptionGroup optionGroup = OptionGroup.makeGroup(string, this.options);
            if (optionGroup == null) continue;
            optionGroup.setParentGroup(this);
            this.members.add(optionGroup);
        }
    }

    protected void makePane() {
        if (TabbedOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "makePane()", 214).log();
        }
        MapResourceBundle mapResourceBundle = Option.getResources();
        int[] nArray = new int[]{-1};
        this.pane = new JTabbedPane();
        this.pane.setName("OptionGroup-" + this.name + "-" + this.options.getConfigurableName());
        for (int i = 0; i < this.members.size(); ++i) {
            String string = this.getString("tab" + (i + 1) + ".title", "Missing title");
            Component component = ((OptionGroup)this.members.get(i)).getComponent();
            if (component instanceof Grid && ((Grid)component).needGlue()) {
                ((Grid)component).addGlue();
            }
            if (!(component instanceof JComponent) || ((JComponent)component).getBorder() != null) {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add(component, "Center");
                component = jPanel;
            }
            ((JComponent)component).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.pane.addTab(string, component);
        }
        this.pane.setModel(new DefaultSingleSelectionModel(){

            @Override
            public void setSelectedIndex(int n) {
                int n2 = this.getSelectedIndex();
                if (n != n2 && n2 != -1 && !((OptionGroup)TabbedOptionGroup.this.members.get(n2)).checkValues()) {
                    return;
                }
                super.setSelectedIndex(n);
            }
        });
        this.pane.setUI(new BasicTabbedPaneUI(){

            @Override
            protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "makePane().BasicTabbedPaneUI.paintFocusIndicator(Graphics,int,Rectangle[],int,Rectangle,Rectangle,boolean)", 263).addDetail("g", graphics)).addDetail("tabPlacement", n)).addDetail("rects", rectangleArray)).addDetail("tabIndex", n2)).addDetail("iconRect", rectangle)).addDetail("textRect", rectangle2)).addDetail("isSelected", bl)).log();
                }
                Rectangle rectangle3 = rectangleArray[n2];
                if (this.tabPane.hasFocus() && bl) {
                    graphics.setColor(this.focus);
                    int n3 = rectangle3.x + 4;
                    int n4 = rectangle3.y + 2;
                    int n5 = rectangle3.width - 8;
                    int n6 = rectangle3.height - 6;
                    graphics.drawRect(n3, n4, n5, n6);
                }
            }

            @Override
            protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "makePane().BasicTabbedPaneUI.paintTabBorder(Graphics,int,int,int,int,int,int,boolean)", 280).addDetail("g", graphics)).addDetail("tabPlacement", n)).addDetail("tabIndex", n2)).addDetail("x", n3)).addDetail("y", n4)).addDetail("w", n5)).addDetail("h", n6)).addDetail("isSelected", bl)).log();
                }
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setColor(this.lightHighlight);
                graphics2D.drawLine(n3, n4, n3 + n5 - 2, n4);
                graphics2D.drawLine(n3, n4, n3, n4 + n6 - 1);
                graphics2D.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 1);
                graphics2D.dispose();
            }
        });
        this.pane.setSelectedIndex(0);
        if (this.pane.getTabCount() > 0) {
            nArray[0] = 0;
            this.pane.setTitleAt(0, "<html><b>" + this.pane.getTitleAt(0) + "</b></html>");
        }
        this.pane.addChangeListener(changeEvent -> {
            String string;
            int n = this.pane.getTabCount();
            int n2 = this.pane.getSelectedIndex();
            if (n == 0 || n2 == -1) {
                return;
            }
            if (nArray[0] != -1 && nArray[0] < n && nArray[0] != n2) {
                string = this.pane.getTitleAt(nArray[0]).replaceAll("<html><b>", "").replaceAll("</b></html>", "");
                this.pane.setTitleAt(nArray[0], string);
            }
            if (n2 < n && !(string = this.pane.getTitleAt(n2)).contains("<b>")) {
                this.pane.setTitleAt(n2, "<html><b>" + string + "</b></html>");
            }
            nArray[0] = n2;
        });
        if (this.disabled) {
            this.setEnabled(false);
        }
        this.makeBorder(this.pane);
    }
}

