/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.group;

import de.qfs.lib.config.ConfigWrapper;
import de.qfs.lib.config.Configurable;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.config.JSplitPaneConfigWrapper;
import de.qfs.lib.gui.AdapterTreeModel;
import de.qfs.lib.gui.DelayedTreeSelectionListener;
import de.qfs.lib.gui.Grid;
import de.qfs.lib.gui.tree.AbstractTreeModelFilter;
import de.qfs.lib.gui.tree.filter.FilterTextTreeModelFilter;
import de.qfs.lib.gui.tree.filter.FilteredTreeGUIHelper;
import de.qfs.lib.gui.tree.hierarchyfilter.HierarchicalTreeFilterTraversal;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.OptionGroupTreeAdapter;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.edit.OptionEdit;
import de.qfs.lib.option.edit.OptionEditCallbacks;
import de.qfs.lib.option.group.OptionGroup;
import de.qfs.lib.option.group.PlainOptionGroup;
import de.qfs.lib.tree.IndexBasedTreeAdapter;
import de.qfs.lib.tree.ReturnFromTraversalException;
import de.qfs.lib.tree.Traversal;
import de.qfs.lib.tree.TraversalCallback;
import de.qfs.lib.tree.TreeUtil;
import de.qfs.lib.util.Reflector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import lombok.Generated;

public class TreeOptionGroup
extends OptionGroup {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.group.TreeOptionGroup");
    protected JSplitPane pane;
    protected JTree tree;
    protected AdapterTreeModel model;
    protected JPanel panel;
    protected JPanel innerPanel;
    protected JLabel title;
    protected JScrollPane scroll;
    protected Node current;
    protected DelayedTreeSelectionListener listener;
    @Nullable
    protected FilteredTreeGUIHelper filterTreeHelper;

    protected TreeOptionGroup() {
        if (TreeOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "TreeOptionGroup()", 266).log();
        }
    }

    public TreeOptionGroup(String string, OptionSet optionSet) {
        super(string, optionSet);
        if (TreeOptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "TreeOptionGroup(String,OptionSet)", 279).addDetail("name", string)).addDetail("options", optionSet)).log();
        }
    }

    @Override
    public Component getComponent() {
        if (TreeOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "getComponent()", 297).log();
        }
        if (this.pane == null) {
            this.makePane();
            this.setupBorders();
        }
        this.disableSearchFieldTemorary();
        return this.pane;
    }

    public void selectNode(final @Nullable String string) {
        Node node;
        if (TreeOptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "selectNode(String)", 315).addDetail("path", string)).log();
        }
        TreePath treePath = null;
        if (string != null && string.startsWith(((Node)this.model.getRoot()).path) && (node = (Node)TreeUtil.traverse(this.model.getAdapter(), this.model.getRoot(), new TraversalCallback(){

            @Override
            public boolean nodeEntered(Traversal traversal) throws ReturnFromTraversalException {
                Node node;
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "selectNode(String).TraversalCallback.nodeEntered(Traversal)", 323).addDetail("traversal", traversal)).log();
                }
                if ((node = (Node)traversal.getNode()) == null) {
                    return false;
                }
                if (string.startsWith(node.path)) {
                    if (string.length() == node.path.length()) {
                        throw new ReturnFromTraversalException(node);
                    }
                    return true;
                }
                return false;
            }

            @Override
            public void nodeExited(Traversal traversal) throws ReturnFromTraversalException {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "selectNode(String).TraversalCallback.nodeExited(Traversal)", 341).addDetail("traversal", traversal)).log();
                }
            }
        })) != null) {
            treePath = new TreePath(TreeUtil.getPath(this.model.getAdapter(), node));
        }
        if (treePath != null) {
            this.tree.makeVisible(treePath);
            this.tree.scrollPathToVisible(treePath);
        }
        this.tree.setSelectionPath(treePath);
    }

    protected void makePane() {
        Object object;
        Object object2;
        if (TreeOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "makePane()", 367).log();
        }
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(null);
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BorderLayout());
        this.innerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.scroll = new JScrollPane();
        this.scroll.setName("OptionGroup-" + this.name + "-Groupscrollpane");
        this.scroll.setBorder(BorderFactory.createEtchedBorder());
        this.title = new JLabel();
        this.title.setName("OptionGroup-" + this.name + "-Grouptitle");
        this.title.setForeground(UIManager.getColor("textText"));
        this.title.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 2));
        this.makeTree();
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setName("OptionGroup-" + this.name + "-Treescrollpane");
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        JComponent jComponent = this.getBoolean("search", false) ? this.setupSearch(jScrollPane) : jScrollPane;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(null);
        jPanel.add((Component)jComponent, "Center");
        String string = this.getString("title", null);
        if (string != null) {
            object2 = new JLabel(string);
            ((Component)object2).setName("OptionGroup-" + this.name + "-Title");
            ((JComponent)object2).setForeground(UIManager.getColor("textText"));
            ((JComponent)object2).setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 2));
            jPanel.add((Component)object2, "North");
            object = this.getString("mnemonic", null);
            if (object != null && ((String)object).length() > 0) {
                ((JLabel)object2).setDisplayedMnemonic(((String)object).charAt(0));
            }
            ((JLabel)object2).setLabelFor(this.tree);
        }
        this.pane = new JSplitPane(1, jPanel, this.panel);
        object2 = this.getString("divider", null);
        object = null;
        if (object2 != null) {
            try {
                Double d = Double.valueOf((String)object2);
                if (d >= 0.0 && d <= 1.0) {
                    object = new JSplitPaneConfigWrapper(this.pane, this.name + ".splitpane", d);
                } else if (d.intValue() >= 1) {
                    object = new JSplitPaneConfigWrapper(this.pane, this.name + ".splitpane", d.intValue());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.getBoolean("configure", false)) {
            if (object == null) {
                object = ConfigWrapper.makeWrapper(this.pane, this.name + ".splitpane");
            }
            Configuration.instance().register((Configurable)object);
        }
        this.pane.setName("OptionGroup-" + this.name + "-" + this.options.getConfigurableName());
        this.pane.setBorder(BorderFactory.createEtchedBorder());
    }

    protected void makeTree() {
        if (TreeOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "makeTree()", 452).log();
        }
        Tree tree = new Tree();
        this.model = new AdapterTreeModel(tree, tree.getRoot());
        this.tree = new JTree(this.model){

            @Override
            public void requestFocus() {
                super.requestFocus();
                if (!this.hasFocus()) {
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new FocusEvent(this, 1004));
                }
            }
        };
        this.tree.setName("OptionGroup-" + this.name + "-Tree");
        this.tree.setBorder(null);
        this.tree.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        this.tree.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        Object object = Reflector.safeCall((Object)this.tree, "getInputMap", Integer.TYPE, (Object)0);
        if (object != null) {
            Reflector.safeCall(object, "put", new Class[]{KeyStroke.class, Object.class}, new Object[]{KeyStroke.getKeyStroke(10, 0), "dummy"});
        }
        if ((object = Reflector.safeCall((Object)this.tree, "getInputMap", Integer.TYPE, (Object)1)) != null) {
            Reflector.safeCall(object, "put", new Class[]{KeyStroke.class, Object.class}, new Object[]{KeyStroke.getKeyStroke(27, 0), "dummy"});
        }
        boolean bl = this.getBoolean("rootvisible", false);
        this.tree.setRootVisible(bl);
        this.tree.setShowsRootHandles(this.getBoolean("roothandles", !bl));
        if (this.getBoolean("lines", false) && this.tree.getUI() instanceof MetalTreeUI) {
            this.tree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.tree.setCellRenderer(new Renderer());
        ((DefaultTreeSelectionModel)this.tree.getSelectionModel()).setSelectionMode(1);
        if (this.tree.getRowCount() > 0) {
            this.tree.setSelectionRow(0);
            this.nodeChanged((Node)this.tree.getPathForRow(0).getLastPathComponent());
        }
        this.listener = new Listener();
        this.tree.addTreeSelectionListener(this.listener);
        this.tree.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    protected JComponent setupSearch(JComponent jComponent) {
        if (TreeOptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setupSearch(JComponent)", 526).addDetail("treePane", jComponent)).log();
        }
        this.filterTreeHelper = new FilteredTreeGUIHelper();
        this.filterTreeHelper.doUpdateFilter(true, this.tree, false);
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(this.filterTreeHelper.collectExpandedRowsFromHierarchicalFilter(this.tree));
        this.filterTreeHelper.prepare(this.tree, this.model.getAdapter(), new NodeFilter(new OptionFilter()), this.tree.getCellRenderer());
        HierarchicalTreeFilterTraversal hierarchicalTreeFilterTraversal = (HierarchicalTreeFilterTraversal)this.filterTreeHelper.getTreeHelper().getFilteredModel().getFilterTraversal();
        hierarchicalTreeFilterTraversal.setFilterInternalNodes(true);
        this.filterTreeHelper.registerTreeListeners(this.tree);
        this.model = (AdapterTreeModel)this.tree.getModel();
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            int n = (Integer)object.next();
            this.tree.expandRow(n);
        }
        if (treePathArray != null) {
            this.tree.setSelectionPaths(treePathArray);
        }
        object = this.getString("search.placeholder", "Search for options");
        String string = this.getString("search.tooltip", null);
        return this.filterTreeHelper.setupTreeWithFilterField(bl -> this.filterTreeHelper.doUpdateFilter(bl, this.tree, true), jComponent, (String)object, "OptionGroup-" + this.name + "-Treesfilter", string, true);
    }

    protected void nodeChanged(Node node) {
        if (TreeOptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "nodeChanged(Node)", 577).addDetail("node", node)).log();
        }
        if (this.current == node) {
            return;
        }
        if (this.current != null && this.current.group != null && !this.current.group.checkValues()) {
            this.tree.setSelectionPath(new TreePath(TreeUtil.getPath(this.model.getAdapter(), this.current)));
            return;
        }
        this.current = node;
        if (node == null || node.title == null) {
            this.setDetailTitle(null);
        } else {
            this.setDetailTitle(node.title);
        }
        if (node == null || node.group == null) {
            this.updatePanel(null);
        } else {
            Component component = node.group.getComponent();
            if (component instanceof Grid && ((Grid)component).needGlue()) {
                ((Grid)component).addGlue();
            }
            this.innerPanel.removeAll();
            this.innerPanel.add(component, "Center");
            this.scroll.setViewportView(this.innerPanel);
            this.updatePanel(this.scroll);
        }
        this.panel.revalidate();
        this.panel.repaint();
    }

    private void setupBorders() {
        if (TreeOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "setupBorders()", 622).log();
        }
        OptionGroupTreeAdapter optionGroupTreeAdapter = new OptionGroupTreeAdapter();
        for (Object e : this.members) {
            TreeUtil.traverse(optionGroupTreeAdapter, e, new TraversalCallback(){

                @Override
                public boolean nodeEntered(Traversal traversal) throws ReturnFromTraversalException {
                    Object object;
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "setupBorders().TraversalCallback.nodeEntered(Traversal)", 630).addDetail("traversal", traversal)).log();
                    }
                    if ((object = traversal.getNode()) instanceof OptionEdit) {
                        OptionEdit optionEdit = (OptionEdit)object;
                        optionEdit.setupHighlightingBorder();
                    }
                    return true;
                }

                @Override
                public void nodeExited(Traversal traversal) throws ReturnFromTraversalException {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "setupBorders().TraversalCallback.nodeExited(Traversal)", 641).addDetail("traversal", traversal)).log();
                    }
                }
            });
        }
    }

    void disableSearchFieldTemorary() {
        if (TreeOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "disableSearchFieldTemorary()", 655).log();
        }
        if (this.filterTreeHelper != null) {
            this.filterTreeHelper.getFilterTextField().setEnabled(false);
            this.tree.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "disableSearchFieldTemorary().FocusListener.focusGained(FocusEvent)", 663).addDetail("e", focusEvent)).log();
                    }
                    TreeOptionGroup.this.filterTreeHelper.getFilterTextField().setEnabled(true);
                    TreeOptionGroup.this.tree.removeFocusListener(this);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "disableSearchFieldTemorary().FocusListener.focusLost(FocusEvent)", 670).addDetail("e", focusEvent)).log();
                    }
                }
            });
        }
    }

    protected void updatePanel(@Nullable Component component) {
        if (component == null) {
            this.panel.remove(this.scroll);
        } else {
            this.panel.add(component, "Center");
        }
    }

    protected void setDetailTitle(@Nullable String string) {
        if (TreeOptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setDetailTitle(String)", 704).addDetail("detailTitle", string)).log();
        }
        if (string == null) {
            this.panel.remove(this.title);
        } else {
            this.title.setText(string);
            this.panel.add((Component)this.title, "North");
        }
    }

    @Nullable
    @Generated
    public FilteredTreeGUIHelper getFilterTreeHelper() {
        if (TreeOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "getFilterTreeHelper()", 252).log();
        }
        return this.filterTreeHelper;
    }

    protected class NodeFilter
    extends FilterTextTreeModelFilter {
        @Nullable
        protected BiPredicate<Object, Predicate<String>> optionFilter;
        protected final OptionGroupTreeAdapter optionsAdapter;

        public NodeFilter(BiPredicate<Object, Predicate<String>> biPredicate) {
            super(AbstractTreeModelFilter.FilterType.HIERARCHY);
            this.optionsAdapter = new OptionGroupTreeAdapter();
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "NodeFilter.NodeFilter(BiPredicate<Object, Predicate<String>>)", 1210).addDetail("optionFilter", biPredicate)).log();
            }
            this.optionFilter = biPredicate;
        }

        @Override
        public boolean filter(TreeModel treeModel, Object object) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "NodeFilter.filter(TreeModel,Object)", 1219).addDetail("model", treeModel)).addDetail("treeNode", object)).log();
            }
            if (object instanceof Node) {
                BiPredicate<Object, Predicate<String>> biPredicate;
                Node node = (Node)object;
                boolean bl = false;
                if (this.matchesFilterText(node.name)) {
                    bl = true;
                }
                if ((biPredicate = this.optionFilter) != null) {
                    OptionTreeTraversal optionTreeTraversal = new OptionTreeTraversal(biPredicate);
                    TreeUtil.traverse(this.optionsAdapter, node.group, optionTreeTraversal);
                    bl |= optionTreeTraversal.isAnyOptionMatched();
                }
                return bl;
            }
            return false;
        }

        @Override
        public void reset() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "NodeFilter.reset()", 1246).log();
            }
            super.reset();
            OptionTreeTraversal optionTreeTraversal = new OptionTreeTraversal();
            for (Object e : TreeOptionGroup.this.members) {
                TreeUtil.traverse(this.optionsAdapter, e, optionTreeTraversal);
            }
            this.collapseAllNodes();
        }

        public void collapseAllNodes() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "NodeFilter.collapseAllNodes()", 1262).log();
            }
            for (int i = 0; i < TreeOptionGroup.this.tree.getRowCount(); ++i) {
                TreeOptionGroup.this.tree.collapseRow(i);
            }
            if (TreeOptionGroup.this.current != null) {
                TreeOptionGroup.this.tree.setSelectionPath(new TreePath(TreeUtil.getPath(TreeOptionGroup.this.model.getAdapter(), TreeOptionGroup.this.current)));
            }
        }

        @Nullable
        @Generated
        public BiPredicate<Object, Predicate<String>> getOptionFilter() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "NodeFilter.getOptionFilter()", 1199).log();
            }
            return this.optionFilter;
        }

        @Generated
        public NodeFilter setOptionFilter(@Nullable BiPredicate<Object, Predicate<String>> biPredicate) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "NodeFilter.setOptionFilter(BiPredicate<Object, Predicate<String>>)", 1200).addDetail("optionFilter", biPredicate)).log();
            }
            this.optionFilter = biPredicate;
            return this;
        }

        protected class OptionTreeTraversal
        implements TraversalCallback {
            protected final BiPredicate<Object, Predicate<String>> optionFilterCopy;
            protected boolean anyOptionMatched = false;
            protected final boolean doReset;

            public OptionTreeTraversal(BiPredicate<Object, Predicate<String>> biPredicate) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "NodeFilter.OptionTreeTraversal.OptionTreeTraversal(BiPredicate<Object, Predicate<String>>)", 1294).addDetail("optionFilter", biPredicate)).log();
                }
                this.optionFilterCopy = biPredicate;
                this.doReset = false;
            }

            public OptionTreeTraversal() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "NodeFilter.OptionTreeTraversal.OptionTreeTraversal()", 1300).log();
                }
                this.optionFilterCopy = null;
                this.doReset = true;
            }

            @Override
            public boolean nodeEntered(Traversal traversal) throws ReturnFromTraversalException {
                Object object;
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "NodeFilter.OptionTreeTraversal.nodeEntered(Traversal)", 1309).addDetail("traversal", traversal)).log();
                }
                if ((object = traversal.getNode()) instanceof OptionEdit) {
                    OptionEdit optionEdit = (OptionEdit)object;
                    if (!this.doReset && this.optionFilterCopy.test(optionEdit, string -> NodeFilter.this.matchesFilterText(string))) {
                        this.anyOptionMatched = true;
                        optionEdit.markSearchHit(true);
                    } else {
                        optionEdit.markSearchHit(false);
                    }
                } else if (object instanceof OptionGroup) {
                    OptionGroup optionGroup = (OptionGroup)object;
                    optionGroup.getComponent();
                    if (!this.doReset && this.optionFilterCopy.test(optionGroup, string -> NodeFilter.this.matchesFilterText(string))) {
                        this.anyOptionMatched = true;
                    } else {
                        optionGroup.markSearchHit(false);
                    }
                }
                return true;
            }

            @Override
            public void nodeExited(Traversal traversal) throws ReturnFromTraversalException {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "NodeFilter.OptionTreeTraversal.nodeExited(Traversal)", 1341).addDetail("traversal", traversal)).log();
                }
            }

            @Generated
            public boolean isAnyOptionMatched() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "NodeFilter.OptionTreeTraversal.isAnyOptionMatched()", 1284).log();
                }
                return this.anyOptionMatched;
            }
        }
    }

    public static class OptionFilter
    implements BiPredicate<Object, Predicate<String>> {
        public OptionFilter() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "OptionFilter.OptionFilter()", 1170).log();
            }
        }

        @Override
        public boolean test(Object object, Predicate<String> predicate) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "OptionFilter.test(Object,Predicate<String>)", 1173).addDetail("optionEditOrGroup", object)).addDetail("matcher", predicate)).log();
            }
            if (object instanceof OptionEdit) {
                return ((OptionEdit)object).matchesFilterText(predicate);
            }
            if (object instanceof OptionGroup) {
                return ((OptionGroup)object).matchesFilterText(predicate);
            }
            return false;
        }
    }

    protected class Listener
    extends DelayedTreeSelectionListener {
        protected Listener() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Listener.Listener()", 1091).log();
            }
        }

        @Override
        public void delayedValueChanged(TreeSelectionEvent treeSelectionEvent) {
            Node node = null;
            if (TreeOptionGroup.this.tree.getSelectionPath() != null) {
                node = (Node)TreeOptionGroup.this.tree.getSelectionPath().getLastPathComponent();
            }
            if (TreeOptionGroup.this.filterTreeHelper != null && TreeOptionGroup.this.filterTreeHelper.isSearchFlag()) {
                int[] nArray;
                int n;
                TreeOptionGroup.this.filterTreeHelper.setSearchFlag(false);
                FilterTextTreeModelFilter filterTextTreeModelFilter = (FilterTextTreeModelFilter)TreeOptionGroup.this.filterTreeHelper.getFilter();
                if (filterTextTreeModelFilter != null && filterTextTreeModelFilter.isActive() && node != null && !node.isLeaf() && !this.isNodeMarked(node.group) && (n = (nArray = TreeOptionGroup.this.tree.getSelectionRows())[0] + 1) < TreeOptionGroup.this.tree.getRowCount()) {
                    TreePath treePath = TreeOptionGroup.this.tree.getPathForRow(n);
                    TreeOptionGroup.this.tree.addSelectionPath(treePath);
                    return;
                }
            }
            TreeOptionGroup.this.nodeChanged(node);
        }

        public boolean isNodeMarked(OptionGroup optionGroup) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Listener.isNodeMarked(OptionGroup)", 1142).addDetail("g", optionGroup)).log();
            }
            for (Object e : optionGroup.members) {
                if (e instanceof PlainOptionGroup && this.isNodeMarked((OptionGroup)e)) {
                    return true;
                }
                if (e instanceof OptionEdit && ((OptionEdit)e).isMarked()) {
                    return true;
                }
                if (!(e instanceof OptionGroup) || !((OptionGroup)e).isMarked) continue;
                return true;
            }
            return false;
        }
    }

    protected class Renderer
    extends DefaultTreeCellRenderer {
        protected Renderer() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Renderer.Renderer()", 1045).log();
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            defaultTreeCellRenderer.setText(((Node)object).name);
            defaultTreeCellRenderer.setIcon(((Node)object).icon);
            return defaultTreeCellRenderer;
        }
    }

    protected class Node {
        public Node parent;
        public String path;
        public List<Node> children;
        public String name;
        public Icon icon;
        public String title;
        public OptionGroup group;

        public Node makeNode(String string) {
            Predicate<String> predicate;
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Node.makeNode(String)", 954).addDetail("path", string)).log();
            }
            if ((predicate = OptionEditCallbacks.getMakeOptionEditFilter()) != null && !predicate.test(TreeOptionGroup.this.getResourceName() + "." + string)) {
                return null;
            }
            return new Node(string);
        }

        protected Node(String string) {
            Object object;
            this.path = string;
            String string2 = TreeOptionGroup.this.getString(string + ".children", null);
            if (string2 != null) {
                this.children = new ArrayList<Node>();
                object = new StringTokenizer(string2);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    Node node = this.makeNode(string + "." + ((StringTokenizer)object).nextToken());
                    if (node == null) continue;
                    node.parent = this;
                    this.children.add(node);
                }
            }
            this.name = TreeOptionGroup.this.getString(string + ".name", "");
            this.icon = Option.getResources().getIcon("option.group." + TreeOptionGroup.this.name + "." + string + ".icon", null);
            this.title = TreeOptionGroup.this.getString(string + ".title", null);
            object = TreeOptionGroup.this.getString(string + ".group", null);
            if (object != null) {
                this.group = OptionGroup.makeGroup((String)object, TreeOptionGroup.this.options);
                if (this.group != null) {
                    this.group.setParentGroup(TreeOptionGroup.this);
                    boolean bl = TreeOptionGroup.this.getBoolean(string + ".enabled", true);
                    if (!bl) {
                        this.group.setEnabled(false);
                    }
                    TreeOptionGroup.this.members.add(this.group);
                }
            }
        }

        public boolean isLeaf() {
            return this.children == null;
        }
    }

    protected class Tree
    extends IndexBasedTreeAdapter {
        private Node root;

        public Tree() {
            String string = TreeOptionGroup.this.getString("root", "root");
            this.root = new Node(string);
        }

        public Node findNode(String string) {
            block3: {
                if (string == null || !string.startsWith(this.root.path)) {
                    return null;
                }
                Node node2 = this.root;
                while (true) {
                    if (string.equals(node2.path)) {
                        return node2;
                    }
                    if (node2.children == null) break block3;
                    Optional<Node> optional = node2.children.stream().filter(node -> string.startsWith(node.path)).findFirst();
                    if (!optional.isPresent()) break;
                    node2 = optional.get();
                }
                return null;
            }
            return null;
        }

        @Override
        public Object getParentNode(Object object) {
            return ((Node)object).parent;
        }

        @Override
        public boolean isLeaf(Object object) {
            return ((Node)object).isLeaf();
        }

        @Override
        public int getChildCount(Object object) {
            return ((Node)object).children == null ? 0 : ((Node)object).children.size();
        }

        @Override
        public Object getChildNode(Object object, int n) throws IndexOutOfBoundsException {
            if (((Node)object).children == null) {
                throw new IndexOutOfBoundsException("No children for : " + ((Node)object).path);
            }
            return ((Node)object).children.get(n);
        }

        @Override
        public int getIndexOfChildNode(Object object, Object object2) {
            if (((Node)object).children == null) {
                return -1;
            }
            return ((Node)object).children.indexOf(object2);
        }

        @Generated
        public Node getRoot() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Tree.getRoot()", 733).log();
            }
            return this.root;
        }
    }
}

