/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.properties;

import de.qfs.lib.properties.QfsObservableMap;
import de.qfs.lib.util.StrongObserved;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class QfsObservableMapWrapper<K, V>
extends StrongObserved
implements QfsObservableMap<K, V> {
    private final Map<K, V> delegate;
    private ObservableEntrySet entrySet;
    private ObservableKeySet keySet;
    private ObservableValues values;

    public QfsObservableMapWrapper(Map<K, V> map) {
        this.delegate = map;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.delegate.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.delegate.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.delegate.get(object);
    }

    @Override
    public V put(K k, V v) {
        V v2;
        if (this.delegate.containsKey(k)) {
            v2 = this.delegate.put(k, v);
            if (v2 == null && v != null || v2 != null && !v2.equals(v)) {
                this.notifyObservers();
            }
        } else {
            v2 = this.delegate.put(k, v);
            this.setChanged();
            this.notifyObservers();
        }
        return v2;
    }

    @Override
    public V remove(Object object) {
        if (!this.delegate.containsKey(object)) {
            return null;
        }
        V v = this.delegate.remove(object);
        this.notifyObservers();
        return v;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.delegate.putAll(map);
        this.notifyObservers();
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new ObservableKeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new ObservableValues();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new ObservableEntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        return this.delegate.toString();
    }

    private class ObservableKeySet
    implements Set<K> {
        private ObservableKeySet() {
        }

        @Override
        public int size() {
            return QfsObservableMapWrapper.this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return QfsObservableMapWrapper.this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return QfsObservableMapWrapper.this.delegate.keySet().contains(object);
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                private Iterator<Map.Entry<K, V>> entryIt;
                private K lastKey;
                private V lastValue;
                {
                    this.entryIt = QfsObservableMapWrapper.this.delegate.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.entryIt.hasNext();
                }

                @Override
                public K next() {
                    Map.Entry entry = this.entryIt.next();
                    this.lastKey = entry.getKey();
                    this.lastValue = entry.getValue();
                    return entry.getKey();
                }

                @Override
                public void remove() {
                    this.entryIt.remove();
                    QfsObservableMapWrapper.this.notifyObservers();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return QfsObservableMapWrapper.this.delegate.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return QfsObservableMapWrapper.this.delegate.keySet().toArray(TArray);
        }

        @Override
        public boolean add(K k) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean remove(Object object) {
            return QfsObservableMapWrapper.this.remove(object) != null;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return QfsObservableMapWrapper.this.delegate.keySet().containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.removeRetain(collection, false);
        }

        private boolean removeRetain(Collection<?> collection, boolean bl) {
            boolean bl2 = false;
            Iterator iterator = QfsObservableMapWrapper.this.delegate.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (bl != collection.contains(entry.getKey())) continue;
                bl2 = true;
                Object k = entry.getKey();
                Object v = entry.getValue();
                iterator.remove();
                QfsObservableMapWrapper.this.notifyObservers();
            }
            return bl2;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.removeRetain(collection, true);
        }

        @Override
        public void clear() {
            QfsObservableMapWrapper.this.clear();
        }

        public String toString() {
            return QfsObservableMapWrapper.this.delegate.keySet().toString();
        }

        @Override
        public boolean equals(Object object) {
            return QfsObservableMapWrapper.this.delegate.keySet().equals(object);
        }

        @Override
        public int hashCode() {
            return QfsObservableMapWrapper.this.delegate.keySet().hashCode();
        }
    }

    private class ObservableValues
    implements Collection<V> {
        private ObservableValues() {
        }

        @Override
        public int size() {
            return QfsObservableMapWrapper.this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return QfsObservableMapWrapper.this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return QfsObservableMapWrapper.this.delegate.values().contains(object);
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                private Iterator<Map.Entry<K, V>> entryIt;
                private K lastKey;
                private V lastValue;
                {
                    this.entryIt = QfsObservableMapWrapper.this.delegate.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.entryIt.hasNext();
                }

                @Override
                public V next() {
                    Map.Entry entry = this.entryIt.next();
                    this.lastKey = entry.getKey();
                    this.lastValue = entry.getValue();
                    return this.lastValue;
                }

                @Override
                public void remove() {
                    this.entryIt.remove();
                    QfsObservableMapWrapper.this.notifyObservers();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return QfsObservableMapWrapper.this.delegate.values().toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return QfsObservableMapWrapper.this.delegate.values().toArray(TArray);
        }

        @Override
        public boolean add(V v) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean remove(Object object) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().equals(object)) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return QfsObservableMapWrapper.this.delegate.values().containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.removeRetain(collection, true);
        }

        private boolean removeRetain(Collection<?> collection, boolean bl) {
            boolean bl2 = false;
            Iterator iterator = QfsObservableMapWrapper.this.delegate.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (bl != collection.contains(entry.getValue())) continue;
                bl2 = true;
                Object k = entry.getKey();
                Object v = entry.getValue();
                iterator.remove();
                QfsObservableMapWrapper.this.notifyObservers();
            }
            return bl2;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.removeRetain(collection, false);
        }

        @Override
        public void clear() {
            QfsObservableMapWrapper.this.clear();
        }

        public String toString() {
            return QfsObservableMapWrapper.this.delegate.values().toString();
        }

        @Override
        public boolean equals(Object object) {
            return QfsObservableMapWrapper.this.delegate.values().equals(object);
        }

        @Override
        public int hashCode() {
            return QfsObservableMapWrapper.this.delegate.values().hashCode();
        }
    }

    public class ObservableEntrySet
    implements Set<Map.Entry<K, V>> {
        @Override
        public int size() {
            return QfsObservableMapWrapper.this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return QfsObservableMapWrapper.this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return QfsObservableMapWrapper.this.delegate.entrySet().contains(object);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private Iterator<Map.Entry<K, V>> backingIt;
                private K lastKey;
                private V lastValue;
                {
                    this.backingIt = QfsObservableMapWrapper.this.delegate.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.backingIt.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    Map.Entry entry = this.backingIt.next();
                    this.lastKey = entry.getKey();
                    this.lastValue = entry.getValue();
                    return new ObservableEntry(entry);
                }

                @Override
                public void remove() {
                    this.backingIt.remove();
                    QfsObservableMapWrapper.this.notifyObservers();
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = QfsObservableMapWrapper.this.delegate.entrySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = new ObservableEntry((Map.Entry)objectArray[i]);
            }
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            T[] TArray2 = QfsObservableMapWrapper.this.delegate.entrySet().toArray(TArray);
            for (int i = 0; i < TArray2.length; ++i) {
                TArray2[i] = new ObservableEntry((Map.Entry)TArray2[i]);
            }
            return TArray2;
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = QfsObservableMapWrapper.this.delegate.entrySet().remove(object);
            if (bl) {
                Map.Entry entry = (Map.Entry)object;
                QfsObservableMapWrapper.this.notifyObservers();
            }
            return bl;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return QfsObservableMapWrapper.this.delegate.entrySet().containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.removeRetain(collection, false);
        }

        private boolean removeRetain(Collection<?> collection, boolean bl) {
            boolean bl2 = false;
            Iterator iterator = QfsObservableMapWrapper.this.delegate.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (bl != collection.contains(entry)) continue;
                bl2 = true;
                Object k = entry.getKey();
                Object v = entry.getValue();
                iterator.remove();
                QfsObservableMapWrapper.this.notifyObservers();
            }
            return bl2;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.removeRetain(collection, true);
        }

        @Override
        public void clear() {
            QfsObservableMapWrapper.this.clear();
        }

        public String toString() {
            return QfsObservableMapWrapper.this.delegate.entrySet().toString();
        }

        @Override
        public boolean equals(Object object) {
            return QfsObservableMapWrapper.this.delegate.entrySet().equals(object);
        }

        @Override
        public int hashCode() {
            return QfsObservableMapWrapper.this.delegate.entrySet().hashCode();
        }
    }

    private class ObservableEntry
    implements Map.Entry<K, V> {
        private final Map.Entry<K, V> backingEntry;

        public ObservableEntry(Map.Entry<K, V> entry) {
            this.backingEntry = entry;
        }

        @Override
        public K getKey() {
            return this.backingEntry.getKey();
        }

        @Override
        public V getValue() {
            return this.backingEntry.getValue();
        }

        @Override
        public V setValue(V v) {
            Object v2 = this.backingEntry.setValue(v);
            QfsObservableMapWrapper.this.notifyObservers();
            return v2;
        }

        @Override
        public final boolean equals(Object object) {
            Object v;
            Object v2;
            Object k;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k2 = this.getKey();
            return (k2 == (k = entry.getKey()) || k2 != null && k2.equals(k)) && ((v2 = this.getValue()) == (v = entry.getValue()) || v2 != null && v2.equals(v));
        }

        @Override
        public final int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

