/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.totp;

import de.qfs.lib.totp.CodeGenerationException;
import de.qfs.lib.totp.HashingAlgorithm;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;

public class DefaultCodeGenerator {
    private final HashingAlgorithm algorithm;
    private final int digits;

    public DefaultCodeGenerator() {
        this(HashingAlgorithm.SHA1, 6);
    }

    public DefaultCodeGenerator(int n) {
        this(HashingAlgorithm.SHA1, n);
    }

    public DefaultCodeGenerator(HashingAlgorithm hashingAlgorithm) {
        this(hashingAlgorithm, 6);
    }

    public DefaultCodeGenerator(HashingAlgorithm hashingAlgorithm, int n) {
        if (hashingAlgorithm == null) {
            throw new InvalidParameterException("HashingAlgorithm must not be null.");
        }
        if (n < 1) {
            throw new InvalidParameterException("Number of digits must be higher than 0.");
        }
        this.algorithm = hashingAlgorithm;
        this.digits = n;
    }

    public String generate(String string, long l) throws CodeGenerationException {
        try {
            byte[] byArray = this.generateHash(string, l);
            return this.getDigitsFromHash(byArray);
        }
        catch (Exception exception) {
            throw new CodeGenerationException("Failed to generate code: " + exception, exception);
        }
    }

    private byte[] generateHash(String string, long l) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray = new byte[8];
        long l2 = l;
        int n = 8;
        while (n-- > 0) {
            byArray[n] = (byte)l2;
            l2 >>>= 8;
        }
        Base32 base32 = new Base32();
        byte[] byArray2 = base32.decode(string);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, this.algorithm.getHmacAlgorithm());
        Mac mac = Mac.getInstance(this.algorithm.getHmacAlgorithm());
        mac.init(secretKeySpec);
        return mac.doFinal(byArray);
    }

    private String getDigitsFromHash(byte[] byArray) {
        int n = byArray[byArray.length - 1] & 0xF;
        long l = 0L;
        for (int i = 0; i < 4; ++i) {
            l <<= 8;
            l |= (long)(byArray[n + i] & 0xFF);
        }
        l &= Integer.MAX_VALUE;
        l = (long)((double)l % Math.pow(10.0, this.digits));
        return String.format("%0" + this.digits + "d", l);
    }
}

