/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.transaction;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.transaction.Commitable;
import de.qfs.lib.transaction.FatalTransactionException;
import de.qfs.lib.transaction.OpenTransactionException;
import de.qfs.lib.util.ResourceWaiter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import lombok.Generated;

public class Transaction {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.transaction.Transaction");
    private static final Object classlock = new Object();
    private static int maxTransactions;
    private static Map transactions;
    private static List waiters;
    private static Map threads;
    private static Transaction dummyTransaction;
    private List commitables = new ArrayList();
    private boolean closed;

    public static Transaction instance() {
        Transaction transaction;
        if (Transaction.logger.level >= 7) {
            logger.lvlBuild(7, "instance()", 182).log();
        }
        if ((transaction = (Transaction)transactions.get(Thread.currentThread())) == null) {
            return dummyTransaction;
        }
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Transaction begin() throws OpenTransactionException {
        if (Transaction.logger.level >= 7) {
            logger.lvlBuild(7, "begin()", 206).log();
        }
        Object object = classlock;
        synchronized (object) {
            Transaction transaction = (Transaction)transactions.get(Thread.currentThread());
            if (transaction != null) {
                throw new OpenTransactionException("Transaction for Thread " + Thread.currentThread() + " still open.");
            }
            if (maxTransactions > 0 && transactions.size() >= maxTransactions) {
                if (Transaction.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "begin()", 219).add("No more Transactions available: size = ")).add(transactions.size())).add(", max = ")).add(maxTransactions)).log();
                }
                ResourceWaiter resourceWaiter = new ResourceWaiter(classlock);
                waiters.add(resourceWaiter);
                resourceWaiter.waitFor(-1L);
            }
            transaction = new Transaction();
            transactions.put(Thread.currentThread(), transaction);
            threads.put(transaction, Thread.currentThread());
            return transaction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(Transaction transaction) {
        if (Transaction.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "close(Transaction)", 240).addDetail("transaction", transaction)).log();
        }
        transaction.close();
        Object v = threads.get(transaction);
        if (v != null) {
            Object object = classlock;
            synchronized (object) {
                threads.remove(transaction);
                transactions.remove(v);
                if ((maxTransactions <= 0 || transactions.size() < maxTransactions) && waiters.size() > 0) {
                    if (Transaction.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "close(Transaction)", 252).add("Transaction released, calling waiter.")).log();
                    }
                    ((ResourceWaiter)waiters.remove(0)).handResource(null);
                }
            }
        }
    }

    public static boolean insideTransaction() {
        return transactions.containsKey(Thread.currentThread());
    }

    public static final int getMaxTransactions() {
        return maxTransactions;
    }

    public static final void setMaxTransactions(int n) {
        maxTransactions = n;
    }

    public void add(Commitable commitable) {
        if (Transaction.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "add(Commitable)", 309).addDetail("commitable", commitable)).log();
        }
        this.commitables.add(commitable);
    }

    public void commit() throws FatalTransactionException {
        if (Transaction.logger.level >= 7) {
            logger.lvlBuild(7, "commit()", 326).log();
        }
        if (this.closed) {
            if (Transaction.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "commit()", 330).add("already closed")).log();
            }
            return;
        }
        Transaction.close(this);
        RuntimeException runtimeException = null;
        ListIterator listIterator = this.commitables.listIterator();
        while (listIterator.hasNext()) {
            try {
                ((Commitable)listIterator.next()).commit();
            }
            catch (FatalTransactionException fatalTransactionException) {
                if (Transaction.logger.level >= 1) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "commit()", 343).add("ex", fatalTransactionException)).log();
                }
                throw fatalTransactionException;
            }
            catch (RuntimeException runtimeException2) {
                if (Transaction.logger.level >= 1) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "commit()", 347).add("ex", runtimeException2)).log();
                }
                if (runtimeException != null) continue;
                runtimeException = runtimeException2;
            }
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    public void rollback() throws FatalTransactionException {
        if (Transaction.logger.level >= 7) {
            logger.lvlBuild(7, "rollback()", 370).log();
        }
        if (this.closed) {
            if (Transaction.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "rollback()", 374).add("already closed")).log();
            }
            return;
        }
        Transaction.close(this);
        RuntimeException runtimeException = null;
        ListIterator listIterator = this.commitables.listIterator(this.commitables.size());
        while (listIterator.hasPrevious()) {
            try {
                ((Commitable)listIterator.previous()).rollback();
            }
            catch (FatalTransactionException fatalTransactionException) {
                if (Transaction.logger.level >= 1) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "rollback()", 388).add("ex", fatalTransactionException)).log();
                }
                throw fatalTransactionException;
            }
            catch (RuntimeException runtimeException2) {
                if (Transaction.logger.level >= 1) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "rollback()", 392).add("ex", runtimeException2)).log();
                }
                if (runtimeException != null) continue;
                runtimeException = runtimeException2;
            }
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    public void close() {
        if (Transaction.logger.level >= 7) {
            logger.lvlBuild(7, "close()", 412).log();
        }
        this.closed = true;
    }

    static {
        transactions = Collections.synchronizedMap(new HashMap());
        waiters = Collections.synchronizedList(new ArrayList());
        threads = Collections.synchronizedMap(new HashMap());
        dummyTransaction = new Dummy();
    }

    private static class Dummy
    extends Transaction {
        @Override
        public void add(Commitable commitable) throws FatalTransactionException {
            commitable.commit();
        }

        @Override
        public void commit() {
        }

        @Override
        public void rollback() {
        }
    }
}

