/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.tree;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.tree.IndexTraversal;
import de.qfs.lib.tree.MutableTreeAdapter;
import de.qfs.lib.tree.ReturnFromTraversalException;
import de.qfs.lib.tree.TraversalCallback;
import de.qfs.lib.tree.TreeAdapter;
import de.qfs.lib.util.Visitor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import lombok.Generated;

public class TreeUtil {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.tree.TreeUtil");

    public TreeUtil() {
        if (TreeUtil.logger.level >= 7) {
            logger.lvlBuild(7, "TreeUtil.TreeUtil()", 36).log();
        }
    }

    public static Object getRoot(TreeAdapter treeAdapter, Object object) {
        Object object2 = treeAdapter.getParentNode(object);
        return object2 == null ? object : TreeUtil.getRoot(treeAdapter, object2);
    }

    public static Object[] getPath(TreeAdapter treeAdapter, Object objectArray) {
        Object object;
        Object object2 = objectArray;
        int n = 1;
        while (treeAdapter.getParentNode(object2) != null) {
            object = treeAdapter.getParentNode(object2);
            if (object == object2) {
                if (TreeUtil.logger.level < 3) break;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "getPath(TreeAdapter,Object)", 87).add("Node refers to itself:")).add(object2)).log();
                break;
            }
            object2 = object;
            ++n;
        }
        object = new Object[n];
        object2 = objectArray;
        --n;
        while (n >= 0) {
            object[n] = object2;
            object2 = treeAdapter.getParentNode(object2);
            --n;
        }
        return object;
    }

    public static Object[] getPath(TreeAdapter treeAdapter, Object objectArray, Object object) {
        Object object2;
        Object object3 = objectArray;
        int n = 1;
        while (object3 != null && object3 != object) {
            object2 = treeAdapter.getParentNode(object3);
            if (object2 == object3) {
                if (TreeUtil.logger.level < 3) break;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "getPath(TreeAdapter,Object,Object)", 129).add("Node refers to itself:")).add(object3)).log();
                break;
            }
            object3 = object2;
            ++n;
        }
        if (object3 == null) {
            return null;
        }
        object2 = new Object[n];
        object3 = objectArray;
        --n;
        while (n >= 0) {
            object2[n] = object3;
            object3 = treeAdapter.getParentNode(object3);
            --n;
        }
        return object2;
    }

    public static Object getFollowingNode(TreeAdapter treeAdapter, Object object) {
        if (TreeUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getFollowingNode(TreeAdapter,Object)", 159).addDetail("adapter", treeAdapter)).addDetail("node", object)).log();
        }
        if (treeAdapter.getChildCount(object) > 0) {
            return treeAdapter.getFirstChildNode(object);
        }
        while (object != null) {
            Object object2 = treeAdapter.getNextSibling(object);
            if (object2 != null) {
                return object2;
            }
            object = treeAdapter.getParentNode(object);
        }
        return null;
    }

    public static Object getPrecedingNode(TreeAdapter treeAdapter, Object object) {
        Object object2;
        if (TreeUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getPrecedingNode(TreeAdapter,Object)", 185).addDetail("adapter", treeAdapter)).addDetail("node", object)).log();
        }
        return (object2 = treeAdapter.getPreviousSibling(object)) == null ? treeAdapter.getParentNode(object) : TreeUtil.getLastDescendant(treeAdapter, object2);
    }

    public static Object getFollowingNode(TreeAdapter treeAdapter, Object object, Object object2) {
        if (TreeUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getFollowingNode(TreeAdapter,Object,Object)", 204).addDetail("adapter", treeAdapter)).addDetail("node", object)).addDetail("limit", object2)).log();
        }
        if (treeAdapter.getChildCount(object) > 0) {
            return treeAdapter.getFirstChildNode(object);
        }
        while (object != null && object != object2) {
            Object object3 = treeAdapter.getNextSibling(object);
            if (object3 != null) {
                return object3;
            }
            object = treeAdapter.getParentNode(object);
        }
        return null;
    }

    public static Object getPrecedingNode(TreeAdapter treeAdapter, Object object, Object object2) {
        if (TreeUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getPrecedingNode(TreeAdapter,Object,Object)", 232).addDetail("adapter", treeAdapter)).addDetail("node", object)).addDetail("limit", object2)).log();
        }
        if (object == object2) {
            return null;
        }
        Object object3 = treeAdapter.getPreviousSibling(object);
        return object3 == null ? treeAdapter.getParentNode(object) : TreeUtil.getLastDescendant(treeAdapter, object3);
    }

    public static Object getLastDescendant(TreeAdapter treeAdapter, Object object) {
        Object object2;
        if (TreeUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getLastDescendant(TreeAdapter,Object)", 255).addDetail("adapter", treeAdapter)).addDetail("node", object)).log();
        }
        return (object2 = treeAdapter.getLastChildNode(object)) == null ? object : TreeUtil.getLastDescendant(treeAdapter, object2);
    }

    public static boolean isDescendingFrom(TreeAdapter treeAdapter, Object object, Object object2) {
        if (TreeUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "isDescendingFrom(TreeAdapter,Object,Object)", 274).addDetail("adapter", treeAdapter)).addDetail("node", object)).addDetail("root", object2)).log();
        }
        while (object != null) {
            if (object == object2) {
                return true;
            }
            object = treeAdapter.getParentNode(object);
        }
        return false;
    }

    public static Object getCommonAncestor(TreeAdapter treeAdapter, Object object, Object object2) {
        int n;
        if (TreeUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getCommonAncestor(TreeAdapter,Object,Object)", 299).addDetail("adapter", treeAdapter)).addDetail("left", object)).addDetail("right", object2)).log();
        }
        Object[] objectArray = TreeUtil.getPath(treeAdapter, object);
        Object[] objectArray2 = TreeUtil.getPath(treeAdapter, object2);
        for (n = 0; n < objectArray.length && n < objectArray2.length && objectArray[n] == objectArray2[n]; ++n) {
        }
        return n == 0 ? null : objectArray[n - 1];
    }

    public static Object copyTree(MutableTreeAdapter mutableTreeAdapter, Object object) {
        Object object2 = mutableTreeAdapter.cloneNode(object);
        if (mutableTreeAdapter.isIndexBased()) {
            int n = mutableTreeAdapter.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                Object object3 = TreeUtil.copyTree(mutableTreeAdapter, mutableTreeAdapter.getChildNode(object, i));
                mutableTreeAdapter.addNode(object2, object3);
                mutableTreeAdapter.setParentNode(object3, object2);
            }
        } else if (mutableTreeAdapter.isLinkBased()) {
            Object object4 = mutableTreeAdapter.getFirstChildNode(object2);
            while (object4 != null) {
                Object object5 = TreeUtil.copyTree(mutableTreeAdapter, object4);
                mutableTreeAdapter.addNode(object2, object5);
                mutableTreeAdapter.setParentNode(object5, object2);
                object4 = mutableTreeAdapter.getNextSibling(object4);
            }
        } else {
            Enumeration enumeration = mutableTreeAdapter.enumerateChildren(object2);
            while (enumeration.hasMoreElements()) {
                Object object6 = TreeUtil.copyTree(mutableTreeAdapter, enumeration.nextElement());
                mutableTreeAdapter.addNode(object2, object6);
                mutableTreeAdapter.setParentNode(object6, object2);
            }
        }
        return object2;
    }

    public static Object traverse(TreeAdapter treeAdapter, Object object, TraversalCallback traversalCallback) {
        if (TreeUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "traverse(TreeAdapter,Object,TraversalCallback)", 382).addDetail("adapter", treeAdapter)).addDetail("node", object)).addDetail("callback", traversalCallback)).log();
        }
        try {
            new IndexTraversal(treeAdapter, object).traverse(traversalCallback);
        }
        catch (ReturnFromTraversalException returnFromTraversalException) {
            return returnFromTraversalException.getResult();
        }
        return null;
    }

    public static Object traverseFrom(TreeAdapter treeAdapter, Object object, Object object2, TraversalCallback traversalCallback) {
        Object[] objectArray;
        if (TreeUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "traverseFrom(TreeAdapter,Object,Object,TraversalCallback)", 422).addDetail("adapter", treeAdapter)).addDetail("node", object)).addDetail("start", object2)).addDetail("callback", traversalCallback)).log();
        }
        if ((objectArray = TreeUtil.getPath(treeAdapter, object2, object)) == null) {
            return null;
        }
        try {
            new IndexTraversal(treeAdapter, object).traverseFrom(traversalCallback, objectArray);
        }
        catch (ReturnFromTraversalException returnFromTraversalException) {
            return returnFromTraversalException.getResult();
        }
        return null;
    }

    public static Object visitTree(TreeAdapter treeAdapter, Object object, Object object2) {
        if (TreeUtil.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "visitTree(TreeAdapter,Object,Object)", 454).addDetail("adapter", treeAdapter)).addDetail("visitor", object)).addDetail("node", object2)).log();
        }
        try {
            if (treeAdapter.isIndexBased()) {
                TreeUtil.visitByIndex(treeAdapter, object, object2);
            } else if (treeAdapter.isLinkBased()) {
                TreeUtil.visitByLink(treeAdapter, object, object2);
            } else {
                TreeUtil.visitByEnumeration(treeAdapter, object, object2);
            }
        }
        catch (ReturnFromTraversalException returnFromTraversalException) {
            return returnFromTraversalException.getResult();
        }
        return null;
    }

    private static void visitByIndex(TreeAdapter treeAdapter, Object object, Object object2) {
        Object[] objectArray;
        block11: {
            if (TreeUtil.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "visitByIndex(TreeAdapter,Object,Object)", 489).addDetail("adapter", treeAdapter)).addDetail("visitor", object)).addDetail("node", object2)).log();
            }
            if (object2 == null) {
                if (TreeUtil.logger.level >= 3) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "visitByIndex(TreeAdapter,Object,Object)", 494).add("Null node")).log();
                }
                return;
            }
            try {
                Visitor.visit(object, object2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (TreeUtil.logger.level >= 1) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "visitByIndex(TreeAdapter,Object,Object)", 500).add("ex", noSuchMethodException)).log();
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof ReturnFromTraversalException) {
                    throw (ReturnFromTraversalException)invocationTargetException.getTargetException();
                }
                if (TreeUtil.logger.level < 1) break block11;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "visitByIndex(TreeAdapter,Object,Object)", 506).add("ex.getTargetException()", invocationTargetException.getTargetException())).log();
            }
        }
        for (Object object3 : objectArray = treeAdapter.getChildren(object2)) {
            try {
                TreeUtil.visitByIndex(treeAdapter, object, object3);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (TreeUtil.logger.level < 3) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "visitByIndex(TreeAdapter,Object,Object)", 515).add("ex", indexOutOfBoundsException)).log();
            }
        }
    }

    private static void visitByLink(TreeAdapter treeAdapter, Object object, Object object2) {
        block9: {
            if (TreeUtil.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "visitByLink(TreeAdapter,Object,Object)", 534).addDetail("adapter", treeAdapter)).addDetail("visitor", object)).addDetail("node", object2)).log();
            }
            if (object2 == null) {
                if (TreeUtil.logger.level >= 3) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "visitByLink(TreeAdapter,Object,Object)", 539).add("Null node")).log();
                }
                return;
            }
            try {
                Visitor.visit(object, object2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (TreeUtil.logger.level >= 1) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "visitByLink(TreeAdapter,Object,Object)", 545).add("ex", noSuchMethodException)).log();
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof ReturnFromTraversalException) {
                    throw (ReturnFromTraversalException)invocationTargetException.getTargetException();
                }
                if (TreeUtil.logger.level < 1) break block9;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "visitByLink(TreeAdapter,Object,Object)", 551).add("ex.getTargetException()", invocationTargetException.getTargetException())).log();
            }
        }
        Object object3 = treeAdapter.getFirstChildNode(object2);
        while (object3 != null) {
            TreeUtil.visitByLink(treeAdapter, object, object3);
            object3 = treeAdapter.getNextSibling(object3);
        }
    }

    private static void visitByEnumeration(TreeAdapter treeAdapter, Object object, Object object2) {
        block9: {
            if (TreeUtil.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "visitByEnumeration(TreeAdapter,Object,Object)", 574).addDetail("adapter", treeAdapter)).addDetail("visitor", object)).addDetail("node", object2)).log();
            }
            if (object2 == null) {
                if (TreeUtil.logger.level >= 3) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "visitByEnumeration(TreeAdapter,Object,Object)", 579).add("Null node")).log();
                }
                return;
            }
            try {
                Visitor.visit(object, object2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (TreeUtil.logger.level >= 1) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "visitByEnumeration(TreeAdapter,Object,Object)", 585).add("ex", noSuchMethodException)).log();
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof ReturnFromTraversalException) {
                    throw (ReturnFromTraversalException)invocationTargetException.getTargetException();
                }
                if (TreeUtil.logger.level < 1) break block9;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "visitByEnumeration(TreeAdapter,Object,Object)", 591).add("ex.getTargetException()", invocationTargetException.getTargetException())).log();
            }
        }
        Enumeration enumeration = treeAdapter.enumerateChildren(object2);
        while (enumeration.hasMoreElements()) {
            TreeUtil.visitByEnumeration(treeAdapter, object, enumeration.nextElement());
        }
    }
}

